/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.mapred.Child;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.security.UserGroupInformation;

public class TaskLogsTruncater {
    static final Log LOG = LogFactory.getLog(TaskLogsTruncater.class);
    static final String MAP_USERLOG_RETAIN_SIZE = "mapreduce.cluster.map.userlog.retain-size";
    static final String REDUCE_USERLOG_RETAIN_SIZE = "mapreduce.cluster.reduce.userlog.retain-size";
    static final int DEFAULT_RETAIN_SIZE = -1;
    static final String TRUNCATED_MSG = "[ ... this log file was truncated because of excess length]\n";
    long mapRetainSize;
    long reduceRetainSize;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int MINIMUM_RETAIN_SIZE_FOR_TRUNCATION = 0;
    private static boolean isTruncaterJvm = false;

    public TaskLogsTruncater(Configuration conf) {
        this.mapRetainSize = conf.getLong(MAP_USERLOG_RETAIN_SIZE, -1L);
        this.reduceRetainSize = conf.getLong(REDUCE_USERLOG_RETAIN_SIZE, -1L);
        LOG.info((Object)("Initializing logs' truncater with mapRetainSize=" + this.mapRetainSize + " and reduceRetainSize=" + this.reduceRetainSize));
    }

    public static boolean isTruncaterJvm() {
        return isTruncaterJvm;
    }

    public boolean shouldTruncateLogs(JVMInfo lInfo) throws IOException {
        Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> taskLogFileDetails;
        try {
            taskLogFileDetails = this.getAllLogsFileDetails(lInfo.getAllAttempts());
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception in truncateLogs while getting allLogsFileDetails(). Ignoring the truncation of logs of this process.", (Throwable)e);
            return false;
        }
        File attemptLogDir = lInfo.getLogLocation();
        for (TaskLog.LogName logName : TaskLog.LogName.values()) {
            File logFile = new File(attemptLogDir, logName.toString());
            if (!logFile.exists()) continue;
            if (!this.isTruncationNeeded(lInfo, taskLogFileDetails, logName)) {
                LOG.debug((Object)("Truncation is not needed for " + logFile.getAbsolutePath()));
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateLogs(JVMInfo lInfo) {
        Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> taskLogFileDetails;
        if (UserGroupInformation.isSecurityEnabled() && !TaskLogsTruncater.isTruncaterJvm() && !Child.isChildJvm()) {
            throw new RuntimeException("truncateLogs() cannot securely run in TaskTracker.");
        }
        if (lInfo.getAllAttempts().isEmpty()) {
            return;
        }
        try {
            taskLogFileDetails = this.getAllLogsFileDetails(lInfo.getAllAttempts());
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception in truncateLogs while getting allLogsFileDetails(). Ignoring the truncation of logs of this process.", (Throwable)e);
            return;
        }
        boolean indexModified = false;
        HashMap<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> updatedTaskLogFileDetails = new HashMap<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>>();
        for (TaskLog.LogName logName : TaskLog.LogName.values()) {
            this.copyOriginalIndexFileInfo(lInfo, taskLogFileDetails, updatedTaskLogFileDetails, logName);
        }
        File attemptLogDir = lInfo.getLogLocation();
        block26: for (TaskLog.LogName logName : TaskLog.LogName.values()) {
            FileInputStream logFileInputStream;
            FileOutputStream tmpFileOutputStream;
            File logFile = new File(attemptLogDir, logName.toString());
            if (logFile.exists() && !this.isTruncationNeeded(lInfo, taskLogFileDetails, logName)) {
                LOG.debug((Object)("Truncation is not needed for " + logFile.getAbsolutePath()));
                continue;
            }
            File tmpFile = new File(attemptLogDir, "truncate.tmp");
            try {
                tmpFileOutputStream = SecureIOUtils.createForWrite(tmpFile, 420);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Cannot open " + tmpFile.getAbsolutePath() + " for writing truncated log-file " + logFile.getAbsolutePath() + ". Continuing with other log files. "), (Throwable)ioe);
                continue;
            }
            try {
                logFileInputStream = new FileInputStream(logFile);
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot open " + logFile.getAbsolutePath() + " for reading. Continuing with other log files"), (Throwable)ioe);
                }
                try {
                    tmpFileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Cannot close tmpFileOutputStream for " + tmpFile.getAbsolutePath()), (Throwable)e);
                }
                if (tmpFile.delete()) continue;
                LOG.warn((Object)("Cannot delete tmpFile " + tmpFile.getAbsolutePath()));
                continue;
            }
            long newCurrentOffset = 0L;
            for (Task task : lInfo.getAllAttempts()) {
                long retainSize = task.isMapTask() ? this.mapRetainSize : this.reduceRetainSize;
                TaskLog.LogFileDetail newLogFileDetail = null;
                try {
                    newLogFileDetail = this.truncateALogFileOfAnAttempt(task.getTaskID(), taskLogFileDetails.get(task).get((Object)logName), retainSize, tmpFileOutputStream, logFileInputStream, logName);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Cannot truncate the log file " + logFile.getAbsolutePath() + ". Caught exception while handling " + task.getTaskID()), (Throwable)ioe);
                    this.copyOriginalIndexFileInfo(lInfo, taskLogFileDetails, updatedTaskLogFileDetails, logName);
                    try {
                        logFileInputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Cannot close logFileInputStream for " + logFile.getAbsolutePath()), (Throwable)e);
                    }
                    try {
                        tmpFileOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Cannot close tmpFileOutputStream for " + tmpFile.getAbsolutePath()), (Throwable)e);
                    }
                    if (tmpFile.delete()) continue block26;
                    LOG.warn((Object)("Cannot delete tmpFile " + tmpFile.getAbsolutePath()));
                    continue block26;
                }
                if (!TaskLog.LOGS_TRACKED_BY_INDEX_FILES.contains((Object)logName)) continue;
                if (!updatedTaskLogFileDetails.containsKey(task)) {
                    updatedTaskLogFileDetails.put(task, new HashMap());
                }
                newLogFileDetail.start = newCurrentOffset;
                ((Map)updatedTaskLogFileDetails.get(task)).put(logName, newLogFileDetail);
                newCurrentOffset += newLogFileDetail.length;
                indexModified = true;
            }
            try {
                tmpFileOutputStream.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Couldn't close the tmp file " + tmpFile.getAbsolutePath() + ". Deleting it."), (Throwable)ioe);
                this.copyOriginalIndexFileInfo(lInfo, taskLogFileDetails, updatedTaskLogFileDetails, logName);
                if (tmpFile.delete()) continue;
                LOG.warn((Object)("Cannot delete tmpFile " + tmpFile.getAbsolutePath()));
                continue;
            }
            finally {
                try {
                    logFileInputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Cannot close logFileInputStream for " + logFile.getAbsolutePath()), (Throwable)e);
                }
            }
            if (tmpFile.renameTo(logFile)) continue;
            this.copyOriginalIndexFileInfo(lInfo, taskLogFileDetails, updatedTaskLogFileDetails, logName);
            if (tmpFile.delete()) continue;
            LOG.warn((Object)("Cannot delete tmpFile " + tmpFile.getAbsolutePath()));
        }
        if (indexModified) {
            this.updateIndicesAfterLogTruncation(attemptLogDir.toString(), updatedTaskLogFileDetails);
        }
    }

    private void copyOriginalIndexFileInfo(JVMInfo lInfo, Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> taskLogFileDetails, Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> updatedTaskLogFileDetails, TaskLog.LogName logName) {
        if (TaskLog.LOGS_TRACKED_BY_INDEX_FILES.contains((Object)logName)) {
            for (Task task : lInfo.getAllAttempts()) {
                if (!updatedTaskLogFileDetails.containsKey(task)) {
                    updatedTaskLogFileDetails.put(task, new HashMap());
                }
                updatedTaskLogFileDetails.get(task).put(logName, taskLogFileDetails.get(task).get((Object)logName));
            }
        }
    }

    private Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> getAllLogsFileDetails(List<Task> allAttempts) throws IOException {
        HashMap<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> taskLogFileDetails = new HashMap<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>>();
        for (Task task : allAttempts) {
            Map<TaskLog.LogName, TaskLog.LogFileDetail> allLogsFileDetails = TaskLog.getAllLogsFileDetails(task.getTaskID(), task.isTaskCleanupTask());
            taskLogFileDetails.put(task, allLogsFileDetails);
        }
        return taskLogFileDetails;
    }

    private boolean isTruncationNeeded(JVMInfo lInfo, Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> taskLogFileDetails, TaskLog.LogName logName) {
        boolean truncationNeeded = false;
        TaskLog.LogFileDetail logFileDetail = null;
        for (Task task : lInfo.getAllAttempts()) {
            long taskRetainSize = task.isMapTask() ? this.mapRetainSize : this.reduceRetainSize;
            Map<TaskLog.LogName, TaskLog.LogFileDetail> allLogsFileDetails = taskLogFileDetails.get(task);
            logFileDetail = allLogsFileDetails.get((Object)logName);
            if (taskRetainSize <= 0L || logFileDetail.length <= taskRetainSize) continue;
            truncationNeeded = true;
            break;
        }
        return truncationNeeded;
    }

    private TaskLog.LogFileDetail truncateALogFileOfAnAttempt(TaskAttemptID taskID, TaskLog.LogFileDetail oldLogFileDetail, long taskRetainSize, FileOutputStream tmpFileOutputStream, FileInputStream logFileInputStream, TaskLog.LogName logName) throws IOException {
        byte[] tmpBuf;
        int bytesRead;
        TaskLog.LogFileDetail newLogFileDetail = new TaskLog.LogFileDetail();
        long logSize = 0L;
        newLogFileDetail.location = oldLogFileDetail.location;
        if (taskRetainSize > 0L && oldLogFileDetail.length > taskRetainSize) {
            LOG.info((Object)("Truncating " + (Object)((Object)logName) + " logs for " + taskID + " from " + oldLogFileDetail.length + "bytes to " + taskRetainSize + "bytes."));
            logSize = taskRetainSize;
            byte[] truncatedMsgBytes = TRUNCATED_MSG.getBytes();
            tmpFileOutputStream.write(truncatedMsgBytes);
            newLogFileDetail.length += (long)truncatedMsgBytes.length;
        } else {
            LOG.debug((Object)("No truncation needed for " + (Object)((Object)logName) + " logs for " + taskID + " length is " + oldLogFileDetail.length + " retain size " + taskRetainSize + "bytes."));
            logSize = oldLogFileDetail.length;
        }
        long bytesSkipped = logFileInputStream.skip(oldLogFileDetail.length - logSize);
        if (bytesSkipped != oldLogFileDetail.length - logSize) {
            throw new IOException("Erroneously skipped " + bytesSkipped + " instead of the expected " + (oldLogFileDetail.length - logSize) + " while truncating " + (Object)((Object)logName) + " logs for " + taskID);
        }
        for (long alreadyRead = 0L; alreadyRead < logSize && (bytesRead = logFileInputStream.read(tmpBuf = logSize - alreadyRead >= 4096L ? new byte[4096] : new byte[(int)(logSize - alreadyRead)])) >= 0; alreadyRead += (long)bytesRead) {
            tmpFileOutputStream.write(tmpBuf);
        }
        newLogFileDetail.length += logSize;
        return newLogFileDetail;
    }

    private void updateIndicesAfterLogTruncation(String location, Map<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> updatedTaskLogFileDetails) {
        for (Map.Entry<Task, Map<TaskLog.LogName, TaskLog.LogFileDetail>> entry : updatedTaskLogFileDetails.entrySet()) {
            Task task = entry.getKey();
            Map<TaskLog.LogName, TaskLog.LogFileDetail> logFileDetails = entry.getValue();
            HashMap<TaskLog.LogName, Long[]> logLengths = new HashMap<TaskLog.LogName, Long[]>();
            for (TaskLog.LogName logName : TaskLog.LOGS_TRACKED_BY_INDEX_FILES) {
                logLengths.put(logName, new Long[]{0L, 0L});
                TaskLog.LogFileDetail lfd = logFileDetails.get((Object)logName);
                if (lfd == null) continue;
                ((Long[])logLengths.get((Object)((Object)logName)))[0] = lfd.start;
                ((Long[])logLengths.get((Object)((Object)logName)))[1] = lfd.start + lfd.length;
            }
            try {
                TaskLog.writeToIndexFile(location, task.getTaskID(), task.isTaskCleanupTask(), logLengths);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Exception encountered while updating index file of task " + task.getTaskID() + ". Ignoring and continuing with other tasks."), (Throwable)ioe);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        isTruncaterJvm = true;
        String taskRanFile = args[0];
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal(conf);
        FSDataInputStream din = lfs.open(new Path(taskRanFile));
        int numTasksRan = din.readInt();
        ArrayList<Task> taskAttemptsRan = new ArrayList<Task>();
        for (int i = 0; i < numTasksRan; ++i) {
            Task t = din.readBoolean() ? new MapTask() : new ReduceTask();
            t.readFields(din);
            taskAttemptsRan.add(t);
        }
        Task firstTask = (Task)taskAttemptsRan.get(0);
        TaskLogsTruncater trunc = new TaskLogsTruncater(conf);
        trunc.truncateLogs(new JVMInfo(TaskLog.getAttemptDir(firstTask.getTaskID(), firstTask.isTaskCleanupTask()), taskAttemptsRan));
        System.exit(0);
    }
}

