/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.AuditLogger;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.CompletedJobStatusStore;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.InfoMap;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMXBean;
import org.apache.hadoop.mapred.JobTrackerMetricsInst;
import org.apache.hadoop.mapred.JobTrackerPlugin;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskGraphServlet;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.token.DelegationTokenRenewal;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.MRAsyncDiskService;
import org.apache.hadoop.util.PluginDispatcher;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

public class JobTracker
implements MRConstants,
InterTrackerProtocol,
JobSubmissionProtocol,
TaskTrackerManager,
RefreshUserMappingsProtocol,
RefreshAuthorizationPolicyProtocol,
AdminOperationsProtocol,
JobTrackerMXBean,
GetUserMappingsProtocol {
    static long TASKTRACKER_EXPIRY_INTERVAL;
    static long RETIRE_JOB_INTERVAL;
    static long RETIRE_JOB_CHECK_INTERVAL;
    private final long DELEGATION_TOKEN_GC_INTERVAL = 3600000L;
    private final DelegationTokenSecretManager secretManager;
    private static long UPDATE_FAULTY_TRACKER_INTERVAL;
    private static double MAX_BLACKLIST_PERCENT;
    private double AVERAGE_BLACKLIST_THRESHOLD = 0.5;
    private int MAX_BLACKLISTS_PER_TRACKER = 4;
    long MAX_JOBCONF_SIZE = 0x500000L;
    public static final String MAX_USER_JOBCONF_SIZE_KEY = "mapred.user.jobconf.limit";
    public static final String DELEGATION_KEY_UPDATE_INTERVAL_KEY = "mapreduce.cluster.delegation.key.update-interval";
    public static final long DELEGATION_KEY_UPDATE_INTERVAL_DEFAULT = 86400000L;
    public static final String DELEGATION_TOKEN_RENEW_INTERVAL_KEY = "mapreduce.cluster.delegation.token.renew-interval";
    public static final long DELEGATION_TOKEN_RENEW_INTERVAL_DEFAULT = 86400000L;
    public static final String DELEGATION_TOKEN_MAX_LIFETIME_KEY = "mapreduce.cluster.delegation.token.max-lifetime";
    public static final long DELEGATION_TOKEN_MAX_LIFETIME_DEFAULT = 604800000L;
    static final String JT_HEARTBEATS_IN_SECOND = "mapred.heartbeats.in.second";
    private int NUM_HEARTBEATS_IN_SECOND;
    private static final int DEFAULT_NUM_HEARTBEATS_IN_SECOND = 100;
    static final String JT_HEARTBEAT_INTERVAL_MIN = "mapreduce.jobtracker.heartbeat.interval.min";
    private int HEARTBEAT_INTERVAL_MIN;
    private static final int MIN_NUM_HEARTBEATS_IN_SECOND = 1;
    static final String JT_HEARTBEATS_SCALING_FACTOR = "mapreduce.jobtracker.heartbeats.scaling.factor";
    private float HEARTBEATS_SCALING_FACTOR;
    private final float MIN_HEARTBEATS_SCALING_FACTOR = 0.01f;
    private final float DEFAULT_HEARTBEATS_SCALING_FACTOR = 1.0f;
    State state = State.INITIALIZING;
    private static final int FS_ACCESS_RETRY_PERIOD = 10000;
    static final String JOB_INFO_FILE = "job-info";
    private DNSToSwitchMapping dnsToSwitchMapping;
    private NetworkTopology clusterMap = new NetworkTopology();
    private int numTaskCacheLevels;
    private Set<Node> nodesAtMaxLevel = Collections.newSetFromMap(new ConcurrentHashMap());
    private final TaskScheduler taskScheduler;
    private final List<JobInProgressListener> jobInProgressListeners = new CopyOnWriteArrayList<JobInProgressListener>();
    private static final LocalDirAllocator lDirAlloc;
    static final FsPermission SYSTEM_DIR_PERMISSION;
    static final FsPermission SYSTEM_FILE_PERMISSION;
    private Clock clock;
    private MRAsyncDiskService asyncDiskService;
    private final JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    final int MAX_COMPLETE_USER_JOBS_IN_MEMORY;
    static final int MIN_TIME_BEFORE_RETIRE = 0;
    private int nextJobId = 1;
    public static final Log LOG;
    static final String CONF_VERSION_KEY = "mapreduce.jobtracker.conf.version";
    static final String CONF_VERSION_DEFAULT = "default";
    private PluginDispatcher<JobTrackerPlugin> pluginDispatcher;
    private final JobTrackerInstrumentation myInstrumentation;
    int port;
    String localMachine;
    private String trackerIdentifier;
    long startTime;
    int totalSubmissions = 0;
    private int totalMapTaskCapacity;
    private int totalReduceTaskCapacity;
    private HostsFileReader hostsReader;
    private volatile boolean hasRestarted = false;
    private volatile boolean hasRecovered = false;
    private volatile long recoveryDuration;
    Map<JobID, JobInProgress> jobs = Collections.synchronizedMap(new TreeMap());
    TreeMap<String, ArrayList<JobInProgress>> userToJobsMap = new TreeMap();
    Map<String, Set<JobID>> trackerToJobsToCleanup = new HashMap<String, Set<JobID>>();
    Map<String, Set<TaskAttemptID>> trackerToTasksToCleanup = new HashMap<String, Set<TaskAttemptID>>();
    Map<TaskAttemptID, TaskInProgress> taskidToTIPMap = new TreeMap<TaskAttemptID, TaskInProgress>();
    Map<String, Set<TaskTracker>> hostnameToTaskTracker = Collections.synchronizedMap(new TreeMap());
    TreeMap<TaskAttemptID, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    Map<String, Node> hostnameToNodeMap = Collections.synchronizedMap(new TreeMap());
    int numResolved;
    private FaultyTrackersInfo faultyTrackers = new FaultyTrackersInfo();
    private JobTrackerStatistics statistics = new JobTrackerStatistics();
    int totalMaps = 0;
    int totalReduces = 0;
    private int occupiedMapSlots = 0;
    private int occupiedReduceSlots = 0;
    private int reservedMapSlots = 0;
    private int reservedReduceSlots = 0;
    private HashMap<String, TaskTracker> taskTrackers = new HashMap();
    Map<String, Integer> uniqueHostsMap = new ConcurrentHashMap<String, Integer>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    Thread retireJobsThread = null;
    final int retiredJobsCacheSize;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    CompletedJobStatusStore completedJobStatusStore = null;
    Thread completedJobsStoreThread = null;
    RecoveryManager recoveryManager;
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    final HttpServer infoServer;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    final LocalFileSystem localFs;
    FileSystem fs = null;
    Path systemDir = null;
    JobConf conf;
    private final ACLsManager aclsManager;
    long limitMaxMemForMapTasks;
    long limitMaxMemForReduceTasks;
    long memSizeForMapSlotOnJT;
    long memSizeForReduceSlotOnJT;
    private QueueManager queueManager;
    public static final String JT_USER_NAME = "mapreduce.jobtracker.kerberos.principal";
    public static final String JT_KEYTAB_FILE = "mapreduce.jobtracker.keytab.file";
    private static final Counters EMPTY_COUNTERS;
    private static final TaskReport[] EMPTY_TASK_REPORTS;
    static final String MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.map.memory.mb";
    static final String MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.reduce.memory.mb";
    static final String MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.max.map.memory.mb";
    static final String MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.max.reduce.memory.mb";
    private static final String[] EMPTY_TASK_DIAGNOSTICS;

    JobTokenSecretManager getJobTokenSecretManager() {
        return this.jobTokenSecretManager;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static JobTracker startTracker(JobConf conf) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, JobTracker.generateNewIdentifier());
    }

    public static JobTracker startTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        JobTracker result = null;
        while (true) {
            try {
                result = new JobTracker(conf, identifier);
                result.taskScheduler.setTaskTrackerManager(result);
            }
            catch (RPC.VersionMismatch e) {
                throw e;
            }
            catch (BindException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error starting tracker: " + StringUtils.stringifyException(e)));
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        if (result != null) {
            JobEndNotifier.startNotifier();
            MBeanUtil.registerMBean("JobTracker", "JobTrackerInfo", result);
        }
        return result;
    }

    public void stopTracker() throws IOException {
        JobEndNotifier.stopNotifier();
        this.close();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(JobSubmissionProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(AdminOperationsProtocol.class.getName())) {
            return 3L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(GetUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    public DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.secretManager;
    }

    synchronized void historyFileCopied(JobID jobid, String historyFile) {
        JobInProgress job = this.getJob(jobid);
        if (job != null) {
            job.setHistoryFileCopied();
            if (historyFile != null) {
                job.setHistoryFile(historyFile);
            }
            return;
        }
        RetireJobInfo jobInfo = this.retireJobs.get(jobid);
        if (jobInfo != null && historyFile != null) {
            jobInfo.setHistoryFile(historyFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerStatus> getStatusesOnHost(String hostName) {
        ArrayList<TaskTrackerStatus> statuses = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!hostName.equals(status.getHost())) continue;
                statuses.add(status);
            }
        }
        return statuses;
    }

    JobTracker(JobConf conf) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier());
    }

    JobTracker(JobConf conf, Clock clock) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier(), clock);
    }

    JobTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        this(conf, identifier, new Clock());
    }

    JobTracker(final JobConf conf, String identifier, Clock clock) throws IOException, InterruptedException {
        JobTrackerInstrumentation tmp;
        this.clock = clock;
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        UserGroupInformation.setConfiguration(conf);
        SecurityUtil.login(conf, JT_KEYTAB_FILE, JT_USER_NAME, this.localMachine);
        long secretKeyInterval = conf.getLong(DELEGATION_KEY_UPDATE_INTERVAL_KEY, 86400000L);
        long tokenMaxLifetime = conf.getLong(DELEGATION_TOKEN_MAX_LIFETIME_KEY, 604800000L);
        long tokenRenewInterval = conf.getLong(DELEGATION_TOKEN_RENEW_INTERVAL_KEY, 86400000L);
        this.secretManager = new DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
        this.secretManager.startThreads();
        this.MAX_JOBCONF_SIZE = conf.getLong(MAX_USER_JOBCONF_SIZE_KEY, this.MAX_JOBCONF_SIZE);
        TASKTRACKER_EXPIRY_INTERVAL = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        RETIRE_JOB_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.interval", 86400000L);
        RETIRE_JOB_CHECK_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.check", 60000L);
        this.retiredJobsCacheSize = conf.getInt("mapred.job.tracker.retiredjobs.cache.size", 1000);
        this.MAX_COMPLETE_USER_JOBS_IN_MEMORY = conf.getInt("mapred.jobtracker.completeuserjobs.maximum", 100);
        this.MAX_BLACKLISTS_PER_TRACKER = conf.getInt("mapred.max.tracker.blacklists", 4);
        this.NUM_HEARTBEATS_IN_SECOND = conf.getInt(JT_HEARTBEATS_IN_SECOND, 100);
        if (this.NUM_HEARTBEATS_IN_SECOND < 1) {
            this.NUM_HEARTBEATS_IN_SECOND = 100;
        }
        this.HEARTBEAT_INTERVAL_MIN = conf.getInt(JT_HEARTBEAT_INTERVAL_MIN, 300);
        this.HEARTBEATS_SCALING_FACTOR = conf.getFloat(JT_HEARTBEATS_SCALING_FACTOR, 1.0f);
        if (this.HEARTBEATS_SCALING_FACTOR < 0.01f) {
            this.HEARTBEATS_SCALING_FACTOR = 1.0f;
        }
        this.AVERAGE_BLACKLIST_THRESHOLD = conf.getFloat("mapred.cluster.average.blacklist.threshold", 0.5f);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.initializeTaskMemoryRelatedConfig();
        this.hostsReader = new HostsFileReader(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        Configuration queuesConf = new Configuration(this.conf);
        this.queueManager = new QueueManager(queuesConf);
        this.aclsManager = new ACLsManager(conf, new JobACLsManager(conf), this.queueManager);
        LOG.info((Object)("Starting jobtracker with owner as " + this.getMROwner().getShortUserName()));
        Class<TaskScheduler> schedulerClass = conf.getClass("mapred.jobtracker.taskScheduler", JobQueueTaskScheduler.class, TaskScheduler.class);
        this.taskScheduler = ReflectionUtils.newInstance(schedulerClass, conf);
        int handlerCount = conf.getInt("mapred.job.tracker.handler.count", 10);
        this.interTrackerServer = RPC.getServer(this, addr.getHostName(), addr.getPort(), handlerCount, false, conf, this.secretManager);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.interTrackerServer.refreshServiceAcl(conf, new MapReducePolicyProvider());
        }
        if (LOG.isDebugEnabled()) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                LOG.debug((Object)("Property '" + string + "' is " + val));
            }
        }
        String infoAddr = NetUtils.getServerAddress(conf, "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.job.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String string = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.startTime = clock.getTime();
        this.infoServer = new HttpServer("job", string, tmpInfoPort, tmpInfoPort == 0, (Configuration)conf, this.aclsManager.getAdminsAcl());
        this.infoServer.setAttribute("job.tracker", this);
        final JobTracker jtFinal = this;
        this.getMROwner().doAs(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                JobHistory.init(jtFinal, conf, jtFinal.localMachine, jtFinal.startTime);
                return true;
            }
        });
        this.infoServer.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.infoServer.start();
        this.trackerIdentifier = identifier;
        Class<? extends JobTrackerInstrumentation> metricsInst = JobTracker.getInstrumentationClass(jobConf);
        try {
            Constructor<? extends JobTrackerInstrumentation> c = metricsInst.getConstructor(JobTracker.class, JobConf.class);
            tmp = c.newInstance(this, jobConf);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize job tracker metrics", (Throwable)e);
            tmp = new JobTrackerMetricsInst(this, jobConf);
        }
        this.myInstrumentation = tmp;
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapred.job.tracker", this.localMachine + ":" + this.port);
        this.localFs = FileSystem.getLocal(conf);
        LOG.info((Object)("JobTracker up at: " + this.port));
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapred.job.tracker.http.address", string + ":" + this.infoPort);
        LOG.info((Object)("JobTracker webserver: " + this.infoServer.getPort()));
        this.recoveryManager = new RecoveryManager();
        this.asyncDiskService = new MRAsyncDiskService(FileSystem.getLocal(jobConf), jobConf.getLocalDirs());
        while (!Thread.currentThread().isInterrupted()) {
            block24: {
                try {
                    if (this.fs == null) {
                        this.fs = this.getMROwner().doAs(new PrivilegedExceptionAction<FileSystem>(){

                            @Override
                            public FileSystem run() throws IOException {
                                return FileSystem.get(conf);
                            }
                        });
                    }
                    if (this.systemDir == null) {
                        this.systemDir = new Path(this.getSystemDir());
                    }
                    try {
                        FileStatus systemDirStatus = this.fs.getFileStatus(this.systemDir);
                        if (!systemDirStatus.getOwner().equals(this.getMROwner().getShortUserName())) {
                            throw new AccessControlException("The systemdir " + this.systemDir + " is not owned by " + this.getMROwner().getShortUserName());
                        }
                        if (!systemDirStatus.getPermission().equals(SYSTEM_DIR_PERMISSION)) {
                            LOG.warn((Object)("Incorrect permissions on " + this.systemDir + ". Setting it to " + SYSTEM_DIR_PERMISSION));
                            this.fs.setPermission(this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                        }
                    }
                    catch (FileNotFoundException fnf) {
                        // empty catch block
                    }
                    FileStatus[] systemDirData = this.fs.listStatus(this.systemDir);
                    if (conf.getBoolean("mapred.jobtracker.restart.recover", false) && systemDirData != null) {
                        for (FileStatus status : systemDirData) {
                            try {
                                this.recoveryManager.checkAndAddJob(status);
                            }
                            catch (Throwable t) {
                                LOG.warn((Object)("Failed to add the job " + status.getPath().getName()), t);
                            }
                        }
                        this.hasRestarted = this.recoveryManager.shouldRecover();
                        if (this.hasRestarted) break;
                    }
                    if (!this.fs.exists(this.systemDir)) {
                        LOG.info((Object)"Creating the system directory");
                        if (FileSystem.mkdirs(this.fs, this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION))) break;
                        LOG.error((Object)("Mkdirs failed to create " + this.systemDir));
                        break block24;
                    }
                    LOG.info((Object)"Cleaning up the system directory");
                    this.fs.setPermission(this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                    this.deleteContents(this.fs, this.systemDir);
                    break;
                }
                catch (AccessControlException ace) {
                    LOG.warn((Object)("Failed to operate on mapred.system.dir (" + this.systemDir.makeQualified(this.fs) + ") because of permissions."));
                    LOG.warn((Object)("This directory should be owned by the user '" + UserGroupInformation.getCurrentUser() + "'"));
                    LOG.warn((Object)"Bailing out ... ", (Throwable)ace);
                    throw ace;
                }
                catch (IOException ie) {
                    LOG.info((Object)("problem cleaning system directory: " + this.systemDir.makeQualified(this.fs)), (Throwable)ie);
                }
            }
            Thread.sleep(10000L);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        this.asyncDiskService.moveAndDeleteFromEachVolume(SUBDIR);
        if (!this.hasRestarted) {
            jobConf.deleteLocalFiles(SUBDIR);
        }
        FileSystem historyFS = this.getMROwner().doAs(new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                JobHistory.initDone(conf, JobTracker.this.fs);
                String historyLogDir = JobHistory.getCompletedJobHistoryLocation().toString();
                JobTracker.this.infoServer.setAttribute("historyLogDir", historyLogDir);
                return new Path(historyLogDir).getFileSystem(conf);
            }
        });
        this.infoServer.setAttribute("fileSys", historyFS);
        this.dnsToSwitchMapping = ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        this.numTaskCacheLevels = conf.getInt("mapred.task.cache.levels", 2);
        this.completedJobStatusStore = new CompletedJobStatusStore(conf, this.aclsManager);
        this.pluginDispatcher = PluginDispatcher.createFromConfiguration(conf, "mapred.jobtracker.plugins", JobTrackerPlugin.class);
        this.pluginDispatcher.dispatchStart(this);
    }

    private void deleteContents(FileSystem fs, Path dir) throws IOException {
        for (FileStatus stat : fs.listStatus(dir)) {
            if (fs.delete(stat.getPath(), true)) continue;
            throw new IOException("Unable to delete " + stat.getPath());
        }
    }

    private static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmm");
    }

    private static String generateNewIdentifier() {
        return JobTracker.getDateFormat().format(new Date());
    }

    static boolean validateIdentifier(String id) {
        try {
            JobTracker.getDateFormat().parse(id);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    static boolean validateJobNumber(String id) {
        try {
            Integer.parseInt(id);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean hasRestarted() {
        return this.hasRestarted;
    }

    public boolean hasRecovered() {
        return this.hasRecovered;
    }

    public long getRecoveryDuration() {
        return this.hasRestarted() ? this.recoveryDuration : 0L;
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    LocalFileSystem getLocalFileSystem() throws IOException {
        return this.localFs;
    }

    public static Class<? extends JobTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapred.jobtracker.instrumentation", JobTrackerMetricsInst.class, JobTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends JobTrackerInstrumentation> t) {
        conf.setClass("mapred.jobtracker.instrumentation", t, JobTrackerInstrumentation.class);
    }

    JobTrackerInstrumentation getInstrumentation() {
        return this.myInstrumentation;
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr(jobTrackerStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws InterruptedException, IOException {
        while (true) {
            try {
                this.recoveryManager.updateRestartCount();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed to initialize recovery manager. ", (Throwable)ioe);
                Thread.sleep(10000L);
                LOG.warn((Object)"Retrying...");
                continue;
            }
            break;
        }
        this.taskScheduler.start();
        try {
            this.recoveryManager.recover();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Recovery manager crashed! Ignoring.", t);
        }
        this.refreshHosts();
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
        this.retireJobsThread = new Thread((Runnable)this.retireJobs, "retireJobs");
        this.retireJobsThread.start();
        this.expireLaunchingTaskThread.start();
        if (this.completedJobStatusStore.isActive()) {
            this.completedJobsStoreThread = new Thread((Runnable)this.completedJobStatusStore, "completedjobsStore-housekeeper");
            this.completedJobsStoreThread.start();
        }
        this.interTrackerServer.start();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            this.state = State.RUNNING;
        }
        LOG.info((Object)"Starting RUNNING");
        this.interTrackerServer.join();
        LOG.info((Object)"Stopped interTrackerServer");
    }

    void close() throws IOException {
        if (this.pluginDispatcher != null) {
            LOG.info((Object)"Stopping pluginDispatcher");
            this.pluginDispatcher.dispatchStop();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception shutting down JobTracker", (Throwable)ex);
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info((Object)"Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        if (this.expireTrackersThread != null && this.expireTrackersThread.isAlive()) {
            LOG.info((Object)"Stopping expireTrackers");
            this.expireTrackersThread.interrupt();
            try {
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.retireJobsThread != null && this.retireJobsThread.isAlive()) {
            LOG.info((Object)"Stopping retirer");
            this.retireJobsThread.interrupt();
            try {
                this.retireJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.taskScheduler != null) {
            this.taskScheduler.terminate();
        }
        if (this.expireLaunchingTaskThread != null && this.expireLaunchingTaskThread.isAlive()) {
            LOG.info((Object)"Stopping expireLaunchingTasks");
            this.expireLaunchingTaskThread.interrupt();
            try {
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.completedJobsStoreThread != null && this.completedJobsStoreThread.isAlive()) {
            LOG.info((Object)"Stopping completedJobsStore thread");
            this.completedJobsStoreThread.interrupt();
            try {
                this.completedJobsStoreThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        DelegationTokenRenewal.close();
        LOG.info((Object)"stopped all jobtracker services");
    }

    void createTaskEntry(TaskAttemptID taskid, String taskTracker, TaskInProgress tip) {
        LOG.info((Object)("Adding task (" + (Object)((Object)tip.getAttemptType(taskid)) + ") " + "'" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'"));
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<TaskAttemptID> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(TaskAttemptID taskid) {
        Set<TaskAttemptID> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        if (this.taskidToTIPMap.remove(taskid) != null) {
            LOG.info((Object)("Removing task '" + taskid + "'"));
        }
    }

    void markCompletedTaskAttempt(String taskTracker, TaskAttemptID taskid) {
        Set<TaskAttemptID> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Marked '" + taskid + "' from '" + taskTracker + "'"));
        }
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getTasks(TaskType.JOB_SETUP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.MAP)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getTasks(TaskType.REDUCE)) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
    }

    private void removeMarkedTasks(String taskTracker) {
        Set<TaskAttemptID> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (TaskAttemptID taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Removed marked completed task '" + taskid + "' from '" + taskTracker + "'"));
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    synchronized void removeJobTasks(JobInProgress job) {
        for (TaskType type : TaskType.values()) {
            for (TaskInProgress tip : job.getTasks(type)) {
                for (TaskAttemptID id : tip.getAllTaskAttemptIDs()) {
                    this.removeTaskEntry(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        JobID id = job.getStatus().getJobID();
        if (job.hasRestarted()) {
            try {
                JobHistory.JobInfo.finalizeRecovery(id, job.getJobConf());
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to finalize the log file recovery for job " + id), (Throwable)ioe);
            }
        }
        try {
            JobHistory.JobInfo.markCompleted(id);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to mark job " + id + " as completed!"), (Throwable)ioe);
        }
        JobTrackerInstrumentation metrics = this.getInstrumentation();
        metrics.finalizeJob(this.conf, id);
        long now = this.clock.getTime();
        this.addJobForCleanup(id);
        if (job.getStatus().getRunState() == 2 && job.getNoOfBlackListedTrackers() > 0) {
            for (String hostName : job.getBlackListedTrackers()) {
                this.faultyTrackers.incrementFaults(hostName);
            }
        }
        String jobUser = job.getProfile().getUser();
        TreeMap<String, ArrayList<JobInProgress>> treeMap = this.userToJobsMap;
        synchronized (treeMap) {
            ArrayList<JobInProgress> userJobs = this.userToJobsMap.get(jobUser);
            if (userJobs == null) {
                userJobs = new ArrayList();
                this.userToJobsMap.put(jobUser, userJobs);
            }
            userJobs.add(job);
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public String getTrackerIdentifier() {
        return this.trackerIdentifier;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 3 && status.getRunState() != 5) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getFailedJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.failedJobs();
        }
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 2) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getCompletedJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.completedJobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<TaskTrackerStatus> taskTrackers() {
        ArrayList<TaskTrackerStatus> ttStatuses;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            ttStatuses = new ArrayList<TaskTrackerStatus>(this.taskTrackers.values().size());
            for (TaskTracker tt : this.taskTrackers.values()) {
                ttStatuses.add(tt.getStatus());
            }
        }
        return ttStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<TaskTrackerStatus> activeTaskTrackers() {
        ArrayList<TaskTrackerStatus> activeTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                activeTrackers.add(status);
            }
        }
        return activeTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<List<String>> taskTrackerNames() {
        ArrayList<String> activeTrackers = new ArrayList<String>();
        ArrayList<String> blacklistedTrackers = new ArrayList<String>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                    activeTrackers.add(status.getTrackerName());
                    continue;
                }
                blacklistedTrackers.add(status.getTrackerName());
            }
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(2);
        result.add(activeTrackers);
        result.add(blacklistedTrackers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<TaskTrackerStatus> blacklistedTaskTrackers() {
        ArrayList<TaskTrackerStatus> blacklistedTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTracker tt : this.taskTrackers.values()) {
                TaskTrackerStatus status = tt.getStatus();
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                blacklistedTrackers.add(status);
            }
        }
        return blacklistedTrackers;
    }

    synchronized int getFaultCount(String hostName) {
        return this.faultyTrackers.getFaultCount(hostName);
    }

    int getBlacklistedTrackerCount() {
        return this.faultyTrackers.numBlacklistedTrackers;
    }

    public synchronized boolean isBlacklisted(String trackerID) {
        TaskTrackerStatus status = this.getTaskTrackerStatus(trackerID);
        if (status != null) {
            return this.faultyTrackers.isBlacklisted(status.getHost());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTrackerStatus getTaskTrackerStatus(String trackerID) {
        TaskTracker taskTracker;
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            taskTracker = this.taskTrackers.get(trackerID);
        }
        return taskTracker == null ? null : taskTracker.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskTracker getTaskTracker(String trackerID) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    JobTrackerStatistics getStatistics() {
        return this.statistics;
    }

    private void addNewTracker(TaskTracker taskTracker) {
        Set<TaskTracker> trackers;
        TaskTrackerStatus status = taskTracker.getStatus();
        this.trackerExpiryQueue.add(status);
        String hostname = status.getHost();
        if (this.getNode(status.getTrackerName()) == null) {
            this.resolveAndAddToTopology(hostname);
        }
        if ((trackers = this.hostnameToTaskTracker.get(hostname)) == null) {
            trackers = Collections.synchronizedSet(new HashSet());
            this.hostnameToTaskTracker.put(hostname, trackers);
        }
        this.statistics.taskTrackerAdded(status.getTrackerName());
        this.getInstrumentation().addTrackers(1);
        LOG.info((Object)("Adding tracker " + status.getTrackerName() + " to host " + hostname));
        trackers.add(taskTracker);
    }

    public Node resolveAndAddToTopology(String name) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(name);
        List<String> rNameList = this.dnsToSwitchMapping.resolve(tmpList);
        String rName = rNameList.get(0);
        String networkLoc = NodeBase.normalize(rName);
        return this.addHostToNodeMapping(name, networkLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node addHostToNodeMapping(String host, String networkLoc) {
        Node node = null;
        Set<Node> set = this.nodesAtMaxLevel;
        synchronized (set) {
            node = this.clusterMap.getNode(networkLoc + "/" + host);
            if (node == null) {
                node = new NodeBase(host, networkLoc);
                this.clusterMap.add(node);
                if (node.getLevel() < this.getNumTaskCacheLevels()) {
                    LOG.fatal((Object)("Got a host whose level is: " + node.getLevel() + "." + " Should get at least a level of value: " + this.getNumTaskCacheLevels()));
                    try {
                        this.stopTracker();
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Exception encountered during shutdown: " + StringUtils.stringifyException(ie)));
                        System.exit(-1);
                    }
                }
                this.hostnameToNodeMap.put(host, node);
                this.nodesAtMaxLevel.add(JobTracker.getParentNode(node, this.getNumTaskCacheLevels() - 1));
            }
        }
        return node;
    }

    public Collection<Node> getNodesAtMaxLevel() {
        return this.nodesAtMaxLevel;
    }

    public static Node getParentNode(Node node, int level) {
        for (int i = 0; i < level; ++i) {
            node = node.getParent();
        }
        return node;
    }

    public Node getNode(String name) {
        return this.hostnameToNodeMap.get(name);
    }

    public int getNumTaskCacheLevels() {
        return this.numTaskCacheLevels;
    }

    public int getNumResolvedTaskTrackers() {
        return this.numResolved;
    }

    @Override
    public int getNumberOfUniqueHosts() {
        return this.uniqueHostsMap.size();
    }

    @Override
    public void addJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.add(listener);
    }

    @Override
    public void removeJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.remove(listener);
    }

    private void updateJobInProgressListeners(JobChangeEvent event) {
        for (JobInProgressListener listener : this.jobInProgressListeners) {
            listener.jobUpdated(event);
        }
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public String getBuildVersion() throws IOException {
        return VersionInfo.getBuildVersion();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean restarted, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> commitTasksList;
        List<TaskTrackerAction> killJobsList;
        List<TaskTrackerAction> killTasksList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got heartbeat from: " + status.getTrackerName() + " (restarted: " + restarted + " initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId));
        }
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        long now = this.clock.getTime();
        boolean isBlacklisted = false;
        if (restarted) {
            this.faultyTrackers.markTrackerHealthy(status.getHost());
        } else {
            isBlacklisted = this.faultyTrackers.shouldAssignTasksToTracker(status.getHost(), now);
        }
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        boolean addRestartInfo = false;
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                if (!this.hasRestarted()) {
                    LOG.warn((Object)("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker"));
                    return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
                }
                addRestartInfo = true;
                this.recoveryManager.unMarkTracker(trackerName);
            } else if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info((Object)("Ignoring 'duplicate' heartbeat from '" + trackerName + "'; resending the previous 'lost' response"));
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        status.setLastSeen(now);
        if (!this.processHeartbeat(status, initialContact)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        isBlacklisted = this.faultyTrackers.isBlacklisted(status.getHost());
        if (this.recoveryManager.shouldSchedule() && acceptNewTasks && !isBlacklisted) {
            TaskTrackerStatus taskTrackerStatus = this.getTaskTrackerStatus(trackerName);
            if (taskTrackerStatus == null) {
                LOG.warn((Object)("Unknown task tracker polling; ignoring: " + trackerName));
            } else {
                List<Task> tasks = this.getSetupAndCleanupTasks(taskTrackerStatus);
                if (tasks == null) {
                    tasks = this.taskScheduler.assignTasks(this.taskTrackers.get(trackerName));
                }
                if (tasks != null) {
                    for (Task task : tasks) {
                        this.expireLaunchingTasks.addNewTask(task.getTaskID());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(trackerName + " -> LaunchTask: " + task.getTaskID()));
                        }
                        actions.add(new LaunchTaskAction(task));
                    }
                }
            }
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        if ((killJobsList = this.getJobsForCleanup(trackerName)) != null) {
            actions.addAll(killJobsList);
        }
        if ((commitTasksList = this.getTasksToSave(status)) != null) {
            actions.addAll(commitTasksList);
        }
        int nextInterval = this.getNextHeartbeatInterval();
        response.setHeartbeatInterval(nextInterval);
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        if (addRestartInfo) {
            response.setRecoveredJobs(this.recoveryManager.getJobsToRecover());
        }
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    @Override
    public int getNextHeartbeatInterval() {
        int clusterSize = this.getClusterStatus().getTaskTrackers();
        int heartbeatInterval = Math.max((int)((double)(1000.0f * this.HEARTBEATS_SCALING_FACTOR) * ((double)clusterSize / (double)this.NUM_HEARTBEATS_IN_SECOND)), this.HEARTBEAT_INTERVAL_MIN);
        return heartbeatInterval;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    private boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        int reduceSlots2;
        int mapSlots;
        TaskTrackerStatus oldStatus;
        TaskTracker tt = this.getTaskTracker(trackerName);
        TaskTrackerStatus taskTrackerStatus = oldStatus = tt == null ? null : tt.getStatus();
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            this.occupiedMapSlots -= oldStatus.countOccupiedMapSlots();
            this.occupiedReduceSlots -= oldStatus.countOccupiedReduceSlots();
            this.getInstrumentation().decRunningMaps(oldStatus.countMapTasks());
            this.getInstrumentation().decRunningReduces(oldStatus.countReduceTasks());
            this.getInstrumentation().decOccupiedMapSlots(oldStatus.countOccupiedMapSlots());
            this.getInstrumentation().decOccupiedReduceSlots(oldStatus.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(oldStatus.getHost())) {
                mapSlots = oldStatus.getMaxMapSlots();
                this.totalMapTaskCapacity -= mapSlots;
                reduceSlots2 = oldStatus.getMaxReduceSlots();
                this.totalReduceTaskCapacity -= reduceSlots2;
            }
            if (status == null) {
                this.taskTrackers.remove(trackerName);
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(oldStatus.getHost());
                if (numTaskTrackersInHost != null) {
                    Integer reduceSlots2 = numTaskTrackersInHost;
                    Integer n = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost - 1);
                    if (numTaskTrackersInHost > 0) {
                        this.uniqueHostsMap.put(oldStatus.getHost(), numTaskTrackersInHost);
                    } else {
                        this.uniqueHostsMap.remove(oldStatus.getHost());
                    }
                }
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            this.occupiedMapSlots += status.countOccupiedMapSlots();
            this.occupiedReduceSlots += status.countOccupiedReduceSlots();
            this.getInstrumentation().addRunningMaps(status.countMapTasks());
            this.getInstrumentation().addRunningReduces(status.countReduceTasks());
            this.getInstrumentation().addOccupiedMapSlots(status.countOccupiedMapSlots());
            this.getInstrumentation().addOccupiedReduceSlots(status.countOccupiedReduceSlots());
            if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                mapSlots = status.getMaxMapSlots();
                this.totalMapTaskCapacity += mapSlots;
                reduceSlots2 = status.getMaxReduceSlots();
                this.totalReduceTaskCapacity += reduceSlots2;
            }
            boolean alreadyPresent = false;
            TaskTracker taskTracker = this.taskTrackers.get(trackerName);
            if (taskTracker != null) {
                alreadyPresent = true;
            } else {
                taskTracker = new TaskTracker(trackerName);
            }
            taskTracker.setStatus(status);
            this.taskTrackers.put(trackerName, taskTracker);
            if (LOG.isDebugEnabled()) {
                int runningMaps = 0;
                int runningReduces = 0;
                int commitPendingMaps = 0;
                int commitPendingReduces = 0;
                int unassignedMaps = 0;
                int unassignedReduces = 0;
                int miscMaps = 0;
                int miscReduces = 0;
                List<TaskStatus> taskReports = status.getTaskReports();
                for (TaskStatus ts : taskReports) {
                    boolean isMap = ts.getIsMap();
                    TaskStatus.State state = ts.getRunState();
                    if (state == TaskStatus.State.RUNNING) {
                        if (isMap) {
                            ++runningMaps;
                            continue;
                        }
                        ++runningReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.UNASSIGNED) {
                        if (isMap) {
                            ++unassignedMaps;
                            continue;
                        }
                        ++unassignedReduces;
                        continue;
                    }
                    if (state == TaskStatus.State.COMMIT_PENDING) {
                        if (isMap) {
                            ++commitPendingMaps;
                            continue;
                        }
                        ++commitPendingReduces;
                        continue;
                    }
                    if (isMap) {
                        ++miscMaps;
                        continue;
                    }
                    ++miscReduces;
                }
                LOG.debug((Object)(trackerName + ": Status -" + " running(m) = " + runningMaps + " unassigned(m) = " + unassignedMaps + " commit_pending(m) = " + commitPendingMaps + " misc(m) = " + miscMaps + " running(r) = " + runningReduces + " unassigned(r) = " + unassignedReduces + " commit_pending(r) = " + commitPendingReduces + " misc(r) = " + miscReduces));
            }
            if (!alreadyPresent) {
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(status.getHost());
                if (numTaskTrackersInHost == null) {
                    numTaskTrackersInHost = 0;
                }
                Integer n = numTaskTrackersInHost;
                Integer n2 = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost + 1);
                this.uniqueHostsMap.put(status.getHost(), numTaskTrackersInHost);
            }
        }
        this.getInstrumentation().setMapSlots(this.totalMapTaskCapacity);
        this.getInstrumentation().setReduceSlots(this.totalReduceTaskCapacity);
        return oldStatus != null;
    }

    void incrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots += reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots += reservedSlots;
        }
    }

    void decrementReservations(TaskType type, int reservedSlots) {
        if (type.equals((Object)TaskType.MAP)) {
            this.reservedMapSlots -= reservedSlots;
        } else if (type.equals((Object)TaskType.REDUCE)) {
            this.reservedReduceSlots -= reservedSlots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeHealthStatus(TaskTrackerStatus trackerStatus) {
        TaskTrackerStatus.TaskTrackerHealthStatus status = trackerStatus.getHealthStatus();
        FaultyTrackersInfo faultyTrackersInfo = this.faultyTrackers;
        synchronized (faultyTrackersInfo) {
            this.faultyTrackers.setNodeHealthStatus(trackerStatus.getHost(), status.isNodeHealthy(), status.getHealthReport());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact) {
        this.getInstrumentation().heartbeat();
        String trackerName = trackerStatus.getTrackerName();
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                TaskTracker taskTracker = this.getTaskTracker(trackerName);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(taskTracker);
                    }
                } else if (!seenBefore) {
                    LOG.warn((Object)("Status from unknown Tracker : " + trackerName));
                    this.updateTaskTrackerStatus(trackerName, null);
                    return false;
                }
                if (initialContact) {
                    if (this.isBlacklisted(trackerName)) {
                        this.faultyTrackers.incrBlackListedTrackers(1);
                    }
                    this.addNewTracker(taskTracker);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        this.updateNodeHealthStatus(trackerStatus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<TaskAttemptID> taskIds = this.trackerToTaskMap.get(taskTracker);
        ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
        if (taskIds != null) {
            for (TaskAttemptID killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (tip == null || !tip.shouldClose(killTaskId) || tip.getJob().isComplete()) continue;
                killList.add(new KillTaskAction(killTaskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(taskTracker + " -> KillTaskAction: " + killTaskId));
            }
        }
        Map<String, Set<TaskAttemptID>> map = this.trackerToTasksToCleanup;
        synchronized (map) {
            Set<TaskAttemptID> set = this.trackerToTasksToCleanup.remove(taskTracker);
            if (set != null) {
                for (TaskAttemptID id : set) {
                    killList.add(new KillTaskAction(id));
                }
            }
        }
        return killList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJobForCleanup(JobID id) {
        for (String taskTracker : this.taskTrackers.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Marking job " + id + " for cleanup by tracker " + taskTracker));
            }
            Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
            synchronized (map) {
                Set<JobID> jobsToKill = this.trackerToJobsToCleanup.get(taskTracker);
                if (jobsToKill == null) {
                    jobsToKill = new HashSet<JobID>();
                    this.trackerToJobsToCleanup.put(taskTracker, jobsToKill);
                }
                jobsToKill.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerAction> getJobsForCleanup(String taskTracker) {
        Set<JobID> jobs = null;
        Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            jobs = this.trackerToJobsToCleanup.remove(taskTracker);
        }
        if (jobs != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            for (JobID killJobId : jobs) {
                killList.add(new KillJobAction(killJobId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(taskTracker + " -> KillJobAction: " + killJobId));
            }
            return killList;
        }
        return null;
    }

    private synchronized List<TaskTrackerAction> getTasksToSave(TaskTrackerStatus tts) {
        List<TaskStatus> taskStatuses = tts.getTaskReports();
        if (taskStatuses != null) {
            ArrayList<TaskTrackerAction> saveList = new ArrayList<TaskTrackerAction>();
            for (TaskStatus taskStatus : taskStatuses) {
                TaskAttemptID taskId;
                TaskInProgress tip;
                if (taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING || (tip = this.taskidToTIPMap.get(taskId = taskStatus.getTaskID())) == null || !tip.shouldCommit(taskId)) continue;
                saveList.add(new CommitTaskAction(taskId));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(tts.getTrackerName() + " -> CommitTaskAction: " + taskId));
            }
            return saveList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<Task> getSetupAndCleanupTasks(TaskTrackerStatus taskTracker) throws IOException {
        int maxMapTasks = taskTracker.getMaxMapSlots();
        int maxReduceTasks = taskTracker.getMaxReduceSlots();
        int numMaps = taskTracker.countOccupiedMapSlots();
        int numReduces = taskTracker.countOccupiedReduceSlots();
        int numTaskTrackers = this.getClusterStatus().getTaskTrackers();
        int numUniqueHosts = this.getNumberOfUniqueHosts();
        Task t = null;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            if (numMaps < maxMapTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
            if (numReduces < maxReduceTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        if (this.fs == null) {
            throw new IllegalStateException("FileSystem object not available yet");
        }
        return this.fs.getUri().toString();
    }

    public JobConf getConf() {
        return this.conf;
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn((Object)("Report from " + taskTracker + ": " + errorMessage));
    }

    static String getJobUniqueString(String jobid) {
        return jobid.substring(4);
    }

    @Override
    public synchronized JobID getNewJobId() throws IOException {
        return new JobID(this.getTrackerIdentifier(), this.nextJobId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus submitJob(JobID jobId, String jobSubmitDir, Credentials ts) throws IOException {
        JobInfo jobInfo = null;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            if (this.jobs.containsKey(jobId)) {
                return this.jobs.get(jobId).getStatus();
            }
            jobInfo = new JobInfo(jobId, new Text(ugi.getShortUserName()), new Path(jobSubmitDir));
        }
        JobInProgress job = null;
        try {
            job = new JobInProgress(this, this.conf, jobInfo, 0, ts);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        JobTracker jobTracker2 = this;
        synchronized (jobTracker2) {
            String queue = job.getProfile().getQueueName();
            if (!this.queueManager.getQueues().contains(queue)) {
                job.fail();
                throw new IOException("Queue \"" + queue + "\" does not exist");
            }
            if (!this.queueManager.isRunning(queue)) {
                throw new IOException("Queue \"" + queue + "\" is not running");
            }
            try {
                this.aclsManager.checkAccess(job, ugi, Operation.SUBMIT_JOB);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Access denied for user " + job.getJobConf().getUser() + ". Ignoring job " + jobId), (Throwable)ioe);
                job.fail();
                throw ioe;
            }
            try {
                this.taskScheduler.checkJobSubmission(job);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Problem in submitting job " + jobId), (Throwable)ioe);
                job.fail();
                throw ioe;
            }
            this.checkMemoryRequirements(job);
            boolean recovered = true;
            if (!recovered) {
                Path jobDir = this.getSystemDirectoryForJob(jobId);
                FileSystem.mkdirs(this.fs, jobDir, new FsPermission(SYSTEM_DIR_PERMISSION));
                FSDataOutputStream out = this.fs.create(this.getSystemFileForJob(jobId));
                jobInfo.write(out);
                out.close();
            }
            return this.addJob(jobId, job);
        }
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        try {
            final String user = UserGroupInformation.getCurrentUser().getShortUserName();
            return this.getMROwner().doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return JobTracker.this.getStagingAreaDirInternal(user);
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private String getStagingAreaDirInternal(String user) throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        FileSystem fs = stagingRootDir.getFileSystem(this.conf);
        return fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JobStatus addJob(JobID jobId, JobInProgress job) {
        ++this.totalSubmissions;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                this.jobs.put(job.getProfile().getJobID(), job);
                for (JobInProgressListener listener : this.jobInProgressListeners) {
                    try {
                        listener.jobAdded(job);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Failed to add and so skipping the job : " + job.getJobID() + ". Exception : " + ioe));
                    }
                }
            }
        }
        this.myInstrumentation.submitJob(job.getJobConf(), jobId);
        LOG.info((Object)("Job " + jobId + " added successfully for user '" + job.getJobConf().getUser() + "' to queue '" + job.getJobConf().getQueueName() + "'"));
        AuditLogger.logSuccess(job.getUser(), Operation.SUBMIT_JOB.name(), jobId.toString());
        return job.getStatus();
    }

    boolean areACLsEnabled() {
        return this.conf.getBoolean("mapred.acls.enabled", false);
    }

    @Override
    @Deprecated
    public synchronized ClusterStatus getClusterStatus() {
        return this.getClusterStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClusterStatus getClusterStatus(boolean detailed) {
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            if (detailed) {
                List<List<String>> trackerNames = this.taskTrackerNames();
                return new ClusterStatus((Collection<String>)trackerNames.get(0), (Collection<String>)trackerNames.get(1), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
            }
            return new ClusterStatus(this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state, this.getExcludedNodes().size());
        }
    }

    public synchronized ClusterMetrics getClusterMetrics() {
        return new ClusterMetrics(this.totalMaps, this.totalReduces, this.occupiedMapSlots, this.occupiedReduceSlots, this.reservedMapSlots, this.reservedReduceSlots, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.totalSubmissions, this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), this.getExcludedNodes().size());
    }

    @Override
    public synchronized void killJob(JobID jobid) throws IOException {
        if (null == jobid) {
            LOG.info((Object)"Null jobid object sent to JobTracker.killJob()");
            return;
        }
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("killJob(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.KILL_JOB);
        this.killJob(job);
    }

    private synchronized void killJob(JobInProgress job) {
        LOG.info((Object)("Killing job " + job.getJobID()));
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        job.kill();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState() && newStatus.getRunState() == 5) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        this.secretManager.cancelToken(token, user);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos authentication");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Text owner = new Text(ugi.getUserName());
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier(owner, renewer, realUser);
        return new Token<DelegationTokenIdentifier>(ident, this.secretManager);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos authentication");
        }
        String user = UserGroupInformation.getCurrentUser().getUserName();
        return this.secretManager.renewToken(token, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initJob(JobInProgress job) {
        block7: {
            if (null == job) {
                LOG.info((Object)"Init on null job is not valid");
                return;
            }
            try {
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                LOG.info((Object)("Initializing " + job.getJobID()));
                job.initTasks();
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() == newStatus.getRunState()) break block7;
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                JobTracker jobTracker = this;
                synchronized (jobTracker) {
                    this.updateJobInProgressListeners(event);
                }
            }
            catch (JobInProgress.KillInterruptedException kie) {
                LOG.error((Object)("Job initialization interrupted:\n" + StringUtils.stringifyException(kie)));
                this.killJob(job);
            }
            catch (Throwable t) {
                String failureInfo = "Job initialization failed:\n" + StringUtils.stringifyException(t);
                LOG.error((Object)failureInfo);
                job.getStatus().setFailureInfo(failureInfo);
                this.failJob(job);
            }
        }
    }

    @Override
    public synchronized void failJob(JobInProgress job) {
        if (null == job) {
            LOG.info((Object)"Fail on null job is not valid");
            return;
        }
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        LOG.info((Object)("Failing job " + job.getJobID()));
        job.fail();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState()) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public synchronized void setJobPriority(JobID jobid, String priority) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("setJobPriority(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        JobPriority newPriority = JobPriority.valueOf(priority);
        this.setJobPriority(jobid, newPriority);
    }

    void storeCompletedJob(JobInProgress job) {
        this.completedJobStatusStore.store(job);
    }

    private boolean isJobInited(JobInProgress job) {
        return job.inited();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobProfile getJobProfile(JobID jobid) {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getProfile();
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.profile;
            }
        }
        return this.completedJobStatusStore.readJobProfile(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(JobID jobid) {
        if (null == jobid) {
            LOG.warn((Object)"JobTracker.getJobStatus() cannot get status for null jobid");
            return null;
        }
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getStatus();
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.status;
            }
        }
        return this.completedJobStatusStore.readJobStatus(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getJobCounters(JobID jobid) throws IOException {
        UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                this.aclsManager.checkAccess(job, callerUGI, Operation.VIEW_JOB_COUNTERS);
                Counters counters = new Counters();
                if (this.isJobInited(job)) {
                    boolean isFine = job.getCounters(counters);
                    if (!isFine) {
                        throw new IOException("Counters Exceeded limit: " + Counters.MAX_COUNTER_LIMIT);
                    }
                    return counters;
                }
                return EMPTY_COUNTERS;
            }
            RetireJobInfo info = this.retireJobs.get(jobid);
            if (info != null) {
                return info.counters;
            }
        }
        return this.completedJobStatusStore.readCounters(jobid);
    }

    @Override
    public synchronized TaskReport[] getMapTaskReports(JobID jobid) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getReduceTaskReports(JobID jobid) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getCleanupTaskReports(JobID jobid) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportCleanupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportCleanupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getSetupTaskReports(JobID jobid) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job == null || !this.isJobInited(job)) {
            return EMPTY_TASK_REPORTS;
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportSetupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportSetupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (null != job) {
            return this.isJobInited(job) ? job.getTaskCompletionEvents(fromEventId, maxEvents) : TaskCompletionEvent.EMPTY_ARRAY;
        }
        return this.completedJobStatusStore.readJobTaskCompletionEvents(jobid, fromEventId, maxEvents);
    }

    @Override
    public synchronized String[] getTaskDiagnostics(TaskAttemptID taskId) throws IOException {
        TaskInProgress tip;
        List<String> taskDiagnosticInfo = null;
        JobID jobId = taskId.getJobID();
        TaskID tipId = taskId.getTaskID();
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.VIEW_JOB_DETAILS);
        }
        if (job != null && this.isJobInited(job) && (tip = job.getTaskInProgress(tipId)) != null) {
            taskDiagnosticInfo = tip.getDiagnosticInfo(taskId);
        }
        return taskDiagnosticInfo == null ? EMPTY_TASK_DIAGNOSTICS : taskDiagnosticInfo.toArray(new String[taskDiagnosticInfo.size()]);
    }

    TaskStatus[] getTaskStatuses(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(TaskAttemptID taskid) {
        TaskInProgress tip = this.getTip(taskid.getTaskID());
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    Counters getTipCounters(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? null : tip.getCounters();
    }

    TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public TaskInProgress getTip(TaskID tipid) {
        JobInProgress job = this.jobs.get(tipid.getJobID());
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    @Override
    public synchronized boolean killTask(TaskAttemptID taskid, boolean shouldFail) throws IOException {
        TaskInProgress tip = this.taskidToTIPMap.get(taskid);
        if (tip != null) {
            this.aclsManager.checkAccess(tip.getJob(), UserGroupInformation.getCurrentUser(), shouldFail ? Operation.FAIL_TASK : Operation.KILL_TASK);
            return tip.killTask(taskid, shouldFail);
        }
        LOG.info((Object)("Kill task attempt failed since task " + taskid + " was not found"));
        return false;
    }

    public synchronized String getAssignedTracker(TaskAttemptID taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return this.getJobStatus(this.jobs.values(), true);
    }

    @Override
    public JobStatus[] getAllJobs() {
        ArrayList<JobStatus> list = new ArrayList<JobStatus>();
        list.addAll(Arrays.asList(this.getJobStatus(this.jobs.values(), false)));
        list.addAll(this.retireJobs.getAllJobStatus());
        return list.toArray(new JobStatus[list.size()]);
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        AccessControlList acl = this.queueManager.getQueueACL(queueName, QueueManager.QueueACL.ADMINISTER_JOBS);
        if (acl == null) {
            acl = new AccessControlList(" ");
        }
        return acl;
    }

    @Override
    public JobInProgress getJob(JobID jobid) {
        return this.jobs.get(jobid);
    }

    Path getSystemDirectoryForJob(JobID id) {
        return new Path(this.getSystemDir(), id.toString());
    }

    Path getSystemFileForJob(JobID id) {
        return new Path(this.getSystemDirectoryForJob(id) + "/" + JOB_INFO_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setJobPriority(JobID jobId, JobPriority priority) throws AccessControlException, IOException {
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            this.aclsManager.checkAccess(job, UserGroupInformation.getCurrentUser(), Operation.SET_JOB_PRIORITY);
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                JobStatus oldStatus = (JobStatus)job.getStatus().clone();
                job.setPriority(priority);
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.PRIORITY_CHANGED, oldStatus, newStatus);
                this.updateJobInProgressListeners(event);
            }
        } else {
            LOG.warn((Object)("Trying to change the priority of an unknown job: " + jobId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskStatuses(TaskTrackerStatus status) {
        String trackerName = status.getTrackerName();
        for (TaskStatus report : status.getTaskReports()) {
            List<TaskAttemptID> failedFetchMaps;
            Map<String, Set<ID>> map;
            report.setTaskTracker(trackerName);
            TaskAttemptID taskId = report.getTaskID();
            this.expireLaunchingTasks.removeTask(taskId);
            JobInProgress job = this.getJob(taskId.getJobID());
            if (job == null) {
                map = this.trackerToJobsToCleanup;
                synchronized (map) {
                    Set<JobID> jobs = this.trackerToJobsToCleanup.get(trackerName);
                    if (jobs == null) {
                        jobs = new HashSet<JobID>();
                        this.trackerToJobsToCleanup.put(trackerName, jobs);
                    }
                    jobs.add(taskId.getJobID());
                    continue;
                }
            }
            if (!job.inited()) {
                map = this.trackerToTasksToCleanup;
                synchronized (map) {
                    Set<TaskAttemptID> tasks = this.trackerToTasksToCleanup.get(trackerName);
                    if (tasks == null) {
                        tasks = new HashSet<TaskAttemptID>();
                        this.trackerToTasksToCleanup.put(trackerName, tasks);
                    }
                    tasks.add(taskId);
                    continue;
                }
            }
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip != null || this.hasRestarted()) {
                if (tip == null) {
                    tip = job.getTaskInProgress(taskId.getTaskID());
                    job.addRunningTaskToTIP(tip, taskId, status, false);
                }
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                job.updateTaskStatus(tip, (TaskStatus)report.clone());
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() != newStatus.getRunState()) {
                    JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                    this.updateJobInProgressListeners(event);
                }
            } else {
                LOG.info((Object)("Serious problem.  While updating status, cannot find taskid " + report.getTaskID()));
            }
            if ((failedFetchMaps = report.getFetchFailedMaps()) == null) continue;
            for (TaskAttemptID mapTaskId : failedFetchMaps) {
                TaskInProgress failedFetchMap = this.taskidToTIPMap.get(mapTaskId);
                if (failedFetchMap == null) continue;
                String failedFetchTrackerName = this.getAssignedTracker(mapTaskId);
                if (failedFetchTrackerName == null) {
                    failedFetchTrackerName = "Lost task tracker";
                }
                failedFetchMap.getJob().fetchFailureNotification(failedFetchMap, mapTaskId, failedFetchTrackerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lostTaskTracker(TaskTracker taskTracker) {
        String trackerName = taskTracker.getTrackerName();
        LOG.info((Object)("Lost tracker '" + trackerName + "'"));
        Map<String, Set<ID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            this.trackerToJobsToCleanup.remove(trackerName);
        }
        map = this.trackerToTasksToCleanup;
        synchronized (map) {
            this.trackerToTasksToCleanup.remove(trackerName);
        }
        this.recoveryManager.unMarkTracker(trackerName);
        Set<TaskAttemptID> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (TaskAttemptID taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                JobInProgress job = tip.getJob();
                if (!tip.isComplete() || tip.isMapTask() && !tip.isJobSetupTask() && job.desiredReduces() != 0) {
                    if (job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4) continue;
                    TaskStatus.State killState = tip.isRunningTask(taskId) && !tip.isJobSetupTask() && !tip.isJobCleanupTask() ? TaskStatus.State.KILLED_UNCLEAN : TaskStatus.State.KILLED;
                    job.failedTask(tip, taskId, "Lost task tracker: " + trackerName, tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, killState, trackerName);
                    jobsWithFailures.add(job);
                    continue;
                }
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName, taskTracker);
            }
            taskTracker.cancelAllReservations();
            this.removeMarkedTasks(trackerName);
        }
    }

    @Override
    public synchronized void refreshNodes() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.aclsManager.isMRAdmin(UserGroupInformation.getCurrentUser())) {
            AuditLogger.logFailure(user, "REFRESH_NODES", this.aclsManager.getAdminsAcl().toString(), "JobTracker", "Unauthorized user");
            throw new AccessControlException(user + " is not authorized to refresh nodes.");
        }
        AuditLogger.logSuccess(user, "REFRESH_NODES", "JobTracker");
        this.refreshHosts();
    }

    UserGroupInformation getMROwner() {
        return this.aclsManager.getMROwner();
    }

    private synchronized void refreshHosts() throws IOException {
        LOG.info((Object)"Refreshing hosts information");
        Configuration conf = new Configuration();
        this.hostsReader.updateFileNames(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        this.hostsReader.refresh();
        HashSet<String> excludeSet = new HashSet<String>();
        for (Map.Entry<String, TaskTracker> eSet : this.taskTrackers.entrySet()) {
            String trackerName = eSet.getKey();
            TaskTrackerStatus status = eSet.getValue().getStatus();
            if (this.inHostsList(status) && !this.inExcludedHostsList(status)) continue;
            excludeSet.add(status.getHost());
        }
        this.decommissionNodes(excludeSet);
    }

    private void removeTracker(TaskTracker tracker) {
        String trackerName = tracker.getTrackerName();
        this.lostTaskTracker(tracker);
        if (this.isBlacklisted(trackerName)) {
            this.faultyTrackers.decrBlackListedTrackers(1);
        }
        this.updateTaskTrackerStatus(trackerName, null);
        this.statistics.taskTrackerRemoved(trackerName);
        this.getInstrumentation().decTrackers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void decommissionNodes(Set<String> hosts) throws IOException {
        LOG.info((Object)("Decommissioning " + hosts.size() + " nodes"));
        HashMap<String, TaskTracker> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                int trackersDecommissioned = 0;
                for (String host : hosts) {
                    LOG.info((Object)("Decommissioning host " + host));
                    Set<TaskTracker> trackers = this.hostnameToTaskTracker.remove(host);
                    if (trackers != null) {
                        for (TaskTracker tracker : trackers) {
                            LOG.info((Object)("Decommission: Losing tracker " + tracker.getTrackerName() + " on host " + host));
                            this.removeTracker(tracker);
                        }
                        trackersDecommissioned += trackers.size();
                    }
                    LOG.info((Object)("Host " + host + " is ready for decommissioning"));
                }
                this.getInstrumentation().setDecommissionedTrackers(trackersDecommissioned);
            }
        }
    }

    Collection<String> getExcludedNodes() {
        return this.hostsReader.getExcludedHosts();
    }

    public static String getLocalJobFilePath(JobID jobId) {
        return JobHistory.JobInfo.getLocalJobFilePath(jobId);
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        StringUtils.startupShutdownMessage(JobTracker.class, argv, LOG);
        try {
            if (argv.length == 0) {
                JobTracker tracker = JobTracker.startTracker(new JobConf());
                tracker.offerService();
            } else if ("-dumpConfiguration".equals(argv[0]) && argv.length == 1) {
                JobTracker.dumpConfiguration(new PrintWriter(System.out));
            } else {
                System.out.println("usage: JobTracker [-dumpConfiguration]");
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    private static void dumpConfiguration(Writer writer) throws IOException {
        Configuration.dumpConfiguration(new JobConf(), writer);
        writer.write("\n");
        QueueManager.dumpConfiguration(writer);
        writer.write("\n");
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return this.queueManager.getJobQueueInfos();
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return this.queueManager.getJobQueueInfo(queue);
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        Collection<JobInProgress> jips = this.taskScheduler.getJobs(queue);
        return this.getJobStatus(jips, false);
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return this.queueManager.getQueueAcls(UserGroupInformation.getCurrentUser());
    }

    private synchronized JobStatus[] getJobStatus(Collection<JobInProgress> jips, boolean toComplete) {
        if (jips == null || jips.isEmpty()) {
            return new JobStatus[0];
        }
        ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
        for (JobInProgress jip : jips) {
            JobStatus status = jip.getStatus();
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            if (toComplete) {
                if (status.getRunState() != 1 && status.getRunState() != 4) continue;
                jobStatusList.add(status);
                continue;
            }
            jobStatusList.add(status);
        }
        return jobStatusList.toArray(new JobStatus[jobStatusList.size()]);
    }

    int getMaxTasksPerJob() {
        return this.conf.getInt("mapred.jobtracker.maxtasks.per.job", -1);
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        if (!this.conf.getBoolean("hadoop.security.authorization", false)) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.interTrackerServer.refreshServiceAcl(this.conf, new MapReducePolicyProvider());
    }

    private void initializeTaskMemoryRelatedConfig() {
        this.memSizeForMapSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY, -1L));
        this.memSizeForReduceSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY, -1L));
        if (this.conf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)(JobConf.deprecatedString("mapred.task.limit.maxvmem") + " instead use " + MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY + " and " + MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY));
            this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapred.task.limit.maxvmem", -1L));
            if (this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForMapTasks >= 0L) {
                this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = this.limitMaxMemForMapTasks / 0x100000L;
            }
        } else {
            this.limitMaxMemForMapTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY, -1L));
            this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        LOG.info((Object)new StringBuilder().append("Scheduler configured with ").append("(memSizeForMapSlotOnJT, memSizeForReduceSlotOnJT,").append(" limitMaxMemForMapTasks, limitMaxMemForReduceTasks) (").append(this.memSizeForMapSlotOnJT).append(", ").append(this.memSizeForReduceSlotOnJT).append(", ").append(this.limitMaxMemForMapTasks).append(", ").append(this.limitMaxMemForReduceTasks).append(")"));
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info((Object)"Refreshing superuser proxy groups mapping ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for user " + user));
        }
        return UserGroupInformation.createRemoteUser(user).getGroupNames();
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + UserGroupInformation.getCurrentUser().getShortUserName()));
        Groups.getUserToGroupsMappingService().refresh();
    }

    private boolean perTaskMemoryConfigurationSetOnJT() {
        return this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForReduceTasks != -1L && this.memSizeForMapSlotOnJT != -1L && this.memSizeForReduceSlotOnJT != -1L;
    }

    private void checkMemoryRequirements(JobInProgress job) throws IOException {
        if (!this.perTaskMemoryConfigurationSetOnJT()) {
            LOG.debug((Object)"Per-Task memory configuration is not set on JT. Not checking the job for invalid memory requirements.");
            return;
        }
        boolean invalidJob = false;
        String msg = "";
        long maxMemForMapTask = job.getMemoryForMapTask();
        long maxMemForReduceTask = job.getMemoryForReduceTask();
        if (maxMemForMapTask == -1L || maxMemForReduceTask == -1L) {
            invalidJob = true;
            msg = "Invalid job requirements.";
        }
        if (maxMemForMapTask > this.limitMaxMemForMapTasks || maxMemForReduceTask > this.limitMaxMemForReduceTasks) {
            invalidJob = true;
            msg = "Exceeds the cluster's max-memory-limit.";
        }
        if (invalidJob) {
            StringBuilder jobStr = new StringBuilder().append(job.getJobID().toString()).append("(").append(maxMemForMapTask).append(" memForMapTasks ").append(maxMemForReduceTask).append(" memForReduceTasks): ");
            LOG.warn((Object)(jobStr.toString() + msg));
            throw new IOException(jobStr.toString() + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshQueues() throws IOException {
        LOG.info((Object)("Refreshing queue information. requested by : " + UserGroupInformation.getCurrentUser().getShortUserName()));
        this.queueManager.refreshQueues(new Configuration());
        TaskScheduler taskScheduler = this.taskScheduler;
        synchronized (taskScheduler) {
            this.taskScheduler.refresh();
        }
    }

    synchronized String getReasonsForBlacklisting(String host) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, false);
        if (fi == null) {
            return "";
        }
        return fi.getTrackerFaultReport();
    }

    synchronized Set<ReasonForBlackListing> getReasonForBlackList(String host) {
        FaultInfo fi = this.faultyTrackers.getFaultInfo(host, false);
        if (fi == null) {
            return new HashSet<ReasonForBlackListing>();
        }
        return fi.getReasonforblacklisting();
    }

    synchronized void incrementFaults(String hostName) {
        this.faultyTrackers.incrementFaults(hostName);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    JobACLsManager getJobACLsManager() {
        return this.aclsManager.getJobACLsManager();
    }

    ACLsManager getACLsManager() {
        return this.aclsManager;
    }

    @Override
    public String getHostname() {
        return StringUtils.simpleHostname(this.getJobTrackerMachine());
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getConfigVersion() {
        return this.conf.get(CONF_VERSION_KEY, CONF_VERSION_DEFAULT);
    }

    @Override
    public int getThreadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getSummaryJson() {
        return this.getSummary().toJson();
    }

    InfoMap getSummary() {
        final ClusterMetrics metrics = this.getClusterMetrics();
        InfoMap map = new InfoMap();
        map.put("nodes", metrics.getTaskTrackerCount() + this.getBlacklistedTrackerCount());
        map.put("alive", metrics.getTaskTrackerCount());
        map.put("blacklisted", this.getBlacklistedTrackerCount());
        map.put("slots", new InfoMap(){
            {
                this.put("map_slots", metrics.getMapSlotCapacity());
                this.put("map_slots_used", metrics.getOccupiedMapSlots());
                this.put("reduce_slots", metrics.getReduceSlotCapacity());
                this.put("reduce_slots_used", metrics.getOccupiedReduceSlots());
            }
        });
        map.put("jobs", metrics.getTotalJobSubmissions());
        return map;
    }

    @Override
    public String getAliveNodesInfoJson() {
        return JSON.toString(this.getAliveNodesInfo());
    }

    List<InfoMap> getAliveNodesInfo() {
        ArrayList<InfoMap> info = new ArrayList<InfoMap>();
        for (final TaskTrackerStatus tts : this.activeTaskTrackers()) {
            final int mapSlots = tts.getMaxMapSlots();
            final int redSlots = tts.getMaxReduceSlots();
            info.add(new InfoMap(){
                {
                    this.put("hostname", tts.getHost());
                    this.put("last_seen", tts.getLastSeen());
                    this.put("health", tts.getHealthStatus().isNodeHealthy() ? "OK" : "");
                    this.put("slots", new InfoMap(){
                        {
                            this.put("map_slots", mapSlots);
                            this.put("map_slots_used", mapSlots - tts.getAvailableMapSlots());
                            this.put("reduce_slots", redSlots);
                            this.put("reduce_slots_used", redSlots - tts.getAvailableReduceSlots());
                        }
                    });
                    this.put("failures", tts.getFailures());
                }
            });
        }
        return info;
    }

    @Override
    public String getBlacklistedNodesInfoJson() {
        return JSON.toString(this.getUnhealthyNodesInfo(this.blacklistedTaskTrackers()));
    }

    List<InfoMap> getUnhealthyNodesInfo(Collection<TaskTrackerStatus> list) {
        ArrayList<InfoMap> info = new ArrayList<InfoMap>();
        for (final TaskTrackerStatus tts : list) {
            info.add(new InfoMap(){
                {
                    this.put("hostname", tts.getHost());
                    this.put("last_seen", tts.getLastSeen());
                    this.put("reason", tts.getHealthStatus().getHealthReport());
                }
            });
        }
        return info;
    }

    @Override
    public String getQueueInfoJson() {
        return this.getQueueInfo().toJson();
    }

    InfoMap getQueueInfo() {
        InfoMap map = new InfoMap();
        try {
            for (final JobQueueInfo q : this.getQueues()) {
                map.put(q.getQueueName(), new InfoMap(){
                    {
                        this.put("info", q.getSchedulingInfo());
                    }
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Getting queue info", e);
        }
        return map;
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
        TASKTRACKER_EXPIRY_INTERVAL = 600000L;
        UPDATE_FAULTY_TRACKER_INTERVAL = 86400000L;
        MAX_BLACKLIST_PERCENT = 0.5;
        lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)448);
        SYSTEM_FILE_PERMISSION = FsPermission.createImmutable((short)448);
        LOG = LogFactory.getLog(JobTracker.class);
        EMPTY_COUNTERS = new Counters();
        EMPTY_TASK_REPORTS = new TaskReport[0];
        EMPTY_TASK_DIAGNOSTICS = new String[0];
    }

    class RecoveryManager {
        Set<JobID> jobsToRecover;
        private int totalEventsRecovered = 0;
        private int restartCount = 0;
        private boolean shouldRecover = false;
        Set<String> recoveredTrackers = Collections.synchronizedSet(new HashSet());

        public RecoveryManager() {
            this.jobsToRecover = new TreeSet<JobID>();
        }

        public boolean contains(JobID id) {
            return this.jobsToRecover.contains(id);
        }

        void addJobForRecovery(JobID id) {
            this.jobsToRecover.add(id);
        }

        public boolean shouldRecover() {
            return this.shouldRecover;
        }

        public boolean shouldSchedule() {
            return this.recoveredTrackers.isEmpty();
        }

        private void markTracker(String trackerName) {
            this.recoveredTrackers.add(trackerName);
        }

        void unMarkTracker(String trackerName) {
            this.recoveredTrackers.remove(trackerName);
        }

        Set<JobID> getJobsToRecover() {
            return this.jobsToRecover;
        }

        private boolean isJobNameValid(String str) {
            if (str == null) {
                return false;
            }
            String[] parts = str.split("_");
            if (parts.length == 3 && parts[0].equals("job")) {
                return JobTracker.validateIdentifier(parts[1]) && JobTracker.validateJobNumber(parts[2]);
            }
            return false;
        }

        public void checkAndAddJob(FileStatus status) throws IOException {
            String fileName = status.getPath().getName();
            if (this.isJobNameValid(fileName)) {
                if (JobClient.isJobDirValid(status.getPath(), JobTracker.this.fs)) {
                    JobTracker.this.recoveryManager.addJobForRecovery(JobID.forName(fileName));
                    this.shouldRecover = true;
                } else {
                    LOG.info((Object)("Found an incomplete job directory " + fileName + "." + " Deleting it!!"));
                    JobTracker.this.fs.delete(status.getPath(), true);
                }
            }
        }

        private JobStatusChangeEvent updateJob(JobInProgress jip, JobHistory.JobInfo job) {
            String jobpriority = job.get(JobHistory.Keys.JOB_PRIORITY);
            JobPriority priority = JobPriority.valueOf(jobpriority);
            try {
                JobTracker.this.setJobPriority(jip.getJobID(), priority);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unexpected. JobTracker could not do SetJobPriority on " + jip.getJobID() + ". " + e));
            }
            JobStatus oldStatus = (JobStatus)jip.getStatus().clone();
            jip.updateJobInfo(job.getLong(JobHistory.Keys.SUBMIT_TIME), job.getLong(JobHistory.Keys.LAUNCH_TIME));
            JobStatus newStatus = (JobStatus)jip.getStatus().clone();
            return new JobStatusChangeEvent(jip, JobStatusChangeEvent.EventType.START_TIME_CHANGED, oldStatus, newStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTip(TaskInProgress tip, JobHistory.Task task) {
            String cause;
            long finishTime;
            long startTime = task.getLong(JobHistory.Keys.START_TIME);
            if (startTime != 0L) {
                tip.setExecStartTime(startTime);
            }
            if ((finishTime = task.getLong(JobHistory.Keys.FINISH_TIME)) != 0L) {
                tip.setExecFinishTime(finishTime);
            }
            if ((cause = task.get(JobHistory.Keys.TASK_ATTEMPT_ID)).length() > 0) {
                TaskAttemptID id = TaskAttemptID.forName(cause);
                TaskStatus status = tip.getTaskStatus(id);
                JobTracker jobTracker = JobTracker.this;
                synchronized (jobTracker) {
                    tip.getJob().failedTask(tip, id, status.getDiagnosticInfo(), status.getPhase(), status.getRunState(), status.getTaskTracker());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTaskAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID id = attemptId.getTaskID();
            String type = attempt.get(JobHistory.Keys.TASK_TYPE);
            TaskInProgress tip = job.getTaskInProgress(id);
            TaskStatus taskStatus = null;
            String trackerName = attempt.get(JobHistory.Keys.TRACKER_NAME);
            String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            int port = 0;
            String hport = attempt.get(JobHistory.Keys.HTTP_PORT);
            if (hport != null && hport.length() > 0) {
                port = attempt.getInt(JobHistory.Keys.HTTP_PORT);
            }
            long attemptStartTime = attempt.getLong(JobHistory.Keys.START_TIME);
            taskStatus = type.equals(JobHistory.Values.MAP.name()) ? new MapTaskStatus(attemptId, 0.0f, job.getNumSlotsPerTask(TaskType.MAP), TaskStatus.State.RUNNING, "", "", trackerName, TaskStatus.Phase.MAP, new Counters()) : new ReduceTaskStatus(attemptId, 0.0f, job.getNumSlotsPerTask(TaskType.REDUCE), TaskStatus.State.RUNNING, "", "", trackerName, TaskStatus.Phase.REDUCE, new Counters());
            taskStatus.setStartTime(attemptStartTime);
            ArrayList<TaskStatus> ttStatusList = new ArrayList<TaskStatus>();
            ttStatusList.add(taskStatus);
            TaskTrackerStatus ttStatus = new TaskTrackerStatus(trackerName, trackerHostName, port, ttStatusList, 0, 0, 0);
            ttStatus.setLastSeen(JobTracker.this.clock.getTime());
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                HashMap hashMap = JobTracker.this.taskTrackers;
                synchronized (hashMap) {
                    TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                    synchronized (treeSet) {
                        boolean isTrackerRegistered;
                        TaskTracker taskTracker = JobTracker.this.getTaskTracker(trackerName);
                        boolean bl = isTrackerRegistered = taskTracker != null;
                        if (!isTrackerRegistered) {
                            this.markTracker(trackerName);
                            taskTracker = new TaskTracker(trackerName);
                            taskTracker.setStatus(ttStatus);
                            JobTracker.this.addNewTracker(taskTracker);
                        }
                        JobTracker.this.updateTaskTrackerStatus(trackerName, ttStatus);
                    }
                }
                job.addRunningTaskToTIP(tip, attemptId, ttStatus, false);
                tip.updateStatus(taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.addNewTask(attemptId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSuccessfulAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID taskId = attemptId.getTaskID();
            String type = attempt.get(JobHistory.Keys.TASK_TYPE);
            TaskInProgress tip = job.getTaskInProgress(taskId);
            long attemptFinishTime = attempt.getLong(JobHistory.Keys.FINISH_TIME);
            TaskStatus taskStatus = (TaskStatus)tip.getTaskStatus(attemptId).clone();
            taskStatus.setFinishTime(attemptFinishTime);
            String stateString = attempt.get(JobHistory.Keys.STATE_STRING);
            taskStatus.setStateString(stateString);
            taskStatus.setProgress(1.0f);
            taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
            if (type.equals(JobHistory.Values.REDUCE.name())) {
                long shuffleTime = Long.parseLong(attempt.get(JobHistory.Keys.SHUFFLE_FINISHED));
                long sortTime = Long.parseLong(attempt.get(JobHistory.Keys.SORT_FINISHED));
                taskStatus.setShuffleFinishTime(shuffleTime);
                taskStatus.setSortFinishTime(sortTime);
            }
            String counterString = attempt.get(JobHistory.Keys.COUNTERS);
            Counters counter = null;
            try {
                counter = Counters.fromEscapedCompactString(counterString);
            }
            catch (ParseException pe) {
                counter = new Counters();
            }
            taskStatus.setCounters(counter);
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                job.updateTaskStatus(tip, taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.removeTask(attemptId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addUnsuccessfulAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID taskId = attemptId.getTaskID();
            TaskInProgress tip = job.getTaskInProgress(taskId);
            long attemptFinishTime = attempt.getLong(JobHistory.Keys.FINISH_TIME);
            TaskStatus taskStatus = (TaskStatus)tip.getTaskStatus(attemptId).clone();
            taskStatus.setFinishTime(attemptFinishTime);
            taskStatus.setProgress(0.0f);
            String stateString = attempt.get(JobHistory.Keys.STATE_STRING);
            taskStatus.setStateString(stateString);
            boolean hasFailed = attempt.get(JobHistory.Keys.TASK_STATUS).equals(JobHistory.Values.FAILED.name());
            if (hasFailed) {
                taskStatus.setRunState(TaskStatus.State.FAILED);
            } else {
                taskStatus.setRunState(TaskStatus.State.KILLED);
            }
            String diagInfo = attempt.get(JobHistory.Keys.ERROR);
            taskStatus.setDiagnosticInfo(diagInfo);
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                job.updateTaskStatus(tip, taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.removeTask(attemptId);
        }

        Path getRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info");
        }

        Path getTempRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info.recover");
        }

        void updateRestartCount() throws IOException {
            Path restartFile = this.getRestartCountFile();
            Path tmpRestartFile = this.getTempRestartCountFile();
            FsPermission filePerm = new FsPermission(SYSTEM_FILE_PERMISSION);
            if (JobTracker.this.fs.exists(restartFile)) {
                JobTracker.this.fs.delete(tmpRestartFile, false);
            } else if (JobTracker.this.fs.exists(tmpRestartFile)) {
                JobTracker.this.fs.rename(tmpRestartFile, restartFile);
            } else {
                this.shouldRecover = false;
                try {
                    FSDataOutputStream out = FileSystem.create(JobTracker.this.fs, restartFile, filePerm);
                    out.writeInt(0);
                    out.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Writing to file " + restartFile + " failed!"));
                    LOG.warn((Object)"FileSystem is not ready yet!");
                    JobTracker.this.fs.delete(restartFile, false);
                    throw ioe;
                }
                return;
            }
            FSDataInputStream in = JobTracker.this.fs.open(restartFile);
            try {
                this.restartCount = in.readInt();
                ++this.restartCount;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("System directory is garbled. Failed to read file " + restartFile));
                LOG.warn((Object)"Jobtracker recovery is not possible with garbled system directory! Please delete the system directory and restart the jobtracker. Note that deleting the system directory will result in loss of all the running jobs.");
                throw new RuntimeException(ioe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            FSDataOutputStream out = FileSystem.create(JobTracker.this.fs, tmpRestartFile, filePerm);
            out.writeInt(this.restartCount);
            out.close();
            JobTracker.this.fs.delete(restartFile, false);
            JobTracker.this.fs.rename(tmpRestartFile, restartFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover() {
            Path jobHistoryFilePath;
            if (!this.shouldRecover()) {
                this.jobsToRecover.clear();
                return;
            }
            LOG.info((Object)("Restart count of the jobtracker : " + this.restartCount));
            HashMap<JobID, Path> jobHistoryFilenameMap = new HashMap<JobID, Path>();
            Iterator<JobID> idIter = this.jobsToRecover.iterator();
            try {
                JobHistory.JobInfo.deleteConfFiles();
            }
            catch (IOException ioe) {
                LOG.info((Object)"Error in cleaning up job history folder", (Throwable)ioe);
            }
            JobInProgress job = null;
            File jobIdFile = null;
            try {
                JobHistory.JobInfo.deleteConfFiles();
            }
            catch (IOException ioe) {
                LOG.info((Object)"Error in cleaning up job history folder", (Throwable)ioe);
            }
            while (idIter.hasNext()) {
                JobID id = idIter.next();
                LOG.info((Object)("Trying to recover details of job " + id));
                try {
                    jobIdFile = new File(lDirAlloc.getLocalPathToRead("jobTracker/" + id, JobTracker.this.conf).toString());
                    String user = null;
                    if (jobIdFile != null && jobIdFile.exists()) {
                        LOG.info((Object)("File " + jobIdFile + " exists for job " + id));
                        FileInputStream in = new FileInputStream(jobIdFile);
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(in));
                            user = reader.readLine();
                            LOG.info((Object)("Recovered user " + user + " for job " + id));
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                            in.close();
                        }
                    }
                    if (user == null) {
                        throw new RuntimeException("Incomplete job " + id);
                    }
                    job = new JobInProgress(JobTracker.this, JobTracker.this.conf, new JobInfo(id, new Text(user), new Path(JobTracker.this.getStagingAreaDirInternal(user))), this.restartCount, new Credentials());
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser(job.getJobConf().getUser());
                    LOG.info((Object)("Submitting job " + id + " on behalf of user " + ugi.getShortUserName() + " in groups : " + StringUtils.arrayToString(ugi.getGroupNames())));
                    try {
                        JobTracker.this.aclsManager.checkAccess(job, ugi, Operation.SUBMIT_JOB);
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("Access denied for user " + ugi.getShortUserName() + " in groups : [" + StringUtils.arrayToString(ugi.getGroupNames()) + "]"));
                        throw t;
                    }
                    String logFileName = JobHistory.JobInfo.getJobHistoryFileName(job.getJobConf(), id);
                    if (logFileName != null) {
                        jobHistoryFilePath = JobHistory.JobInfo.getJobHistoryLogLocation(logFileName);
                        JobHistory.JobInfo.recoverJobHistoryFile(job.getJobConf(), jobHistoryFilePath);
                        jobHistoryFilenameMap.put(job.getJobID(), jobHistoryFilePath);
                    } else {
                        LOG.info((Object)("No history file found for job " + id));
                        idIter.remove();
                    }
                    JobTracker.this.addJob(id, job);
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Failed to recover job " + id + " Ignoring the job."), t);
                    idIter.remove();
                    if (jobIdFile != null) {
                        jobIdFile.delete();
                        jobIdFile = null;
                    }
                    if (job == null) continue;
                    job.fail();
                    job = null;
                }
            }
            long recoveryStartTime = JobTracker.this.clock.getTime();
            idIter = this.jobsToRecover.iterator();
            while (idIter.hasNext()) {
                FileSystem fs;
                JobID id = idIter.next();
                JobInProgress pJob = JobTracker.this.getJob(id);
                jobHistoryFilePath = (Path)jobHistoryFilenameMap.get(pJob.getJobID());
                String logFileName = jobHistoryFilePath.getName();
                try {
                    fs = jobHistoryFilePath.getFileSystem(JobTracker.this.conf);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Failed to get the filesystem for job " + id + ". Ignoring."), (Throwable)ioe);
                    continue;
                }
                JobRecoveryListener listener = new JobRecoveryListener(pJob);
                try {
                    JobHistory.parseHistoryFromFS(jobHistoryFilePath.toString(), listener, fs);
                }
                catch (Throwable t) {
                    LOG.info((Object)("Error reading history file of job " + pJob.getJobID() + ". Ignoring the error and continuing."), t);
                }
                listener.close();
                this.totalEventsRecovered += listener.getNumEventsRecovered();
                try {
                    JobInProgress t = pJob;
                    synchronized (t) {
                        JobHistory.JobInfo.checkpointRecovery(logFileName, pJob.getJobConf());
                    }
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Failed to delete log file (" + logFileName + ") for job " + id + ". Continuing."), t);
                }
                if (!pJob.isComplete()) continue;
                idIter.remove();
            }
            JobTracker.this.recoveryDuration = JobTracker.this.clock.getTime() - recoveryStartTime;
            JobTracker.this.hasRecovered = true;
            TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
            synchronized (treeSet) {
                long now = JobTracker.this.clock.getTime();
                int size = JobTracker.this.trackerExpiryQueue.size();
                for (int i = 0; i < size; ++i) {
                    TaskTrackerStatus taskTracker = JobTracker.this.trackerExpiryQueue.first();
                    JobTracker.this.trackerExpiryQueue.remove(taskTracker);
                    taskTracker.setLastSeen(now);
                    JobTracker.this.trackerExpiryQueue.add(taskTracker);
                }
            }
            LOG.info((Object)"Restoration complete");
        }

        int totalEventsRecovered() {
            return this.totalEventsRecovered;
        }

        class JobRecoveryListener
        implements JobHistory.Listener {
            private JobInProgress jip;
            private JobHistory.JobInfo job;
            private int numEventsRecovered = 0;
            private Map<String, String> hangingAttempts = new HashMap<String, String>();
            private boolean hasUpdates = false;

            public JobRecoveryListener(JobInProgress jip) {
                this.jip = jip;
                this.job = new JobHistory.JobInfo(jip.getJobID().toString());
            }

            private void processTask(String taskId, JobHistory.Task task) {
                boolean hasHanging;
                boolean bl = hasHanging = this.hangingAttempts.remove(taskId) != null;
                if (hasHanging) {
                    this.numEventsRecovered += 2;
                }
                TaskID id = TaskID.forName(taskId);
                TaskInProgress tip = JobTracker.this.getTip(id);
                RecoveryManager.this.updateTip(tip, task);
            }

            private void processTaskAttempt(String taskAttemptId, JobHistory.TaskAttempt attempt) {
                TaskAttemptID id = TaskAttemptID.forName(taskAttemptId);
                String taskStatus = attempt.get(JobHistory.Keys.TASK_STATUS);
                TaskAttemptID taskID = TaskAttemptID.forName(taskAttemptId);
                JobInProgress jip = JobTracker.this.getJob(taskID.getJobID());
                JobStatus prevStatus = (JobStatus)jip.getStatus().clone();
                if (taskStatus.length() > 0) {
                    if (taskStatus.equals(JobHistory.Values.SUCCESS.name())) {
                        this.hangingAttempts.put(id.getTaskID().toString(), taskAttemptId);
                        RecoveryManager.this.addSuccessfulAttempt(jip, id, attempt);
                    } else {
                        RecoveryManager.this.addUnsuccessfulAttempt(jip, id, attempt);
                        this.numEventsRecovered += 2;
                    }
                } else {
                    RecoveryManager.this.createTaskAttempt(jip, id, attempt);
                }
                JobStatus newStatus = (JobStatus)jip.getStatus().clone();
                if (prevStatus.getRunState() != newStatus.getRunState()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Status changed hence informing prevStatus" + prevStatus + " currentStatus " + newStatus));
                    }
                    JobStatusChangeEvent event = new JobStatusChangeEvent(jip, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                    JobTracker.this.updateJobInProgressListeners(event);
                }
            }

            @Override
            public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
                if (recType == JobHistory.RecordTypes.Job) {
                    this.job.handle(values);
                    this.checkAndInit();
                } else if (recType.equals((Object)JobHistory.RecordTypes.Task)) {
                    String taskId = values.get((Object)JobHistory.Keys.TASKID);
                    JobHistory.Task task = new JobHistory.Task();
                    task.handle((Map)values);
                    if (this.isCleanup(task)) {
                        return;
                    }
                    this.processTask(taskId, task);
                } else if (recType.equals((Object)JobHistory.RecordTypes.MapAttempt)) {
                    String attemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                    JobHistory.MapAttempt attempt = new JobHistory.MapAttempt();
                    attempt.handle((Map)values);
                    if (this.isCleanup(attempt)) {
                        return;
                    }
                    this.processTaskAttempt(attemptId, attempt);
                } else if (recType.equals((Object)JobHistory.RecordTypes.ReduceAttempt)) {
                    String attemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                    JobHistory.ReduceAttempt attempt = new JobHistory.ReduceAttempt();
                    attempt.handle((Map)values);
                    if (this.isCleanup(attempt)) {
                        return;
                    }
                    this.processTaskAttempt(attemptId, attempt);
                }
            }

            private boolean isCleanup(JobHistory.Task task) {
                String taskType = task.get(JobHistory.Keys.TASK_TYPE);
                return JobHistory.Values.CLEANUP.name().equals(taskType);
            }

            private void checkAndInit() throws IOException {
                String jobStatus = this.job.get(JobHistory.Keys.JOB_STATUS);
                if (JobHistory.Values.PREP.name().equals(jobStatus)) {
                    this.hasUpdates = true;
                    LOG.info((Object)("Calling init from RM for job " + this.jip.getJobID().toString()));
                    try {
                        JobTracker.this.initJob(this.jip);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Job initialization failed : \n" + StringUtils.stringifyException(t)));
                        JobTracker.this.failJob(this.jip);
                        throw new IOException(t);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                if (this.hasUpdates) {
                    JobStatusChangeEvent event = RecoveryManager.this.updateJob(this.jip, this.job);
                    JobTracker jobTracker = JobTracker.this;
                    synchronized (jobTracker) {
                        JobTracker.this.updateJobInProgressListeners(event);
                    }
                }
            }

            public int getNumEventsRecovered() {
                return this.numEventsRecovered;
            }
        }
    }

    private class FaultyTrackersInfo {
        private Map<String, FaultInfo> potentiallyFaultyTrackers = new HashMap<String, FaultInfo>();
        private volatile int numBlacklistedTrackers = 0;

        private FaultyTrackersInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementFaults(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.getFaultInfo(hostName, true);
                int numFaults = fi.getFaultCount();
                fi.setFaultCount(++numFaults);
                fi.setLastUpdated(JobTracker.this.clock.getTime());
                if (this.exceedsFaults(fi)) {
                    LOG.info((Object)("Adding " + hostName + " to the blacklist" + " across all jobs"));
                    String reason = String.format("%d failures on the tracker", numFaults);
                    this.blackListTracker(hostName, reason, ReasonForBlackListing.EXCEEDING_FAILURES);
                }
            }
        }

        private void incrBlackListedTrackers(int count) {
            this.numBlacklistedTrackers += count;
            JobTracker.this.getInstrumentation().addBlackListedTrackers(count);
        }

        private void decrBlackListedTrackers(int count) {
            this.numBlacklistedTrackers -= count;
            JobTracker.this.getInstrumentation().decBlackListedTrackers(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blackListTracker(String hostName, String reason, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, true);
            boolean blackListed = fi.isBlacklisted();
            if (blackListed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding blacklisted reason for tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                }
                if (!fi.getReasonforblacklisting().contains((Object)rfb)) {
                    LOG.info((Object)("Adding blacklisted reason for tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                }
                fi.addBlackListedReason(rfb, reason);
            } else {
                Set<TaskTracker> trackers;
                LOG.info((Object)("Blacklisting tracker : " + hostName + " Reason for blacklisting is : " + (Object)((Object)rfb)));
                Set<TaskTracker> set = trackers = JobTracker.this.hostnameToTaskTracker.get(hostName);
                synchronized (set) {
                    for (TaskTracker tracker : trackers) {
                        tracker.cancelAllReservations();
                    }
                }
                this.removeHostCapacity(hostName);
                fi.setBlacklist(rfb, reason);
            }
        }

        private boolean canUnBlackListTracker(String hostName, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, false);
            if (fi == null) {
                return false;
            }
            Set<ReasonForBlackListing> rfbSet = fi.getReasonforblacklisting();
            return fi.isBlacklisted() && rfbSet.contains((Object)rfb);
        }

        private void unBlackListTracker(String hostName, ReasonForBlackListing rfb) {
            FaultInfo fi = this.getFaultInfo(hostName, false);
            if (fi.removeBlackListedReason(rfb) && fi.getReasonforblacklisting().isEmpty()) {
                this.addHostCapacity(hostName);
                LOG.info((Object)("Unblacklisting tracker : " + hostName));
                fi.unBlacklist();
                if (fi.numFaults == 0) {
                    this.potentiallyFaultyTrackers.remove(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FaultInfo getFaultInfo(String hostName, boolean createIfNeccessary) {
            FaultInfo fi = null;
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi == null && createIfNeccessary) {
                    fi = new FaultInfo(JobTracker.this.clock.getTime());
                    this.potentiallyFaultyTrackers.put(hostName, fi);
                }
            }
            return fi;
        }

        private boolean exceedsFaults(FaultInfo fi) {
            int faultCount = fi.getFaultCount();
            if (faultCount >= JobTracker.this.MAX_BLACKLISTS_PER_TRACKER) {
                long clusterSize = JobTracker.this.getClusterStatus().getTaskTrackers();
                long sum = 0L;
                for (FaultInfo f : this.potentiallyFaultyTrackers.values()) {
                    sum += (long)f.getFaultCount();
                }
                double avg = (double)sum / (double)clusterSize;
                long totalCluster = clusterSize + (long)this.numBlacklistedTrackers;
                if ((double)faultCount - avg > JobTracker.this.AVERAGE_BLACKLIST_THRESHOLD * avg && (double)this.numBlacklistedTrackers < (double)totalCluster * MAX_BLACKLIST_PERCENT) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markTrackerHealthy(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.remove(hostName);
                if (fi != null && fi.isBlacklisted()) {
                    LOG.info((Object)("Removing " + hostName + " from blacklist"));
                    this.addHostCapacity(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldAssignTasksToTracker(String hostName, long now) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null && now - fi.getLastUpdated() > UPDATE_FAULTY_TRACKER_INTERVAL) {
                    int numFaults = fi.getFaultCount() - 1;
                    fi.setFaultCount(numFaults);
                    fi.setLastUpdated(now);
                    if (this.canUnBlackListTracker(hostName, ReasonForBlackListing.EXCEEDING_FAILURES)) {
                        this.unBlackListTracker(hostName, ReasonForBlackListing.EXCEEDING_FAILURES);
                    }
                }
                return fi != null && fi.isBlacklisted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity -= mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity -= reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().addBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().addBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.remove(hostName);
                this.incrBlackListedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    int mapSlots = status.getMaxMapSlots();
                    JobTracker.this.totalMapTaskCapacity += mapSlots;
                    int reduceSlots = status.getMaxReduceSlots();
                    JobTracker.this.totalReduceTaskCapacity += reduceSlots;
                    ++numTrackersOnHost;
                    JobTracker.this.getInstrumentation().decBlackListedMapSlots(mapSlots);
                    JobTracker.this.getInstrumentation().decBlackListedReduceSlots(reduceSlots);
                }
                JobTracker.this.uniqueHostsMap.put(hostName, numTrackersOnHost);
                this.decrBlackListedTrackers(numTrackersOnHost);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isBlacklisted(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.isBlacklisted();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getFaultCount(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getFaultCount();
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<ReasonForBlackListing> getReasonForBlackListing(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getReasonforblacklisting();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNodeHealthStatus(String hostName, boolean isHealthy, String reason) {
            FaultInfo fi = null;
            if (!isHealthy) {
                fi = this.getFaultInfo(hostName, true);
                fi.setHealthy(isHealthy);
                Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
                synchronized (map) {
                    this.blackListTracker(hostName, reason, ReasonForBlackListing.NODE_UNHEALTHY);
                }
            } else {
                fi = this.getFaultInfo(hostName, false);
                if (fi == null) {
                    return;
                }
                if (this.canUnBlackListTracker(hostName, ReasonForBlackListing.NODE_UNHEALTHY)) {
                    this.unBlackListTracker(hostName, ReasonForBlackListing.NODE_UNHEALTHY);
                }
            }
        }
    }

    private static class FaultInfo {
        static final String FAULT_FORMAT_STRING = "%d failures on the tracker";
        int numFaults = 0;
        long lastUpdated;
        boolean blacklisted;
        private boolean isHealthy;
        private HashMap<ReasonForBlackListing, String> rfbMap;

        FaultInfo(long time) {
            this.lastUpdated = time;
            this.blacklisted = false;
            this.rfbMap = new HashMap();
        }

        void setFaultCount(int num) {
            this.numFaults = num;
        }

        void setLastUpdated(long timeStamp) {
            this.lastUpdated = timeStamp;
        }

        int getFaultCount() {
            return this.numFaults;
        }

        long getLastUpdated() {
            return this.lastUpdated;
        }

        boolean isBlacklisted() {
            return this.blacklisted;
        }

        void setBlacklist(ReasonForBlackListing rfb, String trackerFaultReport) {
            this.blacklisted = true;
            this.rfbMap.put(rfb, trackerFaultReport);
        }

        public void setHealthy(boolean isHealthy) {
            this.isHealthy = isHealthy;
        }

        public boolean isHealthy() {
            return this.isHealthy;
        }

        public String getTrackerFaultReport() {
            StringBuffer sb = new StringBuffer();
            for (String reasons : this.rfbMap.values()) {
                sb.append(reasons);
                sb.append("\n");
            }
            return sb.toString();
        }

        Set<ReasonForBlackListing> getReasonforblacklisting() {
            return this.rfbMap.keySet();
        }

        public void unBlacklist() {
            this.blacklisted = false;
            this.rfbMap.clear();
        }

        public boolean removeBlackListedReason(ReasonForBlackListing rfb) {
            String str = this.rfbMap.remove((Object)rfb);
            return str != null;
        }

        public void addBlackListedReason(ReasonForBlackListing rfb, String reason) {
            this.rfbMap.put(rfb, reason);
        }
    }

    static enum ReasonForBlackListing {
        EXCEEDING_FAILURES,
        NODE_UNHEALTHY;

    }

    class RetireJobs
    implements Runnable {
        private final Map<JobID, RetireJobInfo> jobIDStatusMap = new HashMap<JobID, RetireJobInfo>();
        private final LinkedList<RetireJobInfo> jobRetireInfoQ = new LinkedList();

        synchronized void addToCache(JobInProgress job) {
            Counters counters = new Counters();
            boolean isFine = job.getCounters(counters);
            counters = isFine ? counters : new Counters();
            RetireJobInfo info = new RetireJobInfo(counters, job.getStatus(), job.getProfile(), job.getFinishTime(), job.getHistoryFile());
            this.jobRetireInfoQ.add(info);
            this.jobIDStatusMap.put(info.status.getJobID(), info);
            if (this.jobRetireInfoQ.size() > JobTracker.this.retiredJobsCacheSize) {
                RetireJobInfo removed = this.jobRetireInfoQ.remove();
                this.jobIDStatusMap.remove(removed.status.getJobID());
                LOG.info((Object)("Retired job removed from cache " + removed.status.getJobID()));
            }
        }

        synchronized RetireJobInfo get(JobID jobId) {
            return this.jobIDStatusMap.get(jobId);
        }

        synchronized LinkedList<RetireJobInfo> getAll() {
            return (LinkedList)this.jobRetireInfoQ.clone();
        }

        synchronized LinkedList<JobStatus> getAllJobStatus() {
            LinkedList<JobStatus> list = new LinkedList<JobStatus>();
            for (RetireJobInfo info : this.jobRetireInfoQ) {
                list.add(info.status);
            }
            return list;
        }

        private boolean minConditionToRetire(JobInProgress job, long now) {
            return job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4 && job.getFinishTime() + 0L < now && job.isHistoryFileCopied();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Object jobUser;
                    Object object;
                    ArrayList<JobInProgress> retiredJobs;
                    do {
                        Thread.sleep(RETIRE_JOB_CHECK_INTERVAL);
                        retiredJobs = new ArrayList<JobInProgress>();
                        long now = JobTracker.this.clock.getTime();
                        long retireBefore = now - RETIRE_JOB_INTERVAL;
                        object = JobTracker.this.jobs;
                        synchronized (object) {
                            for (JobInProgress job : JobTracker.this.jobs.values()) {
                                if (!this.minConditionToRetire(job, now) || job.getFinishTime() >= retireBefore) continue;
                                retiredJobs.add(job);
                            }
                        }
                        object = JobTracker.this.userToJobsMap;
                        synchronized (object) {
                            Iterator<Map.Entry<String, ArrayList<JobInProgress>>> userToJobsMapIt = JobTracker.this.userToJobsMap.entrySet().iterator();
                            while (userToJobsMapIt.hasNext()) {
                                Map.Entry<String, ArrayList<JobInProgress>> entry = userToJobsMapIt.next();
                                ArrayList<JobInProgress> userJobs = entry.getValue();
                                Iterator<JobInProgress> it = userJobs.iterator();
                                while (it.hasNext() && userJobs.size() > JobTracker.this.MAX_COMPLETE_USER_JOBS_IN_MEMORY) {
                                    jobUser = it.next();
                                    if (retiredJobs.contains(jobUser)) {
                                        LOG.info((Object)("Removing from userToJobsMap: " + ((JobInProgress)jobUser).getJobID()));
                                        it.remove();
                                        continue;
                                    }
                                    if (!this.minConditionToRetire((JobInProgress)jobUser, now)) continue;
                                    LOG.info((Object)("User limit exceeded. Marking job: " + ((JobInProgress)jobUser).getJobID() + " for retire."));
                                    retiredJobs.add((JobInProgress)jobUser);
                                    it.remove();
                                }
                                if (!userJobs.isEmpty()) continue;
                                userToJobsMapIt.remove();
                            }
                        }
                    } while (retiredJobs.isEmpty());
                    object = JobTracker.this;
                    synchronized (object) {
                        Map<JobID, JobInProgress> map = JobTracker.this.jobs;
                        synchronized (map) {
                            TaskScheduler taskScheduler = JobTracker.this.taskScheduler;
                            synchronized (taskScheduler) {
                                for (JobInProgress job : retiredJobs) {
                                    JobTracker.this.removeJobTasks(job);
                                    JobTracker.this.jobs.remove(job.getProfile().getJobID());
                                    for (JobInProgressListener l : JobTracker.this.jobInProgressListeners) {
                                        l.jobRemoved(job);
                                    }
                                    jobUser = job.getProfile().getUser();
                                    LOG.info((Object)("Retired job with id: '" + job.getProfile().getJobID() + "' of user '" + (String)jobUser + "'"));
                                    JobHistory.JobInfo.cleanupJob(job.getProfile().getJobID());
                                    this.addToCache(job);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException t) {
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in retiring job:\n" + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    static class RetireJobInfo {
        final JobStatus status;
        final JobProfile profile;
        final long finishTime;
        final Counters counters;
        private String historyFile;

        RetireJobInfo(Counters counters, JobStatus status, JobProfile profile, long finishTime, String historyFile) {
            this.counters = counters;
            this.status = status;
            this.profile = profile;
            this.finishTime = finishTime;
            this.historyFile = historyFile;
        }

        void setHistoryFile(String file) {
            this.historyFile = file;
        }

        String getHistoryFile() {
            return this.historyFile;
        }
    }

    class ExpireTrackers
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            HashMap hashMap = JobTracker.this.taskTrackers;
                            synchronized (hashMap) {
                                TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                                synchronized (treeSet) {
                                    long now = JobTracker.this.clock.getTime();
                                    TaskTrackerStatus leastRecent = null;
                                    while (JobTracker.this.trackerExpiryQueue.size() > 0 && (leastRecent = JobTracker.this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                        JobTracker.this.trackerExpiryQueue.remove(leastRecent);
                                        String trackerName = leastRecent.getTrackerName();
                                        TaskTracker current = JobTracker.this.getTaskTracker(trackerName);
                                        TaskTrackerStatus newProfile = current == null ? null : current.getStatus();
                                        if (newProfile == null) continue;
                                        if (now - newProfile.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                            JobTracker.this.removeTracker(current);
                                            String hostname = newProfile.getHost();
                                            JobTracker.this.hostnameToTaskTracker.get(hostname).remove(trackerName);
                                            continue;
                                        }
                                        JobTracker.this.trackerExpiryQueue.add(newProfile);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
                catch (Exception t) {
                    LOG.error((Object)("Tracker Expiry Thread got exception: " + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private Map<TaskAttemptID, Long> launchingTasks = new LinkedHashMap<TaskAttemptID, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        long now = JobTracker.this.clock.getTime();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Starting launching task sweep");
                        }
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            Map<TaskAttemptID, Long> map = this.launchingTasks;
                            synchronized (map) {
                                Iterator<Map.Entry<TaskAttemptID, Long>> itr = this.launchingTasks.entrySet().iterator();
                                while (itr.hasNext()) {
                                    Map.Entry<TaskAttemptID, Long> pair = itr.next();
                                    TaskAttemptID taskId = pair.getKey();
                                    long age = now - pair.getValue();
                                    LOG.info((Object)(taskId + " is " + age + " ms debug."));
                                    if (age <= TASKTRACKER_EXPIRY_INTERVAL) break;
                                    LOG.info((Object)("Launching task " + taskId + " timed out."));
                                    TaskInProgress tip = null;
                                    tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                    if (tip != null) {
                                        JobInProgress job = tip.getJob();
                                        String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                        TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTrackerStatus(trackerName);
                                        if (trackerStatus != null) {
                                            job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerName);
                                        }
                                    }
                                    itr.remove();
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Expire Launching Task Thread got exception: " + StringUtils.stringifyException(e)));
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, JobTracker.this.clock.getTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }
    }

    public static class IllegalStateException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public IllegalStateException(String msg) {
            super(msg);
        }
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

