/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;

public class JobHistory {
    static final long VERSION = 1L;
    public static final Log LOG = LogFactory.getLog(JobHistory.class);
    private static final char DELIMITER = ' ';
    static final char LINE_DELIMITER_CHAR = '.';
    static final char[] charsToEscape = new char[]{'\"', '=', '.'};
    static final String DIGITS = "[0-9]+";
    static final String KEY = "(\\w+)";
    static final String VALUE = "[^\"\\\\]*+(?:\\\\.[^\"\\\\]*+)*+";
    static final Pattern pattern = Pattern.compile("(\\w+)=\"[^\"\\\\]*+(?:\\\\.[^\"\\\\]*+)*+\"");
    public static final int JOB_NAME_TRIM_LENGTH = 50;
    private static String JOBTRACKER_UNIQUE_STRING = null;
    private static String LOG_DIR = null;
    private static final String SECONDARY_FILE_SUFFIX = ".recover";
    private static long jobHistoryBlockSize = 0L;
    private static String jobtrackerHostname;
    private static JobHistoryFilesManager fileManager;
    static final FsPermission HISTORY_DIR_PERMISSION;
    static final FsPermission HISTORY_FILE_PERMISSION;
    private static FileSystem LOGDIR_FS;
    private static FileSystem DONEDIR_FS;
    private static JobConf jtConf;
    private static Path DONE;
    private static boolean aclsEnabled;
    private static final PathFilter CONF_FILTER;
    private static Map<JobID, MovedFileInfo> jobHistoryFileMap;

    public static String getHistoryFilePath(JobID jobId) {
        MovedFileInfo info = jobHistoryFileMap.get(jobId);
        if (info == null) {
            return null;
        }
        return info.historyFile;
    }

    public static void init(JobTracker jobTracker, JobConf conf, String hostname, long jobTrackerStartTime) throws IOException {
        LOG_DIR = conf.get("hadoop.job.history.location", "file:///" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath() + File.separator + "history");
        JOBTRACKER_UNIQUE_STRING = hostname + "_" + String.valueOf(jobTrackerStartTime) + "_";
        jobtrackerHostname = hostname;
        Path logDir = new Path(LOG_DIR);
        LOGDIR_FS = logDir.getFileSystem(conf);
        if (!LOGDIR_FS.exists(logDir) && !LOGDIR_FS.mkdirs(logDir, new FsPermission(HISTORY_DIR_PERMISSION))) {
            throw new IOException("Mkdirs failed to create " + logDir.toString());
        }
        conf.set("hadoop.job.history.location", LOG_DIR);
        jobHistoryBlockSize = conf.getLong("mapred.jobtracker.job.history.block.size", 0x300000L);
        jtConf = conf;
        aclsEnabled = conf.getBoolean("mapred.acls.enabled", false);
        fileManager = new JobHistoryFilesManager(conf, jobTracker);
    }

    static void initDone(JobConf conf, FileSystem fs) throws IOException {
        String doneLocation = conf.get("mapred.job.tracker.history.completed.location");
        if (doneLocation != null) {
            Path donePath = new Path(doneLocation);
            DONEDIR_FS = donePath.getFileSystem(conf);
            DONE = DONEDIR_FS.makeQualified(donePath);
        } else {
            DONE = new Path(LOG_DIR, "done");
            DONEDIR_FS = LOGDIR_FS;
        }
        if (!DONEDIR_FS.exists(DONE)) {
            LOG.info((Object)("Creating DONE folder at " + DONE));
            if (!DONEDIR_FS.mkdirs(DONE, new FsPermission(HISTORY_DIR_PERMISSION))) {
                throw new IOException("Mkdirs failed to create " + DONE.toString());
            }
        }
        fileManager.start();
    }

    static String escapeString(String data) {
        return StringUtils.escapeString(data, '\\', charsToEscape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHistoryFromFS(String path, Listener l, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(new Path(path));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            StringBuffer buf = new StringBuffer();
            line = reader.readLine();
            if (line == null) {
                return;
            }
            MetaInfoManager mgr = new MetaInfoManager(line);
            boolean isEscaped = mgr.isValueEscaped();
            String lineDelim = String.valueOf(mgr.getLineDelim());
            String escapedLineDelim = StringUtils.escapeString(lineDelim, '\\', mgr.getLineDelim());
            do {
                buf.append(line);
                if (!line.trim().endsWith(lineDelim) || line.trim().endsWith(escapedLineDelim)) {
                    buf.append("\n");
                    continue;
                }
                JobHistory.parseLine(buf.toString(), l, isEscaped);
                buf = new StringBuffer();
            } while ((line = reader.readLine()) != null);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void parseLine(String line, Listener l, boolean isEscaped) throws IOException {
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        HashMap<Keys, String> parseBuffer = new HashMap<Keys, String>();
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = StringUtils.split(tuple, '\\', '=');
            String value = parts[1].substring(1, parts[1].length() - 1);
            if (isEscaped) {
                value = StringUtils.unEscapeString(value, '\\', charsToEscape);
            }
            parseBuffer.put(Keys.valueOf(parts[0]), value);
        }
        l.handle(RecordTypes.valueOf(recType), parseBuffer);
        parseBuffer.clear();
    }

    static void log(PrintWriter out, RecordTypes recordType, Keys key, String value) {
        value = JobHistory.escapeString(value);
        out.println(recordType.name() + ' ' + (Object)((Object)key) + "=\"" + value + "\"" + ' ' + '.');
    }

    static void log(ArrayList<PrintWriter> writers, RecordTypes recordType, Keys[] keys, String[] values) {
        JobHistory.log(writers, recordType, keys, values, null);
    }

    static void log(ArrayList<PrintWriter> writers, RecordTypes recordType, Keys[] keys, String[] values, JobID id) {
        int length = recordType.name().length() + keys.length * 4 + 2;
        for (int i = 0; i < keys.length; ++i) {
            values[i] = JobHistory.escapeString(values[i]);
            length += values[i].length() + keys[i].toString().length();
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(recordType.name());
        builder.append(' ');
        for (int i = 0; i < keys.length; ++i) {
            builder.append((Object)keys[i]);
            builder.append("=\"");
            builder.append(values[i]);
            builder.append("\"");
            builder.append(' ');
        }
        builder.append('.');
        for (PrintWriter out : writers) {
            out.println(builder.toString());
            if (!out.checkError() || id == null) continue;
            LOG.info((Object)("Logging failed for job " + id + "removing PrintWriter from FileManager"));
            fileManager.removeWriter(id, out);
        }
    }

    static Path getJobHistoryLocation() {
        return new Path(LOG_DIR);
    }

    static Path getCompletedJobHistoryLocation() {
        return DONE;
    }

    public static String getTaskLogsUrl(TaskAttempt attempt) {
        if (attempt.get(Keys.HTTP_PORT).equals("") || attempt.get(Keys.TRACKER_NAME).equals("") || attempt.get(Keys.TASK_ATTEMPT_ID).equals("")) {
            return null;
        }
        String taskTrackerName = JobInProgress.convertTrackerNameToHostName(attempt.get(Keys.TRACKER_NAME));
        return TaskLogServlet.getTaskLogUrl(taskTrackerName, attempt.get(Keys.HTTP_PORT), attempt.get(Keys.TASK_ATTEMPT_ID));
    }

    static {
        fileManager = null;
        HISTORY_DIR_PERMISSION = FsPermission.createImmutable((short)493);
        HISTORY_FILE_PERMISSION = FsPermission.createImmutable((short)484);
        DONE = null;
        aclsEnabled = false;
        CONF_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path path) {
                return path.getName().endsWith("_conf.xml");
            }
        };
        jobHistoryFileMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    public static class HistoryCleaner
    implements Runnable {
        static final long ONE_DAY_IN_MS = 86400000L;
        static final long THIRTY_DAYS_IN_MS = 2592000000L;
        private long now;
        private static boolean isRunning = false;
        private static long lastRan = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (isRunning) {
                return;
            }
            this.now = System.currentTimeMillis();
            if (lastRan != 0L && this.now - lastRan < 86400000L) {
                return;
            }
            lastRan = this.now;
            isRunning = true;
            try {
                FileStatus[] historyFiles = DONEDIR_FS.listStatus(DONE);
                if (historyFiles != null) {
                    for (FileStatus f : historyFiles) {
                        if (this.now - f.getModificationTime() <= 2592000000L) continue;
                        DONEDIR_FS.delete(f.getPath(), true);
                        LOG.info((Object)("Deleting old history file : " + f.getPath()));
                    }
                }
                Map map = jobHistoryFileMap;
                synchronized (map) {
                    MovedFileInfo info;
                    Iterator it = jobHistoryFileMap.entrySet().iterator();
                    while (it.hasNext() && this.now - (info = (MovedFileInfo)it.next().getValue()).timestamp > 2592000000L) {
                        it.remove();
                    }
                }
            }
            catch (IOException ie) {
                LOG.info((Object)("Error cleaning up history directory" + StringUtils.stringifyException(ie)));
            }
            isRunning = false;
        }

        static long getLastRan() {
            return lastRan;
        }
    }

    public static interface Listener {
        public void handle(RecordTypes var1, Map<Keys, String> var2) throws IOException;
    }

    public static class ReduceAttempt
    extends TaskAttempt {
        @Deprecated
        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String hostName) {
            ReduceAttempt.logStarted(taskAttemptId, startTime, hostName, -1, Values.REDUCE.name());
        }

        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String trackerName, int httpPort, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.TRACKER_NAME, Keys.HTTP_PORT}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), String.valueOf(startTime), trackerName, httpPort == -1 ? "" : String.valueOf(httpPort)}, id);
            }
        }

        @Deprecated
        public static void logFinished(TaskAttemptID taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName) {
            ReduceAttempt.logFinished(taskAttemptId, shuffleFinished, sortFinished, finishTime, hostName, Values.REDUCE.name(), "", new Counters());
        }

        public static void logFinished(TaskAttemptID taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName, String taskType, String stateString, Counters counter) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.SHUFFLE_FINISHED, Keys.SORT_FINISHED, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.STATE_STRING, Keys.COUNTERS}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.SUCCESS.name(), String.valueOf(shuffleFinished), String.valueOf(sortFinished), String.valueOf(finishTime), hostName, stateString, counter.makeEscapedCompactString()}, id);
            }
        }

        @Deprecated
        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            ReduceAttempt.logFailed(taskAttemptId, timestamp, hostName, error, Values.REDUCE.name());
        }

        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.FAILED.name(), String.valueOf(timestamp), hostName, error}, id);
            }
        }

        @Deprecated
        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            ReduceAttempt.logKilled(taskAttemptId, timestamp, hostName, error, Values.REDUCE.name());
        }

        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.KILLED.name(), String.valueOf(timestamp), hostName, error}, id);
            }
        }
    }

    public static class MapAttempt
    extends TaskAttempt {
        @Deprecated
        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String hostName) {
            MapAttempt.logStarted(taskAttemptId, startTime, hostName, -1, Values.MAP.name());
        }

        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String trackerName, int httpPort, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.TRACKER_NAME, Keys.HTTP_PORT}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), String.valueOf(startTime), trackerName, httpPort == -1 ? "" : String.valueOf(httpPort)}, id);
            }
        }

        @Deprecated
        public static void logFinished(TaskAttemptID taskAttemptId, long finishTime, String hostName) {
            MapAttempt.logFinished(taskAttemptId, finishTime, hostName, Values.MAP.name(), "", new Counters());
        }

        public static void logFinished(TaskAttemptID taskAttemptId, long finishTime, String hostName, String taskType, String stateString, Counters counter) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.STATE_STRING, Keys.COUNTERS}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.SUCCESS.name(), String.valueOf(finishTime), hostName, stateString, counter.makeEscapedCompactString()}, id);
            }
        }

        @Deprecated
        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            MapAttempt.logFailed(taskAttemptId, timestamp, hostName, error, Values.MAP.name());
        }

        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.FAILED.name(), String.valueOf(timestamp), hostName, error}, id);
            }
        }

        @Deprecated
        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            MapAttempt.logKilled(taskAttemptId, timestamp, hostName, error, Values.MAP.name());
        }

        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            JobID id = taskAttemptId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.KILLED.name(), String.valueOf(timestamp), hostName, error}, id);
            }
        }
    }

    public static class TaskAttempt
    extends Task {
    }

    public static class Task
    extends KeyValuePair {
        private Map<String, TaskAttempt> taskAttempts = new TreeMap<String, TaskAttempt>();

        public static void logStarted(TaskID taskId, String taskType, long startTime, String splitLocations) {
            JobID id = taskId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.START_TIME, Keys.SPLITS}, new String[]{taskId.toString(), taskType, String.valueOf(startTime), splitLocations}, id);
            }
        }

        public static void logFinished(TaskID taskId, String taskType, long finishTime, Counters counters) {
            JobID id = taskId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.COUNTERS}, new String[]{taskId.toString(), taskType, Values.SUCCESS.name(), String.valueOf(finishTime), counters.makeEscapedCompactString()}, id);
            }
        }

        public static void logUpdates(TaskID taskId, long finishTime) {
            JobID id = taskId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.FINISH_TIME}, new String[]{taskId.toString(), String.valueOf(finishTime)}, id);
            }
        }

        public static void logFailed(TaskID taskId, String taskType, long time, String error) {
            Task.logFailed(taskId, taskType, time, error, null);
        }

        public static void logFailed(TaskID taskId, String taskType, long time, String error, TaskAttemptID failedDueToAttempt) {
            JobID id = taskId.getJobID();
            ArrayList<PrintWriter> writer = fileManager.getWriters(id);
            if (null != writer) {
                String failedAttempt = failedDueToAttempt == null ? "" : failedDueToAttempt.toString();
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.ERROR, Keys.TASK_ATTEMPT_ID}, new String[]{taskId.toString(), taskType, Values.FAILED.name(), String.valueOf(time), error, failedAttempt}, id);
            }
        }

        public Map<String, TaskAttempt> getTaskAttempts() {
            return this.taskAttempts;
        }
    }

    public static class JobInfo
    extends KeyValuePair {
        private Map<String, Task> allTasks = new TreeMap<String, Task>();
        private Map<JobACL, AccessControlList> jobACLs = new HashMap<JobACL, AccessControlList>();
        private String queueName = null;

        public JobInfo(String jobId) {
            this.set(Keys.JOBID, jobId);
        }

        public Map<String, Task> getAllTasks() {
            return this.allTasks;
        }

        public Map<JobACL, AccessControlList> getJobACLs() {
            return this.jobACLs;
        }

        @Override
        public synchronized void handle(Map<Keys, String> values) {
            if (values.containsKey((Object)Keys.SUBMIT_TIME)) {
                String viewJobACL = values.get((Object)Keys.VIEW_JOB);
                String modifyJobACL = values.get((Object)Keys.MODIFY_JOB);
                if (viewJobACL != null) {
                    this.jobACLs.put(JobACL.VIEW_JOB, new AccessControlList(viewJobACL));
                }
                if (modifyJobACL != null) {
                    this.jobACLs.put(JobACL.MODIFY_JOB, new AccessControlList(modifyJobACL));
                }
                this.queueName = values.get((Object)Keys.JOB_QUEUE);
            }
            super.handle(values);
        }

        String getJobQueue() {
            return this.queueName;
        }

        public static String getLocalJobFilePath(JobID jobId) {
            return System.getProperty("hadoop.log.dir") + File.separator + jobId + "_conf.xml";
        }

        public static String encodeJobHistoryFilePath(String logFile) throws IOException {
            Path rawPath = new Path(logFile);
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(rawPath.getName(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            Path encodedPath = new Path(rawPath.getParent(), encodedFileName);
            return encodedPath.toString();
        }

        public static String encodeJobHistoryFileName(String logFileName) throws IOException {
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return encodedFileName;
        }

        public static String decodeJobHistoryFileName(String logFileName) throws IOException {
            String decodedFileName = null;
            try {
                decodedFileName = URLDecoder.decode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return decodedFileName;
        }

        static String getJobName(JobConf jobConf) {
            String jobName = jobConf.getJobName();
            if (jobName == null || jobName.length() == 0) {
                jobName = "NA";
            }
            return jobName;
        }

        public static String getUserName(JobConf jobConf) {
            String user = jobConf.getUser();
            if (user == null || user.length() == 0) {
                user = "NA";
            }
            return user;
        }

        public static Path getJobHistoryLogLocation(String logFileName) {
            return LOG_DIR == null ? null : new Path(LOG_DIR, logFileName);
        }

        public static Path getJobHistoryLogLocationForUser(String logFileName, JobConf jobConf) {
            Path userLogFile = null;
            Path outputPath = FileOutputFormat.getOutputPath(jobConf);
            String userLogDir = jobConf.get("hadoop.job.history.user.location", outputPath == null ? null : outputPath.toString());
            if ("none".equals(userLogDir)) {
                userLogDir = null;
            }
            if (userLogDir != null) {
                userLogDir = userLogDir + "/" + "_logs" + "/" + "history";
                userLogFile = new Path(userLogDir, logFileName);
            }
            return userLogFile;
        }

        private static String getNewJobHistoryFileName(JobConf jobConf, JobID id) {
            return JOBTRACKER_UNIQUE_STRING + id.toString() + "_" + JobInfo.getUserName(jobConf) + "_" + JobInfo.trimJobName(JobInfo.getJobName(jobConf));
        }

        private static String trimJobName(String jobName) {
            if (jobName.length() > 50) {
                jobName = jobName.substring(0, 50);
            }
            return jobName;
        }

        private static String escapeRegexChars(String string) {
            return "\\Q" + string.replaceAll("\\\\E", "\\\\E\\\\\\\\E\\\\Q") + "\\E";
        }

        public static synchronized String getJobHistoryFileName(JobConf jobConf, JobID id) throws IOException {
            return JobInfo.getJobHistoryFileName(jobConf, id, new Path(LOG_DIR), LOGDIR_FS);
        }

        static synchronized String getDoneJobHistoryFileName(JobConf jobConf, JobID id) throws IOException {
            if (DONE == null) {
                return null;
            }
            return JobInfo.getJobHistoryFileName(jobConf, id, DONE, DONEDIR_FS);
        }

        private static synchronized String getJobHistoryFileName(JobConf jobConf, JobID id, Path dir, FileSystem fs) throws IOException {
            String user = JobInfo.getUserName(jobConf);
            String jobName = JobInfo.trimJobName(JobInfo.getJobName(jobConf));
            if (LOG_DIR == null) {
                return null;
            }
            final Pattern historyFilePattern = Pattern.compile(jobtrackerHostname + "_" + JobHistory.DIGITS + "_" + id.toString() + "_" + user + "_" + JobInfo.escapeRegexChars(jobName) + "+");
            PathFilter filter = new PathFilter(){

                @Override
                public boolean accept(Path path) {
                    String fileName = path.getName();
                    try {
                        fileName = JobInfo.decodeJobHistoryFileName(fileName);
                    }
                    catch (IOException ioe) {
                        LOG.info((Object)("Error while decoding history file " + fileName + "." + " Ignoring file."), (Throwable)ioe);
                        return false;
                    }
                    return historyFilePattern.matcher(fileName).find();
                }
            };
            FileStatus[] statuses = fs.listStatus(dir, filter);
            String filename = null;
            if (statuses.length == 0) {
                LOG.info((Object)("Nothing to recover for job " + id));
            } else {
                filename = JobInfo.getPrimaryFilename(statuses[0].getPath().getName(), jobName);
                LOG.info((Object)("Recovered job history filename for job " + id + " is " + filename));
            }
            return filename;
        }

        private static String getPrimaryFilename(String filename, String jobName) throws IOException {
            if ((filename = JobInfo.decodeJobHistoryFileName(filename)).endsWith(jobName + JobHistory.SECONDARY_FILE_SUFFIX)) {
                int newLength = filename.length() - JobHistory.SECONDARY_FILE_SUFFIX.length();
                filename = filename.substring(0, newLength);
            }
            return JobInfo.encodeJobHistoryFileName(filename);
        }

        static synchronized void checkpointRecovery(String fileName, JobConf conf) throws IOException {
            Path logPath = JobInfo.getJobHistoryLogLocation(fileName);
            if (logPath != null) {
                LOG.info((Object)("Deleting job history file " + logPath.getName()));
                LOGDIR_FS.delete(logPath, false);
            }
            if ((logPath = JobInfo.getJobHistoryLogLocationForUser(fileName, conf)) != null) {
                FileSystem fs = logPath.getFileSystem(conf);
                fs.delete(logPath, false);
            }
        }

        static String getSecondaryJobHistoryFile(String filename) throws IOException {
            return JobInfo.encodeJobHistoryFileName(JobInfo.decodeJobHistoryFileName(filename) + JobHistory.SECONDARY_FILE_SUFFIX);
        }

        public static synchronized Path recoverJobHistoryFile(JobConf conf, Path logFilePath) throws IOException {
            Path ret;
            String logFileName = logFilePath.getName();
            String tmpFilename = JobInfo.getSecondaryJobHistoryFile(logFileName);
            Path logDir = logFilePath.getParent();
            Path tmpFilePath = new Path(logDir, tmpFilename);
            if (LOGDIR_FS.exists(logFilePath)) {
                LOG.info((Object)(logFileName + " exists!"));
                if (LOGDIR_FS.exists(tmpFilePath)) {
                    LOG.info((Object)("Deleting " + tmpFilename + "  and using " + logFileName + " for recovery."));
                    LOGDIR_FS.delete(tmpFilePath, false);
                }
                ret = tmpFilePath;
            } else {
                LOG.info((Object)(logFileName + " doesnt exist! Using " + tmpFilename + " for recovery."));
                if (LOGDIR_FS.exists(tmpFilePath)) {
                    LOG.info((Object)("Renaming " + tmpFilename + " to " + logFileName));
                    LOGDIR_FS.rename(tmpFilePath, logFilePath);
                    ret = tmpFilePath;
                } else {
                    ret = logFilePath;
                }
            }
            logFilePath = JobInfo.getJobHistoryLogLocationForUser(logFileName, conf);
            if (logFilePath != null) {
                FileSystem fs = logFilePath.getFileSystem(conf);
                logDir = logFilePath.getParent();
                tmpFilePath = new Path(logDir, tmpFilename);
                if (fs.exists(logFilePath)) {
                    LOG.info((Object)(logFileName + " exists!"));
                    if (fs.exists(tmpFilePath)) {
                        LOG.info((Object)("Deleting " + tmpFilename + "  and making " + logFileName + " as the master history file for user."));
                        fs.delete(tmpFilePath, false);
                    }
                } else {
                    LOG.info((Object)(logFileName + " doesnt exist! Using " + tmpFilename + " as the master history file for user."));
                    if (fs.exists(tmpFilePath)) {
                        LOG.info((Object)("Renaming " + tmpFilename + " to " + logFileName + " in user directory"));
                        fs.rename(tmpFilePath, logFilePath);
                    }
                }
            }
            return ret;
        }

        static synchronized void finalizeRecovery(JobID id, JobConf conf) throws IOException {
            FileSystem fs;
            Path tmpLogPath = fileManager.getHistoryFile(id);
            if (tmpLogPath == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No file for job with " + id + " found in cache!"));
                }
                return;
            }
            String tmpLogFileName = tmpLogPath.getName();
            String masterLogFileName = JobInfo.getPrimaryFilename(tmpLogFileName, JobInfo.getJobName(conf));
            Path masterLogPath = new Path(tmpLogPath.getParent(), masterLogFileName);
            LOG.info((Object)("Renaming " + tmpLogFileName + " to " + masterLogFileName));
            LOGDIR_FS.rename(tmpLogPath, masterLogPath);
            fileManager.setHistoryFile(id, masterLogPath);
            masterLogPath = JobInfo.getJobHistoryLogLocationForUser(masterLogFileName, conf);
            tmpLogPath = JobInfo.getJobHistoryLogLocationForUser(tmpLogFileName, conf);
            if (masterLogPath != null && (fs = masterLogPath.getFileSystem(conf)).exists(tmpLogPath)) {
                LOG.info((Object)("Renaming " + tmpLogFileName + " to " + masterLogFileName + " in user directory"));
                fs.rename(tmpLogPath, masterLogPath);
            }
        }

        static void cleanupJob(JobID id) {
            String localJobFilePath = JobInfo.getLocalJobFilePath(id);
            File f = new File(localJobFilePath);
            LOG.info((Object)("Deleting localized job conf at " + f));
            if (!f.delete() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to delete file " + f));
            }
        }

        static void deleteConfFiles() throws IOException {
            FileStatus[] status;
            LOG.info((Object)"Cleaning up config files from the job history folder");
            FileSystem fs = new Path(LOG_DIR).getFileSystem(jtConf);
            for (FileStatus s : status = fs.listStatus(new Path(LOG_DIR), CONF_FILTER)) {
                LOG.info((Object)("Deleting conf file " + s.getPath()));
                fs.delete(s.getPath(), false);
            }
        }

        static void markCompleted(JobID id) throws IOException {
            fileManager.moveToDone(id);
        }

        @Deprecated
        public static void logSubmitted(JobID jobId, JobConf jobConf, String jobConfPath, long submitTime) throws IOException {
            JobInfo.logSubmitted(jobId, jobConf, jobConfPath, submitTime, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void logSubmitted(JobID jobId, JobConf jobConf, String jobConfPath, long submitTime, boolean restarted) throws IOException {
            String jobUniqueString;
            String userLogDir;
            FileSystem fs;
            block41: {
                fs = null;
                userLogDir = null;
                jobUniqueString = JOBTRACKER_UNIQUE_STRING + jobId;
                String jobName = JobInfo.getJobName(jobConf);
                String user = JobInfo.getUserName(jobConf);
                String logFileName = null;
                if (restarted) {
                    logFileName = JobInfo.getJobHistoryFileName(jobConf, jobId);
                    if (logFileName == null) {
                        logFileName = JobInfo.encodeJobHistoryFileName(JobInfo.getNewJobHistoryFileName(jobConf, jobId));
                    } else {
                        String[] parts = logFileName.split("_");
                        String jtUniqueString = parts[0] + "_" + parts[1] + "_";
                        jobUniqueString = jtUniqueString + jobId.toString();
                    }
                } else {
                    logFileName = JobInfo.encodeJobHistoryFileName(JobInfo.getNewJobHistoryFileName(jobConf, jobId));
                }
                Path logFile = JobInfo.getJobHistoryLogLocation(logFileName);
                Path userLogFile = JobInfo.getJobHistoryLogLocationForUser(logFileName, jobConf);
                PrintWriter writer = null;
                try {
                    FSDataOutputStream out = null;
                    if (LOG_DIR != null) {
                        if (restarted) {
                            logFile = JobInfo.recoverJobHistoryFile(jobConf, logFile);
                            logFileName = logFile.getName();
                        }
                        int defaultBufferSize = LOGDIR_FS.getConf().getInt("io.file.buffer.size", 4096);
                        out = LOGDIR_FS.create(logFile, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, LOGDIR_FS.getDefaultReplication(), jobHistoryBlockSize, null);
                        writer = new PrintWriter(out);
                        fileManager.addWriter(jobId, writer);
                        fileManager.setHistoryFile(jobId, logFile);
                    }
                    if (userLogFile != null) {
                        userLogDir = userLogFile.getParent().toString();
                        userLogFile = new Path(userLogDir, logFileName);
                        fs = userLogFile.getFileSystem(jobConf);
                        out = fs.create(userLogFile, true, 4096);
                        writer = new PrintWriter(out);
                        fileManager.addWriter(jobId, writer);
                    }
                    ArrayList<PrintWriter> writers = fileManager.getWriters(jobId);
                    MetaInfoManager.logMetaInfo(writers);
                    String viewJobACL = "*";
                    String modifyJobACL = "*";
                    if (aclsEnabled) {
                        viewJobACL = jobConf.get(JobACL.VIEW_JOB.getAclName(), " ");
                        modifyJobACL = jobConf.get(JobACL.MODIFY_JOB.getAclName(), " ");
                    }
                    JobHistory.log(writers, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOBNAME, Keys.USER, Keys.SUBMIT_TIME, Keys.JOBCONF, Keys.VIEW_JOB, Keys.MODIFY_JOB, Keys.JOB_QUEUE}, new String[]{jobId.toString(), jobName, user, String.valueOf(submitTime), jobConfPath, viewJobACL, modifyJobACL, jobConf.getQueueName()}, jobId);
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed creating job history log file for job " + jobId), (Throwable)e);
                    if (writer == null) break block41;
                    fileManager.removeWriter(jobId, writer);
                }
            }
            String localJobFilePath = JobInfo.getLocalJobFilePath(jobId);
            File localJobFile = new File(localJobFilePath);
            FileOutputStream jobOut = null;
            try {
                jobOut = new FileOutputStream(localJobFile);
                jobConf.writeXml(jobOut);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Job conf for " + jobId + " stored at " + localJobFile.getAbsolutePath()));
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Failed to store job conf on the local filesystem ", (Throwable)ioe);
            }
            finally {
                if (jobOut != null) {
                    try {
                        jobOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException(ie)));
                    }
                }
            }
            Path jobFilePath = null;
            if (LOG_DIR != null) {
                jobFilePath = new Path(LOG_DIR + File.separator + jobUniqueString + "_conf.xml");
                fileManager.setConfFile(jobId, jobFilePath);
            }
            Path userJobFilePath = null;
            if (userLogDir != null) {
                userJobFilePath = new Path(userLogDir + File.separator + jobUniqueString + "_conf.xml");
            }
            FSDataOutputStream jobFileOut = null;
            try {
                if (LOG_DIR != null) {
                    int defaultBufferSize = LOGDIR_FS.getConf().getInt("io.file.buffer.size", 4096);
                    if (!LOGDIR_FS.exists(jobFilePath)) {
                        jobFileOut = LOGDIR_FS.create(jobFilePath, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, LOGDIR_FS.getDefaultReplication(), LOGDIR_FS.getDefaultBlockSize(), null);
                        jobConf.writeXml(jobFileOut);
                        jobFileOut.close();
                    }
                }
                if (userLogDir != null) {
                    fs = new Path(userLogDir).getFileSystem(jobConf);
                    jobFileOut = fs.create(userJobFilePath);
                    jobConf.writeXml(jobFileOut);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Job conf for " + jobId + " stored at " + jobFilePath + "and" + userJobFilePath));
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Failed to store job conf in the log dir", (Throwable)ioe);
            }
            finally {
                if (jobFileOut != null) {
                    try {
                        jobFileOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info((Object)("Failed to close the job configuration file " + StringUtils.stringifyException(ie)));
                    }
                }
            }
        }

        public static void logInited(JobID jobId, long startTime, int totalMaps, int totalReduces) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobId);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.LAUNCH_TIME, Keys.TOTAL_MAPS, Keys.TOTAL_REDUCES, Keys.JOB_STATUS}, new String[]{jobId.toString(), String.valueOf(startTime), String.valueOf(totalMaps), String.valueOf(totalReduces), Values.PREP.name()}, jobId);
            }
        }

        @Deprecated
        public static void logStarted(JobID jobId, long startTime, int totalMaps, int totalReduces) {
            JobInfo.logStarted(jobId);
        }

        public static void logStarted(JobID jobId) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobId);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOB_STATUS}, new String[]{jobId.toString(), Values.RUNNING.name()}, jobId);
            }
        }

        public static void logFinished(JobID jobId, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters mapCounters, Counters reduceCounters, Counters counters) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobId);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES, Keys.FAILED_MAPS, Keys.FAILED_REDUCES, Keys.MAP_COUNTERS, Keys.REDUCE_COUNTERS, Keys.COUNTERS}, new String[]{jobId.toString(), Long.toString(finishTime), Values.SUCCESS.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces), String.valueOf(failedMaps), String.valueOf(failedReduces), mapCounters.makeEscapedCompactString(), reduceCounters.makeEscapedCompactString(), counters.makeEscapedCompactString()}, jobId);
                for (PrintWriter out : writer) {
                    out.close();
                }
            }
            Thread historyCleaner = new Thread(new HistoryCleaner());
            historyCleaner.start();
        }

        public static void logFailed(JobID jobid, long timestamp, int finishedMaps, int finishedReduces) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobid);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid.toString(), String.valueOf(timestamp), Values.FAILED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)}, jobid);
                for (PrintWriter out : writer) {
                    out.close();
                }
            }
        }

        public static void logKilled(JobID jobid, long timestamp, int finishedMaps, int finishedReduces) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobid);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid.toString(), String.valueOf(timestamp), Values.KILLED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)}, jobid);
                for (PrintWriter out : writer) {
                    out.close();
                }
            }
        }

        public static void logJobPriority(JobID jobid, JobPriority priority) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobid);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOB_PRIORITY}, new String[]{jobid.toString(), priority.toString()}, jobid);
            }
        }

        @Deprecated
        public static void logJobInfo(JobID jobid, long submitTime, long launchTime, int restartCount) {
            JobInfo.logJobInfo(jobid, submitTime, launchTime);
        }

        public static void logJobInfo(JobID jobid, long submitTime, long launchTime) {
            ArrayList<PrintWriter> writer = fileManager.getWriters(jobid);
            if (null != writer) {
                JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.SUBMIT_TIME, Keys.LAUNCH_TIME}, new String[]{jobid.toString(), String.valueOf(submitTime), String.valueOf(launchTime)}, jobid);
            }
        }
    }

    static class KeyValuePair {
        private Map<Keys, String> values = new HashMap<Keys, String>();

        KeyValuePair() {
        }

        public String get(Keys k) {
            String s = this.values.get((Object)k);
            return s == null ? "" : s;
        }

        public int getInt(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Integer.parseInt(s);
            }
            return 0;
        }

        public long getLong(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Long.parseLong(s);
            }
            return 0L;
        }

        public void set(Keys k, String s) {
            this.values.put(k, s);
        }

        public void set(Map<Keys, String> m) {
            this.values.putAll(m);
        }

        public synchronized void handle(Map<Keys, String> values) {
            this.set(values);
        }

        public Map<Keys, String> getValues() {
            return this.values;
        }
    }

    static class MetaInfoManager
    implements Listener {
        private long version = 0L;
        private KeyValuePair pairs = new KeyValuePair();

        public MetaInfoManager(String line) throws IOException {
            if (null != line) {
                JobHistory.parseLine(line, this, false);
            }
        }

        char getLineDelim() {
            if (this.version == 0L) {
                return '\"';
            }
            return '.';
        }

        boolean isValueEscaped() {
            return this.version != 0L;
        }

        @Override
        public void handle(RecordTypes recType, Map<Keys, String> values) throws IOException {
            if (RecordTypes.Meta == recType) {
                this.pairs.handle(values);
                this.version = this.pairs.getLong(Keys.VERSION);
            }
        }

        static void logMetaInfo(ArrayList<PrintWriter> writers) {
            if (null != writers) {
                JobHistory.log(writers, RecordTypes.Meta, new Keys[]{Keys.VERSION}, new String[]{String.valueOf(1L)});
            }
        }
    }

    public static enum Values {
        SUCCESS,
        FAILED,
        KILLED,
        MAP,
        REDUCE,
        CLEANUP,
        RUNNING,
        PREP,
        SETUP;

    }

    public static enum Keys {
        JOBTRACKERID,
        START_TIME,
        FINISH_TIME,
        JOBID,
        JOBNAME,
        USER,
        JOBCONF,
        SUBMIT_TIME,
        LAUNCH_TIME,
        TOTAL_MAPS,
        TOTAL_REDUCES,
        FAILED_MAPS,
        FAILED_REDUCES,
        FINISHED_MAPS,
        FINISHED_REDUCES,
        JOB_STATUS,
        TASKID,
        HOSTNAME,
        TASK_TYPE,
        ERROR,
        TASK_ATTEMPT_ID,
        TASK_STATUS,
        COPY_PHASE,
        SORT_PHASE,
        REDUCE_PHASE,
        SHUFFLE_FINISHED,
        SORT_FINISHED,
        COUNTERS,
        SPLITS,
        JOB_PRIORITY,
        HTTP_PORT,
        TRACKER_NAME,
        STATE_STRING,
        VERSION,
        MAP_COUNTERS,
        REDUCE_COUNTERS,
        VIEW_JOB,
        MODIFY_JOB,
        JOB_QUEUE;

    }

    public static enum RecordTypes {
        Jobtracker,
        Job,
        Task,
        MapAttempt,
        ReduceAttempt,
        Meta;

    }

    private static class JobHistoryFilesManager {
        private ThreadPoolExecutor executor = null;
        private final Configuration conf;
        private final JobTracker jobTracker;
        private Map<JobID, FilesHolder> fileCache = new ConcurrentHashMap<JobID, FilesHolder>();

        JobHistoryFilesManager(Configuration conf, JobTracker jobTracker) throws IOException {
            this.conf = conf;
            this.jobTracker = jobTracker;
        }

        void start() {
            this.executor = new ThreadPoolExecutor(1, 3, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>());
        }

        private FilesHolder getFileHolder(JobID id) {
            FilesHolder holder = this.fileCache.get(id);
            if (holder == null) {
                holder = new FilesHolder();
                this.fileCache.put(id, holder);
            }
            return holder;
        }

        void addWriter(JobID id, PrintWriter writer) {
            FilesHolder holder = this.getFileHolder(id);
            holder.writers.add(writer);
        }

        void setHistoryFile(JobID id, Path file) {
            FilesHolder holder = this.getFileHolder(id);
            holder.historyFilename = file;
        }

        void setConfFile(JobID id, Path file) {
            FilesHolder holder = this.getFileHolder(id);
            holder.confFilename = file;
        }

        ArrayList<PrintWriter> getWriters(JobID id) {
            FilesHolder holder = this.fileCache.get(id);
            return holder == null ? null : holder.writers;
        }

        Path getHistoryFile(JobID id) {
            FilesHolder holder = this.fileCache.get(id);
            return holder == null ? null : holder.historyFilename;
        }

        Path getConfFileWriters(JobID id) {
            FilesHolder holder = this.fileCache.get(id);
            return holder == null ? null : holder.confFilename;
        }

        void purgeJob(JobID id) {
            this.fileCache.remove(id);
        }

        void moveToDone(final JobID id) {
            final ArrayList<Path> paths = new ArrayList<Path>();
            final Path historyFile = fileManager.getHistoryFile(id);
            if (historyFile == null) {
                LOG.info((Object)("No file for job-history with " + id + " found in cache!"));
            } else {
                paths.add(historyFile);
            }
            Path confPath = fileManager.getConfFileWriters(id);
            if (confPath == null) {
                LOG.info((Object)("No file for jobconf with " + id + " found in cache!"));
            } else {
                paths.add(confPath);
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Path path : paths) {
                            if (!LOGDIR_FS.exists(path)) continue;
                            LOG.info((Object)("Moving " + path.toString() + " to " + DONE.toString()));
                            DONEDIR_FS.moveFromLocalFile(path, DONE);
                            DONEDIR_FS.setPermission(new Path(DONE, path.getName()), new FsPermission(HISTORY_FILE_PERMISSION));
                        }
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Unable to move history file to DONE folder.", e);
                    }
                    String historyFileDonePath = null;
                    if (historyFile != null) {
                        historyFileDonePath = new Path(DONE, historyFile.getName()).toString();
                    }
                    jobHistoryFileMap.put(id, new MovedFileInfo(historyFileDonePath, System.currentTimeMillis()));
                    JobHistoryFilesManager.this.jobTracker.historyFileCopied(id, historyFileDonePath);
                    fileManager.purgeJob(id);
                }
            });
        }

        void removeWriter(JobID jobId, PrintWriter writer) {
            fileManager.getWriters(jobId).remove(writer);
        }

        private static class FilesHolder {
            ArrayList<PrintWriter> writers = new ArrayList();
            Path historyFilename;
            Path confFilename;

            private FilesHolder() {
            }
        }
    }

    private static class MovedFileInfo {
        private final String historyFile;
        private final long timestamp;

        public MovedFileInfo(String historyFile, long timestamp) {
            this.historyFile = historyFile;
            this.timestamp = timestamp;
        }
    }
}

