/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.NativeCodeLoader;

public class NativeIO {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_NOCTTY = 256;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    public static final int O_NONBLOCK = 2048;
    public static final int O_SYNC = 4096;
    public static final int O_ASYNC = 8192;
    public static final int O_FSYNC = 4096;
    public static final int O_NDELAY = 2048;
    private static final Log LOG = LogFactory.getLog(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    static final String WORKAROUND_NON_THREADSAFE_CALLS_KEY = "hadoop.workaround.non.threadsafe.getpwuid";
    static final boolean WORKAROUND_NON_THREADSAFE_CALLS_DEFAULT = false;
    private static final Map<Long, CachedUid> uidCache;
    private static long cacheTimeout;
    private static boolean initialized;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

    public static native void chmod(String var0, int var1) throws IOException;

    private static native long getUIDForFDOwner(FileDescriptor var0) throws IOException;

    private static native String getUserName(long var0) throws IOException;

    private static native void initNative();

    public static String getOwner(FileDescriptor fd) throws IOException {
        NativeIO.ensureInitialized();
        long uid = NativeIO.getUIDForFDOwner(fd);
        CachedUid cUid = uidCache.get(uid);
        long now = System.currentTimeMillis();
        if (cUid != null && cUid.timestamp + cacheTimeout > now) {
            return cUid.username;
        }
        String user = NativeIO.getUserName(uid);
        LOG.debug((Object)("Got UserName " + user + " for UID " + uid + " from the native implementation"));
        cUid = new CachedUid(user, now);
        uidCache.put(uid, cUid);
        return user;
    }

    private static synchronized void ensureInitialized() {
        if (!initialized) {
            cacheTimeout = new Configuration().getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
            LOG.debug((Object)("Initialized cache for UID to User mapping with a cache timeout of " + cacheTimeout / 1000L + " seconds."));
            initialized = true;
        }
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                Configuration conf = new Configuration();
                workaroundNonThreadSafePasswdCalls = conf.getBoolean(WORKAROUND_NON_THREADSAFE_CALLS_KEY, false);
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Unable to initialize NativeIO libraries", t);
            }
        }
        uidCache = new ConcurrentHashMap<Long, CachedUid>();
        initialized = false;
    }

    private static class CachedUid {
        final long timestamp;
        final String username;

        public CachedUid(String username, long timestamp) {
            this.timestamp = timestamp;
            this.username = username;
        }
    }
}

