/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

class TransferFsImage
implements FSConstants {
    public static final String CONTENT_LENGTH = "Content-Length";
    private static final Log LOG = LogFactory.getLog(TransferFsImage.class);
    private boolean isGetImage = false;
    private boolean isGetEdit = false;
    private boolean isPutImage = false;
    private int remoteport = 0;
    private String machineName = null;
    private CheckpointSignature token = null;
    private MD5Hash newChecksum = null;

    public TransferFsImage(Map<String, String[]> pmap, HttpServletRequest request, HttpServletResponse response) throws IOException {
        for (String key : pmap.keySet()) {
            if (key.equals("getimage")) {
                this.isGetImage = true;
                continue;
            }
            if (key.equals("getedit")) {
                this.isGetEdit = true;
                continue;
            }
            if (key.equals("putimage")) {
                this.isPutImage = true;
                continue;
            }
            if (key.equals("port")) {
                this.remoteport = new Integer(pmap.get("port")[0]);
                continue;
            }
            if (key.equals("machine")) {
                this.machineName = pmap.get("machine")[0];
                continue;
            }
            if (key.equals("token")) {
                this.token = new CheckpointSignature(pmap.get("token")[0]);
                continue;
            }
            if (!key.equals("newChecksum")) continue;
            this.newChecksum = new MD5Hash(pmap.get("newChecksum")[0]);
        }
        int numGets = (this.isGetImage ? 1 : 0) + (this.isGetEdit ? 1 : 0);
        if (numGets > 1 || numGets == 0 && !this.isPutImage) {
            throw new IOException("Illegal parameters to TransferFsImage");
        }
    }

    boolean getEdit() {
        return this.isGetEdit;
    }

    boolean getImage() {
        return this.isGetImage;
    }

    boolean putImage() {
        return this.isPutImage;
    }

    CheckpointSignature getToken() {
        return this.token;
    }

    MD5Hash getNewChecksum() {
        return this.newChecksum;
    }

    String getInfoServer() throws IOException {
        if (this.machineName == null || this.remoteport == 0) {
            throw new IOException("MachineName and port undefined");
        }
        return this.machineName + ":" + this.remoteport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getFileServer(OutputStream outstream, File localfile) throws IOException {
        byte[] buf = new byte[BUFFER_SIZE];
        FileInputStream infile = null;
        try {
            infile = new FileInputStream(localfile);
            if (SecondaryNameNode.ErrorSimulator.getErrorSimulation(2) && localfile.getAbsolutePath().contains("secondary")) {
                throw new IOException("If this exception is not caught by the name-node fs image will be truncated.");
            }
            if (SecondaryNameNode.ErrorSimulator.getErrorSimulation(3) && localfile.getAbsolutePath().contains("fsimage")) {
                long len = localfile.length();
                buf = new byte[(int)Math.min(len / 2L, (long)BUFFER_SIZE)];
                infile.read(buf);
            }
            int num = 1;
            while (num > 0) {
                num = infile.read(buf);
                if (num <= 0) {
                    break;
                }
                outstream.write(buf, 0, num);
            }
        }
        finally {
            if (infile != null) {
                infile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MD5Hash getFileClient(String fsName, String id, File[] localPath, boolean getChecksum) throws IOException {
        int i;
        byte[] buf = new byte[BUFFER_SIZE];
        String proto = UserGroupInformation.isSecurityEnabled() ? "https://" : "http://";
        StringBuffer str = new StringBuffer(proto + fsName + "/getimage?");
        str.append(id);
        URL url = new URL(str.toString());
        SecurityUtil.fetchServiceTicket(url);
        URLConnection connection = url.openConnection();
        String contentLength = connection.getHeaderField(CONTENT_LENGTH);
        if (contentLength == null) {
            throw new IOException("Content-Length header is not provided by the namenode when trying to fetch " + str);
        }
        long advertisedSize = Long.parseLong(contentLength);
        long received = 0L;
        InputStream stream = connection.getInputStream();
        MessageDigest digester = null;
        if (getChecksum) {
            digester = MD5Hash.getDigester();
            stream = new DigestInputStream(stream, digester);
        }
        FileOutputStream[] output = null;
        try {
            if (localPath != null) {
                output = new FileOutputStream[localPath.length];
                for (i = 0; i < output.length; ++i) {
                    output[i] = new FileOutputStream(localPath[i]);
                }
            }
            int num = 1;
            while (num > 0) {
                num = stream.read(buf);
                if (num <= 0 || localPath == null) continue;
                received += (long)num;
                for (int i2 = 0; i2 < output.length; ++i2) {
                    output[i2].write(buf, 0, num);
                }
            }
        }
        finally {
            stream.close();
            if (output != null) {
                for (i = 0; i < output.length; ++i) {
                    if (output[i] == null) continue;
                    output[i].getChannel().force(true);
                    output[i].close();
                }
            }
            if (received != advertisedSize) {
                throw new IOException("File " + str + " received length " + received + " is not of the advertised size " + advertisedSize);
            }
        }
        return digester == null ? null : new MD5Hash(digester.digest());
    }
}

