/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.util.StringUtils;

class DataXceiverServer
implements Runnable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    ServerSocket ss;
    DataNode datanode;
    Map<Socket, Socket> childSockets = Collections.synchronizedMap(new HashMap());
    static final int MAX_XCEIVER_COUNT = 256;
    int maxXceiverCount = 256;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    DataXceiverServer(ServerSocket ss, Configuration conf, DataNode datanode) {
        this.ss = ss;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.xcievers", 256);
        this.estimateBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.balance.bandwidthPerSec", 0x100000L));
    }

    @Override
    public void run() {
        while (this.datanode.shouldRun) {
            try {
                Socket s = this.ss.accept();
                s.setTcpNoDelay(true);
                new DataXceiver(s, this.datanode, this).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (IOException ie) {
                LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiverServer: IOException due to:" + StringUtils.stringifyException(ie)));
            }
            catch (Throwable te) {
                LOG.error((Object)(this.datanode.dnRegistration + ":DataXceiverServer: Exiting due to:" + StringUtils.stringifyException(te)));
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiverServer: Close exception due to: " + StringUtils.stringifyException(ie)));
        }
        LOG.info((Object)"Exiting DataXceiverServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiverServer.kill(): " + StringUtils.stringifyException(ie)));
        }
        Map<Socket, Socket> map = this.childSockets;
        synchronized (map) {
            for (Socket thissock : this.childSockets.values()) {
                try {
                    thissock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static class BlockBalanceThrottler
    extends BlockTransferThrottler {
        private int numThreads;

        private BlockBalanceThrottler(long bandwidth) {
            super(bandwidth);
            LOG.info((Object)("Balancing bandwith is " + bandwidth + " bytes/s"));
        }

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

