/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class TrieStringMatcher {
    protected TrieNode root = new TrieNode('\u0000', false);

    protected TrieStringMatcher() {
    }

    protected final TrieNode matchChar(TrieNode node, String s, int idx) {
        return node.getChild(s.charAt(idx));
    }

    protected final void addPatternForward(String s) {
        TrieNode node = this.root;
        int stop = s.length() - 1;
        if (s.length() > 0) {
            int i;
            for (i = 0; i < stop; ++i) {
                node = node.getChildAddIfNotPresent(s.charAt(i), false);
            }
            node = node.getChildAddIfNotPresent(s.charAt(i), true);
        }
    }

    protected final void addPatternBackward(String s) {
        TrieNode node = this.root;
        if (s.length() > 0) {
            for (int i = s.length() - 1; i > 0; --i) {
                node = node.getChildAddIfNotPresent(s.charAt(i), false);
            }
            node = node.getChildAddIfNotPresent(s.charAt(0), true);
        }
    }

    public abstract boolean matches(String var1);

    public abstract String shortestMatch(String var1);

    public abstract String longestMatch(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TrieNode
    implements Comparable<TrieNode> {
        protected TrieNode[] children;
        protected LinkedList<TrieNode> childrenList;
        protected char nodeChar;
        protected boolean terminal;

        TrieNode(char nodeChar, boolean isTerminal) {
            this.nodeChar = nodeChar;
            this.terminal = isTerminal;
            this.childrenList = new LinkedList();
        }

        boolean isTerminal() {
            return this.terminal;
        }

        TrieNode getChildAddIfNotPresent(char nextChar, boolean isTerminal) {
            if (this.childrenList == null) {
                this.childrenList = new LinkedList();
                this.childrenList.addAll(Arrays.asList(this.children));
                this.children = null;
            }
            if (this.childrenList.size() == 0) {
                TrieNode newNode = new TrieNode(nextChar, isTerminal);
                this.childrenList.add(newNode);
                return newNode;
            }
            ListIterator<TrieNode> iter = this.childrenList.listIterator();
            TrieNode node = (TrieNode)iter.next();
            while (node.nodeChar < nextChar && iter.hasNext()) {
                node = (TrieNode)iter.next();
            }
            if (node.nodeChar == nextChar) {
                node.terminal |= isTerminal;
                return node;
            }
            if (node.nodeChar > nextChar) {
                iter.previous();
            }
            TrieNode newNode = new TrieNode(nextChar, isTerminal);
            iter.add(newNode);
            return newNode;
        }

        TrieNode getChild(char nextChar) {
            if (this.children == null) {
                this.children = this.childrenList.toArray(new TrieNode[this.childrenList.size()]);
                this.childrenList = null;
                Arrays.sort(this.children);
            }
            int min = 0;
            int max = this.children.length - 1;
            int mid = 0;
            while (min < max) {
                mid = (min + max) / 2;
                if (this.children[mid].nodeChar == nextChar) {
                    return this.children[mid];
                }
                if (this.children[mid].nodeChar < nextChar) {
                    min = mid + 1;
                    continue;
                }
                max = mid - 1;
            }
            if (min == max && this.children[min].nodeChar == nextChar) {
                return this.children[min];
            }
            return null;
        }

        @Override
        public int compareTo(TrieNode other) {
            if (this.nodeChar < other.nodeChar) {
                return -1;
            }
            if (this.nodeChar == other.nodeChar) {
                return 0;
            }
            return 1;
        }
    }
}

