/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import com.google.common.collect.ImmutableMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDNamesCollection {
    private static final Log LOG = LogFactory.getLog(TLDNamesCollection.class);
    private static ImmutableMultimap<String, String> tldToSecondaryNameMap = null;

    public static Collection<String> getSecondaryNames(String tldName) {
        TLDNamesCollection.initialize();
        return tldToSecondaryNameMap.get((Object)tldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        Class<TLDNamesCollection> clazz = TLDNamesCollection.class;
        synchronized (TLDNamesCollection.class) {
            if (tldToSecondaryNameMap == null) {
                try {
                    ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
                    InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("effective_tld_list.txt");
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith("//") || line.length() == 0) continue;
                            int indexOfDot = line.lastIndexOf(".");
                            if (indexOfDot == -1) {
                                builder.put((Object)line.trim(), (Object)"");
                                continue;
                            }
                            String leftSide = line.substring(0, indexOfDot).trim();
                            String rightSide = line.substring(indexOfDot + 1).trim();
                            builder.put((Object)rightSide, (Object)leftSide);
                        }
                        tldToSecondaryNameMap = builder.build();
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    throw new RuntimeException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

