/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFileWriter<KeyType extends Writable, ValueType extends Writable> {
    static final Log LOG = LogFactory.getLog(TFileWriter.class);
    FSDataOutputStream _stream;
    TFile.Writer _writer;
    DataOutputBuffer _keyStream = new DataOutputBuffer();
    DataOutputBuffer _valueStream = new DataOutputBuffer();

    public TFileWriter(FileSystem fs, Configuration conf, Path path, String compressionScheme, int minCompressedBlockSize, Class<? extends RawComparator<KeyType>> comparatorClass) throws IOException {
        this._stream = fs.create(path);
        this._writer = new TFile.Writer(this._stream, minCompressedBlockSize, compressionScheme, "jclass:" + comparatorClass.getName(), conf);
    }

    public void append(KeyType key, ValueType value) throws IOException {
        this._keyStream.reset();
        key.write((DataOutput)this._keyStream);
        this._valueStream.reset();
        value.write((DataOutput)this._valueStream);
        this.append(this._keyStream, this._valueStream);
    }

    public final void append(DataOutputBuffer keyStream, DataOutputBuffer valueStream) throws IOException {
        this._writer.append(this._keyStream.getData(), 0, this._keyStream.getLength(), this._valueStream.getData(), 0, this._valueStream.getLength());
    }

    public TFile.Writer getUnderlyingWriter() {
        return this._writer;
    }

    public long getPosition() throws IOException {
        return this._stream.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._writer != null) {
            try {
                try {
                    this._writer.close();
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var3_2 = null;
                    this._writer = null;
                }
                Object var3_1 = null;
                this._writer = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._writer = null;
                throw throwable;
            }
        }
        if (this._stream != null) {
            try {
                try {
                    this._stream.close();
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var5_8 = null;
                    this._stream = null;
                }
                Object var5_7 = null;
                this._stream = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this._stream = null;
                throw throwable;
            }
        }
    }
}

