/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Utils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.commoncrawl.util.shared.CCStringUtils;

public class TFileUtils {
    static final Log LOG = LogFactory.getLog(TFileUtils.class);
    static final Utils.Version BCFILE_API_VERSION = new Utils.Version(1, 0);
    static final String TFILE_META_BLOCK_NAME = "TFile.meta";
    static final String TFILE_BLOCK_NAME = "TFile.index";
    static final String BCFILE_META_BLOCK_NAME = "BCFile.index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger logger = Logger.getLogger((String)"org.commoncrawl");
        logger.setLevel(Level.INFO);
        BasicConfigurator.configure();
        Configuration conf = new Configuration();
        conf.addResource("core-site.xml");
        conf.addResource("hdfs-site.xml");
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            LOG.info((Object)("Loading TFile at:" + args[0]));
            Path path = new Path(args[0]);
            FileStatus status = fs.getFileStatus(path);
            FSDataInputStream in = fs.open(path);
            try {
                LOG.info((Object)"Initializing Metadata Reader");
                BCFileMetaReader metaReader = new BCFileMetaReader(in, status.getLen(), conf);
                LOG.info((Object)("Earliest Index Offset:" + metaReader.getEarliestMetadataOffset()));
                BCFileMetaIndex index = metaReader.metaIndex;
                for (Map.Entry<String, BCFileMetaIndexEntry> entry : index.index.entrySet()) {
                    LOG.info((Object)("Entry:" + entry.getKey() + " Pos:" + entry.getValue().getRegion().getOffset() + " Len:" + entry.getValue().getRegion().getRawSize()));
                }
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    static final class BCFileBlockRegion {
        private final long offset;
        private final long compressedSize;
        private final long rawSize;

        public BCFileBlockRegion(DataInput in) throws IOException {
            this.offset = Utils.readVLong((DataInput)in);
            this.compressedSize = Utils.readVLong((DataInput)in);
            this.rawSize = Utils.readVLong((DataInput)in);
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getRawSize() {
            return this.rawSize;
        }
    }

    static final class BCFileMetaIndexEntry {
        private final String metaName;
        private final String compressionAlgorithm;
        private static final String defaultPrefix = "data:";
        private final BCFileBlockRegion region;

        public BCFileMetaIndexEntry(DataInput in) throws IOException {
            String fullMetaName = Utils.readString((DataInput)in);
            if (!fullMetaName.startsWith(defaultPrefix)) {
                throw new IOException("Corrupted Meta region Index");
            }
            this.metaName = fullMetaName.substring(defaultPrefix.length(), fullMetaName.length());
            this.compressionAlgorithm = Utils.readString((DataInput)in);
            this.region = new BCFileBlockRegion(in);
        }

        public String getMetaName() {
            return this.metaName;
        }

        public String getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public BCFileBlockRegion getRegion() {
            return this.region;
        }
    }

    static class BCFileMetaIndex {
        final Map<String, BCFileMetaIndexEntry> index;

        public BCFileMetaIndex() {
            this.index = new TreeMap<String, BCFileMetaIndexEntry>();
        }

        public BCFileMetaIndex(DataInput in) throws IOException {
            int count = Utils.readVInt((DataInput)in);
            this.index = new TreeMap<String, BCFileMetaIndexEntry>();
            for (int nx = 0; nx < count; ++nx) {
                BCFileMetaIndexEntry indexEntry = new BCFileMetaIndexEntry(in);
                this.index.put(indexEntry.getMetaName(), indexEntry);
            }
        }
    }

    public static class BCFileMetaReader {
        public Utils.Version version = null;
        public BCFileMetaIndex metaIndex = null;
        public long fileLength;

        public BCFileMetaReader(FSDataInputStream fin, long fileLength, Configuration conf) throws IOException {
            this.fileLength = fileLength;
            fin.seek(fileLength - (long)BCFileMagic.size() - (long)Utils.Version.size() - 8L);
            long offsetIndexMeta = fin.readLong();
            this.version = new Utils.Version((DataInput)fin);
            BCFileMagic.readAndVerify((DataInput)fin);
            if (!this.version.compatibleWith(BCFILE_API_VERSION)) {
                throw new RuntimeException("Incompatible BCFile fileBCFileVersion.");
            }
            fin.seek(offsetIndexMeta);
            this.metaIndex = new BCFileMetaIndex((DataInput)fin);
        }

        public long getEarliestMetadataOffset() {
            long earliestIndexPos = this.fileLength;
            for (Map.Entry<String, BCFileMetaIndexEntry> entry : this.metaIndex.index.entrySet()) {
                earliestIndexPos = Math.min(entry.getValue().getRegion().getOffset(), earliestIndexPos);
            }
            return earliestIndexPos;
        }
    }

    static final class BCFileMagic {
        private static final byte[] AB_MAGIC_BCFILE = new byte[]{-47, 17, -45, 104, -111, -75, -41, -74, 57, -33, 65, 64, -110, -70, -31, 80};

        BCFileMagic() {
        }

        public static void readAndVerify(DataInput in) throws IOException {
            byte[] abMagic = new byte[BCFileMagic.size()];
            in.readFully(abMagic);
            if (!Arrays.equals(abMagic, AB_MAGIC_BCFILE)) {
                throw new IOException("Not a valid BCFile.");
            }
        }

        public static void write(DataOutput out) throws IOException {
            out.write(AB_MAGIC_BCFILE);
        }

        public static int size() {
            return AB_MAGIC_BCFILE.length;
        }
    }
}

