/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.TFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFileThriftObjectWriter<KeyType extends TBase, ValueType extends TBase> {
    static final Log LOG = LogFactory.getLog(TFileWriter.class);
    FSDataOutputStream _stream;
    TFile.Writer _writer;
    DataOutputBuffer _keyStream = new DataOutputBuffer();
    DataOutputBuffer _valueStream = new DataOutputBuffer();
    TBinaryProtocol _keyProto = new TBinaryProtocol((TTransport)new TIOStreamTransport((OutputStream)this._keyStream));
    TBinaryProtocol _valueProto = new TBinaryProtocol((TTransport)new TIOStreamTransport((OutputStream)this._valueStream));

    public TFileThriftObjectWriter(FileSystem fs, Configuration conf, Path path, short replicationFactor, String compressionScheme, int minCompressedBlockSize, Class<? extends RawComparator<KeyType>> comparatorClass) throws IOException {
        this._stream = fs.create(path, replicationFactor);
        this._writer = new TFile.Writer(this._stream, minCompressedBlockSize, compressionScheme, "jclass:" + comparatorClass.getName(), conf);
    }

    public void append(KeyType key, ValueType value) throws IOException {
        try {
            this._keyStream.reset();
            key.write((TProtocol)this._keyProto);
            this._valueStream.reset();
            value.write((TProtocol)this._valueProto);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        this.append(this._keyStream, this._valueStream);
    }

    public final void append(DataOutputBuffer keyStream, DataOutputBuffer valueStream) throws IOException {
        this._writer.append(this._keyStream.getData(), 0, this._keyStream.getLength(), this._valueStream.getData(), 0, this._valueStream.getLength());
    }

    public TFile.Writer getUnderlyingWriter() {
        return this._writer;
    }

    public long getPosition() throws IOException {
        return this._stream.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._writer != null) {
            try {
                try {
                    this._writer.close();
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var3_2 = null;
                    this._writer = null;
                }
                Object var3_1 = null;
                this._writer = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._writer = null;
                throw throwable;
            }
        }
        if (this._stream != null) {
            try {
                try {
                    this._stream.close();
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var5_8 = null;
                    this._stream = null;
                }
                Object var5_7 = null;
                this._stream = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this._stream = null;
                throw throwable;
            }
        }
    }
}

