/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.TFileWritableReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFileThriftObjectReader<KeyType extends TBase, ValueType extends TBase> {
    static final Log LOG = LogFactory.getLog(TFileWritableReader.class);
    private FSDataInputStream _inputStream;
    private TFile.Reader _reader;
    private boolean _ownsReader;
    private TFile.Reader.Scanner _scanner;
    private TResettableTransport _keyTransport = new TResettableTransport();
    private TResettableTransport _valueTransport = new TResettableTransport();
    private TBinaryProtocol _keyProtocol = new TBinaryProtocol((TTransport)this._keyTransport);
    private TBinaryProtocol _valueProtocol = new TBinaryProtocol((TTransport)this._valueTransport);
    private ValueReader _valueReader = new ValueReader();

    public TFileThriftObjectReader(TFile.Reader reader) throws IOException {
        if (reader == null) {
            throw new IOException("Reader == null!");
        }
        this._reader = reader;
        this._ownsReader = false;
        this._inputStream = null;
        this._scanner = this._reader.createScanner();
    }

    public TFileThriftObjectReader(FileSystem fs, Configuration conf, Path path) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(path);
        if (fileStatus == null) {
            throw new IOException("Invalid File:" + path);
        }
        this._ownsReader = true;
        this._inputStream = fs.open(path);
        this._reader = new TFile.Reader(this._inputStream, fileStatus.getLen(), conf);
        this._scanner = this._reader.createScanner();
    }

    public TFile.Reader getReader() {
        return this._reader;
    }

    public TFile.Reader.Scanner getScanner() {
        return this._scanner;
    }

    public ValueReader next(KeyType key) throws IOException {
        if (this._scanner != null && !this._scanner.atEnd()) {
            try {
                this._keyTransport.setInputStream(this._scanner.entry().getKeyStream());
                key.read((TProtocol)this._keyProtocol);
                DataInputStream stream = this._scanner.entry().getValueStream();
                this._valueTransport.setInputStream(stream);
                return this._valueReader;
            }
            catch (TException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public boolean next(KeyType keyType, ValueType valueType) throws IOException {
        if (this._scanner != null && !this._scanner.atEnd()) {
            try {
                this._keyTransport.setInputStream(this._scanner.entry().getKeyStream());
                keyType.read((TProtocol)this._keyProtocol);
                if (valueType != null) {
                    this._valueTransport.setInputStream(this._scanner.entry().getValueStream());
                    valueType.read((TProtocol)this._valueProtocol);
                }
            }
            catch (TException e) {
                throw new IOException(e);
            }
            this._scanner.advance();
            return true;
        }
        return false;
    }

    public boolean hasMoreData() {
        return this._scanner != null && !this._scanner.atEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._scanner != null) {
            try {
                try {
                    this._scanner.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var3_2 = null;
                    this._scanner = null;
                }
                Object var3_1 = null;
                this._scanner = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._scanner = null;
                throw throwable;
            }
        }
        if (this._reader != null && this._ownsReader) {
            try {
                try {
                    this._reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var5_10 = null;
                    this._reader = null;
                }
                Object var5_9 = null;
                this._reader = null;
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                this._reader = null;
                throw throwable;
            }
        }
        if (this._inputStream != null) {
            try {
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var7_14 = null;
                    this._inputStream = null;
                }
                Object var7_13 = null;
                this._inputStream = null;
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                this._inputStream = null;
                throw throwable;
            }
        }
    }

    public class ValueReader {
        public TBinaryProtocol getProtocol() {
            return TFileThriftObjectReader.this._valueProtocol;
        }

        public void close() throws IOException {
            TFileThriftObjectReader.this._scanner.advance();
        }
    }

    public static class TResettableTransport
    extends TIOStreamTransport {
        public void setInputStream(InputStream is) {
            this.inputStream_ = is;
        }

        public void setOutputStream(OutputStream os) {
            this.outputStream_ = os;
        }
    }
}

