/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFileReader<KeyType extends Writable, ValueType extends Writable> {
    static final Log LOG = LogFactory.getLog(TFileReader.class);
    private FSDataInputStream _inputStream;
    private TFile.Reader _reader;
    private TFile.Reader.Scanner _scanner;

    public TFileReader(FileSystem fs, Configuration conf, Path path) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(path);
        if (fileStatus == null) {
            throw new IOException("Invalid File:" + path);
        }
        this._inputStream = fs.open(path);
        this._reader = new TFile.Reader(this._inputStream, fileStatus.getLen(), conf);
        this._scanner = this._reader.createScanner();
    }

    public TFile.Reader getReader() {
        return this._reader;
    }

    public TFile.Reader.Scanner getScanner() {
        return this._scanner;
    }

    public boolean next(KeyType keyType, ValueType valueType) throws IOException {
        if (this._scanner != null && !this._scanner.atEnd()) {
            keyType.readFields((DataInput)this._scanner.entry().getKeyStream());
            valueType.readFields((DataInput)this._scanner.entry().getValueStream());
            this._scanner.advance();
            return true;
        }
        return false;
    }

    public boolean hasMoreData() {
        return this._scanner != null && !this._scanner.atEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._scanner != null) {
            try {
                try {
                    this._scanner.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var3_2 = null;
                    this._scanner = null;
                }
                Object var3_1 = null;
                this._scanner = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._scanner = null;
                throw throwable;
            }
        }
        if (this._reader != null) {
            try {
                try {
                    this._reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var5_10 = null;
                    this._reader = null;
                }
                Object var5_9 = null;
                this._reader = null;
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                this._reader = null;
                throw throwable;
            }
        }
        if (this._inputStream != null) {
            try {
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    Object var7_14 = null;
                    this._inputStream = null;
                }
                Object var7_13 = null;
                this._inputStream = null;
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                this._inputStream = null;
                throw throwable;
            }
        }
    }
}

