/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

public class SmoothedAverage {
    private double _alpha;
    private int _observationCount;
    private double _smoothedValue;

    public SmoothedAverage(double alpha) {
        this._alpha = alpha;
        this._observationCount = 0;
        this._smoothedValue = 0.0;
    }

    public synchronized double addSample(double sampleValue) {
        this._smoothedValue = this._observationCount++ == 0 ? sampleValue : this._alpha * sampleValue + (1.0 - this._alpha) * this._smoothedValue;
        return this._smoothedValue;
    }

    public synchronized double getAverage() {
        return this._smoothedValue;
    }
}

