/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Collection;
import java.util.Iterator;
import org.commoncrawl.util.shared.TrieStringMatcher;

public class PrefixStringMatcher
extends TrieStringMatcher {
    public PrefixStringMatcher(String[] prefixes) {
        for (int i = 0; i < prefixes.length; ++i) {
            this.addPatternForward(prefixes[i]);
        }
    }

    public PrefixStringMatcher(Collection prefixes) {
        Iterator iter = prefixes.iterator();
        while (iter.hasNext()) {
            this.addPatternForward((String)iter.next());
        }
    }

    public boolean matches(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = 0; i < input.length(); ++i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return false;
            }
            if (!node.isTerminal()) continue;
            return true;
        }
        return false;
    }

    public String shortestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        for (int i = 0; i < input.length(); ++i) {
            if ((node = node.getChild(input.charAt(i))) == null) {
                return null;
            }
            if (!node.isTerminal()) continue;
            return input.substring(0, i + 1);
        }
        return null;
    }

    public String longestMatch(String input) {
        TrieStringMatcher.TrieNode node = this.root;
        String result = null;
        for (int i = 0; i < input.length() && (node = node.getChild(input.charAt(i))) != null; ++i) {
            if (!node.isTerminal()) continue;
            result = input.substring(0, i + 1);
        }
        return result;
    }

    public static final void main(String[] argv) {
        PrefixStringMatcher matcher = new PrefixStringMatcher(new String[]{"abcd", "abc", "aac", "baz", "foo", "foobar"});
        String[] tests = new String[]{"a", "ab", "abc", "abcdefg", "apple", "aa", "aac", "aaccca", "abaz", "baz", "bazooka", "fo", "foobar", "kite"};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println("testing: " + tests[i]);
            System.out.println("   matches: " + matcher.matches(tests[i]));
            System.out.println("  shortest: " + matcher.shortestMatch(tests[i]));
            System.out.println("   longest: " + matcher.longestMatch(tests[i]));
        }
    }
}

