/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.commoncrawl.util.shared.CCStringUtils;

public class MMapUtils {
    static final Log LOG;
    public static final int DEFAULT_MAX_BUFF = 262144;
    public static final boolean UNMAP_SUPPORTED;

    public static boolean getUseUnmap() {
        return UNMAP_SUPPORTED;
    }

    static final void cleanMapping(final ByteBuffer buffer) throws IOException {
        if (MMapUtils.getUseUnmap()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                IOException ioe = new IOException("unable to unmap the mapped buffer");
                ioe.initCause(e.getCause());
                throw ioe;
            }
        }
    }

    public static int getMaxChunkSize() {
        return 262144;
    }

    static {
        boolean v;
        LOG = LogFactory.getLog(MMapUtils.class);
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception e) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
    }

    public static class MMapFile {
        long length = -1L;
        ByteBuffer[] buffers = null;
        int[] bufSizes = null;
        private int refCount = 0;
        private boolean closePending = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MMapFile(File input) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(input, "r");
            try {
                this.length = raf.length();
                if (this.length / (long)MMapUtils.getMaxChunkSize() > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("RandomAccessFile too big for maximum buffer size: " + raf.toString());
                }
                int nrBuffers = (int)(this.length / (long)MMapUtils.getMaxChunkSize());
                if ((long)nrBuffers * (long)MMapUtils.getMaxChunkSize() <= this.length) {
                    ++nrBuffers;
                }
                this.buffers = new ByteBuffer[nrBuffers];
                this.bufSizes = new int[nrBuffers];
                long bufferStart = 0L;
                FileChannel rafc = raf.getChannel();
                for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
                    int bufSize = this.length > bufferStart + (long)MMapUtils.getMaxChunkSize() ? MMapUtils.getMaxChunkSize() : (int)(this.length - bufferStart);
                    this.buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, bufferStart, bufSize);
                    this.bufSizes[bufNr] = bufSize;
                    bufferStart += (long)bufSize;
                }
                LOG.info((Object)("Initialized MapFile from file:" + input.getAbsolutePath() + " NumBuffers:" + this.buffers.length + " TotalLength:" + this.length));
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                raf.close();
                throw throwable;
            }
            raf.close();
        }

        public FSDataInputStream newInputStream() throws IOException {
            MMapFileInputStream stream = new MMapFileInputStream();
            FSDataInputStream dataStream = new FSDataInputStream((InputStream)((Object)stream));
            return dataStream;
        }

        private synchronized void addRef() {
            ++this.refCount;
        }

        private synchronized void release() {
            if (--this.refCount == 0 && this.closePending) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
            }
        }

        public synchronized void close() throws IOException {
            if (this.refCount == 0) {
                if (this.buffers != null) {
                    for (ByteBuffer buffer : this.buffers) {
                        MMapUtils.cleanMapping(buffer);
                    }
                }
                this.buffers = null;
            } else {
                this.closePending = true;
            }
        }

        public long getLength() {
            return this.length;
        }

        public class MMapFileInputStream
        extends FSInputStream {
            private int curBufIndex = 0;
            private final int maxBufSize = MMapUtils.getMaxChunkSize();
            private ByteBuffer curBuf;

            public MMapFileInputStream() throws IOException {
                MMapFile.this.addRef();
                this.seek(0L);
            }

            public int read() throws IOException {
                try {
                    return this.curBuf.get() & 0xFF;
                }
                catch (BufferUnderflowException e) {
                    ++this.curBufIndex;
                    if (this.curBufIndex >= MMapFile.this.buffers.length) {
                        throw new IOException("read past EOF");
                    }
                    this.curBuf = MMapFile.this.buffers[this.curBufIndex].slice();
                    this.curBuf.position(0);
                    return this.curBuf.get() & 0xFF;
                }
            }

            public int read(byte[] bytes, int offset, int len) throws IOException {
                try {
                    this.curBuf.get(bytes, offset, len);
                    return len;
                }
                catch (BufferUnderflowException e) {
                    int bytesRead = 0;
                    int curAvail = this.curBuf.remaining();
                    while (len > curAvail) {
                        this.curBuf.get(bytes, offset, curAvail);
                        bytesRead += curAvail;
                        len -= curAvail;
                        offset += curAvail;
                        ++this.curBufIndex;
                        if (this.curBufIndex >= MMapFile.this.buffers.length) {
                            return bytesRead;
                        }
                        this.curBuf = MMapFile.this.buffers[this.curBufIndex].slice();
                        this.curBuf.position(0);
                        curAvail = this.curBuf.remaining();
                    }
                    this.curBuf.get(bytes, offset, len);
                    return bytesRead + len;
                }
            }

            public void close() throws IOException {
                MMapFile.this.release();
            }

            public int available() throws IOException {
                long amtAvailable = this.length() - this.getPos();
                return amtAvailable <= Integer.MAX_VALUE ? (int)amtAvailable : Integer.MAX_VALUE;
            }

            public void seek(long pos) throws IOException {
                int bufferIndex = (int)(pos / (long)this.maxBufSize);
                if (this.curBuf == null || bufferIndex != this.curBufIndex) {
                    this.curBufIndex = bufferIndex;
                    this.curBuf = MMapFile.this.buffers[this.curBufIndex].slice();
                }
                int bufOffset = (int)(pos - (long)this.curBufIndex * (long)this.maxBufSize);
                this.curBuf.position(bufOffset);
            }

            public long length() {
                return MMapFile.this.length;
            }

            public long getPos() throws IOException {
                return (long)this.curBufIndex * (long)this.maxBufSize + (long)this.curBuf.position();
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                this.seek(targetPos);
                return false;
            }

            public short readShort() throws IOException {
                try {
                    return this.curBuf.getShort();
                }
                catch (BufferUnderflowException e) {
                    return (short)((this.read() & 0xFF) << 8 | this.read() & 0xFF);
                }
            }

            public int readInt() throws IOException {
                try {
                    return this.curBuf.getInt();
                }
                catch (BufferUnderflowException e) {
                    return (this.read() & 0xFF) << 24 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 8 | this.read() & 0xFF;
                }
            }

            public long readLong() throws IOException {
                try {
                    return this.curBuf.getLong();
                }
                catch (BufferUnderflowException e) {
                    return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
                }
            }

            public int readVInt() throws IOException {
                int b = this.read();
                int i = b & 0x7F;
                int shift = 7;
                while ((b & 0x80) != 0) {
                    b = this.read();
                    i |= (b & 0x7F) << shift;
                    shift += 7;
                }
                return i;
            }

            public long readVLong() throws IOException {
                int b = this.read();
                long i = b & 0x7F;
                int shift = 7;
                while ((b & 0x80) != 0) {
                    b = this.read();
                    i |= ((long)b & 0x7FL) << shift;
                    shift += 7;
                }
                return i;
            }
        }
    }
}

