/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Iterator;
import junit.framework.TestCase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrusiveList<ClassType extends IntrusiveListElement<ClassType>>
implements Iterable<ClassType> {
    private ClassType _head = null;
    private ClassType _tail = null;
    private int _itemCount = 0;

    public ClassType getHead() {
        return this._head;
    }

    public ClassType getTail() {
        return this._tail;
    }

    public int size() {
        return this._itemCount;
    }

    public void addHead(ClassType element) {
        ((IntrusiveListElement)element)._prev = null;
        ((IntrusiveListElement)element)._next = this._head;
        if (this._head != null) {
            ((IntrusiveListElement)this._head).setPrev(element);
        }
        this._head = element;
        if (this._tail == null) {
            this._tail = this._head;
        }
        ++this._itemCount;
    }

    public void addTail(ClassType element) {
        ((IntrusiveListElement)element)._next = null;
        ((IntrusiveListElement)element).setPrev(this._tail);
        if (this._tail != null) {
            ((IntrusiveListElement)this._tail).setNext(element);
        }
        this._tail = element;
        if (this._head == null) {
            this._head = this._tail;
        }
        ++this._itemCount;
    }

    public void insertAfter(ClassType elementToInsertAfter, ClassType elementToInsert) {
        if (elementToInsertAfter == this._tail) {
            this._tail = elementToInsert;
            ((IntrusiveListElement)elementToInsert).setNext(null);
        } else {
            ((IntrusiveListElement)elementToInsert).setNext(((IntrusiveListElement)elementToInsertAfter).getNext());
            ((IntrusiveListElement)((IntrusiveListElement)elementToInsert).getNext()).setPrev(elementToInsert);
        }
        ((IntrusiveListElement)elementToInsertAfter).setNext(elementToInsert);
        ((IntrusiveListElement)elementToInsert).setPrev(elementToInsertAfter);
        ++this._itemCount;
    }

    public ClassType removeHead() {
        ClassType elementRemoved = this._head;
        this.removeElement(elementRemoved);
        return elementRemoved;
    }

    public ClassType removeTail() {
        ClassType elementRemoved = this._tail;
        this.removeElement(elementRemoved);
        return elementRemoved;
    }

    public void removeElement(ClassType element) {
        if (element == this._head) {
            this._head = (IntrusiveListElement)((IntrusiveListElement)this._head).getNext();
            if (this._head != null) {
                ((IntrusiveListElement)this._head).setPrev(null);
            }
            if (this._tail == element) {
                this._tail = this._head;
            }
        } else if (element == this._tail) {
            this._tail = (IntrusiveListElement)((IntrusiveListElement)this._tail).getPrev();
            ((IntrusiveListElement)this._tail).setNext(null);
        } else {
            ((IntrusiveListElement)((IntrusiveListElement)element).getPrev()).setNext(((IntrusiveListElement)element).getNext());
            ((IntrusiveListElement)((IntrusiveListElement)element).getNext()).setPrev(((IntrusiveListElement)element).getPrev());
        }
        --this._itemCount;
        ((IntrusiveListElement)element)._next = null;
        ((IntrusiveListElement)element)._prev = null;
    }

    public void removeAll() {
        Object element = this._head;
        while (element != null) {
            IntrusiveListElement next = (IntrusiveListElement)((IntrusiveListElement)element)._next;
            ((IntrusiveListElement)element)._prev = null;
            ((IntrusiveListElement)element)._next = null;
            element = next;
        }
        this._head = null;
        this._tail = null;
        this._itemCount = 0;
    }

    public IntrusiveList<ClassType> detach(ClassType targetElement) {
        IntrusiveList<ClassType> newList = new IntrusiveList<ClassType>();
        newList._head = targetElement;
        newList._tail = this._tail;
        if (((IntrusiveListElement)targetElement)._prev != null) {
            this._tail = (IntrusiveListElement)((IntrusiveListElement)targetElement)._prev;
            ((IntrusiveListElement)targetElement)._prev = null;
            ((IntrusiveListElement)this._tail)._next = null;
        } else {
            this._head = null;
            this._tail = null;
        }
        int newListItemCount = 0;
        Object element = targetElement;
        while (element != null) {
            ++newListItemCount;
            element = (IntrusiveListElement)((IntrusiveListElement)element)._next;
        }
        newList._itemCount = newListItemCount;
        this._itemCount -= newListItemCount;
        return newList;
    }

    public void attach(IntrusiveList<ClassType> listToAppendFrom) {
        if (listToAppendFrom.size() != 0) {
            if (this._tail != null) {
                ((IntrusiveListElement)this._tail)._next = listToAppendFrom._head;
                ((IntrusiveListElement)listToAppendFrom._head)._prev = this._tail;
            } else {
                this._head = listToAppendFrom._head;
            }
            this._tail = listToAppendFrom._tail;
            this._itemCount += listToAppendFrom._itemCount;
        }
        listToAppendFrom._head = null;
        listToAppendFrom._tail = null;
        listToAppendFrom._itemCount = 0;
    }

    @Override
    public Iterator<ClassType> iterator() {
        return new IntrusiveListIterator();
    }

    @Test
    public void classUnitTest() throws Exception {
        LinkedListTest test = new LinkedListTest("Test");
        test.setUp();
        test.testGetHead();
        test.testAddRemoveAdd();
        test.testIterator();
        UnitTestElement element1 = new UnitTestElement(1);
        UnitTestElement element2 = new UnitTestElement(2);
        UnitTestElement element3 = new UnitTestElement(3);
        UnitTestElement element4 = new UnitTestElement(4);
        UnitTestElement element5 = new UnitTestElement(5);
        IntrusiveList<IntrusiveListElement> list = new IntrusiveList<IntrusiveListElement>();
        list.addHead(element1);
        list.addHead(element2);
        list.addHead(element3);
        list.addHead(element4);
        list.addHead(element5);
        list.removeHead();
        list.removeTail();
        for (UnitTestElement unitTestElement : list) {
            System.out.println("ID:" + unitTestElement.getId());
        }
        while (list.getHead() != null) {
            list.removeHead();
        }
        for (UnitTestElement unitTestElement : list) {
            System.out.println("ID:" + unitTestElement.getId());
        }
        list.addHead(element1);
        list.addHead(element2);
        list.addHead(element3);
        list.addHead(element4);
        list.addHead(element5);
        while (list.getTail() != null) {
            list.removeTail();
        }
        list.addHead(element1);
        list.addHead(element2);
        list.addHead(element3);
        list.addHead(element4);
        list.addHead(element5);
        IntrusiveList<IntrusiveListElement> detached = list.detach((IntrusiveListElement)((UnitTestElement)list.getHead()).getNext());
        System.out.println("Original:");
        for (UnitTestElement unitTestElement : list) {
            System.out.println("ID:" + unitTestElement.getId());
        }
        System.out.println("Detached:");
        for (UnitTestElement unitTestElement : detached) {
            System.out.println("ID:" + unitTestElement.getId());
        }
        list.attach(detached);
        System.out.println("Original Post Attach:");
        for (UnitTestElement unitTestElement : list) {
            System.out.println("ID:" + unitTestElement.getId());
        }
        System.out.println("Detacehd Post Attach:");
        for (UnitTestElement unitTestElement : detached) {
            System.out.println("ID:" + unitTestElement.getId());
        }
    }

    public static class LinkedListTest
    extends TestCase {
        private IntrusiveList<UnitTestElement> empty;
        private IntrusiveList<UnitTestElement> one;
        private IntrusiveList<UnitTestElement> several;

        public LinkedListTest(String s) {
            super(s);
        }

        public void setUp() {
            this.empty = new IntrusiveList();
            this.one = new IntrusiveList();
            this.one.addHead(new UnitTestElement(0));
            this.several = new IntrusiveList();
            this.several.addHead(new UnitTestElement(2));
            this.several.addHead(new UnitTestElement(1));
            this.several.addHead(new UnitTestElement(0));
        }

        public void testGetHead() {
            LinkedListTest.assertEquals((String)"Check 0", (Object)new UnitTestElement(0), (Object)this.one.getHead());
            LinkedListTest.assertEquals((String)"Check 0", (Object)new UnitTestElement(0), (Object)this.several.getHead());
            LinkedListTest.assertEquals((String)"Check 2", (Object)new UnitTestElement(2), (Object)this.several.getTail());
            LinkedListTest.assertEquals((String)"Check 1", (Object)new UnitTestElement(1), this.several.getTail().getPrev());
        }

        public void testAddRemoveAdd() {
            this.one.removeTail();
            LinkedListTest.assertTrue((String)"one empty", (this.one.size() == 0 ? 1 : 0) != 0);
            this.one.addHead(new UnitTestElement(0));
            LinkedListTest.assertEquals((String)"Check remove then add 0", (Object)new UnitTestElement(0), (Object)this.one.getHead());
        }

        public void testIterator() {
            int counter = 0;
            Iterator<UnitTestElement> iterator = this.empty.iterator();
            while (iterator.hasNext()) {
                LinkedListTest.fail((String)"Iterating empty list and found element");
            }
            counter = 0;
            iterator = this.several.iterator();
            while (iterator.hasNext()) {
                LinkedListTest.assertEquals((String)"Check several iteration", (Object)new UnitTestElement(counter++), (Object)iterator.next());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnitTestElement
    extends IntrusiveListElement<UnitTestElement> {
        private int _id;

        public UnitTestElement(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnitTestElement) {
                return this._id == ((UnitTestElement)obj)._id;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntrusiveListIterator<ClassType extends IntrusiveListElement<ClassType>>
    implements Iterator<ClassType> {
        private IntrusiveList<ClassType> _list = null;
        private ClassType _current = null;
        private ClassType _next = null;

        public IntrusiveListIterator() {
            this._next = IntrusiveList.this._head;
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public ClassType next() {
            this._current = this._next;
            if (this._next != null) {
                this._next = (IntrusiveListElement)((IntrusiveListElement)this._next).getNext();
            }
            return this._current;
        }

        @Override
        public void remove() {
            this._list.removeElement(this._current);
            this._current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntrusiveListElement<ClassType> {
        ClassType _prev = null;
        ClassType _next = null;

        public ClassType getPrev() {
            return this._prev;
        }

        public ClassType getNext() {
            return this._next;
        }

        public void setPrev(ClassType prev) {
            this._prev = prev;
        }

        public void setNext(ClassType next) {
            this._next = next;
        }

        ClassType getObject() {
            return (ClassType)this;
        }
    }
}

