/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Collection;
import java.util.regex.Pattern;
import org.commoncrawl.util.shared.TLDNamesCollection;

public class DomainNameUtils {
    static Pattern invalidDomainCharactersRegEx = Pattern.compile("[^0-9a-z\\-\\._]");
    static Pattern ipAddressRegEx = Pattern.compile("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$");
    static Pattern numericOnly = Pattern.compile("[0-9]*$");
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;

    public static boolean isValidDomainName(String name) {
        if (name.length() > 255) {
            return false;
        }
        String candidate = name.toLowerCase();
        if (ipAddressRegEx.matcher(candidate).matches()) {
            return true;
        }
        if (invalidDomainCharactersRegEx.matcher(candidate).matches()) {
            return false;
        }
        String[] parts = name.split("\\.");
        if (parts.length > 128) {
            return false;
        }
        return DomainNameUtils.extractRootDomainName(candidate) != null;
    }

    private static String buildRootNameString(String candidateString, String[] parts, int rootNameIndex) {
        int dotsToInclude;
        int partsToInclude = parts.length - rootNameIndex;
        int rootNameLength = dotsToInclude = partsToInclude - 1;
        for (int i = rootNameIndex; i < parts.length; ++i) {
            rootNameLength += parts[i].length();
        }
        return candidateString.substring(candidateString.length() - rootNameLength);
    }

    public static String extractRootDomainName(String candidate) {
        Collection<String> secondaryNames;
        String[] parts;
        if (ipAddressRegEx.matcher(candidate).matches()) {
            return candidate;
        }
        if (candidate.endsWith(".")) {
            candidate = candidate.substring(0, candidate.length() - 1);
        }
        if (candidate.startsWith("*") && candidate.length() > 1) {
            candidate = candidate.substring(1);
        }
        if (candidate.length() != 0 && !invalidDomainCharactersRegEx.matcher(candidate).find() && (parts = candidate.split("\\.")).length >= 2 && (secondaryNames = TLDNamesCollection.getSecondaryNames(parts[parts.length - 1])).size() != 0) {
            if (secondaryNames.contains(parts[parts.length - 2]) || secondaryNames.contains("*")) {
                if (secondaryNames.contains("!" + parts[parts.length - 2])) {
                    return DomainNameUtils.buildRootNameString(candidate, parts, parts.length - 2);
                }
                if (parts.length >= 3) {
                    return DomainNameUtils.buildRootNameString(candidate, parts, parts.length - 3);
                }
            } else {
                String extendedWildcard = "*." + parts[parts.length - 2];
                if (secondaryNames.contains(extendedWildcard)) {
                    if (parts.length >= 3) {
                        String exclusionRule2 = "!" + parts[parts.length - 3] + "." + parts[parts.length - 2];
                        if (secondaryNames.contains(exclusionRule2)) {
                            return DomainNameUtils.buildRootNameString(candidate, parts, parts.length - 3);
                        }
                        if (parts.length >= 4) {
                            return DomainNameUtils.buildRootNameString(candidate, parts, parts.length - 4);
                        }
                    }
                } else if (secondaryNames.contains("")) {
                    return DomainNameUtils.buildRootNameString(candidate, parts, parts.length - 2);
                }
            }
        }
        return null;
    }
}

