/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.io.shared.NIOHttpHeaders;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.HttpHeaderUtils;
import org.commoncrawl.util.shared.MimeTypeFilter;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetUtils {
    public static final Log LOG = LogFactory.getLog(CharsetUtils.class);
    private static final int CHUNK_SIZE = 2000;
    private static Pattern metaPattern = Pattern.compile("<meta\\s+([^>]*http-equiv=\"?content-type\"?[^>]*)>", 2);
    private static Pattern charsetPattern = Pattern.compile("charset=\\s*([a-z][_\\-0-9a-z]*)", 2);
    private static int MAX_CHARS_TO_DETECT = 16000;
    static final ImmutableMap<String, String> aliasTable;

    public static String aliasCharset(String inputCharset) {
        String alias = (String)aliasTable.get((Object)inputCharset.toLowerCase());
        return alias != null ? alias : inputCharset;
    }

    public static String bestEffortDecodeBytes(NIOHttpHeaders headers, byte[] crawlData, int offset, int length) throws IOException {
        String aliasValue;
        String alternateCharset;
        HttpHeaderUtils.ContentTypeAndCharset urlMetadata = new HttpHeaderUtils.ContentTypeAndCharset();
        HttpHeaderUtils.parseContentType(headers, urlMetadata);
        if (urlMetadata._charset != null && crawlData != null && urlMetadata._contentType != null && urlMetadata._contentType.equalsIgnoreCase("text/html") && (alternateCharset = CharsetUtils.sniffCharacterEncoding(crawlData, offset, length)) != null) {
            urlMetadata._charset = alternateCharset;
        }
        if (urlMetadata._charset == null && crawlData != null && urlMetadata._contentType != null && MimeTypeFilter.isTextType(urlMetadata._contentType)) {
            String detectedCharset = CharsetUtils.detectCharacterEncoding(crawlData, offset, length);
            urlMetadata._charset = detectedCharset != null ? detectedCharset : "ASCII";
        }
        if (urlMetadata._charset != null && (aliasValue = (String)aliasTable.get((Object)urlMetadata._charset.toLowerCase())) != null) {
            urlMetadata._charset = aliasValue;
        }
        if (urlMetadata._charset != null && crawlData != null) {
            Charset charset;
            block12: {
                charset = null;
                try {
                    charset = Charset.forName(urlMetadata._charset);
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    String detectedCharset = CharsetUtils.detectCharacterEncoding(crawlData, offset, length);
                    if (detectedCharset == null) break block12;
                    try {
                        charset = Charset.forName(detectedCharset);
                    }
                    catch (Exception e2) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    }
                }
            }
            if (charset != null) {
                try {
                    CharBuffer ucs2Chars = charset.decode(ByteBuffer.wrap(crawlData, offset, length));
                    return ucs2Chars.toString();
                }
                catch (Exception e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
            }
        } else {
            LOG.error((Object)"NULL_CHARSET_PASSED_TO_PARSER");
        }
        return null;
    }

    public static String sniffCharacterEncoding(byte[] content, int offset, int length) {
        Matcher charsetMatcher;
        length = length < 2000 ? length : 2000;
        String str = "";
        try {
            str = new String(content, offset, length, Charset.forName("ASCII").toString());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        Matcher metaMatcher = metaPattern.matcher(str);
        String encoding = null;
        if (metaMatcher.find() && (charsetMatcher = charsetPattern.matcher(metaMatcher.group(1))).find()) {
            encoding = new String(charsetMatcher.group(1));
        }
        return encoding;
    }

    public static String detectCharacterEncoding(byte[] content, int offset, int length) {
        if (content != null && content.length != 0) {
            boolean isAscii;
            DetectorState state = new DetectorState();
            nsDetector detector = new nsDetector(0);
            detector.Init((nsICharsetDetectionObserver)state);
            if (offset != 0) {
                byte[] contentCopy = new byte[Math.min(length, MAX_CHARS_TO_DETECT)];
                System.arraycopy(content, offset, contentCopy, 0, length);
                content = contentCopy;
            }
            if (!(isAscii = detector.isAscii(content, content.length))) {
                isAscii = detector.DoIt(content, Math.min(content.length, MAX_CHARS_TO_DETECT), false);
            }
            detector.DataEnd();
            if (isAscii) {
                return "ASCII";
            }
            if (state._detectedCharset != null) {
                return state._detectedCharset;
            }
            String[] prob = detector.getProbableCharsets();
            if (prob != null && prob.length != 0) {
                return prob[0];
            }
        }
        return null;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"ibm-1208", (Object)"UTF-8");
        builder.put((Object)"ibm-1209", (Object)"UTF-8");
        builder.put((Object)"ibm-5304", (Object)"UTF-8");
        builder.put((Object)"ibm-5305", (Object)"UTF-8");
        builder.put((Object)"ibm-13496", (Object)"UTF-8");
        builder.put((Object)"ibm-13497", (Object)"UTF-8");
        builder.put((Object)"ibm-17592", (Object)"UTF-8");
        builder.put((Object)"ibm-17593", (Object)"UTF-8");
        builder.put((Object)"windows-65001", (Object)"UTF-8");
        builder.put((Object)"cp1208", (Object)"UTF-8");
        builder.put((Object)"iso-10646-ucs-2", (Object)"UTF-16");
        builder.put((Object)"ibm-1204", (Object)"UTF-16");
        builder.put((Object)"ibm-1205", (Object)"UTF-16");
        builder.put((Object)"unicode", (Object)"UTF-16");
        builder.put((Object)"csunicode", (Object)"UTF-16");
        builder.put((Object)"ucs-2", (Object)"UTF-16");
        builder.put((Object)"x-utf-16be", (Object)"UTF-16BE");
        builder.put((Object)"unicodebigunmarked", (Object)"UTF-16BE");
        builder.put((Object)"ibm-1200", (Object)"UTF-16BE");
        builder.put((Object)"ibm-1201", (Object)"UTF-16BE");
        builder.put((Object)"ibm-13488", (Object)"UTF-16BE");
        builder.put((Object)"ibm-13489", (Object)"UTF-16BE");
        builder.put((Object)"ibm-17584", (Object)"UTF-16BE");
        builder.put((Object)"ibm-17585", (Object)"UTF-16BE");
        builder.put((Object)"ibm-21680", (Object)"UTF-16BE");
        builder.put((Object)"ibm-21681", (Object)"UTF-16BE");
        builder.put((Object)"ibm-25776", (Object)"UTF-16BE");
        builder.put((Object)"ibm-25777", (Object)"UTF-16BE");
        builder.put((Object)"ibm-29872", (Object)"UTF-16BE");
        builder.put((Object)"ibm-29873", (Object)"UTF-16BE");
        builder.put((Object)"ibm-61955", (Object)"UTF-16BE");
        builder.put((Object)"ibm-61956", (Object)"UTF-16BE");
        builder.put((Object)"windows-1201", (Object)"UTF-16BE");
        builder.put((Object)"cp1200", (Object)"UTF-16BE");
        builder.put((Object)"cp1201", (Object)"UTF-16BE");
        builder.put((Object)"utf16_bigendian", (Object)"UTF-16BE");
        builder.put((Object)"x-utf-16le", (Object)"UTF-16LE");
        builder.put((Object)"unicodelittleunmarked", (Object)"UTF-16LE");
        builder.put((Object)"ibm-1202", (Object)"UTF-16LE");
        builder.put((Object)"ibm-1203", (Object)"UTF-16LE");
        builder.put((Object)"ibm-13490", (Object)"UTF-16LE");
        builder.put((Object)"ibm-13491", (Object)"UTF-16LE");
        builder.put((Object)"ibm-17586", (Object)"UTF-16LE");
        builder.put((Object)"ibm-17587", (Object)"UTF-16LE");
        builder.put((Object)"ibm-21682", (Object)"UTF-16LE");
        builder.put((Object)"ibm-21683", (Object)"UTF-16LE");
        builder.put((Object)"ibm-25778", (Object)"UTF-16LE");
        builder.put((Object)"ibm-25779", (Object)"UTF-16LE");
        builder.put((Object)"ibm-29874", (Object)"UTF-16LE");
        builder.put((Object)"ibm-29875", (Object)"UTF-16LE");
        builder.put((Object)"utf16_littleendian", (Object)"UTF-16LE");
        builder.put((Object)"windows-1200", (Object)"UTF-16LE");
        builder.put((Object)"ibm-819", (Object)"ISO-8859-1");
        builder.put((Object)"ibm819", (Object)"ISO-8859-1");
        builder.put((Object)"cp819", (Object)"ISO-8859-1");
        builder.put((Object)"latin1", (Object)"ISO-8859-1");
        builder.put((Object)"8859_1", (Object)"ISO-8859-1");
        builder.put((Object)"csisolatin1", (Object)"ISO-8859-1");
        builder.put((Object)"iso-ir-100", (Object)"ISO-8859-1");
        builder.put((Object)"iso_8859-1:1987", (Object)"ISO-8859-1");
        builder.put((Object)"l1", (Object)"ISO-8859-1");
        builder.put((Object)"819", (Object)"ISO-8859-1");
        builder.put((Object)"ascii", (Object)"US-ASCII");
        builder.put((Object)"ansi_x3.4-1968", (Object)"US-ASCII");
        builder.put((Object)"ansi_x3.4-1986", (Object)"US-ASCII");
        builder.put((Object)"iso_646.irv:1991", (Object)"US-ASCII");
        builder.put((Object)"iso_646.irv:1983", (Object)"US-ASCII");
        builder.put((Object)"iso646-us", (Object)"US-ASCII");
        builder.put((Object)"us", (Object)"US-ASCII");
        builder.put((Object)"csascii", (Object)"US-ASCII");
        builder.put((Object)"iso-ir-6", (Object)"US-ASCII");
        builder.put((Object)"cp367", (Object)"US-ASCII");
        builder.put((Object)"ascii7", (Object)"US-ASCII");
        builder.put((Object)"646", (Object)"US-ASCII");
        builder.put((Object)"windows-20127", (Object)"US-ASCII");
        builder.put((Object)"ibm-367", (Object)"US-ASCII");
        builder.put((Object)"ibm367", (Object)"US-ASCII");
        builder.put((Object)"ibm-912_p100-1995", (Object)"ISO-8859-2");
        builder.put((Object)"ibm-912", (Object)"ISO-8859-2");
        builder.put((Object)"iso_8859-2:1987", (Object)"ISO-8859-2");
        builder.put((Object)"latin2", (Object)"ISO-8859-2");
        builder.put((Object)"csisolatin2", (Object)"ISO-8859-2");
        builder.put((Object)"iso-ir-101", (Object)"ISO-8859-2");
        builder.put((Object)"l2", (Object)"ISO-8859-2");
        builder.put((Object)"8859_2", (Object)"ISO-8859-2");
        builder.put((Object)"cp912", (Object)"ISO-8859-2");
        builder.put((Object)"912", (Object)"ISO-8859-2");
        builder.put((Object)"windows-28592", (Object)"ISO-8859-2");
        builder.put((Object)"ibm-913_p100-2000", (Object)"ISO-8859-3");
        builder.put((Object)"ibm-913", (Object)"ISO-8859-3");
        builder.put((Object)"iso_8859-3:1988", (Object)"ISO-8859-3");
        builder.put((Object)"latin3", (Object)"ISO-8859-3");
        builder.put((Object)"csisolatin3", (Object)"ISO-8859-3");
        builder.put((Object)"iso-ir-109", (Object)"ISO-8859-3");
        builder.put((Object)"l3", (Object)"ISO-8859-3");
        builder.put((Object)"8859_3", (Object)"ISO-8859-3");
        builder.put((Object)"cp913", (Object)"ISO-8859-3");
        builder.put((Object)"913", (Object)"ISO-8859-3");
        builder.put((Object)"windows-28593", (Object)"ISO-8859-3");
        builder.put((Object)"ibm-914_p100-1995", (Object)"ISO-8859-4");
        builder.put((Object)"ibm-914", (Object)"ISO-8859-4");
        builder.put((Object)"latin4", (Object)"ISO-8859-4");
        builder.put((Object)"csisolatin4", (Object)"ISO-8859-4");
        builder.put((Object)"iso-ir-110", (Object)"ISO-8859-4");
        builder.put((Object)"iso_8859-4:1988", (Object)"ISO-8859-4");
        builder.put((Object)"l4", (Object)"ISO-8859-4");
        builder.put((Object)"8859_4", (Object)"ISO-8859-4");
        builder.put((Object)"cp914", (Object)"ISO-8859-4");
        builder.put((Object)"914", (Object)"ISO-8859-4");
        builder.put((Object)"windows-28594", (Object)"ISO-8859-4");
        builder.put((Object)"ibm-915_p100-1995", (Object)"ISO-8859-5");
        builder.put((Object)"ibm-915", (Object)"ISO-8859-5");
        builder.put((Object)"cyrillic", (Object)"ISO-8859-5");
        builder.put((Object)"csisolatincyrillic", (Object)"ISO-8859-5");
        builder.put((Object)"iso-ir-144", (Object)"ISO-8859-5");
        builder.put((Object)"iso_8859-5:1988", (Object)"ISO-8859-5");
        builder.put((Object)"8859_5", (Object)"ISO-8859-5");
        builder.put((Object)"cp915", (Object)"ISO-8859-5");
        builder.put((Object)"915", (Object)"ISO-8859-5");
        builder.put((Object)"windows-28595", (Object)"ISO-8859-5");
        builder.put((Object)"ibm-1089_p100-1995", (Object)"ISO-8859-6");
        builder.put((Object)"ibm-1089", (Object)"ISO-8859-6");
        builder.put((Object)"arabic", (Object)"ISO-8859-6");
        builder.put((Object)"csisolatinarabic", (Object)"ISO-8859-6");
        builder.put((Object)"iso-ir-127", (Object)"ISO-8859-6");
        builder.put((Object)"iso_8859-6:1987", (Object)"ISO-8859-6");
        builder.put((Object)"ecma-114", (Object)"ISO-8859-6");
        builder.put((Object)"asmo-708", (Object)"ISO-8859-6");
        builder.put((Object)"8859_6", (Object)"ISO-8859-6");
        builder.put((Object)"cp1089", (Object)"ISO-8859-6");
        builder.put((Object)"1089", (Object)"ISO-8859-6");
        builder.put((Object)"windows-28596", (Object)"ISO-8859-6");
        builder.put((Object)"iso-8859-6-i", (Object)"ISO-8859-6");
        builder.put((Object)"iso-8859-6-e", (Object)"ISO-8859-6");
        builder.put((Object)"ibm-9005_x110-2007", (Object)"ISO-8859-7");
        builder.put((Object)"ibm-9005", (Object)"ISO-8859-7");
        builder.put((Object)"greek", (Object)"ISO-8859-7");
        builder.put((Object)"greek8", (Object)"ISO-8859-7");
        builder.put((Object)"elot_928", (Object)"ISO-8859-7");
        builder.put((Object)"ecma-118", (Object)"ISO-8859-7");
        builder.put((Object)"csisolatingreek", (Object)"ISO-8859-7");
        builder.put((Object)"iso-ir-126", (Object)"ISO-8859-7");
        builder.put((Object)"iso_8859-7:1987", (Object)"ISO-8859-7");
        builder.put((Object)"windows-28597", (Object)"ISO-8859-7");
        builder.put((Object)"sun_eu_greek", (Object)"ISO-8859-7");
        builder.put((Object)"ibm-813_p100-1995", (Object)"ISO-8859-7");
        builder.put((Object)"ibm-813", (Object)"ISO-8859-7");
        builder.put((Object)"8859_7", (Object)"ISO-8859-7");
        builder.put((Object)"cp813", (Object)"ISO-8859-7");
        builder.put((Object)"813", (Object)"ISO-8859-7");
        builder.put((Object)"ibm-5012_p100-1999", (Object)"ISO-8859-8");
        builder.put((Object)"ibm-5012", (Object)"ISO-8859-8");
        builder.put((Object)"hebrew", (Object)"ISO-8859-8");
        builder.put((Object)"csisolatinhebrew", (Object)"ISO-8859-8");
        builder.put((Object)"iso-ir-138", (Object)"ISO-8859-8");
        builder.put((Object)"iso_8859-8:1988", (Object)"ISO-8859-8");
        builder.put((Object)"iso-8859-8-i", (Object)"ISO-8859-8");
        builder.put((Object)"iso-8859-8-e", (Object)"ISO-8859-8");
        builder.put((Object)"8859_8", (Object)"ISO-8859-8");
        builder.put((Object)"windows-28598", (Object)"ISO-8859-8");
        builder.put((Object)"hebrew8", (Object)"ISO-8859-8");
        builder.put((Object)"ibm-916_p100-1995", (Object)"ibm-916");
        builder.put((Object)"cp916", (Object)"ibm-916");
        builder.put((Object)"916", (Object)"ibm-916");
        builder.put((Object)"ibm-920_p100-1995", (Object)"ISO-8859-9");
        builder.put((Object)"ibm-920", (Object)"ISO-8859-9");
        builder.put((Object)"latin5", (Object)"ISO-8859-9");
        builder.put((Object)"csisolatin5", (Object)"ISO-8859-9");
        builder.put((Object)"iso-ir-148", (Object)"ISO-8859-9");
        builder.put((Object)"iso_8859-9:1989", (Object)"ISO-8859-9");
        builder.put((Object)"l5", (Object)"ISO-8859-9");
        builder.put((Object)"8859_9", (Object)"ISO-8859-9");
        builder.put((Object)"cp920", (Object)"ISO-8859-9");
        builder.put((Object)"920", (Object)"ISO-8859-9");
        builder.put((Object)"windows-28599", (Object)"ISO-8859-9");
        builder.put((Object)"ecma-128", (Object)"ISO-8859-9");
        builder.put((Object)"turkish8", (Object)"ISO-8859-9");
        builder.put((Object)"turkish", (Object)"ISO-8859-9");
        builder.put((Object)"ibm-921_p100-1995", (Object)"ISO-8859-13");
        builder.put((Object)"ibm-921", (Object)"ISO-8859-13");
        builder.put((Object)"8859_13", (Object)"ISO-8859-13");
        builder.put((Object)"windows-28603", (Object)"ISO-8859-13");
        builder.put((Object)"cp921", (Object)"ISO-8859-13");
        builder.put((Object)"921", (Object)"ISO-8859-13");
        builder.put((Object)"ibm-923_p100-1998", (Object)"ISO-8859-15");
        builder.put((Object)"ibm-923", (Object)"ISO-8859-15");
        builder.put((Object)"latin-9", (Object)"ISO-8859-15");
        builder.put((Object)"l9", (Object)"ISO-8859-15");
        builder.put((Object)"8859_15", (Object)"ISO-8859-15");
        builder.put((Object)"latin0", (Object)"ISO-8859-15");
        builder.put((Object)"csisolatin0", (Object)"ISO-8859-15");
        builder.put((Object)"csisolatin9", (Object)"ISO-8859-15");
        builder.put((Object)"iso8859_15_fdis", (Object)"ISO-8859-15");
        builder.put((Object)"cp923", (Object)"ISO-8859-15");
        builder.put((Object)"923", (Object)"ISO-8859-15");
        builder.put((Object)"windows-28605", (Object)"ISO-8859-15");
        builder.put((Object)"ibm-943_p15a-2003", (Object)"Shift_JIS");
        builder.put((Object)"ms_kanji", (Object)"Shift_JIS");
        builder.put((Object)"csshiftjis", (Object)"Shift_JIS");
        builder.put((Object)"windows-31j", (Object)"Shift_JIS");
        builder.put((Object)"cswindows31j", (Object)"Shift_JIS");
        builder.put((Object)"x-sjis", (Object)"Shift_JIS");
        builder.put((Object)"x-ms-cp932", (Object)"Shift_JIS");
        builder.put((Object)"cp932", (Object)"Shift_JIS");
        builder.put((Object)"windows-932", (Object)"Shift_JIS");
        builder.put((Object)"cp943c", (Object)"Shift_JIS");
        builder.put((Object)"ibm-943c", (Object)"Shift_JIS");
        builder.put((Object)"ms932", (Object)"Shift_JIS");
        builder.put((Object)"pck", (Object)"Shift_JIS");
        builder.put((Object)"sjis", (Object)"Shift_JIS");
        builder.put((Object)"s-jis", (Object)"Shift_JIS");
        builder.put((Object)"ibm-943_vsub_vpua", (Object)"Shift_JIS");
        builder.put((Object)"ibm-943_p130-1999", (Object)"x-IBM943");
        builder.put((Object)"ibm-943", (Object)"x-IBM943");
        builder.put((Object)"shift_jis", (Object)"x-IBM943");
        builder.put((Object)"943", (Object)"x-IBM943");
        builder.put((Object)"ibm-943_vascii_vsub_vpu", (Object)"x-IBM943");
        builder.put((Object)"cp943", (Object)"x-IBM943");
        builder.put((Object)"ibm-33722_p120-1999", (Object)"x-IBM33722");
        builder.put((Object)"ibm-5050", (Object)"x-IBM33722");
        builder.put((Object)"cp33722", (Object)"x-IBM33722");
        builder.put((Object)"33722", (Object)"x-IBM33722");
        builder.put((Object)"ibm-33722_vascii_vpua", (Object)"x-IBM33722");
        builder.put((Object)"ibm-954_p101-2007", (Object)"x-JISAutoDetect");
        builder.put((Object)"ibm-954", (Object)"x-JISAutoDetect");
        builder.put((Object)"euc-jp", (Object)"x-JISAutoDetect");
        builder.put((Object)"cseucpkdfmtjapanese", (Object)"x-JISAutoDetect");
        builder.put((Object)"x-euc-jp", (Object)"x-JISAutoDetect");
        builder.put((Object)"eucjis", (Object)"x-JISAutoDetect");
        builder.put((Object)"ujis", (Object)"x-JISAutoDetect");
        builder.put((Object)"windows-950-2000", (Object)"Big5");
        builder.put((Object)"csbig5", (Object)"Big5");
        builder.put((Object)"windows-950", (Object)"Big5");
        builder.put((Object)"x-big5", (Object)"Big5");
        builder.put((Object)"ibm-950_p110-1999", (Object)"x-IBM950");
        builder.put((Object)"ibm-950", (Object)"x-IBM950");
        builder.put((Object)"cp950", (Object)"x-IBM950");
        builder.put((Object)"950", (Object)"x-IBM950");
        builder.put((Object)"ibm-1375_p100-2007", (Object)"Big5-HKSCS");
        builder.put((Object)"ibm-1375", (Object)"Big5-HKSCS");
        builder.put((Object)"big5-hkscs", (Object)"Big5-HKSCS");
        builder.put((Object)"big5hk", (Object)"Big5-HKSCS");
        builder.put((Object)"hkscs-big5", (Object)"Big5-HKSCS");
        builder.put((Object)"ibm-5471_p100-2006", (Object)"x-MS950-HKSCS");
        builder.put((Object)"ibm-5471", (Object)"x-MS950-HKSCS");
        builder.put((Object)"ms950_hkscs", (Object)"x-MS950-HKSCS");
        builder.put((Object)"hkbig5", (Object)"x-MS950-HKSCS");
        builder.put((Object)"big5-hkscs:unicode3.0", (Object)"x-MS950-HKSCS");
        builder.put((Object)"windows-936-2000", (Object)"GBK");
        builder.put((Object)"cp936", (Object)"GBK");
        builder.put((Object)"ms936", (Object)"GBK");
        builder.put((Object)"windows-936", (Object)"GBK");
        builder.put((Object)"ibm-1383_p110-1999", (Object)"GB2312");
        builder.put((Object)"ibm-1383", (Object)"GB2312");
        builder.put((Object)"csgb2312", (Object)"GB2312");
        builder.put((Object)"cp1383", (Object)"GB2312");
        builder.put((Object)"1383", (Object)"GB2312");
        builder.put((Object)"euc-cn", (Object)"GB2312");
        builder.put((Object)"ibm-euccn", (Object)"GB2312");
        builder.put((Object)"hp15cn", (Object)"GB2312");
        builder.put((Object)"ibm-1383_vpua", (Object)"GB2312");
        builder.put((Object)"ibm-964_p110-1999", (Object)"x-IBM964");
        builder.put((Object)"ibm-964", (Object)"x-IBM964");
        builder.put((Object)"euc-tw", (Object)"x-IBM964");
        builder.put((Object)"ibm-euctw", (Object)"x-IBM964");
        builder.put((Object)"cns11643", (Object)"x-IBM964");
        builder.put((Object)"cp964", (Object)"x-IBM964");
        builder.put((Object)"964", (Object)"x-IBM964");
        builder.put((Object)"ibm-964_vpua", (Object)"x-IBM964");
        builder.put((Object)"ibm-949_p110-1999", (Object)"x-IBM949");
        builder.put((Object)"ibm-949", (Object)"x-IBM949");
        builder.put((Object)"cp949", (Object)"x-IBM949");
        builder.put((Object)"949", (Object)"x-IBM949");
        builder.put((Object)"ibm-949_vascii_vsub_vpua", (Object)"x-IBM949");
        builder.put((Object)"ibm-970_p110_p110-2006_u2", (Object)"EUC-KR");
        builder.put((Object)"ibm-970", (Object)"EUC-KR");
        builder.put((Object)"euc-kr", (Object)"EUC-KR");
        builder.put((Object)"ks_c_5601-1987", (Object)"EUC-KR");
        builder.put((Object)"windows-51949", (Object)"EUC-KR");
        builder.put((Object)"cseuckr", (Object)"EUC-KR");
        builder.put((Object)"ibm-euckr", (Object)"EUC-KR");
        builder.put((Object)"ksc_5601", (Object)"EUC-KR");
        builder.put((Object)"5601", (Object)"EUC-KR");
        builder.put((Object)"cp970", (Object)"EUC-KR");
        builder.put((Object)"970", (Object)"EUC-KR");
        builder.put((Object)"ibm-970_vpua", (Object)"EUC-KR");
        builder.put((Object)"windows-949-2000", (Object)"x-windows-949");
        builder.put((Object)"windows-949", (Object)"x-windows-949");
        builder.put((Object)"ks_c_5601-1989", (Object)"x-windows-949");
        builder.put((Object)"csksc56011987", (Object)"x-windows-949");
        builder.put((Object)"korean", (Object)"x-windows-949");
        builder.put((Object)"iso-ir-149", (Object)"x-windows-949");
        builder.put((Object)"ms949", (Object)"x-windows-949");
        builder.put((Object)"windows-874-2000", (Object)"x-windows-874");
        builder.put((Object)"windows-874", (Object)"x-windows-874");
        builder.put((Object)"ms874", (Object)"x-windows-874");
        builder.put((Object)"ibm-874_p100-1995", (Object)"x-IBM874");
        builder.put((Object)"ibm-874", (Object)"x-IBM874");
        builder.put((Object)"ibm-9066", (Object)"x-IBM874");
        builder.put((Object)"cp874", (Object)"x-IBM874");
        builder.put((Object)"tis-620", (Object)"x-IBM874");
        builder.put((Object)"tis620.2533", (Object)"x-IBM874");
        builder.put((Object)"eucth", (Object)"x-IBM874");
        builder.put((Object)"ibm-437_p100-1995", (Object)"IBM437");
        builder.put((Object)"ibm437", (Object)"IBM437");
        builder.put((Object)"cp437", (Object)"IBM437");
        builder.put((Object)"437", (Object)"IBM437");
        builder.put((Object)"cspc8codepage437", (Object)"IBM437");
        builder.put((Object)"windows-437", (Object)"IBM437");
        builder.put((Object)"ibm-737_p100-1997", (Object)"x-IBM737");
        builder.put((Object)"ibm-737", (Object)"x-IBM737");
        builder.put((Object)"ibm737", (Object)"x-IBM737");
        builder.put((Object)"cp737", (Object)"x-IBM737");
        builder.put((Object)"windows-737", (Object)"x-IBM737");
        builder.put((Object)"737", (Object)"x-IBM737");
        builder.put((Object)"ibm-775_p100-1996", (Object)"IBM775");
        builder.put((Object)"ibm-775", (Object)"IBM775");
        builder.put((Object)"ibm775", (Object)"IBM775");
        builder.put((Object)"cp775", (Object)"IBM775");
        builder.put((Object)"cspc775baltic", (Object)"IBM775");
        builder.put((Object)"windows-775", (Object)"IBM775");
        builder.put((Object)"775", (Object)"IBM775");
        builder.put((Object)"ibm-850_p100-1995", (Object)"IBM850");
        builder.put((Object)"ibm-850", (Object)"IBM850");
        builder.put((Object)"ibm850", (Object)"IBM850");
        builder.put((Object)"cp850", (Object)"IBM850");
        builder.put((Object)"850", (Object)"IBM850");
        builder.put((Object)"cspc850multilingual", (Object)"IBM850");
        builder.put((Object)"windows-850", (Object)"IBM850");
        builder.put((Object)"ibm-852_p100-1995", (Object)"IBM852");
        builder.put((Object)"ibm-852", (Object)"IBM852");
        builder.put((Object)"ibm852", (Object)"IBM852");
        builder.put((Object)"cp852", (Object)"IBM852");
        builder.put((Object)"852", (Object)"IBM852");
        builder.put((Object)"cspcp852", (Object)"IBM852");
        builder.put((Object)"windows-852", (Object)"IBM852");
        builder.put((Object)"ibm-855_p100-1995", (Object)"IBM855");
        builder.put((Object)"ibm-855", (Object)"IBM855");
        builder.put((Object)"ibm855", (Object)"IBM855");
        builder.put((Object)"cp855", (Object)"IBM855");
        builder.put((Object)"855", (Object)"IBM855");
        builder.put((Object)"csibm855", (Object)"IBM855");
        builder.put((Object)"cspcp855", (Object)"IBM855");
        builder.put((Object)"windows-855", (Object)"IBM855");
        builder.put((Object)"ibm-856_p100-1995", (Object)"x-IBM856");
        builder.put((Object)"ibm-856", (Object)"x-IBM856");
        builder.put((Object)"ibm856", (Object)"x-IBM856");
        builder.put((Object)"cp856", (Object)"x-IBM856");
        builder.put((Object)"856", (Object)"x-IBM856");
        builder.put((Object)"ibm-857_p100-1995", (Object)"IBM857");
        builder.put((Object)"ibm-857", (Object)"IBM857");
        builder.put((Object)"cp857", (Object)"IBM857");
        builder.put((Object)"857", (Object)"IBM857");
        builder.put((Object)"csibm857", (Object)"IBM857");
        builder.put((Object)"windows-857", (Object)"IBM857");
        builder.put((Object)"ibm-858_p100-1997", (Object)"IBM00858");
        builder.put((Object)"ibm-858", (Object)"IBM00858");
        builder.put((Object)"ccsid00858", (Object)"IBM00858");
        builder.put((Object)"cp00858", (Object)"IBM00858");
        builder.put((Object)"pc-multilingual-850+euro", (Object)"IBM00858");
        builder.put((Object)"cp858", (Object)"IBM00858");
        builder.put((Object)"windows-858", (Object)"IBM00858");
        builder.put((Object)"ibm-860_p100-1995", (Object)"IBM860");
        builder.put((Object)"ibm-860", (Object)"IBM860");
        builder.put((Object)"cp860", (Object)"IBM860");
        builder.put((Object)"860", (Object)"IBM860");
        builder.put((Object)"csibm860", (Object)"IBM860");
        builder.put((Object)"ibm-861_p100-1995", (Object)"IBM861");
        builder.put((Object)"ibm-861", (Object)"IBM861");
        builder.put((Object)"cp861", (Object)"IBM861");
        builder.put((Object)"861", (Object)"IBM861");
        builder.put((Object)"cp-is", (Object)"IBM861");
        builder.put((Object)"csibm861", (Object)"IBM861");
        builder.put((Object)"windows-861", (Object)"IBM861");
        builder.put((Object)"ibm-862_p100-1995", (Object)"IBM862");
        builder.put((Object)"ibm-862", (Object)"IBM862");
        builder.put((Object)"cp862", (Object)"IBM862");
        builder.put((Object)"862", (Object)"IBM862");
        builder.put((Object)"cspc862latinhebrew", (Object)"IBM862");
        builder.put((Object)"dos-862", (Object)"IBM862");
        builder.put((Object)"windows-862", (Object)"IBM862");
        builder.put((Object)"ibm-863_p100-1995", (Object)"");
        builder.put((Object)"ibm-863", (Object)"IBM863");
        builder.put((Object)"cp863", (Object)"IBM863");
        builder.put((Object)"863", (Object)"IBM863");
        builder.put((Object)"csibm863", (Object)"IBM863");
        builder.put((Object)"ibm-864_x110-1999", (Object)"IBM864");
        builder.put((Object)"ibm-864", (Object)"IBM864");
        builder.put((Object)"cp864", (Object)"IBM864");
        builder.put((Object)"csibm864", (Object)"IBM864");
        builder.put((Object)"ibm-865_p100-1995", (Object)"IBM865");
        builder.put((Object)"ibm-865", (Object)"IBM865");
        builder.put((Object)"cp865", (Object)"IBM865");
        builder.put((Object)"865", (Object)"IBM865");
        builder.put((Object)"csibm865", (Object)"IBM865");
        builder.put((Object)"ibm-866_p100-1995", (Object)"IBM866");
        builder.put((Object)"ibm-866", (Object)"IBM866");
        builder.put((Object)"cp866", (Object)"IBM866");
        builder.put((Object)"866", (Object)"IBM866");
        builder.put((Object)"csibm866", (Object)"IBM866");
        builder.put((Object)"windows-866", (Object)"IBM866");
        builder.put((Object)"ibm-868_p100-1995", (Object)"IBM868");
        builder.put((Object)"ibm-868", (Object)"IBM868");
        builder.put((Object)"cp868", (Object)"IBM868");
        builder.put((Object)"868", (Object)"IBM868");
        builder.put((Object)"csibm868", (Object)"IBM868");
        builder.put((Object)"cp-ar", (Object)"IBM868");
        builder.put((Object)"ibm-869_p100-1995", (Object)"IBM869");
        builder.put((Object)"ibm-869", (Object)"IBM869");
        builder.put((Object)"cp869", (Object)"IBM869");
        builder.put((Object)"869", (Object)"IBM869");
        builder.put((Object)"cp-gr", (Object)"IBM869");
        builder.put((Object)"csibm869", (Object)"IBM869");
        builder.put((Object)"windows-869", (Object)"IBM869");
        builder.put((Object)"ibm-878_p100-1996", (Object)"KOI8-R");
        builder.put((Object)"ibm-878", (Object)"KOI8-R");
        builder.put((Object)"koi8-r", (Object)"KOI8-R");
        builder.put((Object)"koi8", (Object)"KOI8-R");
        builder.put((Object)"cskoi8r", (Object)"KOI8-R");
        builder.put((Object)"windows-20866", (Object)"KOI8-R");
        builder.put((Object)"cp878", (Object)"KOI8-R");
        builder.put((Object)"ibm-922_p100-1999", (Object)"x-IBM922");
        builder.put((Object)"ibm-922", (Object)"x-IBM922");
        builder.put((Object)"ibm922", (Object)"x-IBM922");
        builder.put((Object)"cp922", (Object)"x-IBM922");
        builder.put((Object)"922", (Object)"x-IBM922");
        builder.put((Object)"ibm-5346_p100-1998", (Object)"windows-1250");
        builder.put((Object)"ibm-5346", (Object)"windows-1250");
        builder.put((Object)"cp1250", (Object)"windows-1250");
        builder.put((Object)"ibm-5347_p100-1998", (Object)"windows-1251");
        builder.put((Object)"ibm-5347", (Object)"windows-1251");
        builder.put((Object)"cp1251", (Object)"windows-1251");
        builder.put((Object)"ansi1251", (Object)"windows-1251");
        builder.put((Object)"ibm-5348_p100-1997", (Object)"windows-1252");
        builder.put((Object)"ibm-5348", (Object)"windows-1252");
        builder.put((Object)"cp1252", (Object)"windows-1252");
        builder.put((Object)"ibm-5349_p100-1998", (Object)"windows-1253");
        builder.put((Object)"ibm-5349", (Object)"windows-1253");
        builder.put((Object)"cp1253", (Object)"windows-1253");
        builder.put((Object)"ibm-5350_p100-1998", (Object)"windows-1254");
        builder.put((Object)"ibm-5350", (Object)"windows-1254");
        builder.put((Object)"cp1254", (Object)"windows-1254");
        builder.put((Object)"ibm-9447_p100-2002", (Object)"windows-1255");
        builder.put((Object)"ibm-9447", (Object)"windows-1255");
        builder.put((Object)"cp1255", (Object)"windows-1255");
        builder.put((Object)"ibm-9448_x100-2005", (Object)"windows-1256");
        builder.put((Object)"ibm-9448", (Object)"windows-1256");
        builder.put((Object)"cp1256", (Object)"windows-1256");
        builder.put((Object)"ibm-9449_p100-2002", (Object)"windows-1257");
        builder.put((Object)"ibm-9449", (Object)"windows-1257");
        builder.put((Object)"cp1257", (Object)"windows-1257");
        builder.put((Object)"ibm-5354_p100-1998", (Object)"windows-1258");
        builder.put((Object)"ibm-5354", (Object)"windows-1258");
        builder.put((Object)"cp1258", (Object)"windows-1258");
        builder.put((Object)"ibm-1006_p100-1995", (Object)"x-IBM1006");
        builder.put((Object)"ibm-1006", (Object)"x-IBM1006");
        builder.put((Object)"ibm1006", (Object)"x-IBM1006");
        builder.put((Object)"cp1006", (Object)"x-IBM1006");
        builder.put((Object)"1006", (Object)"x-IBM1006");
        builder.put((Object)"ibm-1098_p100-1995", (Object)"x-IBM1006");
        builder.put((Object)"ibm-1098", (Object)"x-IBM1006");
        builder.put((Object)"ibm1098", (Object)"x-IBM1006");
        builder.put((Object)"cp1098", (Object)"x-IBM1006");
        builder.put((Object)"1098", (Object)"x-IBM1006");
        builder.put((Object)"ibm-1124_p100-1996", (Object)"x-IBM1124");
        builder.put((Object)"ibm-1124", (Object)"x-IBM1124");
        builder.put((Object)"cp1124", (Object)"x-IBM1124");
        builder.put((Object)"1124", (Object)"x-IBM1124");
        builder.put((Object)"ISO_2022,locale=ja,version=0", (Object)"ISO-2022-JP");
        builder.put((Object)"iso-2022-jp", (Object)"ISO-2022-JP");
        builder.put((Object)"csiso2022jp", (Object)"ISO-2022-JP");
        builder.put((Object)"ISO_2022,locale=ko,version=0", (Object)"ISO-2022-KR");
        builder.put((Object)"iso-2022-kr", (Object)"ISO-2022-KR");
        builder.put((Object)"csiso2022kr", (Object)"ISO-2022-KR");
        builder.put((Object)"ISO_2022,locale=zh,version=0", (Object)"ISO-2022-CN");
        builder.put((Object)"iso-2022-cn", (Object)"ISO-2022-CN");
        builder.put((Object)"csiso2022cn", (Object)"ISO-2022-CN");
        builder.put((Object)"ibm-37_p100-1995", (Object)"IBM037");
        builder.put((Object)"ibm-37", (Object)"IBM037");
        builder.put((Object)"ibm-037", (Object)"IBM037");
        builder.put((Object)"ebcdic-cp-us", (Object)"IBM037");
        builder.put((Object)"ebcdic-cp-ca", (Object)"IBM037");
        builder.put((Object)"ebcdic-cp-wt", (Object)"IBM037");
        builder.put((Object)"ebcdic-cp-nl", (Object)"IBM037");
        builder.put((Object)"csibm037", (Object)"IBM037");
        builder.put((Object)"cp037", (Object)"IBM037");
        builder.put((Object)"37", (Object)"IBM037");
        builder.put((Object)"cpibm37", (Object)"IBM037");
        builder.put((Object)"cp37", (Object)"IBM037");
        builder.put((Object)"ibm-273_p100-1995", (Object)"IBM273");
        builder.put((Object)"ibm-273", (Object)"IBM273");
        builder.put((Object)"cp273", (Object)"IBM273");
        builder.put((Object)"csibm273", (Object)"IBM273");
        builder.put((Object)"ebcdic-de", (Object)"IBM273");
        builder.put((Object)"273", (Object)"IBM273");
        builder.put((Object)"ibm-277_p100-1995", (Object)"IBM277");
        builder.put((Object)"ibm-277", (Object)"IBM277");
        builder.put((Object)"cp277", (Object)"IBM277");
        builder.put((Object)"ebcdic-cp-dk", (Object)"IBM277");
        builder.put((Object)"ebcdic-cp-no", (Object)"IBM277");
        builder.put((Object)"csibm277", (Object)"IBM277");
        builder.put((Object)"ebcdic-dk", (Object)"IBM277");
        builder.put((Object)"277", (Object)"IBM277");
        builder.put((Object)"ibm-278_p100-1995", (Object)"IBM278");
        builder.put((Object)"ibm-278", (Object)"IBM278");
        builder.put((Object)"cp278", (Object)"IBM278");
        builder.put((Object)"ebcdic-cp-fi", (Object)"IBM278");
        builder.put((Object)"ebcdic-cp-se", (Object)"IBM278");
        builder.put((Object)"csibm278", (Object)"IBM278");
        builder.put((Object)"ebcdic-sv", (Object)"IBM278");
        builder.put((Object)"278", (Object)"IBM278");
        builder.put((Object)"ibm-280_p100-1995", (Object)"IBM280");
        builder.put((Object)"ibm-280", (Object)"IBM280");
        builder.put((Object)"cp280", (Object)"IBM280");
        builder.put((Object)"ebcdic-cp-it", (Object)"IBM280");
        builder.put((Object)"csibm280", (Object)"IBM280");
        builder.put((Object)"280", (Object)"IBM280");
        builder.put((Object)"ibm-284_p100-1995", (Object)"IBM284");
        builder.put((Object)"ibm-284", (Object)"IBM284");
        builder.put((Object)"cp284", (Object)"IBM284");
        builder.put((Object)"ebcdic-cp-es", (Object)"IBM284");
        builder.put((Object)"csibm284", (Object)"IBM284");
        builder.put((Object)"cpibm284", (Object)"IBM284");
        builder.put((Object)"284", (Object)"IBM284");
        builder.put((Object)"ibm-285_p100-1995", (Object)"IBM285");
        builder.put((Object)"ibm-285", (Object)"IBM285");
        builder.put((Object)"cp285", (Object)"IBM285");
        builder.put((Object)"ebcdic-cp-gb", (Object)"IBM285");
        builder.put((Object)"csibm285", (Object)"IBM285");
        builder.put((Object)"cpibm285", (Object)"IBM285");
        builder.put((Object)"ebcdic-gb", (Object)"IBM285");
        builder.put((Object)"285", (Object)"IBM285");
        builder.put((Object)"ibm-297_p100-1995", (Object)"IBM297");
        builder.put((Object)"ibm-297", (Object)"IBM297");
        builder.put((Object)"cp297", (Object)"IBM297");
        builder.put((Object)"ebcdic-cp-fr", (Object)"IBM297");
        builder.put((Object)"csibm297", (Object)"IBM297");
        builder.put((Object)"cpibm297", (Object)"IBM297");
        builder.put((Object)"297", (Object)"IBM297");
        builder.put((Object)"ibm-420_x120-1999", (Object)"IBM420");
        builder.put((Object)"ibm-420", (Object)"IBM420");
        builder.put((Object)"ibm420", (Object)"IBM420");
        builder.put((Object)"cp420", (Object)"IBM420");
        builder.put((Object)"ebcdic-cp-ar1", (Object)"IBM420");
        builder.put((Object)"csibm420", (Object)"IBM420");
        builder.put((Object)"420", (Object)"IBM420");
        builder.put((Object)"ibm-424_p100-1995", (Object)"IBM424");
        builder.put((Object)"ibm-424", (Object)"IBM424");
        builder.put((Object)"cp424", (Object)"IBM424");
        builder.put((Object)"ebcdic-cp-he", (Object)"IBM424");
        builder.put((Object)"csibm424", (Object)"IBM424");
        builder.put((Object)"424", (Object)"IBM424");
        builder.put((Object)"ibm-500_p100-1995", (Object)"IBM500");
        builder.put((Object)"ibm-500", (Object)"IBM500");
        builder.put((Object)"cp500", (Object)"IBM500");
        builder.put((Object)"ebcdic-cp-be", (Object)"IBM500");
        builder.put((Object)"csibm500", (Object)"IBM500");
        builder.put((Object)"ebcdic-cp-ch", (Object)"IBM500");
        builder.put((Object)"500", (Object)"IBM500");
        builder.put((Object)"ibm-838_p100-1995", (Object)"IBM-Thai");
        builder.put((Object)"ibm-838", (Object)"IBM-Thai");
        builder.put((Object)"ibm838", (Object)"IBM-Thai");
        builder.put((Object)"csibmthai", (Object)"IBM-Thai");
        builder.put((Object)"cp838", (Object)"IBM-Thai");
        builder.put((Object)"838", (Object)"IBM-Thai");
        builder.put((Object)"ibm-9030", (Object)"IBM-Thai");
        builder.put((Object)"ibm-870_p100-1995", (Object)"IBM870");
        builder.put((Object)"ibm-870", (Object)"IBM870");
        builder.put((Object)"cp870", (Object)"IBM870");
        builder.put((Object)"ebcdic-cp-roece", (Object)"IBM870");
        builder.put((Object)"ebcdic-cp-yu", (Object)"IBM870");
        builder.put((Object)"csibm870", (Object)"IBM870");
        builder.put((Object)"ibm-871_p100-1995", (Object)"IBM871");
        builder.put((Object)"ibm-871", (Object)"IBM871");
        builder.put((Object)"ebcdic-cp-is", (Object)"IBM871");
        builder.put((Object)"csibm871", (Object)"IBM871");
        builder.put((Object)"cp871", (Object)"IBM871");
        builder.put((Object)"ebcdic-is", (Object)"IBM871");
        builder.put((Object)"871", (Object)"IBM871");
        builder.put((Object)"ibm-875_p100-1995", (Object)"x-IBM875");
        builder.put((Object)"ibm-875", (Object)"x-IBM875");
        builder.put((Object)"ibm875", (Object)"x-IBM875");
        builder.put((Object)"cp875", (Object)"x-IBM875");
        builder.put((Object)"875", (Object)"x-IBM875");
        builder.put((Object)"ibm-918_p100-1995", (Object)"IBM918");
        builder.put((Object)"ibm-918", (Object)"IBM918");
        builder.put((Object)"cp918", (Object)"IBM918");
        builder.put((Object)"ebcdic-cp-ar2", (Object)"IBM918");
        builder.put((Object)"csibm918", (Object)"IBM918");
        builder.put((Object)"ibm-930_p120-1999", (Object)"x-IBM930");
        builder.put((Object)"ibm-930", (Object)"x-IBM930");
        builder.put((Object)"ibm-5026", (Object)"x-IBM930");
        builder.put((Object)"ibm930", (Object)"x-IBM930");
        builder.put((Object)"cp930", (Object)"x-IBM930");
        builder.put((Object)"930", (Object)"x-IBM930");
        builder.put((Object)"ibm-933_p110-1995", (Object)"x-IBM933");
        builder.put((Object)"ibm-933", (Object)"x-IBM933");
        builder.put((Object)"cp933", (Object)"x-IBM933");
        builder.put((Object)"933", (Object)"x-IBM933");
        builder.put((Object)"ibm-935_p110-1999", (Object)"x-IBM935");
        builder.put((Object)"ibm-935", (Object)"x-IBM935");
        builder.put((Object)"cp935", (Object)"x-IBM935");
        builder.put((Object)"935", (Object)"x-IBM935");
        builder.put((Object)"ibm-937_p110-1999", (Object)"x-IBM937");
        builder.put((Object)"ibm-937", (Object)"x-IBM937");
        builder.put((Object)"cp937", (Object)"x-IBM937");
        builder.put((Object)"937", (Object)"x-IBM937");
        builder.put((Object)"ibm-939_p120-1999", (Object)"x-IBM939");
        builder.put((Object)"ibm-939", (Object)"x-IBM939");
        builder.put((Object)"ibm-931", (Object)"x-IBM939");
        builder.put((Object)"ibm-5035", (Object)"x-IBM939");
        builder.put((Object)"ibm939", (Object)"x-IBM939");
        builder.put((Object)"cp939", (Object)"x-IBM939");
        builder.put((Object)"939", (Object)"x-IBM939");
        builder.put((Object)"ibm-1025_p100-1995", (Object)"x-IBM1025");
        builder.put((Object)"ibm-1025", (Object)"x-IBM1025");
        builder.put((Object)"cp1025", (Object)"x-IBM1025");
        builder.put((Object)"1025", (Object)"x-IBM1025");
        builder.put((Object)"ibm-1026_p100-1995", (Object)"IBM1026");
        builder.put((Object)"ibm-1026", (Object)"IBM1026");
        builder.put((Object)"ibm1026", (Object)"IBM1026");
        builder.put((Object)"cp1026", (Object)"IBM1026");
        builder.put((Object)"csibm1026", (Object)"IBM1026");
        builder.put((Object)"1026", (Object)"IBM1026");
        builder.put((Object)"ibm-1047_p100-1995", (Object)"IBM1047");
        builder.put((Object)"ibm-1047", (Object)"IBM1047");
        builder.put((Object)"ibm1047", (Object)"IBM1047");
        builder.put((Object)"cp1047", (Object)"IBM1047");
        builder.put((Object)"1047", (Object)"IBM1047");
        builder.put((Object)"ibm-1097_p100-1995", (Object)"x-IBM1097");
        builder.put((Object)"ibm-1097", (Object)"x-IBM1097");
        builder.put((Object)"cp1097", (Object)"x-IBM1097");
        builder.put((Object)"1097", (Object)"x-IBM1097");
        builder.put((Object)"ibm-1112_p100-1995", (Object)"x-IBM1112");
        builder.put((Object)"ibm-1112", (Object)"x-IBM1112");
        builder.put((Object)"cp1112", (Object)"x-IBM1112");
        builder.put((Object)"1112", (Object)"x-IBM1112");
        builder.put((Object)"ibm-1122_p100-1999", (Object)"x-IBM1122");
        builder.put((Object)"ibm-1122", (Object)"x-IBM1122");
        builder.put((Object)"cp1122", (Object)"x-IBM1122");
        builder.put((Object)"1122", (Object)"x-IBM1122");
        builder.put((Object)"ibm-1123_p100-1995", (Object)"x-IBM1123");
        builder.put((Object)"ibm-1123", (Object)"x-IBM1123");
        builder.put((Object)"cp1123", (Object)"x-IBM1123");
        builder.put((Object)"1123", (Object)"x-IBM1123");
        builder.put((Object)"ibm-1140_p100-1997", (Object)"IBM01140");
        builder.put((Object)"ibm-1140", (Object)"IBM01140");
        builder.put((Object)"ccsid01140", (Object)"IBM01140");
        builder.put((Object)"cp01140", (Object)"IBM01140");
        builder.put((Object)"cp1140", (Object)"IBM01140");
        builder.put((Object)"ebcdic-us-37+euro", (Object)"IBM01140");
        builder.put((Object)"ibm-1141_p100-1997", (Object)"IBM01141");
        builder.put((Object)"ibm-1141", (Object)"IBM01141");
        builder.put((Object)"ccsid01141", (Object)"IBM01141");
        builder.put((Object)"cp01141", (Object)"IBM01141");
        builder.put((Object)"cp1141", (Object)"IBM01141");
        builder.put((Object)"ebcdic-de-273+euro", (Object)"IBM01141");
        builder.put((Object)"ibm-1142_p100-1997", (Object)"IBM01142");
        builder.put((Object)"ibm-1142", (Object)"IBM01142");
        builder.put((Object)"ccsid01142", (Object)"IBM01142");
        builder.put((Object)"cp01142", (Object)"IBM01142");
        builder.put((Object)"cp1142", (Object)"IBM01142");
        builder.put((Object)"ebcdic-dk-277+euro", (Object)"IBM01142");
        builder.put((Object)"ebcdic-no-277+euro", (Object)"IBM01142");
        builder.put((Object)"ibm-1143_p100-1997", (Object)"IBM01143");
        builder.put((Object)"ibm-1143", (Object)"IBM01143");
        builder.put((Object)"ccsid01143", (Object)"IBM01143");
        builder.put((Object)"cp01143", (Object)"IBM01143");
        builder.put((Object)"cp1143", (Object)"IBM01143");
        builder.put((Object)"ebcdic-fi-278+euro", (Object)"IBM01143");
        builder.put((Object)"ebcdic-se-278+euro", (Object)"IBM01143");
        builder.put((Object)"ibm-1144_p100-1997", (Object)"IBM01144");
        builder.put((Object)"ibm-1144", (Object)"IBM01144");
        builder.put((Object)"ccsid01144", (Object)"IBM01144");
        builder.put((Object)"cp01144", (Object)"IBM01144");
        builder.put((Object)"cp1144", (Object)"IBM01144");
        builder.put((Object)"ebcdic-it-280+euro", (Object)"IBM01144");
        builder.put((Object)"ibm-1145_p100-1997", (Object)"IBM01145");
        builder.put((Object)"ibm-1145", (Object)"IBM01145");
        builder.put((Object)"ccsid01145", (Object)"IBM01145");
        builder.put((Object)"cp01145", (Object)"IBM01145");
        builder.put((Object)"cp1145", (Object)"IBM01145");
        builder.put((Object)"ebcdic-es-284+euro", (Object)"IBM01145");
        builder.put((Object)"ibm-1146_p100-1997", (Object)"IBM01146");
        builder.put((Object)"ibm-1146", (Object)"IBM01146");
        builder.put((Object)"ccsid01146", (Object)"IBM01146");
        builder.put((Object)"cp01146", (Object)"IBM01146");
        builder.put((Object)"cp1146", (Object)"IBM01146");
        builder.put((Object)"ebcdic-gb-285+euro", (Object)"IBM01146");
        builder.put((Object)"ibm-1147_p100-1997", (Object)"IBM01147");
        builder.put((Object)"ibm-1147", (Object)"IBM01147");
        builder.put((Object)"ccsid01147", (Object)"IBM01147");
        builder.put((Object)"cp01147", (Object)"IBM01147");
        builder.put((Object)"cp1147", (Object)"IBM01147");
        builder.put((Object)"ebcdic-fr-297+euro", (Object)"IBM01147");
        builder.put((Object)"ibm-1148_p100-1997", (Object)"IBM01148");
        builder.put((Object)"ibm-1148", (Object)"IBM01148");
        builder.put((Object)"ccsid01148", (Object)"IBM01148");
        builder.put((Object)"cp01148", (Object)"IBM01148");
        builder.put((Object)"cp1148", (Object)"IBM01148");
        builder.put((Object)"ebcdic-international-500+euro", (Object)"IBM01148");
        builder.put((Object)"ibm-1149_p100-1997", (Object)"IBM01149");
        builder.put((Object)"ibm-1149", (Object)"IBM01149");
        builder.put((Object)"ccsid01149", (Object)"IBM01149");
        builder.put((Object)"cp01149", (Object)"IBM01149");
        builder.put((Object)"cp1149", (Object)"IBM01149");
        builder.put((Object)"ebcdic-is-871+euro", (Object)"IBM01149");
        aliasTable = builder.build();
    }

    public static class DetectorState
    implements nsICharsetDetectionObserver {
        public boolean _done = false;
        public String _detectedCharset = null;

        public void Notify(String charset) {
            this._detectedCharset = charset;
            this._done = true;
        }
    }
}

