/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSInputStream;

public class ByteBufferInputStream
extends FSInputStream {
    ByteBuffer _source;

    public ByteBufferInputStream() {
        this._source = null;
    }

    public ByteBufferInputStream(ByteBuffer source) {
        this._source = source;
    }

    public void setSoruce(ByteBuffer source) {
        this._source = source;
    }

    public synchronized int read() throws IOException {
        if (this._source == null || !this._source.hasRemaining()) {
            return -1;
        }
        return this._source.get() & 0xFF;
    }

    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        if (this._source == null) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        if (this._source.remaining() == 0) {
            return -1;
        }
        len = Math.min(len, this._source.remaining());
        this._source.get(bytes, off, len);
        return len;
    }

    public long getPos() throws IOException {
        return this._source.position();
    }

    public void seek(long pos) throws IOException {
        this._source.position((int)pos);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.seek(targetPos);
        return false;
    }
}

