/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.BoundedFIFO;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.commoncrawl.util.shared.Dispatcher;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    BoundedFIFO bf;
    AppenderAttachableImpl aai;
    Dispatcher dispatcher;
    boolean locationInfo = false;
    boolean interruptedWarningMessage = false;

    public AsyncAppender(int logBufferQueueSize) {
        this.bf = new BoundedFIFO(Math.max(128, logBufferQueueSize));
        this.aai = new AppenderAttachableImpl();
        this.dispatcher = new Dispatcher(this.bf, this);
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.addAppender(newAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (!this.dispatcher.isAlive()) {
            AppenderAttachableImpl appenderAttachableImpl = this.aai;
            synchronized (appenderAttachableImpl) {
                this.aai.appendLoopOnAppenders(event);
            }
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            while (this.bf.isFull()) {
                try {
                    this.bf.wait();
                }
                catch (InterruptedException e) {
                    if (!this.interruptedWarningMessage) {
                        this.interruptedWarningMessage = true;
                        LogLog.warn((String)"AsyncAppender interrupted.", (Throwable)e);
                        continue;
                    }
                    LogLog.warn((String)"AsyncAppender interrupted again.");
                }
            }
            this.bf.put(event);
            if (this.bf.wasEmpty()) {
                this.bf.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AsyncAppender asyncAppender = this;
        synchronized (asyncAppender) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.dispatcher.close();
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            LogLog.error((String)"Got an InterruptedException while waiting for the dispatcher to finish.", (Throwable)e);
        }
        this.dispatcher = null;
        this.bf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            return this.aai.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            return this.aai.getAppender(name);
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(name);
        }
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public void setBufferSize(int size) {
        this.bf.resize(size);
    }

    public int getBufferSize() {
        return this.bf.getMaxSize();
    }
}

