/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.rpc.RPCActorService;
import org.commoncrawl.server.AsyncWebServerRequest;
import org.commoncrawl.server.WebServer;
import org.commoncrawl.util.shared.CCStringUtils;

public abstract class CommonCrawlServer
extends RPCActorService {
    public static final Log LOG = LogFactory.getLog(CommonCrawlServer.class);
    private static final int DEFAULT_MAX_THREADPOOL_THREADS = 5;
    private static final int DEFAULT_DNS_THREAD_POOL_SIZE = 50;
    public static final String DNS_POOL_NAME = "dns";
    protected Configuration _configuration;
    private static CommonCrawlServer _serverSingleton;
    protected static CommonConfig _commonConfig;
    protected String _hostName;
    protected InetSocketAddress _serverAddress;
    protected File _dataDir;
    protected WebServer _webServer;
    protected boolean _useAsyncWebDispatch = false;
    private int _dnsThreadPoolSize = 50;
    protected EventLoop _eventLoop = null;
    private ExecutorService _defaultThreadPool;
    private TreeMap<String, ExecutorService> _threadPoolMap = new TreeMap();
    private static boolean _detailLoggingEnabled;
    FileSystem _fileSystem = null;
    private static ThreadLocal<CommonCrawlServer> _serverObject;

    public CommonCrawlServer() {
        super(null);
        _serverSingleton = this;
    }

    public static CommonCrawlServer getServerSingleton() {
        return _serverObject.get();
    }

    protected void overrideConfig(Configuration conf) {
    }

    protected abstract boolean parseArguements(String[] var1);

    protected abstract String getDefaultRPCInterface();

    protected abstract int getDefaultRPCPort();

    protected abstract String getDefaultHttpInterface();

    protected abstract int getDefaultHttpPort();

    protected abstract String getAppName();

    protected abstract String getDefaultDataDir();

    protected abstract void printUsage();

    protected abstract boolean initServer();

    protected abstract boolean startDaemons();

    protected abstract void stopDaemons();

    public Configuration getHadoopConfig() {
        return this._configuration;
    }

    public String getServerName() {
        return this.getClass().getSimpleName();
    }

    public EventLoop getEventLoop() {
        return this._eventLoop;
    }

    public synchronized ExecutorService getDefaultThreadPool() {
        return this._defaultThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService registerThreadPool(String threadPoolId, int maxThreads) {
        ExecutorService service = null;
        TreeMap<String, ExecutorService> treeMap = this._threadPoolMap;
        synchronized (treeMap) {
            service = this._threadPoolMap.get(threadPoolId);
            if (service == null) {
                service = Executors.newFixedThreadPool(maxThreads);
                this._threadPoolMap.put(threadPoolId, service);
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPool(String threadPoolId) {
        ExecutorService service = null;
        TreeMap<String, ExecutorService> treeMap = this._threadPoolMap;
        synchronized (treeMap) {
            service = this._threadPoolMap.get(threadPoolId);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateDefaultThreadPool() {
        ExecutorService oldThreadPool = null;
        CommonCrawlServer commonCrawlServer = this;
        synchronized (commonCrawlServer) {
            oldThreadPool = this._defaultThreadPool;
            this._defaultThreadPool = Executors.newFixedThreadPool(this._configuration.getInt("org.commoncrawl.threadpool.max.threads", 5));
        }
        oldThreadPool.shutdown();
        try {
            while (!oldThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                LOG.info((Object)"Awaiting shutdown for Default ThreadPool");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThreadPool(String threadPoolId) {
        ExecutorService service = null;
        TreeMap<String, ExecutorService> treeMap = this._threadPoolMap;
        synchronized (treeMap) {
            service = this._threadPoolMap.remove(threadPoolId);
        }
        if (service != null) {
            LOG.info((Object)("Terminating ThreadPool:" + threadPoolId));
            service.shutdown();
            try {
                while (!service.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    LOG.info((Object)("Awaiting shutdown for ThreadPool:" + threadPoolId));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void setAsyncWebDispatch(boolean asyncWebDispatch) {
        this._useAsyncWebDispatch = asyncWebDispatch;
    }

    public FileSystem getFileSystem() {
        return this._fileSystem;
    }

    public String getHostName() {
        return this._hostName;
    }

    public InetSocketAddress getServerAddress() {
        return this._serverAddress;
    }

    public File getDataDirectory() {
        return this._dataDir;
    }

    public File getLogDirectory() {
        return new File(System.getProperty("commoncrawl.log.dir"));
    }

    public WebServer getWebServer() {
        return this._webServer;
    }

    public static boolean detailLoggingEnabled() {
        return _detailLoggingEnabled;
    }

    protected final boolean init(String[] argv, Configuration conf) throws IOException {
        this._configuration = conf;
        this._fileSystem = FileSystem.get((Configuration)this._configuration);
        LOG.info((Object)("Hadoop FileSystem is:" + this._fileSystem.getUri().toString()));
        if (!this.parseArguements(argv)) {
            this.printUsage();
            return false;
        }
        this.overrideConfig(conf);
        this._defaultThreadPool = Executors.newFixedThreadPool(this._configuration.getInt("org.commoncrawl.threadpool.max.threads", 5));
        this._hostName = this._configuration.get("org.commoncrawl.hostname");
        if (this._hostName == null) {
            InetAddress localHostAddr = InetAddress.getLocalHost();
            this._hostName = localHostAddr.getHostName();
            this._configuration.set("org.commoncrawl.hostname", this._hostName);
        }
        if (CommonCrawlServer.detailLoggingEnabled()) {
            LOG.info((Object)("Hostname is: " + this._hostName));
        }
        String rpcInterface = this._configuration.get("org.commoncrawl.rpcInterface", this.getDefaultRPCInterface());
        String webInterface = this._configuration.get("org.commoncrawl.httpInterface", this.getDefaultHttpInterface());
        int rpcPort = this._configuration.getInt("org.commoncrawl.rpcPort", this.getDefaultRPCPort());
        int httpPort = this._configuration.getInt("org.commoncrawl.httpPort", this.getDefaultHttpPort());
        String dataDirectory = this._configuration.get("org.commoncrawl.dataDir", this.getDefaultDataDir());
        this._dnsThreadPoolSize = this._configuration.getInt("org.commoncrawl.dnsThreadPoolSize", 50);
        this._dataDir = new File(dataDirectory);
        if (!this._dataDir.exists()) {
            if (!this._dataDir.mkdirs()) {
                System.out.println("Unable to create data directory: " + dataDirectory);
                return false;
            }
        } else if (!this._dataDir.isDirectory()) {
            System.out.println("Invalid data directory:" + dataDirectory);
            return false;
        }
        LOG.info((Object)("Config says rpcInterface is:" + rpcInterface));
        conf.set("org.commoncrawl.rpcInterface", rpcInterface);
        LOG.info((Object)("Config says httpInterface is:" + webInterface));
        conf.set("org.commoncrawl.httpInterface", webInterface);
        LOG.info((Object)("Config says rpcPort is:" + rpcPort));
        conf.setInt("org.commoncrawl.rpcPort", rpcPort);
        LOG.info((Object)("Config says httpPort is:" + httpPort));
        conf.setInt("org.commoncrawl.httpPort", httpPort);
        LOG.info((Object)("Config says dataDir  is:" + dataDirectory));
        conf.set("org.commoncrawl.dataDir", dataDirectory);
        String[] rpcIPS = CommonCrawlServer.getIPs(rpcInterface);
        String[] webIPS = CommonCrawlServer.getIPs(webInterface);
        if (rpcIPS == null || rpcIPS.length == 0) {
            LOG.error((Object)("No Valid IP Addresses found for RPC Interface:" + rpcInterface));
            return false;
        }
        if (webIPS == null || webIPS.length == 0) {
            LOG.error((Object)("No Valid IP Addresses found for Web Interface:" + webInterface));
            return false;
        }
        String selectedRPCInterface = rpcIPS[0];
        if (rpcIPS.length > 1) {
            for (String rpcIPAddress : rpcIPS) {
                if (rpcIPAddress.endsWith(".1")) continue;
                selectedRPCInterface = rpcIPAddress;
                break;
            }
        }
        String selectedWebInterface = webIPS[0];
        if (webIPS.length > 1) {
            for (String webIPAddress : rpcIPS) {
                if (webIPAddress.endsWith(".1")) continue;
                selectedWebInterface = webIPAddress;
                break;
            }
        }
        LOG.info((Object)("RPC Interface translates to IP:" + selectedRPCInterface));
        LOG.info((Object)("Web Interface translates to IP:" + selectedWebInterface));
        this._serverAddress = new InetSocketAddress(selectedRPCInterface, rpcPort);
        this._eventLoop = new EventLoop(this.registerThreadPool(DNS_POOL_NAME, this._dnsThreadPoolSize));
        this._webServer = new WebServer(this, selectedWebInterface, httpPort, false, this._useAsyncWebDispatch);
        this._webServer.setAttribute("commoncrawl.server", this);
        if (this.initServer()) {
            LOG.info((Object)(CommonCrawlServer._commonConfig._className + " up at: " + this._serverAddress));
            return true;
        }
        return false;
    }

    public void start() throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                CommonCrawlServer.this.stop();
            }
        }));
        this._eventLoop.start();
        if (this.startDaemons()) {
            super.start();
            this._webServer.start();
        }
    }

    private void join() throws InterruptedException {
        if (this._eventLoop.getEventThread() != null) {
            this._eventLoop.getEventThread().join();
        }
    }

    public void stop() {
        super.stop();
        this.stopDaemons();
        this._eventLoop.stop();
    }

    public static CommonConfig parseCommonConfig(String[] argv) {
        CommonConfig configOut = new CommonConfig();
        if (argv != null) {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equalsIgnoreCase("--server")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._className = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--hostname")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._hostName = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--rpcIntfc")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._rpcInterface = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--httpIntfc")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._webInterface = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--rpcPort")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._rpcPort = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--httpPort")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._webPort = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--conf")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._configName = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--dataDir")) {
                    if (i + 1 >= argv.length) continue;
                    configOut._dataDir = argv[++i];
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--dnsPoolSize")) {
                    configOut._dnsThreadPoolSize = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--detailLogging")) {
                    boolean enabled;
                    _detailLoggingEnabled = enabled = Boolean.parseBoolean(argv[++i]);
                    continue;
                }
                if (!argv[i].equalsIgnoreCase("--dumpAppName")) continue;
                configOut._dumpAppName = true;
            }
        }
        return configOut;
    }

    private static void printCommonUsage() {
        System.err.println("Usage: java CommonCrawlServer --server [server type] --hostname [hostname] --rpcInterface [rpc server interface] --rpcPort [rpc server port] --httpInterface [web server interface] --httpPort [web server port] --dataDir [data directory] --conf [config file] [server args]");
    }

    public static void main(String[] argv) throws Exception {
        block19: {
            try {
                Configuration conf = new Configuration();
                conf.addResource("core-site.xml");
                conf.addResource("mapred-site.xml");
                conf.addResource("hdfs-site.xml");
                _commonConfig = CommonCrawlServer.parseCommonConfig(argv);
                if (CommonCrawlServer._commonConfig._dumpAppName) {
                    if (CommonCrawlServer._commonConfig._className == null) {
                        System.out.println("");
                        return;
                    }
                    try {
                        Class theClass = conf.getClassByName(CommonCrawlServer._commonConfig._className);
                        Object serverInstance = theClass.newInstance();
                        CommonCrawlServer server = (CommonCrawlServer)CommonCrawlServer.class.cast(serverInstance);
                        System.out.println(server.getAppName());
                    }
                    catch (Exception e) {
                        System.err.println("Failed to Instatiate Server with Error:" + CCStringUtils.stringifyException((Throwable)e));
                    }
                    return;
                }
                if (CommonCrawlServer._commonConfig._className == null) {
                    CommonCrawlServer.printCommonUsage();
                    return;
                }
                if (CommonCrawlServer._commonConfig._configName != null) {
                    LOG.info((Object)("Processing Config File:" + CommonCrawlServer._commonConfig._configName));
                    conf.addResource(CommonCrawlServer._commonConfig._configName);
                }
                if (CommonCrawlServer._commonConfig._hostName != null) {
                    conf.set("org.commoncrawl.hostname", CommonCrawlServer._commonConfig._hostName);
                }
                if (CommonCrawlServer._commonConfig._rpcInterface != null) {
                    conf.set("org.commoncrawl.rpcInterface", CommonCrawlServer._commonConfig._rpcInterface);
                }
                if (CommonCrawlServer._commonConfig._webInterface != null) {
                    conf.set("org.commoncrawl.httpInterface", CommonCrawlServer._commonConfig._webInterface);
                }
                if (CommonCrawlServer._commonConfig._rpcPort != -1) {
                    conf.setInt("org.commoncrawl.rpcPort", CommonCrawlServer._commonConfig._rpcPort);
                }
                if (CommonCrawlServer._commonConfig._webPort != -1) {
                    conf.setInt("org.commoncrawl.httpPort", CommonCrawlServer._commonConfig._webPort);
                }
                if (CommonCrawlServer._commonConfig._dataDir != null) {
                    conf.set("org.commoncrawl.dataDir", CommonCrawlServer._commonConfig._dataDir);
                }
                if (CommonCrawlServer._commonConfig._dnsThreadPoolSize != -1) {
                    conf.setInt("org.commoncrawl.dnsThreadPoolSize", CommonCrawlServer._commonConfig._dnsThreadPoolSize);
                }
                LOG.info((Object)("Log File Is:" + System.getProperty("commoncrawl.log.file")));
                LOG.info((Object)("Instantiating Class:" + CommonCrawlServer._commonConfig._className));
                Class theClass = conf.getClassByName(CommonCrawlServer._commonConfig._className);
                Object serverInstance = theClass.newInstance();
                CommonCrawlServer server = (CommonCrawlServer)CommonCrawlServer.class.cast(serverInstance);
                StringUtils.startupShutdownMessage((Class)theClass, (String[])argv, (Log)LOG);
                if (!server.init(argv, conf)) break block19;
                try {
                    try {
                        server.start();
                        server.join();
                    }
                    catch (IOException e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                        throw e;
                    }
                    Object var7_10 = null;
                    server.stopDaemons();
                    server.stop();
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    server.stopDaemons();
                    server.stop();
                    throw throwable;
                }
            }
            catch (Throwable e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public Configuration getConfig() {
        return this._configuration;
    }

    public static String[] getIPs(String strInterface) throws UnknownHostException {
        Pattern pattern = Pattern.compile("([0-9]+).([0-9]+).([0-9]+).([0-9]+)");
        Matcher m = pattern.matcher(strInterface);
        if (m.matches()) {
            LOG.info((Object)("getIPs detected ip address as interface name. returned: " + strInterface));
            return new String[]{strInterface};
        }
        if (strInterface.equalsIgnoreCase("localhost") || strInterface.equalsIgnoreCase("lo")) {
            LOG.info((Object)("getIPs for localhost name:" + strInterface + " returned: 127.0.0.1"));
            return new String[]{"127.0.0.1"};
        }
        try {
            NetworkInterface netIF = NetworkInterface.getByName(strInterface);
            if (netIF == null) {
                return null;
            }
            Vector<String> ips = new Vector<String>();
            Enumeration<InetAddress> e = netIF.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress address = e.nextElement();
                if (address.getAddress().length != 4) continue;
                LOG.info((Object)("getIPs for name:" + strInterface + " found:" + address.getHostAddress()));
                ips.add(address.getHostAddress());
            }
            return ips.toArray(new String[0]);
        }
        catch (SocketException e) {
            return null;
        }
    }

    public void dispatchAsyncWebRequest(AsyncWebServerRequest request) throws IOException {
        request.dispatch(this._eventLoop);
        if (request.getException() != null) {
            throw request.getException();
        }
    }

    static {
        _detailLoggingEnabled = false;
        _serverObject = new ThreadLocal<CommonCrawlServer>(){

            @Override
            protected CommonCrawlServer initialValue() {
                return _serverSingleton;
            }
        };
    }

    protected static final class CommonConfig {
        public String _className;
        public String _hostName;
        public String _rpcInterface;
        public int _rpcPort = -1;
        public String _webInterface;
        public int _webPort = -1;
        public String _configName;
        public String _dataDir = null;
        public int _dnsThreadPoolSize = -1;
        public boolean _dumpAppName = false;

        protected CommonConfig() {
        }
    }
}

