/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.util.shared.CCStringUtils;

public abstract class AsyncWebServerRequest {
    private static final Log LOG = LogFactory.getLog(AsyncWebServerRequest.class);
    final String requestName;
    final Writer writer;
    PrintWriter out = null;
    public IOException exceptionOut = null;

    public AsyncWebServerRequest(String requestName, Writer incomingWriter) {
        this.requestName = requestName;
        this.writer = incomingWriter;
        if (incomingWriter != null) {
            this.out = new PrintWriter(incomingWriter);
        }
    }

    public AsyncWebServerRequest(String requestName) {
        this.requestName = requestName;
        this.out = null;
        this.writer = null;
    }

    public IOException getException() {
        return this.exceptionOut;
    }

    public abstract boolean handleRequest(Semaphore var1) throws IOException;

    public void dispatch(EventLoop eventLoop) {
        final Semaphore waitState = new Semaphore(0);
        eventLoop.setTimer(new Timer(0L, false, new Timer.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timerFired(Timer timer) {
                boolean isClosure = false;
                try {
                    try {
                        isClosure = AsyncWebServerRequest.this.handleRequest(waitState);
                    }
                    catch (IOException exception) {
                        AsyncWebServerRequest.this.exceptionOut = exception;
                        if (AsyncWebServerRequest.this.out != null) {
                            AsyncWebServerRequest.this.out.print("<pre>WebRequest:" + AsyncWebServerRequest.this.requestName + " Failed with exception: " + CCStringUtils.stringifyException((Throwable)exception) + " </pre>");
                        }
                        Object var5_4 = null;
                        if (!isClosure) {
                            waitState.release();
                        }
                    }
                    Object var5_3 = null;
                    if (!isClosure) {
                        waitState.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!isClosure) {
                        waitState.release();
                    }
                    throw throwable;
                }
            }
        }));
        waitState.acquireUninterruptibly();
    }
}

