/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.samples;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.commoncrawl.hadoop.io.ARCInputFormat;
import org.commoncrawl.hadoop.io.ARCResource;
import org.commoncrawl.hadoop.io.ARCSplit;
import org.commoncrawl.protocol.shared.ArcFileItem;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.FileUtils;

public class BasicArcFileReaderSample {
    private static final Log LOG = LogFactory.getLog(BasicArcFileReaderSample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String awsCredentials = args[0];
        String awsSecret = args[1];
        String bucketName = args[2];
        String inputPrefixes = args[3];
        JobConf conf = new JobConf();
        System.out.println("using awsCredentials:" + awsCredentials);
        conf.set("jets3t.arc.source.aws.access.key.id", awsCredentials);
        conf.set("jets3t.arc.source.aws.secret.access.key", awsSecret);
        System.out.println("using bucket:" + bucketName);
        conf.set("jets3t.arc.source.bucket.name", bucketName);
        System.out.println("using input prefixes:" + inputPrefixes);
        conf.set("jets3t.arc.source.input.prefixes.csv", inputPrefixes);
        ARCInputFormat inputFormat = new ARCInputFormat();
        inputFormat.configure(conf);
        File tmpFile = new File("/tmp/ExtractorTest" + System.currentTimeMillis());
        System.out.println("Dumping SequenceFile Output to:" + tmpFile.getAbsolutePath());
        FileUtils.recursivelyDeleteFile(tmpFile);
        tmpFile.mkdir();
        try {
            InputSplit[] splits = inputFormat.getSplits(conf, 0);
            if (splits.length == 0) {
                System.out.println("ERROR: No Arc Files Found!");
                return;
            }
            System.out.println("Found " + splits.length + " InputSplits:");
            for (InputSplit split : splits) {
                Object var22_22;
                System.out.println("Processing Split:" + split.toString());
                ARCResource resource = ((ARCSplit)split).getResources()[0];
                Path arcFileName = new Path(resource.getName());
                Path outputPath = new Path(tmpFile.getAbsolutePath(), arcFileName.getName().substring(0, arcFileName.getName().lastIndexOf(".gz")) + ".seq");
                LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
                System.out.println("Local file will be:" + outputPath);
                SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)localFS, (Configuration)conf, (Path)outputPath, Text.class, ArcFileItem.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                try {
                    RecordReader reader = inputFormat.getRecordReader(split, conf, new Reporter(){

                        public Counters.Counter getCounter(Enum<?> arg0) {
                            return null;
                        }

                        public Counters.Counter getCounter(String arg0, String arg1) {
                            return null;
                        }

                        public InputSplit getInputSplit() throws UnsupportedOperationException {
                            return null;
                        }

                        public void incrCounter(Enum<?> arg0, long arg1) {
                            System.out.println("Incementing:" + arg0.toString());
                        }

                        public void incrCounter(String arg0, String arg1, long arg2) {
                        }

                        public void setStatus(String arg0) {
                        }

                        public void progress() {
                        }
                    });
                    Text url = new Text();
                    ArcFileItem item = new ArcFileItem();
                    while (reader.next((Object)url, (Object)item)) {
                        writer.append((Writable)url, (Writable)item);
                        System.out.println("URL:" + url.toString());
                    }
                    var22_22 = null;
                }
                catch (Throwable throwable) {
                    var22_22 = null;
                    writer.close();
                    throw throwable;
                }
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }
}

