/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.thriftrpc.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RccTask
extends Task {
    private String language = "java";
    private File src;
    private File dest = new File(".");
    private final ArrayList<FileSet> filesets = new ArrayList();
    private boolean failOnError = true;

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setFailonerror(boolean flag) {
        this.failOnError = flag;
    }

    public void setDestdir(File dir) {
        this.dest = dir;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    File getGenStampFile(File baseDir) {
        return new File(baseDir, "thrift-gen.stamp");
    }

    public void execute() throws BuildException {
        System.out.println("Thrif RCC Execute");
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("There must be a file attribute or a fileset child element");
        }
        ArrayList<File> srcList = new ArrayList<File>();
        if (this.src != null) {
            System.out.println("Src is present:" + this.src.getAbsolutePath());
            srcList.add(this.src);
        }
        Project myProject = this.getProject();
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = this.filesets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(myProject);
            File dir = fs.getDir(myProject);
            String[] srcs = ds.getIncludedFiles();
            for (int j = 0; j < srcs.length; ++j) {
                File srcLocation = new File(dir, srcs[j]);
                srcList.add(srcLocation);
            }
        }
        for (File srcLocation : srcList) {
            File genStampFile = this.getGenStampFile(srcLocation.getParentFile());
            if (genStampFile.exists() && srcLocation.lastModified() <= genStampFile.lastModified()) continue;
            System.out.println("src:" + srcLocation.getAbsolutePath());
            this.doCompile(srcLocation);
            genStampFile.delete();
            try {
                genStampFile.createNewFile();
            }
            catch (IOException e) {
                throw new BuildException("Failed to create GenStamp File for src:" + srcLocation);
            }
        }
    }

    private File getDestFileGivenFQN(String fullyQualifiedName) {
        String pathDelimited = fullyQualifiedName.replace(".", "/");
        return new File(this.dest, pathDelimited + ".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile(File file) throws BuildException {
        Pattern namespacePattern = Pattern.compile("namespace\\s+java\\s+(.+)$");
        Pattern servicePattern = Pattern.compile("service\\s+([^\\s{]+).*$");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line = null;
                String namespace = null;
                while ((line = reader.readLine()) != null) {
                    Matcher namespaceMatcher = namespacePattern.matcher(line);
                    Matcher servicePatternMatcher = servicePattern.matcher(line);
                    if (namespaceMatcher.matches()) {
                        namespace = namespaceMatcher.group(1);
                        System.out.println("Namespace is:" + namespace);
                        continue;
                    }
                    if (!servicePatternMatcher.matches()) continue;
                    String service = servicePatternMatcher.group(1);
                    System.out.println("Processing Service :" + service);
                    String fullyQualifiedName = namespace + "." + service;
                    File destFile = this.getDestFileGivenFQN(fullyQualifiedName + "_CCAsyncSupport");
                    destFile.getParentFile().mkdirs();
                    System.out.println("Dest File:" + destFile.getAbsolutePath());
                    PrintWriter writer = new PrintWriter(new FileWriter(destFile));
                    try {
                        RccTask.generateAsyncStub(fullyQualifiedName, writer);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    finally {
                        writer.flush();
                        writer.close();
                    }
                }
            }
            finally {
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public static void generateAsyncStub(String fullyQualifiedServiceName, PrintWriter writer) throws ClassNotFoundException {
        String packageName = fullyQualifiedServiceName.substring(0, fullyQualifiedServiceName.lastIndexOf("."));
        String className = fullyQualifiedServiceName.substring(fullyQualifiedServiceName.lastIndexOf(".") + 1);
        Class<?> zclass = Class.forName(fullyQualifiedServiceName + "$Iface");
        writer.println("package " + packageName + ";");
        writer.println("");
        writer.println("import java.util.List;");
        writer.println("import java.util.ArrayList;");
        writer.println("import java.util.Map;");
        writer.println("import java.util.HashMap;");
        writer.println("import java.util.EnumMap;");
        writer.println("import java.util.Set;");
        writer.println("import java.util.HashSet;");
        writer.println("import java.util.EnumSet;");
        writer.println("import java.util.Collections;");
        writer.println("import java.util.BitSet;");
        writer.println("import java.nio.ByteBuffer;");
        writer.println("import java.util.Arrays;");
        writer.println("import org.slf4j.Logger;");
        writer.println("import org.slf4j.LoggerFactory;");
        writer.println("import java.io.IOException;");
        writer.println("");
        writer.println("import org.commoncrawl.rpc.thriftrpc.*;");
        writer.println("import org.apache.thrift.TException;");
        writer.println("import org.apache.thrift.protocol.TMessage;");
        writer.println("import org.apache.thrift.protocol.TProtocol;");
        writer.println("import org.apache.thrift.transport.TFramedTransport;");
        writer.println("import org.apache.thrift.transport.TIOStreamTransport;");
        writer.println("import org.commoncrawl.io.internal.NIOBufferList;");
        writer.println("import org.commoncrawl.io.internal.NIOBufferListOutputStream;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.*;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.ThriftRPCMessageDispatcher;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.ThriftIncomingMessageContext;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.ThriftOutgoingMessageContext;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.ThriftRPCClientChannel;");
        writer.println("import org.commoncrawl.rpc.thriftrpc.ThriftRPCServerChannel;");
        writer.println("import " + packageName + "." + className + ".*;");
        writer.println("class " + className + "_CCAsyncSupport {");
        writer.println("");
        writer.println("  public static class " + className + "_AsyncCallStub extends ThriftRPCChannel.AsyncStub {");
        writer.println("    public " + className + "_AsyncCallStub(ThriftRPCChannel channel) {");
        writer.println("      super(channel);");
        writer.println("    }");
        writer.println("");
        Class<?> blockingIFaceClass = Class.forName(fullyQualifiedServiceName + "$Iface");
        for (Method m : blockingIFaceClass.getMethods()) {
            String argsName = m.getName() + "_args";
            String resultName = m.getName() + "_result";
            Class<?> argsClass = Class.forName(fullyQualifiedServiceName + "$" + argsName);
            Map metadataMap = FieldMetaData.getStructMetaDataMap(argsClass);
            writer.print("    public void " + m.getName() + "(");
            int fieldIndex = 0;
            for (TFieldIdEnum field : metadataMap.keySet()) {
                if (fieldIndex++ != 0) {
                    writer.print(",");
                }
                try {
                    writer.print(argsClass.getField(field.getFieldName()).getType().getName() + " " + field.getFieldName());
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            writer.println(",final ThriftOutgoingMessageContext.ThriftAsyncRequestCallback<" + argsName + "," + resultName + "> resultHandler) throws org.apache.thrift.TException {");
            writer.println("      " + argsName + " args = new " + argsName + "();");
            for (TFieldIdEnum field : metadataMap.keySet()) {
                try {
                    writer.println("      args." + field.getFieldName() + " = " + field.getFieldName() + ";");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            writer.println("      " + resultName + " result = new " + resultName + "();");
            writer.println("      ThriftOutgoingMessageContext<" + argsName + "," + resultName + "> asyncCallContext = " + "new ThriftOutgoingMessageContext<" + argsName + "," + resultName + ">(super.getChannel(),resultHandler,\"" + m.getName() + "\",args,result);");
            writer.println("      super.getChannel().sendRequest(asyncCallContext);");
            writer.println("    }");
        }
        writer.println("  }");
        String baseInterfaceName = className + "_AsyncIFace";
        writer.println("  public static interface " + baseInterfaceName + "{ ");
        for (Method method : zclass.getMethods()) {
            String inputType = method.getName() + "_args";
            String outputType = method.getName() + "_result";
            writer.println("    public void " + className + "_" + method.getName() + " (final ThriftIncomingMessageContext<" + inputType + "," + outputType + "> context) throws TException;");
        }
        writer.println("  }");
        String processClassName = className + "_RequestProcessor";
        writer.println("  public static class " + processClassName + " implements ThriftRPCMessageDispatcher { ");
        writer.println("    " + baseInterfaceName + " _iface;");
        writer.println("    " + processClassName + "(" + baseInterfaceName + " iface){");
        writer.println("      _iface = iface;");
        writer.println("    }");
        writer.println("");
        writer.println("   public void process(ThriftRPCServerChannel serverChannel,ThriftRPCClientChannel clientChannel,TMessage message,TProtocol iprot)throws TException {");
        for (Method method : zclass.getMethods()) {
            String inputType = method.getName() + "_args";
            String outputType = method.getName() + "_result";
            writer.println("    if (message.name.equals(\"" + method.getName() + "\")){");
            writer.println("      " + inputType + " input = new " + inputType + "();");
            writer.println("      " + outputType + " output = new " + outputType + "();");
            writer.println("      input.read(iprot);");
            writer.println("      iprot.readMessageEnd();");
            writer.println("      ThriftIncomingMessageContext<" + inputType + "," + outputType + "> context = new ThriftIncomingMessageContext<" + inputType + "," + outputType + ">" + "(serverChannel,clientChannel,message,iprot,input,output);");
            writer.println("      _iface." + className + "_" + method.getName() + "(context);");
            writer.println("      return;");
            writer.println("    }");
        }
        writer.println("    org.apache.thrift.protocol.TProtocolUtil.skip(iprot, org.apache.thrift.protocol.TType.STRUCT);");
        writer.println("    iprot.readMessageEnd();");
        writer.println("    NIOBufferList bufferListTemp = new NIOBufferList();");
        writer.println("    TProtocol oprot = clientChannel.getOutputProtocolFactory().getProtocol(new TFramedTransport(new TIOStreamTransport(new NIOBufferListOutputStream(bufferListTemp))));");
        writer.println("    org.apache.thrift.TApplicationException x = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.UNKNOWN_METHOD, \"Invalid method name: '+message.name+'\");");
        writer.println("    oprot.writeMessageBegin(new org.apache.thrift.protocol.TMessage(message.name, org.apache.thrift.protocol.TMessageType.EXCEPTION, message.seqid));");
        writer.println("    x.write(oprot);");
        writer.println("    oprot.writeMessageEnd();");
        writer.println("    oprot.getTransport().flush();");
        writer.println("    try {");
        writer.println("      clientChannel.responseReady(bufferListTemp);");
        writer.println("    } catch (IOException e) {");
        writer.println("      throw new TException(e);");
        writer.println("    }");
        writer.println("    }");
        writer.println("");
        writer.println("  }");
        writer.println("");
        writer.println("}");
    }
}

