/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.thriftrpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOServerSocketListener;
import org.commoncrawl.io.internal.NIOServerTCPSocket;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.rpc.thriftrpc.ThriftRPCClientChannel;
import org.commoncrawl.rpc.thriftrpc.ThriftRPCMessageDispatcher;
import org.commoncrawl.util.shared.CCStringUtils;

public class ThriftRPCServerChannel
implements NIOServerSocketListener {
    public static final Log LOG = LogFactory.getLog(ThriftRPCServerChannel.class);
    final long MAX_READ_BUFFER_BYTES;
    long readBufferBytesAllocated = 0L;
    final ThriftRPCMessageDispatcher processor;
    final TProtocolFactory inputProtocolFactory = new TBinaryProtocol.Factory();
    final TProtocolFactory outputProtocolFactory = new TBinaryProtocol.Factory();
    EventLoop eventLoop;
    boolean isServing = false;
    NIOServerTCPSocket _socket;
    InetSocketAddress _address;
    int _reconnectDelay = 0;
    Timer _reconnectTimer = null;
    private static int INITIAL_RECONNECT_DELAY = 1000;
    State _state = State.CLOSED;

    public ThriftRPCServerChannel(EventLoop eventLoop, InetSocketAddress bindAddress, ThriftRPCMessageDispatcher processor, long max_read_buffer_size) {
        this.MAX_READ_BUFFER_BYTES = max_read_buffer_size;
        this._address = bindAddress;
        this.processor = processor;
        this.eventLoop = eventLoop;
    }

    public void open() throws IOException {
        if (this._state == State.CLOSED) {
            this.rebind();
        }
    }

    public void close() {
        if (this._state != State.CLOSED) {
            this.release();
        }
    }

    void rebind() throws IOException {
        this.release();
        if (this._reconnectDelay == 0) {
            this._reconnectDelay = INITIAL_RECONNECT_DELAY;
            this.bind();
        } else {
            this._reconnectTimer = new Timer(this._reconnectDelay, false, new Timer.Callback(){

                public void timerFired(Timer timer) {
                    try {
                        ThriftRPCServerChannel.this.bind();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            ThriftRPCServerChannel.this.rebind();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.eventLoop.setTimer(this._reconnectTimer);
        }
    }

    void bind() throws IOException {
        this._reconnectDelay *= 2;
        this._reconnectTimer = null;
        if (this._socket == null) {
            this._socket = new NIOServerTCPSocket(this);
            this._socket.open(this._address);
            this.eventLoop.getSelector().registerForAccept(this._socket);
            this._state = State.OPEN_CONNECTED;
        }
    }

    void release() {
        if (this._reconnectTimer != null) {
            this.eventLoop.cancelTimer(this._reconnectTimer);
            this._reconnectTimer = null;
        }
        if (this._socket != null) {
            this.eventLoop.getSelector().cancelRegistration(this._socket);
            this._socket.close();
            this._socket = null;
        }
        this._state = State.CLOSED;
    }

    protected boolean requestInvoke(ThriftRPCClientChannel channel) throws TException {
        channel.invoke();
        channel.prepareRead();
        return true;
    }

    protected void requestSelectInterestChange(final ThriftRPCClientChannel buffer) {
        this.eventLoop.setTimer(new Timer(0L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                buffer.changeSelectInterests();
            }
        }));
    }

    private void cleanupSelectionkey(SelectionKey key) {
        ThriftRPCClientChannel buffer = (ThriftRPCClientChannel)key.attachment();
        if (buffer != null) {
            buffer.close();
        }
        key.cancel();
    }

    public void Accepted(NIOClientSocket theSocket) throws IOException {
        block5: {
            SelectionKey clientKey = null;
            TNonblockingSocket client = null;
            try {
                client = new TNonblockingSocket((SocketChannel)theSocket.getChannel());
                try {
                    clientKey = client.registerSelector(this.eventLoop.getSelector().getSelector(), 1);
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    throw new TTransportException((Throwable)e);
                }
                ThriftRPCClientChannel frameBuffer = new ThriftRPCClientChannel(this, this, (TNonblockingTransport)client, clientKey);
                clientKey.attach(frameBuffer);
            }
            catch (TTransportException tte) {
                LOG.warn((Object)"Exception trying to accept!", (Throwable)tte);
                tte.printStackTrace();
                if (clientKey != null) {
                    this.cleanupSelectionkey(clientKey);
                }
                if (client == null) break block5;
                client.close();
            }
        }
    }

    public void Disconnected(NIOSocket theSocket, Exception optionalException) throws IOException {
    }

    public void Excepted(NIOSocket socket, Exception e) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OPEN,
        OPEN_CONNECTED,
        CLOSED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractNonblockingServerArgs<T extends AbstractNonblockingServerArgs<T>>
    extends TServer.AbstractServerArgs<T> {
        public long maxReadBufferBytes = Long.MAX_VALUE;

        public AbstractNonblockingServerArgs(TNonblockingServerTransport transport) {
            super((TServerTransport)transport);
            this.transportFactory((TTransportFactory)new TFramedTransport.Factory());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends AbstractNonblockingServerArgs<Args> {
        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }
    }
}

