/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.thriftrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.rpc.thriftrpc.ThriftRPCServerChannel;
import org.commoncrawl.util.shared.CCStringUtils;

class ThriftRPCClientChannel
implements NIOClientSocketListener {
    private static final int READING_FRAME_SIZE = 1;
    private static final int READING_FRAME = 2;
    private static final int READ_FRAME_COMPLETE = 3;
    public final TNonblockingTransport trans_;
    private final SelectionKey selectionKey_;
    private int state_ = 1;
    private ByteBuffer inputBuffer_;
    NIOBufferList outputBuffer_ = new NIOBufferList();
    private TByteArrayOutputStream response_;
    ThriftRPCServerChannel serverChannel_;

    public ThriftRPCClientChannel(ThriftRPCServerChannel serverChannel_, ThriftRPCServerChannel serverChannel, TNonblockingTransport trans, SelectionKey selectionKey) {
        this.serverChannel_ = serverChannel_;
        serverChannel_ = serverChannel;
        this.trans_ = trans;
        this.selectionKey_ = selectionKey;
        this.inputBuffer_ = ByteBuffer.allocate(4);
    }

    TProtocolFactory getInputProtocolFactory() {
        return this.serverChannel_.inputProtocolFactory;
    }

    TProtocolFactory getOutputProtocolFactory() {
        return this.serverChannel_.outputProtocolFactory;
    }

    public boolean read() {
        if (this.state_ == 1) {
            if (!this.internalRead()) {
                return false;
            }
            if (this.inputBuffer_.remaining() == 0) {
                int frameSize = this.inputBuffer_.getInt(0);
                if (frameSize <= 0) {
                    ThriftRPCServerChannel.LOG.error((Object)("Read an invalid frame size of " + frameSize + ". Are you using TFramedTransport on the client side?"));
                    return false;
                }
                if ((long)frameSize > this.serverChannel_.MAX_READ_BUFFER_BYTES) {
                    ThriftRPCServerChannel.LOG.error((Object)("Read a frame size of " + frameSize + ", which is bigger than the maximum allowable buffer size for ALL connections."));
                    return false;
                }
                if (this.serverChannel_.readBufferBytesAllocated + (long)frameSize > this.serverChannel_.MAX_READ_BUFFER_BYTES) {
                    return true;
                }
                this.serverChannel_.readBufferBytesAllocated += (long)frameSize;
                this.inputBuffer_ = ByteBuffer.allocate(frameSize);
                this.state_ = 2;
            } else {
                return true;
            }
        }
        if (this.state_ == 2) {
            if (!this.internalRead()) {
                return false;
            }
            if (this.inputBuffer_.remaining() == 0) {
                this.selectionKey_.interestOps(0);
                this.state_ = 3;
            }
            return true;
        }
        ThriftRPCServerChannel.LOG.error((Object)("Read was called but state is invalid (" + this.state_ + ")"));
        return false;
    }

    public boolean write() {
        if (this.outputBuffer_.available() != 0) {
            try {
                while (this.outputBuffer_.available() != 0) {
                    ByteBuffer bufferToWrite = this.outputBuffer_.read();
                    if (this.trans_.write(bufferToWrite) < 0) {
                        return false;
                    }
                    if (bufferToWrite.remaining() == 0) continue;
                    this.outputBuffer_.putBack(bufferToWrite);
                    break;
                }
            }
            catch (IOException e) {
                ThriftRPCServerChannel.LOG.warn((Object)"Got an IOException during write!", (Throwable)e);
                return false;
            }
            if (this.outputBuffer_.available() == 0) {
                this.changeSelectInterests();
            }
            return true;
        }
        ThriftRPCServerChannel.LOG.error((Object)("Write was called, but state is invalid (" + this.state_ + ")"));
        return false;
    }

    public void changeSelectInterests() {
        if (this.outputBuffer_.available() != 0) {
            this.selectionKey_.interestOps(5);
        } else {
            this.selectionKey_.interestOps(1);
        }
    }

    public void close() {
        if (this.state_ == 2 || this.state_ == 3) {
            this.serverChannel_.readBufferBytesAllocated -= (long)this.inputBuffer_.array().length;
        }
        this.trans_.close();
    }

    public boolean isFrameFullyRead() {
        return this.state_ == 3;
    }

    public synchronized void responseReady(NIOBufferList responseData) throws IOException {
        try {
            ByteBuffer bufferToTransfer = null;
            while ((bufferToTransfer = responseData.read()) != null) {
                bufferToTransfer.position(bufferToTransfer.limit());
                this.outputBuffer_.write(bufferToTransfer);
            }
            this.outputBuffer_.flush();
            this.requestSelectInterestChange();
        }
        catch (IOException e) {
            ThriftRPCServerChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            this.close();
            throw e;
        }
    }

    public void invoke() throws TException {
        TProtocol inProt = this.serverChannel_.inputProtocolFactory.getProtocol((TTransport)new TMemoryInputTransport(this.inputBuffer_.array()));
        TMessage msg = inProt.readMessageBegin();
        this.serverChannel_.processor.process(this.serverChannel_, this, msg, inProt);
    }

    private TTransport getOutputTransport() {
        this.response_ = new TByteArrayOutputStream();
        return new TFramedTransport((TTransport)new TIOStreamTransport((OutputStream)this.response_));
    }

    private boolean internalRead() {
        try {
            return this.trans_.read(this.inputBuffer_) >= 0;
        }
        catch (IOException e) {
            ThriftRPCServerChannel.LOG.warn((Object)"Got an IOException in internalRead!", (Throwable)e);
            return false;
        }
    }

    void prepareRead() {
        this.inputBuffer_ = ByteBuffer.allocate(4);
        this.state_ = 1;
    }

    private void requestSelectInterestChange() {
        if (Thread.currentThread() == this.serverChannel_.eventLoop.getEventThread()) {
            this.changeSelectInterests();
        } else {
            this.serverChannel_.requestSelectInterestChange(this);
        }
    }

    public void Connected(NIOClientSocket theSocket) throws IOException {
    }

    public int Readable(NIOClientSocket theSocket) throws IOException {
        if (!this.read()) {
            return -1;
        }
        if (this.isFrameFullyRead()) {
            try {
                if (!this.serverChannel_.requestInvoke(this)) {
                    return -1;
                }
            }
            catch (TException e) {
                ThriftRPCServerChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                return -1;
            }
        }
        return 0;
    }

    public void Writeable(NIOClientSocket theSocket) throws IOException {
        if (!this.write()) {
            this.close();
        }
    }

    public void Disconnected(NIOSocket theSocket, Exception optionalException) throws IOException {
        this.close();
    }

    public void Excepted(NIOSocket socket, Exception e) {
        ThriftRPCServerChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        this.close();
    }
}

