/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.thriftrpc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListInputStream;
import org.commoncrawl.io.internal.NIOBufferListOutputStream;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIOClientTCPSocket;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.rpc.RPCChannel;
import org.commoncrawl.rpc.RPCServerChannel;
import org.commoncrawl.rpc.thriftrpc.ThriftOutgoingMessageContext;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThriftRPCChannel
implements NIOClientSocketListener,
Comparable<ThriftRPCChannel> {
    private static long _lastChannelId = 0L;
    private long _channelId = 0L;
    public static final Log LOG = LogFactory.getLog(ThriftRPCChannel.class);
    private static int INITIAL_RECONNECT_DELAY = 1000;
    private static int MAX_RECONNECT_DELAY = 5000;
    private EventLoop _eventLoop;
    private int _lastRequestId = 0;
    private Map<Integer, ThriftOutgoingMessageContext<TBase, TBase>> _requestMap = Collections.synchronizedMap(new HashMap());
    private LinkedList<ThriftOutgoingMessageContext<TBase, TBase>> _deferredSendQueue = new LinkedList();
    private boolean _isOpen = false;
    private boolean _isOnline = false;
    private InetSocketAddress _localAddress;
    private InetSocketAddress _address;
    private NIOClientSocket _socket;
    private int _reconnectDelay = 0;
    private Timer _reconnectTimer;
    private NIOBufferList _output = new NIOBufferList();
    private NIOBufferList _input = new NIOBufferList();
    private NIOBufferListInputStream _inputStream = new NIOBufferListInputStream(this._input);
    private DataInputStream _dataInputStream = new DataInputStream(this._inputStream);
    private NIOBufferListOutputStream _outputStream = new NIOBufferListOutputStream(this._output);
    private TProtocolFactory _outputProtocolFactory;
    private TProtocol _inputProtocol;
    private TProtocol _outputProtocol;
    RPCServerChannel _serverChannel = null;
    ConnectionCallback _connectionCallback;
    private static final int READING_FRAME_SIZE = 1;
    private static final int READING_FRAME = 2;
    private int _readState = 1;
    private int _frameSize = 0;
    ByteBuffer readBufferDirect = ByteBuffer.allocateDirect(32384);
    ByteBuffer writeBufferDirect = ByteBuffer.allocateDirect(32384);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThriftRPCChannel(EventLoop client, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, InetSocketAddress localAddress, InetSocketAddress address, ConnectionCallback callback) throws IOException {
        this._inputProtocol = inputProtocolFactory.getProtocol((TTransport)new TIOStreamTransport((InputStream)this._inputStream));
        this._outputProtocolFactory = outputProtocolFactory;
        this._outputProtocol = this.createOutputProtocol();
        Class<RPCChannel> clazz = RPCChannel.class;
        synchronized (RPCChannel.class) {
            this._channelId = ++_lastChannelId;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this._eventLoop = client;
            this._address = address;
            this._localAddress = localAddress;
            this._connectionCallback = callback;
            return;
        }
    }

    private TProtocol createOutputProtocol() {
        return this._outputProtocolFactory.getProtocol((TTransport)new TFramedTransport((TTransport)new TIOStreamTransport((OutputStream)this._outputStream)));
    }

    public synchronized void open() throws IOException {
        if (this._isOpen) {
            LOG.error((Object)"open called on already open channel");
            throw new IOException("Channel Alread Open");
        }
        this._isOpen = true;
        this.reconnect();
    }

    public synchronized void close() throws IOException {
        if (this._isOpen) {
            this._isOpen = false;
            this.disconnect(this._isOnline);
        }
    }

    public String toString() {
        if (this._address != null) {
            return "RPCChannel(" + this._address.toString() + ")";
        }
        return "Uninitialized ClientRPCChannel";
    }

    public synchronized boolean isOpen() {
        return this._isOpen;
    }

    public synchronized void reconnect() throws IOException {
        this.disconnect(this._isOnline);
        if (this._reconnectDelay == 0) {
            this._reconnectDelay = INITIAL_RECONNECT_DELAY;
            this.connect();
        } else {
            this._reconnectTimer = new Timer(this._reconnectDelay, false, new Timer.Callback(){

                public void timerFired(Timer timer) {
                    try {
                        ThriftRPCChannel.this.connect();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOG.error((Object)("Reconnect threw exception:" + e.toString()));
                    }
                }
            });
            this._eventLoop.setTimer(this._reconnectTimer);
        }
        this._reconnectDelay = Math.min(MAX_RECONNECT_DELAY, this._reconnectDelay * 2);
    }

    private synchronized void connect() throws IOException {
        this._reconnectTimer = null;
        this._socket = new NIOClientTCPSocket(this._localAddress, this);
        this._socket.connect(this._address);
        this.getEventLoop().getSelector().registerForConnect(this._socket);
    }

    private synchronized void disconnect(boolean generateEvent) {
        if (this._reconnectTimer != null) {
            this._eventLoop.cancelTimer(this._reconnectTimer);
            this._reconnectTimer = null;
        }
        if (this._socket != null) {
            this._eventLoop.getSelector().cancelRegistration(this._socket);
            this._socket.close();
            this._socket = null;
        }
        this._output.reset();
        this._input.reset();
        this._inputStream.reset();
        this._output.reset();
        this._outputStream.reset();
        this._outputProtocol = this.createOutputProtocol();
        this._readState = 1;
        this._frameSize = 0;
        this._isOnline = false;
        if (generateEvent) {
            this.cancelOutgoingMessages();
            if (this._connectionCallback != null) {
                this._connectionCallback.OutgoingChannelDisconnected(this);
            }
        }
    }

    RPCServerChannel getServerChannel() {
        return this._serverChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendRequest(final ThriftOutgoingMessageContext request) {
        if (Thread.currentThread() != this.getEventLoop().getEventThread()) {
            this.getEventLoop().queueAsyncRunnable(new Runnable(){

                public void run() {
                    ThriftRPCChannel.this.sendRequest(request);
                }
            });
        } else {
            int requestId = 0;
            try {
                ThriftRPCChannel thriftRPCChannel = this;
                synchronized (thriftRPCChannel) {
                    requestId = ++this._lastRequestId;
                }
                request.setRequestId(requestId);
                try {
                    if (this._isOnline) {
                        this.encodeRequest(request);
                        this._requestMap.put(requestId, request);
                    } else {
                        this._deferredSendQueue.add(request);
                    }
                }
                catch (TException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    request.getCallback().onError(request, (Exception)((Object)e));
                }
                if (this._socket != null && this._socket.isOpen()) {
                    this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
                }
            }
            catch (IOException e) {
                this._requestMap.remove(requestId);
                this._deferredSendQueue.remove(request);
                LOG.error((Object)("IOException during sendRequest:" + e.toString()));
                request.getCallback().onError(request, e);
            }
        }
    }

    private void encodeRequest(ThriftOutgoingMessageContext<TBase, TBase> request) throws TException {
        this._outputProtocol.writeMessageBegin(new TMessage(request.getMethodName(), 1, request.getRequestId()));
        request.getInputArgs().write(this._outputProtocol);
        this._outputProtocol.writeMessageEnd();
        this._outputProtocol.getTransport().flush();
    }

    public EventLoop getEventLoop() {
        return this._eventLoop;
    }

    @Override
    public synchronized void Connected(NIOClientSocket theSocket) throws IOException {
        this._isOnline = true;
        this._reconnectDelay = INITIAL_RECONNECT_DELAY;
        this._requestMap.clear();
        if (this._deferredSendQueue.size() != 0) {
            LinkedList<ThriftOutgoingMessageContext<TBase, TBase>> temp = this._deferredSendQueue;
            this._deferredSendQueue = new LinkedList();
            for (ThriftOutgoingMessageContext thriftOutgoingMessageContext : temp) {
                this.sendRequest(thriftOutgoingMessageContext);
            }
            this.getEventLoop().getSelector().registerForWrite(this._socket);
        }
        if (this._connectionCallback != null) {
            this._connectionCallback.OutgoingChannelConnected(this);
        }
    }

    @Override
    public synchronized void Disconnected(NIOSocket theSocket, Exception disconnectReason) throws IOException {
        this._isOnline = false;
        this.cancelOutgoingMessages();
        if (this._connectionCallback != null) {
            this._connectionCallback.OutgoingChannelDisconnected(this);
        }
        if (this.isOpen()) {
            this.reconnect();
        }
    }

    private synchronized void cancelOutgoingMessages() {
        LinkedList<ThriftOutgoingMessageContext<TBase, TBase>> tempList = new LinkedList<ThriftOutgoingMessageContext<TBase, TBase>>();
        tempList.addAll(this._requestMap.values());
        this._requestMap.clear();
        for (ThriftOutgoingMessageContext thriftOutgoingMessageContext : tempList) {
            thriftOutgoingMessageContext.getCallback().onError(thriftOutgoingMessageContext, (Exception)((Object)new TException("Request Cancelled")));
        }
    }

    @Override
    public synchronized int Readable(NIOClientSocket theSocket) throws IOException {
        if (!this._socket.isOpen()) {
            LOG.warn((Object)"Readable callback called on closed socket");
            return -1;
        }
        int totalBytesRead = 0;
        try {
            int singleReadAmount = 0;
            do {
                ByteBuffer buffer;
                if ((singleReadAmount = this._socket.read(buffer = this._input.getWriteBuf())) <= 0) continue;
                this._input.write(buffer);
                totalBytesRead += singleReadAmount;
            } while (singleReadAmount > 0);
            if (totalBytesRead != 0) {
                this._input.flush();
            }
            this.readResponseFrames();
            if (this._output.isDataAvailable()) {
                this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
            } else if (this._deferredSendQueue.size() != 0) {
                this.getEventLoop().getSelector().registerForRead(this._socket);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException in Readable callback:" + CCStringUtils.stringifyException((Throwable)e)));
            e.printStackTrace();
            this.reconnect();
        }
        return totalBytesRead == 0 ? -1 : totalBytesRead;
    }

    @Override
    public synchronized void Writeable(NIOClientSocket theSocket) throws IOException {
        if (!this._socket.isOpen()) {
            LOG.warn((Object)"Writeable callback called on closed socket");
            return;
        }
        int amountWritten = 0;
        try {
            do {
                amountWritten = 0;
                ByteBuffer bufferToWrite = this._output.read();
                if (bufferToWrite == null) continue;
                amountWritten = this._socket.write(bufferToWrite);
                if (bufferToWrite.remaining() <= 0) continue;
                this._output.putBack(bufferToWrite);
                break;
            } while (amountWritten > 0);
            if (this._output.isDataAvailable()) {
                this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
            } else if (this._deferredSendQueue.size() != 0) {
                this.getEventLoop().getSelector().registerForRead(this._socket);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException in Writeable callback:" + e.toString()));
            this.reconnect();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void readResponseFrames() throws IOException {
        while (this._inputStream.available() != 0) {
            switch (this._readState) {
                case 1: {
                    if (this._inputStream.available() < 4) break;
                    this._frameSize = this._dataInputStream.readInt();
                    this._readState = 2;
                    break;
                }
                case 2: {
                    if (this._inputStream.available() < this._frameSize) break;
                    bytesOriginallyAvailable = this._inputStream.available();
                    try {
                        message = this._inputProtocol.readMessageBegin();
                        associatedRequest = this._requestMap.get(message.seqid);
                        if (associatedRequest == null) ** GOTO lbl23
                        this._requestMap.remove(message.seqid);
                        this._deferredSendQueue.remove(associatedRequest);
                        associatedRequest.getResultArgs().read(this._inputProtocol);
                        associatedRequest.getCallback().onComplete(associatedRequest);
lbl23:
                        // 2 sources

                        var5_5 = null;
                    }
                    catch (Throwable var4_8) {
                        var5_5 = null;
                        bytesRead = bytesOriginallyAvailable - this._inputStream.available();
                        bytesToSkip = this._frameSize - bytesRead;
                        if (bytesToSkip != 0) {
                            ThriftRPCChannel.LOG.error((Object)("Skipping Extra Bytes(" + bytesToSkip + ")!!"));
                            this._inputStream.skip(bytesToSkip);
                        }
                        this._frameSize = 0;
                        this._readState = 1;
                        throw var4_8;
                    }
                    bytesRead = bytesOriginallyAvailable - this._inputStream.available();
                    bytesToSkip = this._frameSize - bytesRead;
                    if (bytesToSkip != 0) {
                        ThriftRPCChannel.LOG.error((Object)("Skipping Extra Bytes(" + bytesToSkip + ")!!"));
                        this._inputStream.skip(bytesToSkip);
                    }
                    this._frameSize = 0;
                    this._readState = 1;
                    break;
                    {
                        catch (TException e) {
                            ThriftRPCChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                            throw new IOException(e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public synchronized void Excepted(NIOSocket socket, Exception e) {
        LOG.error((Object)("Runtime Error on Socket:" + StringUtils.stringifyException((Throwable)e)));
        try {
            this.Disconnected(socket, e);
        }
        catch (IOException e2) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
        }
    }

    @Override
    public int compareTo(ThriftRPCChannel o) {
        long comparisonResult = this._channelId - o._channelId;
        return comparisonResult < 0L ? -1 : (comparisonResult > 0L ? 1 : 0);
    }

    public static interface ConnectionCallback {
        public void OutgoingChannelConnected(ThriftRPCChannel var1);

        public void OutgoingChannelDisconnected(ThriftRPCChannel var1);
    }

    public static class AsyncStub {
        private ThriftRPCChannel _channel;

        public AsyncStub(ThriftRPCChannel channel) {
            this._channel = channel;
        }

        public ThriftRPCChannel getChannel() {
            return this._channel;
        }
    }
}

