/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.thriftrpc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListOutputStream;
import org.commoncrawl.rpc.thriftrpc.ThriftRPCClientChannel;
import org.commoncrawl.rpc.thriftrpc.ThriftRPCServerChannel;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThriftIncomingMessageContext<InputArgs extends TBase, OutputArgs extends TBase> {
    TProtocol iprot;
    TProtocol oprot;
    NIOBufferList responseBuffer = new NIOBufferList();
    TMessage msg = null;
    InputArgs inputArgs;
    OutputArgs outputArgs;
    ThriftRPCServerChannel serverChannel;
    ThriftRPCClientChannel clientChannel;

    public ThriftIncomingMessageContext(ThriftRPCServerChannel serverChannel, ThriftRPCClientChannel channel, TMessage message, TProtocol inputProtocol, InputArgs inputArgs, OutputArgs outputArgs) throws TException {
        this.serverChannel = serverChannel;
        this.clientChannel = channel;
        this.iprot = inputProtocol;
        this.msg = message;
        this.inputArgs = inputArgs;
        this.outputArgs = outputArgs;
        this.oprot = channel.getOutputProtocolFactory().getProtocol((TTransport)new TFramedTransport((TTransport)new TIOStreamTransport((OutputStream)new NIOBufferListOutputStream(this.responseBuffer))));
        this.oprot.writeMessageBegin(new TMessage(this.msg.name, 2, this.msg.seqid));
    }

    public InputArgs getInput() {
        return this.inputArgs;
    }

    public OutputArgs getOutput() {
        return this.outputArgs;
    }

    public ThriftRPCServerChannel getServerChannel() {
        return this.serverChannel;
    }

    public ThriftRPCClientChannel getClientChannel() {
        return this.clientChannel;
    }

    public void completeRequest() throws TException {
        this.outputArgs.write(this.oprot);
        this.oprot.writeMessageEnd();
        this.oprot.getTransport().flush();
        try {
            this.clientChannel.responseReady(this.responseBuffer);
        }
        catch (IOException e) {
            ThriftRPCServerChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            this.clientChannel.close();
            throw new TException((Throwable)e);
        }
    }

    public void failRequest(Exception e) throws TException {
        TApplicationException x = new TApplicationException(7, e.getMessage());
        this.oprot.writeMessageBegin(new TMessage(this.msg.name, 3, this.msg.seqid));
        x.write(this.oprot);
        this.oprot.writeMessageEnd();
        this.oprot.getTransport().flush();
        try {
            this.clientChannel.responseReady(this.responseBuffer);
        }
        catch (IOException e1) {
            ThriftRPCServerChannel.LOG.error((Object)CCStringUtils.stringifyException((Throwable)e1));
            this.clientChannel.close();
            throw new TException((Throwable)e1);
        }
    }
}

