/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler.generated;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.commoncrawl.rpc.compiler.JBoolean;
import org.commoncrawl.rpc.compiler.JBuffer;
import org.commoncrawl.rpc.compiler.JByte;
import org.commoncrawl.rpc.compiler.JComparator;
import org.commoncrawl.rpc.compiler.JDouble;
import org.commoncrawl.rpc.compiler.JEnum;
import org.commoncrawl.rpc.compiler.JEnumValue;
import org.commoncrawl.rpc.compiler.JField;
import org.commoncrawl.rpc.compiler.JFile;
import org.commoncrawl.rpc.compiler.JFloat;
import org.commoncrawl.rpc.compiler.JInt;
import org.commoncrawl.rpc.compiler.JLong;
import org.commoncrawl.rpc.compiler.JMap;
import org.commoncrawl.rpc.compiler.JMethod;
import org.commoncrawl.rpc.compiler.JModule;
import org.commoncrawl.rpc.compiler.JRecord;
import org.commoncrawl.rpc.compiler.JService;
import org.commoncrawl.rpc.compiler.JString;
import org.commoncrawl.rpc.compiler.JType;
import org.commoncrawl.rpc.compiler.JVector;
import org.commoncrawl.rpc.compiler.generated.ParseException;
import org.commoncrawl.rpc.compiler.generated.RPCCompilerConstants;
import org.commoncrawl.rpc.compiler.generated.RPCCompilerTokenManager;
import org.commoncrawl.rpc.compiler.generated.SimpleCharStream;
import org.commoncrawl.rpc.compiler.generated.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCCompiler
implements RPCCompilerConstants {
    private static String language = "java";
    private static String destDir = ".";
    private static ArrayList<String> recFiles = new ArrayList();
    private static ArrayList<String> cmdargs = new ArrayList();
    private static JFile curFile;
    private static Hashtable<String, JRecord> recTab;
    private static Hashtable<String, JService> serviceTable;
    private static String curMethod;
    private static String curService;
    private static String curParamType;
    private static String curDir;
    private static String curFileName;
    private static String curModuleName;
    public RPCCompilerTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) {
        System.exit(RPCCompiler.driver(args));
    }

    public static void usage() {
        System.err.println("Usage: RPCCompiler --language [java] ddl-files");
    }

    public static int driver(String[] args) {
        int i;
        for (i = 0; i < args.length; ++i) {
            if ("-l".equalsIgnoreCase(args[i]) || "--language".equalsIgnoreCase(args[i])) {
                language = args[i + 1].toLowerCase();
                ++i;
                continue;
            }
            if ("-d".equalsIgnoreCase(args[i]) || "--destdir".equalsIgnoreCase(args[i])) {
                destDir = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                String arg = args[i].substring(1);
                if (arg.startsWith("-")) {
                    arg = arg.substring(1);
                }
                cmdargs.add(arg.toLowerCase());
                continue;
            }
            recFiles.add(args[i]);
        }
        if (recFiles.size() == 0) {
            RPCCompiler.usage();
            return 1;
        }
        for (i = 0; i < recFiles.size(); ++i) {
            curFileName = recFiles.get(i);
            File file = new File(curFileName);
            curDir = file.getParent();
            System.out.println("\n****PARSING FILE:" + file.toString() + "\n");
            try {
                FileReader reader = new FileReader(file);
                RPCCompiler parser = new RPCCompiler(reader);
                try {
                    recTab = new Hashtable();
                    curFile = parser.Input();
                }
                catch (ParseException e) {
                    System.err.println(e.toString());
                    return 1;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + recFiles.get(i) + " Not found.");
                return 1;
            }
            try {
                int retCode = curFile.genCode(language, destDir, cmdargs);
                if (retCode == 0) continue;
                return retCode;
            }
            catch (IOException e) {
                System.err.println(e.toString());
                return 1;
            }
        }
        return 0;
    }

    public final JFile Input() throws ParseException {
        ArrayList<JFile> ilist = new ArrayList<JFile>();
        ArrayList<JRecord> rlist = new ArrayList<JRecord>();
        ArrayList<JService> serviceList = new ArrayList<JService>();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    JFile i = this.Include();
                    ilist.add(i);
                    break;
                }
                case 11: {
                    JModule module = this.Module();
                    rlist.addAll(module.getRecords());
                    serviceList.addAll(module.getServices());
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 19: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(0);
        return new JFile(curFileName, ilist, rlist, serviceList);
    }

    public final JFile Include() throws ParseException {
        this.jj_consume_token(19);
        Token t = this.jj_consume_token(44);
        JFile ret = null;
        String fname = t.image.replaceAll("^\"", "").replaceAll("\"$", "");
        File file = new File(curDir, fname);
        String tmpDir = curDir;
        String tmpFile = curFileName;
        curDir = file.getParent();
        curFileName = file.getName();
        try {
            FileReader reader = new FileReader(file);
            RPCCompiler parser = new RPCCompiler(reader);
            try {
                ret = parser.Input();
                System.out.println(fname + " Parsed Successfully");
            }
            catch (ParseException e) {
                System.out.println(e.toString());
                System.exit(1);
            }
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        catch (FileNotFoundException e) {
            System.out.println("tmpDir is:" + tmpDir);
            System.out.println("File " + fname + " Not found. Path:" + file.getAbsolutePath());
            System.exit(1);
        }
        curDir = tmpDir;
        curFileName = tmpFile;
        return ret;
    }

    public final JModule Module() throws ParseException {
        JModule module;
        block10: {
            this.jj_consume_token(11);
            String mName = this.ModuleName();
            System.out.println("Module Name:" + mName);
            curModuleName = mName;
            module = new JModule(mName);
            this.jj_consume_token(35);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        JService service = this.Service();
                        module.addService(service);
                        continue block7;
                    }
                    case 13: {
                        JRecord record = this.Record();
                        if (record != null) {
                            System.out.println("Record() returned:" + record.toString());
                        } else {
                            System.out.println("Record() returned NULL");
                        }
                        module.addRecord(record);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(36);
        return module;
    }

    public final String ModuleName() throws ParseException {
        String name = "";
        Token t = this.jj_consume_token(45);
        name = name + t.image;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(43);
            t = this.jj_consume_token(45);
            name = name + "." + t.image;
        }
        return name;
    }

    public final JService Service() throws ParseException {
        String name;
        ArrayList<JMethod> methodList = new ArrayList<JMethod>();
        this.jj_consume_token(12);
        Token t = this.jj_consume_token(45);
        curService = name = t.image;
        this.jj_consume_token(35);
        block3: while (true) {
            JMethod m = this.Method();
            methodList.add(m);
            this.jj_consume_token(41);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(36);
        String fqn = curModuleName + "." + name;
        JService service = new JService(fqn, methodList);
        serviceTable.put(fqn, service);
        return service;
    }

    public final JMethod Method() throws ParseException {
        String inputType = null;
        String outputType = null;
        JRecord inputAnonymousRecord = null;
        JRecord outputAnonymousRecord = null;
        this.jj_consume_token(14);
        Token name = this.jj_consume_token(45);
        curMethod = name.toString();
        this.jj_consume_token(39);
        this.jj_consume_token(17);
        curParamType = "input";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                inputType = this.ModuleName();
                break;
            }
            case 35: {
                inputAnonymousRecord = this.AnonymousRecord();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(42);
        this.jj_consume_token(18);
        curParamType = "output";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                outputType = this.ModuleName();
                break;
            }
            case 35: {
                outputAnonymousRecord = this.AnonymousRecord();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(40);
        JRecord inputRecordType = null;
        JRecord outputRecordType = null;
        if (inputAnonymousRecord != null) {
            inputRecordType = inputAnonymousRecord;
        } else if (inputType.compareTo("NullMessage") != 0) {
            if (inputType.indexOf(46, 0) < 0) {
                inputType = curModuleName + "." + inputType;
            }
            if ((inputRecordType = recTab.get(inputType)) == null) {
                System.out.println("Input Param of Type " + inputType + " not known. Exiting.");
                System.exit(1);
            }
        }
        if (outputAnonymousRecord != null) {
            outputRecordType = outputAnonymousRecord;
        } else if (outputType.compareTo("NullMessage") != 0) {
            if (outputType.indexOf(46, 0) < 0) {
                outputType = curModuleName + "." + outputType;
            }
            if ((outputRecordType = recTab.get(outputType)) == null) {
                System.out.println("Output Param of Type " + outputType + " not known. Exiting.");
                System.exit(1);
            }
        }
        return new JMethod(name.image, inputRecordType, outputRecordType);
    }

    public final Set<String> RecordModifiers() throws ParseException {
        HashSet<String> modifiers = new HashSet<String>();
        this.jj_consume_token(47);
        String modifier = this.RecordModifier();
        modifiers.add(modifier);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(42);
            modifier = this.RecordModifier();
            modifiers.add(modifier);
        }
        this.jj_consume_token(48);
        return modifiers;
    }

    public final String RecordModifier() throws ParseException {
        Token modifier = this.jj_consume_token(45);
        return modifier.toString();
    }

    public final JRecord Record() throws ParseException {
        System.out.println("Entering Record Constructor");
        ArrayList<JField<JType>> flist = new ArrayList<JField<JType>>();
        ArrayList<JEnum> enumList = new ArrayList<JEnum>();
        ArrayList<JComparator> comparators = new ArrayList<JComparator>();
        Set<String> modifiers = null;
        this.jj_consume_token(13);
        Token t = this.jj_consume_token(45);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                modifiers = this.RecordModifiers();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        String rname = t.image;
        this.jj_consume_token(35);
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    JEnum e = this.Enumeration();
                    enumList.add(e);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 45: 
                case 47: {
                    JField<JType> f = this.Field();
                    this.jj_consume_token(41);
                    flist.add(f);
                    break;
                }
                case 16: {
                    JComparator c = this.Comparator();
                    comparators.add(c);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 45: 
                case 47: {
                    continue block11;
                }
            }
            break;
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(36);
        String fqn = curModuleName + "." + rname;
        System.out.println("fqn:" + fqn);
        JRecord r = new JRecord(fqn, flist, enumList, modifiers, comparators);
        recTab.put(fqn, r);
        return r;
    }

    public final JRecord AnonymousRecord() throws ParseException {
        System.out.println("Entering AnonymousRecord Constructor");
        ArrayList<JField<JType>> flist = new ArrayList<JField<JType>>();
        Object modifiers = null;
        this.jj_consume_token(35);
        block3: while (true) {
            JField<JType> f = this.Field();
            this.jj_consume_token(41);
            flist.add(f);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 45: 
                case 47: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(36);
        String fqn = curMethod + "_" + curParamType;
        JRecord r = new JRecord(fqn, flist, null, null, null);
        return r;
    }

    public final JComparator Comparator() throws ParseException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        this.jj_consume_token(16);
        Token name = this.jj_consume_token(45);
        this.jj_consume_token(35);
        block3: while (true) {
            Token fieldName = this.jj_consume_token(45);
            this.jj_consume_token(41);
            fieldNames.add(fieldName.toString());
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(36);
        return new JComparator(name.toString(), fieldNames);
    }

    public final JEnum Enumeration() throws ParseException {
        ArrayList<JEnumValue> values = new ArrayList<JEnumValue>();
        this.jj_consume_token(15);
        Token name = this.jj_consume_token(45);
        this.jj_consume_token(35);
        block3: while (true) {
            JEnumValue v = this.EnumerationValue();
            values.add(v);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(36);
        return new JEnum(name.image, values);
    }

    public final JEnumValue EnumerationValue() throws ParseException {
        Token valueName = this.jj_consume_token(45);
        this.jj_consume_token(34);
        Token ordinal = this.jj_consume_token(46);
        this.jj_consume_token(41);
        return new JEnumValue(valueName.image, Integer.parseInt(ordinal.image));
    }

    public final int FieldModifiers() throws ParseException {
        int modifiers = 0;
        int modifier = 0;
        this.jj_consume_token(47);
        modifier = this.FieldModifier();
        modifiers |= modifier;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(42);
            modifier = this.FieldModifier();
            modifiers |= modifier;
        }
        this.jj_consume_token(48);
        return modifiers;
    }

    public final int FieldModifier() throws ParseException {
        int modifier = 0;
        block4: while (this.jj_2_1(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    this.jj_consume_token(32);
                    modifier = JField.Modifiers.KEY;
                    continue block4;
                }
                case 33: {
                    this.jj_consume_token(33);
                    modifier = JField.Modifiers.TRANSIENT;
                    continue block4;
                }
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return modifier;
    }

    public final JField<JType> Field() throws ParseException {
        int modifiers = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                modifiers = this.FieldModifiers();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        JType jt = this.Type();
        Token name = this.jj_consume_token(45);
        this.jj_consume_token(34);
        Token ordinal = this.jj_consume_token(46);
        return new JField<JType>(name.image, jt, Integer.parseInt(ordinal.image), modifiers);
    }

    public final JType Type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                JMap jt = this.Map();
                return jt;
            }
            case 30: {
                JVector jt = this.Vector();
                return jt;
            }
            case 20: {
                this.jj_consume_token(20);
                return new JByte();
            }
            case 21: {
                this.jj_consume_token(21);
                return new JBoolean();
            }
            case 22: {
                this.jj_consume_token(22);
                return new JInt(false);
            }
            case 23: {
                this.jj_consume_token(23);
                return new JLong(false);
            }
            case 24: {
                this.jj_consume_token(24);
                return new JInt(true);
            }
            case 25: {
                this.jj_consume_token(25);
                return new JLong(true);
            }
            case 26: {
                this.jj_consume_token(26);
                return new JFloat();
            }
            case 27: {
                this.jj_consume_token(27);
                return new JDouble();
            }
            case 28: {
                this.jj_consume_token(28);
                return new JString();
            }
            case 29: {
                this.jj_consume_token(29);
                return new JBuffer();
            }
            case 45: {
                JRecord r;
                String rname = this.ModuleName();
                if (rname.indexOf(46, 0) < 0) {
                    rname = curModuleName + "." + rname;
                }
                if ((r = recTab.get(rname)) == null) {
                    System.out.println("Type " + rname + " not known. Exiting.");
                    System.exit(1);
                }
                return r;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JMap Map() throws ParseException {
        this.jj_consume_token(31);
        this.jj_consume_token(37);
        JType jt1 = this.Type();
        this.jj_consume_token(42);
        JType jt2 = this.Type();
        this.jj_consume_token(38);
        return new JMap(jt1, jt2);
    }

    public final JVector Vector() throws ParseException {
        this.jj_consume_token(30);
        this.jj_consume_token(37);
        JType jt = this.Type();
        this.jj_consume_token(38);
        return new JVector(jt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(32);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{526336, 526336, 12288, 12288, 0, 16384, 0, 0, 0, 0, -950272, -950272, -1048576, 0, 0, 0, 0, 0, -1048576};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 2048, 0, 8200, 8200, 1024, 32768, 40960, 40960, 40960, 8192, 8192, 1024, 3, 32768, 8192};
    }

    public RPCCompiler(InputStream stream) {
        this(stream, null);
    }

    public RPCCompiler(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new RPCCompilerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RPCCompiler(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RPCCompilerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RPCCompiler(RPCCompilerTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(RPCCompilerTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 19; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[49];
        for (i = 0; i < 49; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 19; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 49; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        recTab = new Hashtable();
        serviceTable = new Hashtable();
        curMethod = "";
        curService = "";
        curParamType = "";
        curDir = ".";
        RPCCompiler.jj_la1_0();
        RPCCompiler.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

