/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.commoncrawl.rpc.compiler.generated.RPCCompiler;

public class RccTask
extends Task {
    private String language = "java";
    private File src;
    private File dest = new File(".");
    private final ArrayList<FileSet> filesets = new ArrayList();
    private boolean failOnError = true;

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setFailonerror(boolean flag) {
        this.failOnError = flag;
    }

    public void setDestdir(File dir) {
        this.dest = dir;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    File getGenStampFile(File baseDir) {
        return new File(baseDir, "gen.stamp");
    }

    public void execute() throws BuildException {
        File genStampFile;
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("There must be a file attribute or a fileset child element");
        }
        if (!(this.src == null || (genStampFile = this.getGenStampFile(this.src.getParentFile())).exists() && this.src.lastModified() <= genStampFile.lastModified())) {
            this.doCompile(this.src);
            genStampFile.delete();
            try {
                genStampFile.createNewFile();
            }
            catch (IOException e) {
                throw new BuildException("Failed to create GenStamp File for src:" + this.src);
            }
        }
        Project myProject = this.getProject();
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = this.filesets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(myProject);
            File dir = fs.getDir(myProject);
            String[] srcs = ds.getIncludedFiles();
            for (int j = 0; j < srcs.length; ++j) {
                File srcLocation = new File(dir, srcs[j]);
                File genStampFile2 = this.getGenStampFile(srcLocation.getParentFile());
                if (genStampFile2.exists() && srcLocation.lastModified() <= genStampFile2.lastModified()) continue;
                this.doCompile(srcLocation);
                genStampFile2.delete();
                try {
                    genStampFile2.createNewFile();
                    continue;
                }
                catch (IOException e) {
                    throw new BuildException("Failed to create GenStamp File for src:" + srcLocation);
                }
            }
        }
    }

    private void doCompile(File file) throws BuildException {
        String[] args = new String[]{"--language", this.language, "--destdir", this.dest.getPath(), file.getPath()};
        int retVal = -1;
        try {
            retVal = RPCCompiler.driver(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retVal != 0 && this.failOnError) {
            throw new BuildException("Hadoop record compiler returned error code " + retVal);
        }
    }
}

