/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JCompType;
import org.commoncrawl.rpc.compiler.JType;

public class JVector
extends JCompType {
    private static int level = 0;

    private static String getId(String id) {
        return id + JVector.getLevel();
    }

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    public JVector(JType t) {
        this.setJavaType(new JavaVector(t.getJavaType()));
    }

    class JavaVector
    extends JCompType.JavaCompType {
        private JType.JavaType element;

        JavaVector(JType.JavaType t) {
            super("java.util.ArrayList<" + t.getWrapperType() + ">", "Vector", "java.util.ArrayList<" + t.getWrapperType() + ">");
            this.element = t;
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("itemCount") + " = decoder.readInt(input);\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (int " + JVector.getId("i") + "=0;" + JVector.getId("i") + "<" + JVector.getId("itemCount") + ";++" + JVector.getId("i") + ") {\n");
            this.element.genReadMethod(cb, JVector.getId("e"), JVector.getId("e"), true);
            cb.append(fname + ".add(" + JVector.getId("e") + ");\n");
            cb.append("}\n");
            JVector.decrLevel();
            cb.append("}\n");
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append("{\n");
            JVector.incrLevel();
            cb.append("int " + JVector.getId("len") + " = " + fname + ".size();\n");
            cb.append("encoder.writeInt(output," + JVector.getId("len") + ");\n");
            cb.append("for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("e") + " = " + fname + ".get(" + JVector.getId("vidx") + ");\n");
            this.element.genWriteMethod(cb, JVector.getId("e"), JVector.getId("e"));
            cb.append("}\n");
            cb.append("}\n");
            JVector.decrLevel();
        }

        void genClearMethod(CodeBuffer cb, String fname) {
            cb.append(fname + ".clear();\n");
        }

        void genClone(CodeBuffer cb, String type, String targetField, String sourceField) {
            this.genMergeOrClone(true, cb, type, targetField, sourceField);
        }

        void genMerge(CodeBuffer cb, String type, String targetField, String sourceField) {
            this.genMergeOrClone(false, cb, type, targetField, sourceField);
        }

        private final void genMergeOrClone(boolean isClone, CodeBuffer cb, String type, String targetField, String sourceField) {
            cb.append("//Deep Copy Vector\n");
            if (isClone) {
                cb.append(targetField + " = new " + "java.util.ArrayList<" + this.element.getWrapperType() + ">();\n");
            }
            cb.append("int " + JVector.getId("len") + " = " + sourceField + ".size();\n");
            cb.append("for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
            cb.append(this.element.getType() + " " + JVector.getId("src") + " = " + sourceField + ".get(" + JVector.getId("vidx") + ");\n");
            cb.append(this.element.getType() + " " + JVector.getId("tgt") + ";\n");
            this.element.genClone(cb, this.element.getType(), JVector.getId("tgt"), JVector.getId("src"));
            cb.append(targetField + ".add(" + JVector.getId("tgt") + ");\n");
            cb.append("}\n");
        }

        void genValidFieldCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (" + fieldName + ".size() != 0)");
        }

        boolean hasDirtyState() {
            return true;
        }

        void genDirtyCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (!isDirty){\n");
            cb.append("isDirty=" + fieldName + ".size() !=0;\n");
            cb.append("}\n");
        }
    }
}

