/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JCompType;
import org.commoncrawl.rpc.compiler.JType;

public class JMap
extends JCompType {
    private static int level = 0;

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    private static String getId(String id) {
        return id + JMap.getLevel();
    }

    public JMap(JType t1, JType t2) {
        this.setJavaType(new JavaMap(t1.getJavaType(), t2.getJavaType()));
    }

    class JavaMap
    extends JCompType.JavaCompType {
        JType.JavaType key;
        JType.JavaType value;

        JavaMap(JType.JavaType key, JType.JavaType value) {
            super("java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">", "Map", "java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">");
            this.key = key;
            this.value = value;
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("int " + JMap.getId("itemCount") + " = decoder.readInt(input);\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (int " + JMap.getId("i") + "=0;" + JMap.getId("i") + "<" + JMap.getId("itemCount") + ";++" + JMap.getId("i") + ") {\n");
            this.key.genReadMethod(cb, JMap.getId("k"), JMap.getId("k"), true);
            this.value.genReadMethod(cb, JMap.getId("v"), JMap.getId("v"), true);
            cb.append(fname + ".put(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
            cb.append("}\n");
            JMap.decrLevel();
            cb.append("}\n");
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            String setType = "java.util.Set<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            String entryType = "java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            cb.append("{\n");
            JMap.incrLevel();
            cb.append(setType + JMap.getId("es") + " = " + fname + ".entrySet();\n");
            cb.append("// write out set size\n");
            cb.append("encoder.writeInt(output," + JMap.getId("es") + ".size());\n");
            cb.append("for(" + iterType + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext();) {\n");
            cb.append(entryType + JMap.getId("me") + " = " + JMap.getId("midx") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("k") + " = " + JMap.getId("me") + ".getKey();\n");
            cb.append(this.value.getType() + " " + JMap.getId("v") + " = " + JMap.getId("me") + ".getValue();\n");
            this.key.genWriteMethod(cb, JMap.getId("k"), JMap.getId("k"));
            this.value.genWriteMethod(cb, JMap.getId("v"), JMap.getId("v"));
            cb.append("}\n");
            cb.append("}\n");
            JMap.decrLevel();
        }

        void genClearMethod(CodeBuffer cb, String fname) {
            cb.append(fname + ".clear();\n");
        }

        void genClone(CodeBuffer cb, String type, String targetField, String sourceField) {
            this.genMergeOrClone(true, cb, type, targetField, sourceField);
        }

        void genMerge(CodeBuffer cb, String type, String targetField, String sourceField) {
            this.genMergeOrClone(false, cb, type, targetField, sourceField);
        }

        private void genMergeOrClone(boolean isClone, CodeBuffer cb, String type, String targetField, String sourceField) {
            cb.append("//Deep Copy Map\n");
            if (isClone) {
                cb.append(targetField + " = new " + "java.util.TreeMap<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">();\n");
            }
            String setType = "java.util.Set<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            String entryType = "java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            cb.append(setType + JMap.getId("es") + " = " + sourceField + ".entrySet();\n");
            cb.append("for(" + iterType + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext();) {\n");
            cb.append(entryType + JMap.getId("me") + " = " + JMap.getId("midx") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("k") + ";\n");
            cb.append(this.value.getType() + " " + JMap.getId("v") + ";\n");
            this.key.genClone(cb, this.key.getType(), JMap.getId("k"), JMap.getId("me") + ".getKey()");
            this.value.genClone(cb, this.value.getType(), JMap.getId("v"), JMap.getId("me") + ".getValue()");
            cb.append(targetField + ".put(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
            cb.append("}\n");
        }

        void genValidFieldCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (" + fieldName + ".size() != 0)");
        }

        boolean hasDirtyState() {
            return false;
        }

        void genDirtyCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (!isDirty){\n");
            cb.append("isDirty=" + fieldName + ".size() !=0;\n");
            cb.append("}\n");
        }
    }
}

