/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JCompType;
import org.commoncrawl.rpc.compiler.JType;

public class JBuffer
extends JCompType {
    public JBuffer() {
        this.setJavaType(new JavaBuffer());
    }

    String getSignature() {
        return "B";
    }

    boolean isComparable() {
        return true;
    }

    class JavaBuffer
    extends JCompType.JavaCompType {
        JavaBuffer() {
            super(JBuffer.this, "FlexBuffer", "FlexBuffer", "org.commoncrawl.util.shared.FlexBuffer");
        }

        void genEquals(CodeBuffer cb, String fname, String peer) {
            cb.append("ret = " + fname + ".equals(" + peer + ");\n");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("result = MurmurHash.hash(" + fname + ".get()," + fname + ".getOffset()," + fname + ".getCount(),result);\n");
        }

        void genClearMethod(CodeBuffer cb, String fname) {
            cb.append(fname + ".reset();\n");
        }

        void genGetSet(CodeBuffer cb, String className, String fname, boolean trackDirtyFields) {
            cb.append("public ImmutableBuffer get" + JType.toCamelCase(fname) + "() {\n");
            cb.append("return new ImmutableBuffer(" + fname + ");\n");
            cb.append("}\n");
            cb.append("public " + className + " set" + JType.toCamelCase(fname) + "( " + this.getType() + " " + fname + ") {\n");
            if (trackDirtyFields) {
                cb.append("__validFields.set(Field_" + fname.toUpperCase() + ");\n");
            }
            cb.append("this." + fname + "=" + fname + ";\n");
            cb.append("return this;\n");
            cb.append("}\n");
            cb.append("public " + className + " set" + JType.toCamelCase(fname) + "( Buffer " + fname + ",boolean shared) {\n");
            if (trackDirtyFields) {
                cb.append("__validFields.set(Field_" + fname.toUpperCase() + ");\n");
            }
            cb.append("this." + fname + "= new FlexBuffer(" + fname + ".get(),0," + fname + ".getCount(),shared);\n");
            cb.append("return this;\n");
            cb.append("}\n");
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + " = new FlexBuffer();\n");
            }
            cb.append("decoder.read" + this.getMethodSuffix() + "(input," + fname + ");\n");
        }
    }
}

