/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListInputStream;
import org.commoncrawl.io.internal.NIOBufferListOutputStream;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIOClientTCPSocket;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.Channel;
import org.commoncrawl.rpc.IncomingMessageContext;
import org.commoncrawl.rpc.MessageData;
import org.commoncrawl.rpc.OutgoingMessageContext;
import org.commoncrawl.rpc.RPCException;
import org.commoncrawl.rpc.RPCFrame;
import org.commoncrawl.rpc.RPCServerChannel;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCChannel
implements NIOClientSocketListener,
Comparable<RPCChannel>,
Channel {
    private static long _lastChannelId = 0L;
    private long _channelId = 0L;
    public static final Log LOG = LogFactory.getLog((String)"org.commoncrawl.rpc.AsyncClientChannel");
    private static int INITIAL_RECONNECT_DELAY = 1000;
    private static int MAX_RECONNECT_DELAY = 5000;
    private EventLoop _eventLoop;
    private ThreadPoolExecutor _optionalThreadPool;
    private int _lastRequestId = 0;
    private Map<Integer, OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>> _requestMap = Collections.synchronizedMap(new HashMap());
    private LinkedList<OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>> _sendQueue = new LinkedList();
    private boolean _isOpen = false;
    private InetSocketAddress _localAddress;
    private InetSocketAddress _address;
    private NIOClientSocket _socket;
    private int _reconnectDelay = 0;
    private Timer _reconnectTimer;
    private NIOBufferList _output = new NIOBufferList();
    private NIOBufferList _input = new NIOBufferList();
    private NIOBufferListInputStream _inputStream = new NIOBufferListInputStream(this._input);
    private NIOBufferListOutputStream _outputStream = new NIOBufferListOutputStream(this._output);
    RPCFrame.Decoder _decoder = new RPCFrame.Decoder(this._inputStream);
    RPCFrame.Encoder _encoder = new RPCFrame.Encoder(this._outputStream);
    RPCServerChannel _serverChannel = null;
    ConnectionCallback _connectionCallback;
    Object _context;
    ByteBuffer readBufferDirect = ByteBuffer.allocateDirect(32384);
    ByteBuffer writeBufferDirect = ByteBuffer.allocateDirect(32384);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCChannel(EventLoop eventLoop, ThreadPoolExecutor optionalThreadPool, InetSocketAddress localAddress, InetSocketAddress address, ConnectionCallback callback) throws IOException {
        Class<RPCChannel> clazz = RPCChannel.class;
        synchronized (RPCChannel.class) {
            this._channelId = ++_lastChannelId;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this._eventLoop = eventLoop;
            this._optionalThreadPool = optionalThreadPool;
            this._address = address;
            this._localAddress = localAddress;
            this._connectionCallback = callback;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RPCChannel(NIOClientTCPSocket socket, RPCServerChannel serverChannel) throws IOException {
        Class<RPCChannel> clazz = RPCChannel.class;
        synchronized (RPCChannel.class) {
            this._channelId = ++_lastChannelId;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this._isOpen = true;
            this._serverChannel = serverChannel;
            this._socket = socket;
            this._eventLoop = this._serverChannel._eventLoop;
            this._address = socket.getSocketAddress();
            socket.setListener(this);
            this._eventLoop.getSelector().registerForRead(this._socket);
            return;
        }
    }

    public void setContext(Object contextObj) {
        this._context = contextObj;
    }

    public Object getContext() {
        return this._context;
    }

    public synchronized void open() throws IOException {
        if (this._isOpen) {
            LOG.error((Object)"open called on already open channel");
            throw new IOException("Channel Alread Open");
        }
        this._isOpen = true;
        this.reconnect();
    }

    public synchronized void close() throws IOException {
        if (this._isOpen) {
            this._isOpen = false;
            this.disconnect(true);
        }
    }

    public String toString() {
        if (this._address != null) {
            return "RPCChannel(" + this._address.toString() + ")";
        }
        return "Uninitialized ClientRPCChannel";
    }

    public synchronized boolean isOpen() {
        return this._isOpen;
    }

    public synchronized void reconnect() throws IOException {
        this.disconnect(false);
        if (this._reconnectDelay == 0) {
            this._reconnectDelay = INITIAL_RECONNECT_DELAY;
            this.connect();
        } else {
            this._reconnectTimer = new Timer(this._reconnectDelay, false, new Timer.Callback(){

                public void timerFired(Timer timer) {
                    try {
                        RPCChannel.this.connect();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOG.error((Object)("Reconnect threw exception:" + e.toString()));
                    }
                }
            });
            this._eventLoop.setTimer(this._reconnectTimer);
        }
        this._reconnectDelay = Math.min(MAX_RECONNECT_DELAY, this._reconnectDelay * 2);
    }

    private synchronized void connect() throws IOException {
        this._reconnectTimer = null;
        this._socket = new NIOClientTCPSocket(this._localAddress, this);
        this._socket.connect(this._address);
        this.getEventLoop().getSelector().registerForConnect(this._socket);
    }

    private synchronized void disconnect(boolean flushQueues) {
        if (this._reconnectTimer != null) {
            this._eventLoop.cancelTimer(this._reconnectTimer);
            this._reconnectTimer = null;
        }
        if (this._socket != null) {
            this._eventLoop.getSelector().cancelRegistration(this._socket);
            this._socket.close();
            this._socket = null;
        }
        this._output.reset();
        this._input.reset();
        this._inputStream.reset();
        this._decoder.reset();
        this._output.reset();
        this._outputStream.reset();
        this._encoder.reset();
        if (flushQueues) {
            this.cancelOutgoingMessages();
        }
        this._requestMap.clear();
    }

    synchronized boolean isIncomingChannel() {
        return this._serverChannel != null;
    }

    RPCServerChannel getServerChannel() {
        return this._serverChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendRequest(OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct> request) throws RPCException {
        int requestId = 0;
        try {
            RPCChannel rPCChannel = this;
            synchronized (rPCChannel) {
                requestId = ++this._lastRequestId;
            }
            request.setRequestId(requestId);
            this._requestMap.put(requestId, request);
            this._encoder.encodeRequest(request);
            this._sendQueue.add(request);
            if (this._socket != null && this._socket.isOpen()) {
                this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
            }
        }
        catch (IOException e) {
            this._requestMap.remove(requestId);
            e.printStackTrace();
            LOG.error((Object)("IOException during sendRequest:" + e.toString()));
            throw new RPCException(e);
        }
    }

    @Override
    public synchronized void sendResponse(IncomingMessageContext<? extends RPCStruct, ? extends RPCStruct> context) throws RPCException {
        if (this._socket == null || !this._socket.isOpen()) {
            LOG.error((Object)"sendResponse invoked on closed channel");
            throw new RPCException("Invoking RPC Response on Closed Channel.");
        }
        try {
            this._encoder.encodeResponse(context);
            this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
        }
        catch (IOException e) {
            LOG.error((Object)("IOException during encodeResponse in sendResponse::" + e.toString()));
            e.printStackTrace();
            throw new RPCException(e);
        }
    }

    public EventLoop getEventLoop() {
        return this._eventLoop;
    }

    @Override
    public synchronized void Connected(NIOClientSocket theSocket) throws IOException {
        this._reconnectDelay = INITIAL_RECONNECT_DELAY;
        if (this._sendQueue.size() != 0) {
            LinkedList<OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>> temp = this._sendQueue;
            this._sendQueue = new LinkedList();
            for (OutgoingMessageContext outgoingMessageContext : temp) {
                try {
                    this.sendRequest(outgoingMessageContext);
                }
                catch (RPCException e) {
                    LOG.error((Object)e);
                    if (outgoingMessageContext.getCallback() == null) continue;
                    outgoingMessageContext.setStatus(MessageData.Status.Error_RPCFailed);
                    outgoingMessageContext.setErrorDesc("RPC Failed During Resend");
                    outgoingMessageContext.getCallback().requestComplete(outgoingMessageContext);
                }
            }
            this.getEventLoop().getSelector().registerForWrite(this._socket);
        }
        if (this._connectionCallback != null) {
            this._connectionCallback.OutgoingChannelConnected(this);
        }
    }

    @Override
    public synchronized void Disconnected(NIOSocket theSocket, Exception disconnectReason) throws IOException {
        if (this.isIncomingChannel()) {
            this.disconnect(true);
            this.getServerChannel().ClientChannelDisconnected(this);
        } else {
            if (this._connectionCallback != null && !this._connectionCallback.OutgoingChannelDisconnected(this)) {
                this.cancelOutgoingMessages();
            }
            if (this.isOpen()) {
                this.reconnect();
            }
        }
    }

    private synchronized void cancelOutgoingMessages() {
        LinkedList<OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>> tempList = new LinkedList<OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>>();
        tempList.addAll(this._sendQueue);
        this._sendQueue.clear();
        for (final OutgoingMessageContext outgoingMessageContext : tempList) {
            outgoingMessageContext.setStatus(MessageData.Status.Error_RPCFailed);
            if (outgoingMessageContext.getCallback() == null) continue;
            if (this._optionalThreadPool != null) {
                this._optionalThreadPool.submit(new Runnable(){

                    public void run() {
                        outgoingMessageContext.getCallback().requestComplete(outgoingMessageContext);
                    }
                });
                continue;
            }
            outgoingMessageContext.getCallback().requestComplete(outgoingMessageContext);
        }
        this._sendQueue.clear();
    }

    @Override
    public synchronized int Readable(NIOClientSocket theSocket) throws IOException {
        if (!this._socket.isOpen()) {
            LOG.warn((Object)"Readable callback called on closed socket");
            return -1;
        }
        int totalBytesRead = 0;
        try {
            int singleReadAmount = 0;
            do {
                ByteBuffer buffer;
                if ((singleReadAmount = this._socket.read(buffer = this._input.getWriteBuf())) <= 0) continue;
                this._input.write(buffer);
                totalBytesRead += singleReadAmount;
            } while (singleReadAmount > 0);
            if (totalBytesRead != 0) {
                this._input.flush();
            }
            if (!this.isIncomingChannel()) {
                this.readResponseFrames();
            } else {
                this.readRequestFrames();
            }
            if (this._output.isDataAvailable()) {
                this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
            } else if (this._sendQueue.size() != 0 || this.isIncomingChannel()) {
                this.getEventLoop().getSelector().registerForRead(this._socket);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException in Readable callback:" + CCStringUtils.stringifyException((Throwable)e)));
            e.printStackTrace();
            this.reconnect();
        }
        return totalBytesRead == 0 ? -1 : totalBytesRead;
    }

    @Override
    public synchronized void Writeable(NIOClientSocket theSocket) throws IOException {
        if (!this._socket.isOpen()) {
            LOG.warn((Object)"Writeable callback called on closed socket");
            return;
        }
        int amountWritten = 0;
        try {
            do {
                amountWritten = 0;
                ByteBuffer bufferToWrite = this._output.read();
                if (bufferToWrite == null) continue;
                amountWritten = this._socket.write(bufferToWrite);
                if (bufferToWrite.remaining() <= 0) continue;
                this._output.putBack(bufferToWrite);
                break;
            } while (amountWritten > 0);
            if (this._output.isDataAvailable()) {
                this.getEventLoop().getSelector().registerForReadAndWrite(this._socket);
            } else if (this._sendQueue.size() != 0 || this.isIncomingChannel()) {
                this.getEventLoop().getSelector().registerForRead(this._socket);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException in Writeable callback:" + e.toString()));
            this.reconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readResponseFrames() throws IOException {
        RPCFrame.IncomingFrame incoming = null;
        while ((incoming = this._decoder.getNextResponseFrame()) != null) {
            final OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct> associatedRequest = this._requestMap.get(incoming._requestId);
            if (associatedRequest != null) {
                this._requestMap.remove(incoming._requestId);
                LinkedList<OutgoingMessageContext<? extends RPCStruct, ? extends RPCStruct>> linkedList = this._sendQueue;
                synchronized (linkedList) {
                    this._sendQueue.remove(associatedRequest);
                }
                try {
                    associatedRequest.setStatus(MessageData.Status.values()[incoming._status]);
                    if (associatedRequest.getStatus() == MessageData.Status.Success) {
                        ((RPCStruct)associatedRequest.getOutput()).deserialize(new DataInputStream(incoming._payload), new BinaryProtocol());
                    } else if (associatedRequest.getStatus() == MessageData.Status.Error_ServerError && incoming._payload.available() != 0) {
                        associatedRequest.setErrorDesc(new DataInputStream(incoming._payload).readUTF());
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("IOException in readResponseFrame:" + CCStringUtils.stringifyException((Throwable)e)));
                    associatedRequest.setStatus(MessageData.Status.Error_RPCFailed);
                }
                if (associatedRequest.getCallback() == null) continue;
                if (this._optionalThreadPool != null) {
                    this._optionalThreadPool.submit(new Runnable(){

                        public void run() {
                            associatedRequest.getCallback().requestComplete(associatedRequest);
                        }
                    });
                    continue;
                }
                associatedRequest.getCallback().requestComplete(associatedRequest);
                continue;
            }
            LOG.error((Object)"Orphaned request found in readResponseFrame");
        }
    }

    private synchronized void readRequestFrames() throws IOException {
        RPCFrame.IncomingFrame incoming = null;
        while ((incoming = this._decoder.getNextRequestFrame()) != null) {
            try {
                this.getServerChannel().dispatchRequest(this, incoming);
            }
            catch (RPCException e) {
                LOG.error((Object)("RPCException thrown during dispatchRequest:" + e.toString()));
                e.printStackTrace();
                IncomingMessageContext<Object, Object> dummyContext = new IncomingMessageContext<Object, Object>(this, incoming._requestId, null, null);
                dummyContext.setStatus(MessageData.Status.Error_RPCFailed);
                dummyContext.setErrorDesc(e.toString());
                try {
                    this.sendResponse(dummyContext);
                }
                catch (RPCException e1) {
                    LOG.error((Object)("RPCException while sending <FAILED> response::" + e.toString()));
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void Excepted(NIOSocket socket, Exception e) {
        LOG.error((Object)("Runtime Error on Socket:" + StringUtils.stringifyException((Throwable)e)));
        try {
            this.Disconnected(socket, e);
        }
        catch (IOException e2) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
        }
    }

    @Override
    public int compareTo(RPCChannel o) {
        long comparisonResult = this._channelId - o._channelId;
        return comparisonResult < 0L ? -1 : (comparisonResult > 0L ? 1 : 0);
    }

    public static interface ConnectionCallback {
        public void OutgoingChannelConnected(RPCChannel var1);

        public boolean OutgoingChannelDisconnected(RPCChannel var1);
    }
}

