/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.TextBytes;

public final class BinaryProtocol {
    public static final int RAW_PROTOCOL_VERSION = 1;
    public static final int FIELD_ID_ENCODING_MODE_UNKNOWN = 0;
    public static final int FIELD_ID_ENCODING_MODE_SHORT = 1;
    public static final int FIELD_ID_ENCODING_MODE_VINT = 2;
    public static int DEFAULT_PROTOCOL_ENCODING_MODE = 2;
    private int _currentMode;
    private static final int DEFAULT_MODE_STACK_CAPACITY = 20;
    int _currentModeIdx = -1;
    int[] _modeStack = new int[20];
    int _nestingLevel = 0;

    public BinaryProtocol() {
        this.pushFieldIdEncodingMode(0);
    }

    public int popFieldIdEncodingMode() {
        this._currentMode = this._modeStack[--this._currentModeIdx];
        return this._currentMode;
    }

    public void pushFieldIdEncodingMode(int mode) {
        if (this._currentModeIdx + 1 == this._modeStack.length) {
            int[] temp = new int[this._modeStack.length * 2];
            System.arraycopy(this._modeStack, 0, temp, 0, this._currentModeIdx + 1);
            this._modeStack = temp;
        }
        this._modeStack[++this._currentModeIdx] = mode;
        this._currentMode = mode;
    }

    public int getFieldIdEncodingMode() {
        return this._currentMode;
    }

    public void beginFields(DataOutput out) throws IOException {
        this.pushFieldIdEncodingMode(DEFAULT_PROTOCOL_ENCODING_MODE);
        if (this._nestingLevel++ == 0 && this._currentMode == 2) {
            out.writeByte(1);
        }
    }

    public void beginField(DataOutput out, String fieldName, int fieldId) throws IOException {
        if (this._currentMode == 0) {
            throw new IOException("Unknown Field Id Encoding Mode!");
        }
        if (this._currentMode == 1) {
            out.writeShort(fieldId);
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)fieldId);
        }
    }

    public void endFields(DataOutput out) throws IOException {
        if (this._currentMode == 0) {
            throw new IOException("Unknown Field Id Encoding Mode!");
        }
        if (this._currentMode == 1) {
            out.writeShort(-1);
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)-1);
        }
        this.popFieldIdEncodingMode();
        --this._nestingLevel;
    }

    public boolean readBool(DataInput in) throws IOException {
        return in.readBoolean();
    }

    public void readFlexBuffer(DataInput in, FlexBuffer buffer) throws IOException {
        int length = in.readInt();
        buffer.setCount(0);
        if (length != 0) {
            buffer.setCount(length);
            in.readFully(buffer.get(), buffer.getOffset(), buffer.getCount());
        }
    }

    public byte readByte(DataInput in) throws IOException {
        return in.readByte();
    }

    public double readDouble(DataInput in) throws IOException {
        return in.readDouble();
    }

    public int readFieldId(DataInput in) throws IOException {
        int fieldIdOut = -1;
        byte firstByte = in.readByte();
        if (this._currentMode != 2) {
            if (this._currentMode == 1 || firstByte == 0 || firstByte == -1) {
                if (this._currentMode == 0) {
                    ++this._nestingLevel;
                    this.pushFieldIdEncodingMode(1);
                }
                fieldIdOut = firstByte << 8 | in.readByte() & 0xFF;
            } else if (this._currentMode == 0) {
                if (this._nestingLevel++ == 0) {
                    firstByte = in.readByte();
                }
                this.pushFieldIdEncodingMode(2);
            }
        }
        if (this._currentMode == 2) {
            int len = WritableUtils.decodeVIntSize((byte)firstByte);
            if (len == 1) {
                fieldIdOut = firstByte;
            } else {
                long i = 0L;
                for (int idx = 0; idx < len - 1; ++idx) {
                    byte b = in.readByte();
                    i <<= 8;
                    i |= (long)(b & 0xFF);
                }
                fieldIdOut = (int)(WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i);
            }
        }
        if (fieldIdOut == -1) {
            this.popFieldIdEncodingMode();
            --this._nestingLevel;
        }
        return fieldIdOut;
    }

    public float readFloat(DataInput in) throws IOException {
        return in.readFloat();
    }

    public int readInt(DataInput in) throws IOException {
        return in.readInt();
    }

    public long readLong(DataInput in) throws IOException {
        return in.readLong();
    }

    public void readTextBytes(DataInput in, TextBytes stringBytes) throws IOException {
        if (this._currentMode == 1) {
            int utfLen = in.readUnsignedShort();
            stringBytes.setLength(utfLen);
            if (utfLen != 0) {
                FlexBuffer buffer = stringBytes.getBuffer();
                buffer.copyOnWrite();
                in.readFully(buffer.get(), buffer.getOffset(), utfLen);
            }
        } else {
            stringBytes.readFields(in);
        }
    }

    public void writeBool(DataOutput out, boolean b) throws IOException {
        out.writeBoolean(b);
    }

    public void writeFlexBuffer(DataOutput out, FlexBuffer buf) throws IOException {
        out.writeInt(buf.getCount());
        if (buf.getCount() != 0) {
            out.write(buf.get(), buf.getOffset(), buf.getCount());
        }
    }

    public void writeByte(DataOutput out, byte b) throws IOException {
        out.writeByte(b);
    }

    public void writeDouble(DataOutput out, double d) throws IOException {
        out.writeDouble(d);
    }

    public void writeFloat(DataOutput out, float f) throws IOException {
        out.writeFloat(f);
    }

    public void writeInt(DataOutput out, int i) throws IOException {
        out.writeInt(i);
    }

    public void writeLong(DataOutput out, long l) throws IOException {
        out.writeLong(l);
    }

    public void writeTextBytes(DataOutput out, TextBytes s) throws IOException {
        if (this._currentMode == 1) {
            if (s.getLength() > 65535) {
                throw new IOException("String Length Exceeds Max Encoding Length of 65535");
            }
            out.writeShort(s.getLength());
            if (s.getLength() != 0) {
                out.write(s.getBytes(), s.getOffset(), s.getLength());
            }
        } else {
            s.write(out);
        }
    }

    public int readVInt(DataInput in) throws IOException {
        return WritableUtils.readVInt((DataInput)in);
    }

    public long readVLong(DataInput in) throws IOException {
        return WritableUtils.readVLong((DataInput)in);
    }

    public void writeVInt(DataOutput out, int i) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)i);
    }

    public void writeVLong(DataOutput out, long l) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)l);
    }
}

