/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStatus
extends RPCStruct<QueryStatus>
implements Writable {
    public static final int Field_QUERYID = 1;
    public static final int Field_SHARDID = 2;
    public static final int Field_ATTEMPTS = 3;
    public static final int Field_LASTATTEMPTTIME = 4;
    public static final int Field_PROGRESS = 5;
    public static final int Field_STATUS = 6;
    public static final int Field_OPTERRORREASON = 7;
    public static final int Field_OPTRESULTCOUNT = 8;
    static final int FieldID_MAX = 8;
    private BitSet __validFields = new BitSet(9);
    private long queryId;
    private int shardId;
    private int attempts;
    private long lastAttemptTime;
    private float progress;
    private int status;
    private TextBytes optErrorReason = new TextBytes();
    private long optResultCount;

    public static QueryStatus newInstance(Configuration conf) {
        return (QueryStatus)ReflectionUtils.newInstance(QueryStatus.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final QueryStatus setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final QueryStatus setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public QueryStatus setQueryId(long queryId) {
        this.__validFields.set(1);
        this.queryId = queryId;
        return this;
    }

    public int getShardId() {
        return this.shardId;
    }

    public QueryStatus setShardId(int shardId) {
        this.__validFields.set(2);
        this.shardId = shardId;
        return this;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public QueryStatus setAttempts(int attempts) {
        this.__validFields.set(3);
        this.attempts = attempts;
        return this;
    }

    public long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    public QueryStatus setLastAttemptTime(long lastAttemptTime) {
        this.__validFields.set(4);
        this.lastAttemptTime = lastAttemptTime;
        return this;
    }

    public float getProgress() {
        return this.progress;
    }

    public QueryStatus setProgress(float progress) {
        this.__validFields.set(5);
        this.progress = progress;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public QueryStatus setStatus(int status) {
        this.__validFields.set(6);
        this.status = status;
        return this;
    }

    public TextBytes getOptErrorReasonAsTextBytes() {
        return this.optErrorReason;
    }

    public String getOptErrorReason() {
        return this.optErrorReason.toString();
    }

    public QueryStatus setOptErrorReason(String optErrorReason) {
        this.__validFields.set(7);
        this.optErrorReason.set(optErrorReason);
        return this;
    }

    public long getOptResultCount() {
        return this.optResultCount;
    }

    public QueryStatus setOptResultCount(long optResultCount) {
        this.__validFields.set(8);
        this.optResultCount = optResultCount;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "queryId", 1);
            encoder.writeLong(output, this.queryId);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "shardId", 2);
            encoder.writeInt(output, this.shardId);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "attempts", 3);
            encoder.writeInt(output, this.attempts);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "lastAttemptTime", 4);
            encoder.writeLong(output, this.lastAttemptTime);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "progress", 5);
            encoder.writeFloat(output, this.progress);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "status", 6);
            encoder.writeInt(output, this.status);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "optErrorReason", 7);
            encoder.writeTextBytes(output, this.optErrorReason);
        }
        if (this.__validFields.get(8)) {
            encoder.beginField(output, "optResultCount", 8);
            encoder.writeLong(output, this.optResultCount);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.queryId = decoder.readLong(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    this.shardId = decoder.readInt(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    this.attempts = decoder.readInt(input);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.lastAttemptTime = decoder.readLong(input);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.progress = decoder.readFloat(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    this.status = decoder.readInt(input);
                    break;
                }
                case 7: {
                    this.__validFields.set(7);
                    decoder.readTextBytes(input, this.optErrorReason);
                    break;
                }
                case 8: {
                    this.__validFields.set(8);
                    this.optResultCount = decoder.readLong(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.queryId = 0L;
        this.shardId = 0;
        this.attempts = 0;
        this.lastAttemptTime = 0L;
        this.progress = 0.0f;
        this.status = 0;
        this.optErrorReason.clear();
        this.optResultCount = 0L;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof QueryStatus)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        QueryStatus peer = (QueryStatus)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.queryId == peer.queryId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(2)) {
            boolean bl = ret = this.shardId == peer.shardId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3)) {
            boolean bl = ret = this.attempts == peer.attempts;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.lastAttemptTime == peer.lastAttemptTime;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.progress == peer.progress;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(6)) {
            boolean bl = ret = this.status == peer.status;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(7) && !(ret = this.optErrorReason.equals(peer.optErrorReason))) {
            return ret;
        }
        if (this.__validFields.get(8)) {
            boolean bl = ret = this.optResultCount == peer.optResultCount;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        QueryStatus other = new QueryStatus();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.queryId = this.queryId;
        }
        if (this.__validFields.get(2)) {
            other.shardId = this.shardId;
        }
        if (this.__validFields.get(3)) {
            other.attempts = this.attempts;
        }
        if (this.__validFields.get(4)) {
            other.lastAttemptTime = this.lastAttemptTime;
        }
        if (this.__validFields.get(5)) {
            other.progress = this.progress;
        }
        if (this.__validFields.get(6)) {
            other.status = this.status;
        }
        if (this.__validFields.get(7)) {
            other.optErrorReason = (TextBytes)this.optErrorReason.clone();
        }
        if (this.__validFields.get(8)) {
            other.optResultCount = this.optResultCount;
        }
        return other;
    }

    @Override
    public final void merge(QueryStatus peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.queryId = peer.queryId;
        }
        if (peer.__validFields.get(2)) {
            this.shardId = peer.shardId;
        }
        if (peer.__validFields.get(3)) {
            this.attempts = peer.attempts;
        }
        if (peer.__validFields.get(4)) {
            this.lastAttemptTime = peer.lastAttemptTime;
        }
        if (peer.__validFields.get(5)) {
            this.progress = peer.progress;
        }
        if (peer.__validFields.get(6)) {
            this.status = peer.status;
        }
        if (peer.__validFields.get(7)) {
            this.optErrorReason = (TextBytes)peer.optErrorReason.clone();
        }
        if (peer.__validFields.get(8)) {
            this.optResultCount = peer.optResultCount;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.queryId, result);
        result = MurmurHash.hashInt(this.shardId, result);
        result = MurmurHash.hashInt(this.attempts, result);
        result = MurmurHash.hashLong(this.lastAttemptTime, result);
        result = MurmurHash.hashFloat(this.progress, result);
        result = MurmurHash.hashInt(this.status, result);
        result = MurmurHash.hash(this.optErrorReason.getBytes(), this.optErrorReason.getOffset(), this.optErrorReason.getLength(), result);
        result = MurmurHash.hashLong(this.optResultCount, result);
        return result;
    }

    public static final class Status {
        public static final int PENDING = 0;
        public static final int RUNNING = 1;
        public static final int FINISHED = 2;
        public static final int ERROR = 3;
        public static final int CANCELLED = 4;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 0: {
                    return "PENDING";
                }
                case 1: {
                    return "RUNNING";
                }
                case 2: {
                    return "FINISHED";
                }
                case 3: {
                    return "ERROR";
                }
                case 4: {
                    return "CANCELLED";
                }
            }
            return "";
        }
    }
}

