/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.commoncrawl.hadoop.mergeutils.MergeSortSpillWriter;
import org.commoncrawl.hadoop.mergeutils.SequenceFileIndexWriter;
import org.commoncrawl.query.QueryResult;
import org.commoncrawl.query.QueryResultRecord;
import org.commoncrawl.util.shared.CCStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultFileIndex<KeyType extends WritableComparable, ValueType extends Writable> {
    private static final Class[] emptyArray = new Class[0];
    FileSystem _fileSystem;
    Path _indexFileName;
    PositionBasedIndexWriter.IndexHeader _header = new PositionBasedIndexWriter.IndexHeader();
    ByteBuffer _indexData = null;
    DataInputStream _inputStream = null;
    int _headerOffset = -1;
    int _indexItemCount;
    static final int INDEX_RECORD_SIZE = 16;
    Constructor<KeyType> keyConstructor = null;
    Constructor<ValueType> valConstructor = null;
    public static final Log LOG = LogFactory.getLog(QueryResultFileIndex.class);

    public static Path getIndexNameFromBaseName(Path baseFileName) {
        return new Path(baseFileName.getParent(), baseFileName.getName() + ".index");
    }

    public static Path getBaseNameFromIndexName(Path indexName) {
        String baseName = indexName.getName().substring(0, indexName.getName().length() - ".index".length());
        return new Path(indexName.getParent(), baseName);
    }

    public QueryResultFileIndex(FileSystem fileSystem, Path indexFilePath, Class<KeyType> keyClass, Class<ValueType> valueClass) throws IOException {
        this._fileSystem = fileSystem;
        this._indexFileName = indexFilePath;
        if (!this._fileSystem.exists(this._indexFileName) || this._fileSystem.isDirectory(this._indexFileName)) {
            throw new IOException("Index Path:" + indexFilePath + " Points to Invalid File");
        }
        try {
            this.keyConstructor = keyClass.getDeclaredConstructor(emptyArray);
            this.keyConstructor.setAccessible(true);
            this.valConstructor = valueClass.getDeclaredConstructor(emptyArray);
            this.valConstructor.setAccessible(true);
        }
        catch (SecurityException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        this._indexData = this.loadStreamIntoMemory(indexFilePath);
        this._inputStream = new DataInputStream(QueryResultFileIndex.newInputStream(this._indexData));
        this._header.readHeader(this._inputStream);
        this._headerOffset = this._indexData.position();
        this._indexItemCount = this._indexData.remaining() / 16;
    }

    public long getRecordCount() {
        return this._header._totalRecordCount;
    }

    private static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    LOG.error((Object)"EOF REACHED in Wrapper Stream!");
                    return -1;
                }
                return buf.get() & 0xFF;
            }

            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    private IndexItem findIndexDataPosForItemIndex(long targetItemIndexValue) throws IOException {
        int low = 0;
        int high = this._indexItemCount - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            this._indexData.position(this._headerOffset + mid * 16);
            long indexValue = this._inputStream.readLong();
            int comparisonResult = (int)(indexValue - targetItemIndexValue);
            if (comparisonResult > 0) {
                high = mid - 1;
                continue;
            }
            if (comparisonResult < 0) {
                low = mid + 1;
                continue;
            }
            return new IndexItem(indexValue, this._inputStream.readLong());
        }
        if (high == -1) {
            return null;
        }
        this._indexData.position(this._headerOffset + high * 16);
        return new IndexItem(this._inputStream.readLong(), this._inputStream.readLong());
    }

    public void dump() throws IOException {
        for (long i = 0L; i < this._header._totalRecordCount; i += 100L) {
            IndexItem indexItem = this.findIndexDataPosForItemIndex(i);
        }
    }

    public void seekReaderToItemAtIndex(SequenceFile.Reader reader, long desiredIndexPos) throws IOException {
        IndexItem indexItem = this.findIndexDataPosForItemIndex(desiredIndexPos);
        if (indexItem == null) {
            throw new IOException("Invalid Index Position:" + desiredIndexPos);
        }
        long timeStart = System.currentTimeMillis();
        reader.seek(indexItem._offsetValue);
        DataOutputBuffer skipBuffer = new DataOutputBuffer(){

            public void write(DataInput in, int length) throws IOException {
                in.skipBytes(length);
            }
        };
        timeStart = System.currentTimeMillis();
        int skipCount = 0;
        SequenceFile.ValueBytes skipValue = reader.createValueBytes();
        for (long currentIndexPos = indexItem._indexValue; currentIndexPos < desiredIndexPos; ++currentIndexPos) {
            reader.nextRawKey(skipBuffer);
            reader.nextRawValue(skipValue);
            ++skipCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPaginatedResults(FileSystem fileSystem, Configuration conf, int sortOrder, int pageNumber, int pageSize, QueryResult<KeyType, ValueType> resultOut) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(fileSystem, QueryResultFileIndex.getBaseNameFromIndexName(this._indexFileName), conf);
        try {
            this.readPaginatedResults(reader, sortOrder, pageNumber, pageSize, resultOut);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    public void readPaginatedResults(SequenceFile.Reader reader, int sortOrder, int pageNumber, int pageSize, QueryResult<KeyType, ValueType> resultOut) throws IOException {
        long offset = 0L;
        long startPos = 0L;
        long endPos = 0L;
        resultOut.getResults().clear();
        resultOut.setPageNumber(pageNumber);
        resultOut.setTotalRecordCount(this._header._totalRecordCount);
        if (sortOrder == 0) {
            startPos = pageNumber * pageSize;
            endPos = Math.min(startPos + (long)pageSize, this._header._totalRecordCount);
            offset = pageNumber * pageSize;
        } else {
            startPos = this._header._totalRecordCount - (long)((pageNumber + 1) * pageSize);
            endPos = startPos + (long)pageSize;
            startPos = Math.max(0L, startPos);
            offset = this._header._totalRecordCount - (long)((pageNumber + 1) * pageSize);
        }
        LOG.info((Object)("readPaginatedResults called on Index with sortOrder:" + sortOrder + " pageNumber: " + pageNumber + " pageSize:" + pageSize + " offset is:" + offset));
        if (startPos < this._header._totalRecordCount) {
            this.seekReaderToItemAtIndex(reader, startPos);
            for (long i = startPos; i < endPos; ++i) {
                WritableComparable key = null;
                Writable value = null;
                try {
                    key = (WritableComparable)this.keyConstructor.newInstance(new Object[0]);
                    value = (Writable)this.valConstructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to create key or value type with Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    throw new RuntimeException(e);
                }
                if (!reader.next((Writable)key, value)) break;
                if (sortOrder == 1) {
                    resultOut.getResults().add(0, new QueryResultRecord<WritableComparable, Writable>(key, value));
                    continue;
                }
                resultOut.getResults().add(new QueryResultRecord<WritableComparable, Writable>(key, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuffer loadStreamIntoMemory(Path streamPath) throws IOException {
        if (!this._fileSystem.exists(streamPath) || this._fileSystem.isDirectory(streamPath)) {
            throw new IOException("Stream Path:" + streamPath + " Points to Invalid File");
        }
        FilterInputStream inputStream = null;
        ByteBuffer bufferOut = null;
        try {
            LOG.info((Object)("Allocating Buffer of size:" + this._fileSystem.getLength(streamPath) + " for Stream:" + streamPath));
            bufferOut = ByteBuffer.allocate((int)this._fileSystem.getLength(streamPath));
            inputStream = this._fileSystem.open(streamPath);
            long loadStart = System.currentTimeMillis();
            int offset = 0;
            int totalRead = 0;
            while (offset < bufferOut.capacity()) {
                int bytesToRead = Math.min(16384, bufferOut.capacity() - totalRead);
                ((DataInputStream)inputStream).read(bufferOut.array(), offset, bytesToRead);
                offset += bytesToRead;
                totalRead += bytesToRead;
            }
            Object var10_8 = null;
            if (inputStream == null) return bufferOut;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return bufferOut;
    }

    public static class PositionBasedIndexWriter
    implements SequenceFileIndexWriter {
        public static final Log LOG = LogFactory.getLog(MergeSortSpillWriter.class);
        private FileSystem _fileSystem;
        private Path _indexFileName;
        private RandomAccessFile _indexFile = null;
        private File _tempFileName;
        private IndexHeader _header = null;
        public long _lastKnownStartIndex = -1L;
        public long _lastKnownFileLength = -1L;
        public int _level1IndexItemCount = 0;

        public PositionBasedIndexWriter(FileSystem fileSystem, Path indexFilePath) throws IOException {
            this._fileSystem = fileSystem;
            this._fileSystem.delete(indexFilePath);
            this._indexFileName = indexFilePath;
            this._tempFileName = File.createTempFile("indexTmp", Long.toString(System.currentTimeMillis()));
            this._indexFile = new RandomAccessFile(this._tempFileName, "rw");
            this._header = new IndexHeader();
            this._header.writeHeader(this._indexFile);
        }

        public Path getPath() {
            return this._indexFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this._indexFile != null) {
                try {
                    this._indexFile.seek(0L);
                    this._header.writeHeader(this._indexFile);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this._indexFile.close();
                    throw throwable;
                }
                this._indexFile.close();
                this._indexFile = null;
                this._fileSystem.copyFromLocalFile(new Path(this._tempFileName.getAbsolutePath()), this._indexFileName);
            }
        }

        public void indexItem(byte[] keyData, int keyOffset, int keyLength, byte[] valueData, int valueOffset, int valueLength, long currentFileLength) throws IOException {
            if (currentFileLength != this._lastKnownFileLength) {
                this._lastKnownStartIndex = this._header._totalRecordCount;
                this._lastKnownFileLength = currentFileLength;
                ++this._level1IndexItemCount;
                this._indexFile.writeLong(this._lastKnownStartIndex);
                this._indexFile.writeLong(this._lastKnownFileLength);
            }
            ++this._header._totalRecordCount;
        }

        public static class IndexHeader {
            public short _version = 1;
            public long _totalRecordCount = 0L;

            public void readHeader(DataInput stream) throws IOException {
                this._version = stream.readShort();
                this._totalRecordCount = stream.readLong();
            }

            public void writeHeader(DataOutput stream) throws IOException {
                stream.writeShort(this._version);
                stream.writeLong(this._totalRecordCount);
            }

            public static int sizeOfHeader() {
                return 14;
            }
        }
    }

    private static class IndexItem {
        long _indexValue;
        long _offsetValue;

        public IndexItem(long indexValue, long offsetValue) {
            this._indexValue = indexValue;
            this._offsetValue = offsetValue;
        }
    }
}

