/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.commoncrawl.query.ClientQueryInfo;
import org.commoncrawl.query.Query;
import org.commoncrawl.query.QueryCompletionCallback;
import org.commoncrawl.query.QueryStatus;
import org.commoncrawl.rpc.RPCStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequest<DataType extends RPCStruct, KeyType extends WritableComparable, ValueType extends Writable>
implements Comparable<QueryRequest> {
    private static final Log LOG = LogFactory.getLog(QueryRequest.class);
    private static AtomicLong _lastSeqNo = new AtomicLong();
    private long _querySeqNo = _lastSeqNo.addAndGet(1L);
    private Query<DataType, KeyType, ValueType> _querySource;
    private ClientQueryInfo _clientQueryObj;
    private QueryStatus _queryStatus;
    private QueryCompletionCallback<DataType, KeyType, ValueType> _completionCallback;
    private RunState _runState = RunState.IDLE;
    private RunState _lastRunningState = RunState.IDLE;

    public QueryRequest(Query<DataType, KeyType, ValueType> query, ClientQueryInfo ClientQueryInfo2, QueryCompletionCallback<DataType, KeyType, ValueType> callback) {
        this._querySource = query;
        this._clientQueryObj = ClientQueryInfo2;
        this._completionCallback = callback;
        this._queryStatus = new QueryStatus();
        this._queryStatus.setQueryId(ClientQueryInfo2.getClientQueryId());
        this._queryStatus.setStatus(0);
    }

    public Query<DataType, KeyType, ValueType> getSourceQuery() {
        return this._querySource;
    }

    public ClientQueryInfo getClientQueryInfo() {
        return this._clientQueryObj;
    }

    public QueryStatus getQueryStatus() {
        return this._queryStatus;
    }

    public QueryCompletionCallback<DataType, KeyType, ValueType> getCompletionCallback() {
        return this._completionCallback;
    }

    public void setRunState(RunState runState) {
        if (this._runState != RunState.IDLE && this._runState != RunState.ERROR) {
            this._lastRunningState = this._runState;
        }
        this._runState = runState;
    }

    public RunState getRunState() {
        return this._runState;
    }

    public RunState getLastRunState() {
        return this._lastRunningState;
    }

    @Override
    public int compareTo(QueryRequest o) {
        return this._querySeqNo < o._querySeqNo ? -1 : (this._querySeqNo > o._querySeqNo ? 1 : 0);
    }

    public long getSequenceNo() {
        return this._querySeqNo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunState {
        IDLE,
        RUNNING_REMOTE,
        RUNNING_LOCAL,
        RUNNING_CACHE,
        ERROR;

    }
}

