/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.commoncrawl.async.Callbacks;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.query.BaseConfig;
import org.commoncrawl.query.ClientQueryInfo;
import org.commoncrawl.query.PersistentQueryInfo;
import org.commoncrawl.query.Query;
import org.commoncrawl.query.QueryCompletionCallback;
import org.commoncrawl.query.QueryControllerHost;
import org.commoncrawl.query.QueryInputSplit;
import org.commoncrawl.query.QueryProgressCallback;
import org.commoncrawl.query.QueryRequest;
import org.commoncrawl.query.QueryResult;
import org.commoncrawl.query.QueryStatus;
import org.commoncrawl.query.RemoteQueryCompletionCallback;
import org.commoncrawl.query.SlaveStatus;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.FileUtils;
import org.commoncrawl.util.shared.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryController {
    QueryControllerHost _host;
    FileSystem _remoteFS;
    Configuration _conf;
    Path _hdfsResultsDir;
    Path _hdfsQueryHistoryDir;
    private PriorityQueue<QueryRequest> _queuedClientQueries = new PriorityQueue();
    private Map<Long, QueryRequest> _activeRemoteOrLocalQueries = new HashMap<Long, QueryRequest>();
    private Set<QueryRequest> _activeRemoteQueries = new HashSet<QueryRequest>();
    private Set<QueryRequest> _activeLocalQueries = new HashSet<QueryRequest>();
    private File _localTempDir;
    private int _maxConcurrentQueries;
    private static final Log LOG = LogFactory.getLog(QueryController.class);

    public QueryController(QueryControllerHost host, FileSystem remoteFS, Configuration conf, Path hdfsResultsDir, Path hdfsQueryHistoryDir, File localTempDir, int maxConcurrentQueries) {
        this._host = host;
        this._remoteFS = remoteFS;
        this._conf = conf;
        this._hdfsResultsDir = hdfsResultsDir;
        this._hdfsQueryHistoryDir = hdfsQueryHistoryDir;
        this._localTempDir = localTempDir;
        this._maxConcurrentQueries = maxConcurrentQueries;
    }

    public QueryControllerHost getHost() {
        return this._host;
    }

    void slaveStatusChanged(String fqnHostName, SlaveStatus slaveStatus) {
        if (slaveStatus != null && slaveStatus.getQueryStatus().size() != 0) {
            for (QueryStatus queryStatus : slaveStatus.getQueryStatus()) {
                QueryRequest request = this._activeRemoteOrLocalQueries.get(queryStatus.getQueryId());
                if (request != null) {
                    try {
                        request.getSourceQuery().updateQueryStatus(queryStatus);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Error Updating QueryStatus for Query:" + request.getSourceQuery().getQueryId() + " Slave:" + fqnHostName + " Error:" + CCStringUtils.stringifyException((Throwable)e)));
                    }
                    continue;
                }
                LOG.error((Object)("DID NOT FIND QueryRequestObj for Query:" + queryStatus.getQueryId()));
            }
            slaveStatus.getQueryStatus().clear();
        }
        try {
            this.potentiallyStartNextQuery();
        }
        catch (IOException e) {
            LOG.error((Object)("Error encountered calling startNextQuery. Exception:" + CCStringUtils.stringifyException((Throwable)e)));
        }
    }

    public BaseConfig getBaseConfigForSlave(String fqnHostName) {
        BaseConfig baseConfig = new BaseConfig();
        baseConfig.setQueryResultsDir(this._hdfsResultsDir.toString());
        baseConfig.setSlaveName(fqnHostName);
        return baseConfig;
    }

    public <DataType extends RPCStruct, KeyType extends WritableComparable, ValueType extends Writable> BlockingQueryResult<KeyType, ValueType> blockingQueryRequest(final Query<DataType, KeyType, ValueType> queryObject, final ClientQueryInfo queryInfo) throws IOException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue(1);
        this._host.getEventLoop().setTimer(new Timer(0L, false, new Timer.Callback(){

            public void timerFired(Timer timer) {
                try {
                    QueryController.this.queueClientQueryRequest(queryObject, queryInfo, new QueryCompletionCallback<DataType, KeyType, ValueType>(){

                        @Override
                        public void queryComplete(QueryRequest<DataType, KeyType, ValueType> request, QueryResult<KeyType, ValueType> queryResult) {
                            LOG.info((Object)("Recevied QueryComplete for query:" + request.getSourceQuery().getQueryId() + " Object:" + request.getSourceQuery()));
                            BlockingQueryResult result = new BlockingQueryResult(queryResult);
                            try {
                                LOG.info((Object)("Queing response for Query:" + request.getSourceQuery().getQueryId() + " Object:" + request.getSourceQuery()));
                                queue.put(result);
                                LOG.info((Object)("Queued response for Query:" + request.getSourceQuery().getQueryId() + " Object:" + request.getSourceQuery()));
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                            }
                        }

                        @Override
                        public void queryFailed(QueryRequest<DataType, KeyType, ValueType> request, String reason) {
                            LOG.info((Object)("Received queryFailed for request:" + request.getSourceQuery().getQueryId() + " Object:" + request.getSourceQuery()));
                            BlockingQueryResult result = new BlockingQueryResult(reason);
                            try {
                                queue.put(result);
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
            }
        }));
        try {
            LOG.info((Object)("Waiting for Blocking Result for QueryObject:" + queryObject));
            BlockingQueryResult result = (BlockingQueryResult)queue.take();
            LOG.info((Object)("Returning result for Object:" + queryObject));
            return result;
        }
        catch (InterruptedException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    long locateMatchingQueryInRequestCollection(Query queryObject, Collection<QueryRequest> collection) {
        Tuples.Pair<Long, Long> queryCanonicalId = queryObject.getCanonicalQueryId();
        for (QueryRequest request : collection) {
            Tuples.Pair<Long, Long> requestCanonicalId = request.getSourceQuery().getCanonicalQueryId();
            LOG.info((Object)("Matching " + queryCanonicalId.e0 + ":" + queryCanonicalId.e1 + " Against " + requestCanonicalId.e0 + ":" + requestCanonicalId.e1));
            if (((Long)requestCanonicalId.e0).longValue() != ((Long)queryCanonicalId.e0).longValue() || ((Long)requestCanonicalId.e1).longValue() != ((Long)queryCanonicalId.e1).longValue()) continue;
            LOG.info((Object)("Matched! Returning Id:" + request.getSourceQuery().getQueryId()));
            return request.getSourceQuery().getQueryId();
        }
        return -1L;
    }

    long locateMatchingQueryInQueues(Query queryObject) {
        long queryId = this.locateMatchingQueryInRequestCollection(queryObject, this._queuedClientQueries);
        if (queryId == -1L) {
            queryId = this.locateMatchingQueryInRequestCollection(queryObject, this._activeRemoteQueries);
        }
        if (queryId == -1L) {
            queryId = this.locateMatchingQueryInRequestCollection(queryObject, this._activeLocalQueries);
        }
        return queryId;
    }

    <DataType extends RPCStruct, KeyType extends WritableComparable, ValueType extends Writable> void queueClientQueryRequest(Query<DataType, KeyType, ValueType> queryObject, ClientQueryInfo theClientRequest, QueryCompletionCallback<DataType, KeyType, ValueType> callback) throws IOException {
        queryObject.setClientQueryInfo(theClientRequest);
        PersistentQueryInfo persistentQueryInfo = this.getPersistentQueryInfo(queryObject.getCanonicalQueryId(), theClientRequest.getMaxAge());
        boolean cachedQueryAvailable = false;
        if (persistentQueryInfo != null) {
            LOG.info((Object)("Existing Query Id found:" + persistentQueryInfo.getQueryId() + " for Query Request"));
            queryObject.setQueryId(persistentQueryInfo.getQueryId());
            Path hdfsWorkingDir = new Path(this._hdfsResultsDir, Long.toString(queryObject.getQueryId()));
            queryObject.getCommonQueryInfo().setQueryResultPath(hdfsWorkingDir.toString());
            if (queryObject.cachedResultsAvailable(this._remoteFS, this._conf, theClientRequest)) {
                cachedQueryAvailable = true;
            }
        }
        boolean existingRequestInProgress = false;
        if (!cachedQueryAvailable) {
            long existingIdInQueue = this.locateMatchingQueryInQueues(queryObject);
            if (existingIdInQueue != -1L) {
                existingRequestInProgress = true;
                LOG.info((Object)("Found Existing Query Id: " + existingIdInQueue + " for new Query Request"));
                queryObject.setQueryId(existingIdInQueue);
            } else {
                queryObject.setQueryId(System.currentTimeMillis());
                LOG.info((Object)("Assigning new Id: " + queryObject.getQueryId() + " to Query Request"));
            }
        }
        Path hdfsWorkingDir = new Path(this._hdfsResultsDir, Long.toString(queryObject.getQueryId()));
        Path hdfsTempDir = new Path(hdfsWorkingDir, "temp");
        if (!existingRequestInProgress) {
            this._remoteFS.mkdirs(hdfsWorkingDir);
            this._remoteFS.delete(hdfsTempDir, true);
            this._remoteFS.mkdirs(hdfsTempDir);
        }
        queryObject.getCommonQueryInfo().setQueryResultPath(hdfsWorkingDir.toString());
        queryObject.getCommonQueryInfo().setQueryTempPath(hdfsTempDir.toString());
        QueryRequest<DataType, KeyType, ValueType> clientQueryObj = new QueryRequest<DataType, KeyType, ValueType>(queryObject, theClientRequest, callback);
        queryObject.setContext(clientQueryObj);
        LOG.info((Object)("Queueing Query Request:" + queryObject.getQueryId() + " SeqNo:" + clientQueryObj.getSequenceNo()));
        this._queuedClientQueries.add(clientQueryObj);
        this.potentiallyStartNextQuery();
    }

    private void publishBindings(Query queryObject) throws IOException {
        Tuples.Pair<Long, Long> queryCanonicalId = queryObject.getCanonicalQueryId();
        Path canonicalToIdBinding = new Path(this._hdfsQueryHistoryDir, QueryController.canonicalIdAndQueryIdToFilename(queryCanonicalId, queryObject.getQueryId()));
        if (!this._remoteFS.exists(canonicalToIdBinding)) {
            LOG.info((Object)("Binding CanonicalQuery Id:[" + queryCanonicalId.e0 + ":" + queryCanonicalId.e1 + "] to QueryId:" + queryObject.getQueryId() + " via path:" + canonicalToIdBinding));
            this._remoteFS.createNewFile(canonicalToIdBinding);
        }
    }

    private void potentiallyStartNextQuery() throws IOException {
        FileSystem fileSystem = this._remoteFS;
        if (this._queuedClientQueries.size() != 0) {
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>(this._queuedClientQueries);
            for (QueryRequest request : requests) {
                int localDispatchSlotsAvail = this._maxConcurrentQueries - this._activeLocalQueries.size();
                int remoteDispatchSlotsAvail = this._maxConcurrentQueries - this._activeLocalQueries.size();
                try {
                    if (this._activeRemoteOrLocalQueries.get(request.getSourceQuery().getQueryId()) != null) continue;
                    ArrayList<QueryInputSplit> requiredSplits = new ArrayList<QueryInputSplit>();
                    if (request.getSourceQuery().cachedResultsAvailable(fileSystem, this._conf, request.getClientQueryInfo())) {
                        this._queuedClientQueries.remove(request);
                        this.publishBindings(request.getSourceQuery());
                        LOG.info((Object)("Running Cache Query for Query:" + request.getSourceQuery().getQueryId()));
                        this.runCacheQuery(request);
                        continue;
                    }
                    if (request.getSourceQuery().requiresShardedQuery(fileSystem, this._conf, this, request, this.getHost().getShardCountForQuery(request.getSourceQuery()), requiredSplits)) {
                        if (remoteDispatchSlotsAvail == 0) continue;
                        this._queuedClientQueries.remove();
                        if (requiredSplits.size() == 0) {
                            LOG.error((Object)("Query:" + request.getSourceQuery().getQueryId() + " FAILED WITH EMPTY REQUIRED SHARDS LIST"));
                            throw new IOException("Empty Host List prior to remoteDispath!");
                        }
                        request.getSourceQuery().setSplits(requiredSplits);
                        this._activeRemoteQueries.add(request);
                        this._activeRemoteOrLocalQueries.put(request.getSourceQuery().getQueryId(), request);
                        LOG.info((Object)("Running Remote Query for Query:" + request.getSourceQuery().getQueryId()));
                        this.runRemoteQuery(fileSystem, request);
                        continue;
                    }
                    if (localDispatchSlotsAvail == 0) continue;
                    this._queuedClientQueries.remove(request);
                    this._activeLocalQueries.add(request);
                    this._activeRemoteOrLocalQueries.put(request.getSourceQuery().getQueryId(), request);
                    LOG.info((Object)("Running Local Query for Query:" + request.getSourceQuery().getQueryId()));
                    this.runLocalQuery(request);
                }
                catch (IOException e) {
                    this._queuedClientQueries.remove(request);
                    LOG.error((Object)("Client Request:" + request.getClientQueryInfo().getClientQueryId() + " Failed with Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    request.getCompletionCallback().queryFailed(request, CCStringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    private void deactivateRequest(QueryRequest request, QueryRequest.RunState newRunState) {
        LOG.info((Object)("DeActivating Query:" + request.getSourceQuery().getQueryId() + " RunState:" + request.getRunState().toString()));
        QueryRequest.RunState lastRunState = request.getRunState();
        request.setRunState(newRunState);
        this._activeRemoteOrLocalQueries.remove(request.getSourceQuery().getQueryId());
        boolean requeue = false;
        if (lastRunState == QueryRequest.RunState.RUNNING_REMOTE || lastRunState == QueryRequest.RunState.RUNNING_LOCAL || lastRunState == QueryRequest.RunState.ERROR) {
            this._activeRemoteOrLocalQueries.remove(request.getSourceQuery().getQueryId());
            if (lastRunState == QueryRequest.RunState.RUNNING_REMOTE) {
                this._activeRemoteQueries.remove(request);
            } else if (lastRunState == QueryRequest.RunState.RUNNING_LOCAL) {
                this._activeLocalQueries.remove(request);
            }
            if (request.getRunState() == QueryRequest.RunState.IDLE) {
                LOG.info((Object)("Marking Query:" + request.getSourceQuery().getQueryId() + " SeqNo:" + request.getSequenceNo() + " for Requeue"));
                requeue = true;
            }
        }
        Path hdfsQueryTempDir = new Path(request.getSourceQuery().getCommonQueryInfo().getQueryTempPath());
        File queryTempFile = this.getTempDirForQuery(request.getSourceQuery().getQueryId());
        LOG.info((Object)("** Deleting Temp File for Query:" + request.getSourceQuery().getQueryId() + " At:" + queryTempFile.getAbsolutePath()));
        FileUtils.recursivelyDeleteFile(queryTempFile);
        LOG.info((Object)("** Deleting HDFS Temp Dir:" + hdfsQueryTempDir + " for Query:" + request.getSourceQuery().getQueryId()));
        try {
            this._remoteFS.delete(hdfsQueryTempDir, true);
        }
        catch (IOException e1) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e1));
        }
        if (request.getRunState() == QueryRequest.RunState.ERROR) {
            Path hdfsWorkingDir = new Path(request.getSourceQuery().getCommonQueryInfo().getQueryResultPath());
            LOG.info((Object)("** Query FAILED. Deleting HDFS Working Dir:" + hdfsWorkingDir + " for Query:" + request.getSourceQuery().getQueryId()));
            try {
                this._remoteFS.delete(hdfsWorkingDir, true);
            }
            catch (IOException e1) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e1));
            }
        }
        if (requeue && request.getRunState() == QueryRequest.RunState.IDLE) {
            LOG.info((Object)("ReQueueing Query:" + request.getSourceQuery().getQueryId() + " SeqNo:" + request.getSequenceNo()));
            this._queuedClientQueries.add(request);
        }
        try {
            LOG.info((Object)"** Restarting Next Query");
            this.potentiallyStartNextQuery();
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    private void requeueRequest(QueryRequest request) {
        this.deactivateRequest(request, QueryRequest.RunState.IDLE);
    }

    private void runRemoteQuery(final FileSystem remoteFileSystem, final QueryRequest request) {
        request.setRunState(QueryRequest.RunState.RUNNING_REMOTE);
        request.getQueryStatus().setProgress(0.0f);
        try {
            request.getSourceQuery().startShardedQuery(this, request, request.getSourceQuery().getSplits(), new QueryProgressCallback(){

                public boolean updateProgress(Query theQueryObject, float percentComplete) {
                    LOG.info((Object)("Got updateProgress callback for:" + theQueryObject.getQueryId()));
                    return true;
                }
            }, new RemoteQueryCompletionCallback(){

                public void queryComplete(Query query, long resultCount) {
                    LOG.info((Object)("Recevied QueryComplete for Query:" + request.getSourceQuery().getQueryId()));
                    try {
                        query.shardedQueryComplete(remoteFileSystem, QueryController.this._conf, request, resultCount);
                        if (resultCount > 0L) {
                            LOG.info((Object)("Remote Query:" + request.getSourceQuery().getQueryId() + " returned:" + resultCount + " results"));
                            QueryController.this.requeueRequest((QueryRequest)query.getContextObject());
                        } else {
                            LOG.info((Object)("Query:" + request.getSourceQuery().getQueryId() + " returned zero results"));
                            QueryController.this.deactivateRequest(request, QueryRequest.RunState.ERROR);
                            QueryResult result = new QueryResult();
                            result.setTotalRecordCount(0L);
                            request.getCompletionCallback().queryComplete(request, result);
                            LOG.info((Object)("Query:" + request.getSourceQuery().getQueryId() + " DONE DUDE"));
                        }
                    }
                    catch (IOException e) {
                        String error = "Query: " + request.getSourceQuery().getQueryId() + " Failed with Exception:" + CCStringUtils.stringifyException((Throwable)e);
                        LOG.error((Object)error);
                        QueryController.this.deactivateRequest((QueryRequest)query.getContextObject(), QueryRequest.RunState.ERROR);
                        request.getCompletionCallback().queryFailed(request, error);
                    }
                }

                public void queryFailed(Query query, String reason) {
                    LOG.info((Object)("Recevied QueryFailed for Query:" + request.getSourceQuery().getQueryId() + " Reason:" + reason));
                    query.shardedQueryFailed(remoteFileSystem);
                    QueryController.this.deactivateRequest((QueryRequest)query.getContextObject(), QueryRequest.RunState.ERROR);
                    request.getCompletionCallback().queryFailed(request, reason);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            this.deactivateRequest(request, QueryRequest.RunState.ERROR);
            request.getCompletionCallback().queryFailed(request, CCStringUtils.stringifyException((Throwable)e));
        }
    }

    private void runLocalQuery(final QueryRequest request) {
        request.setRunState(QueryRequest.RunState.RUNNING_LOCAL);
        request.getSourceQuery().startLocalQuery(this._remoteFS, this._conf, this.getTempDirForQuery(request.getSourceQuery().getQueryId()), this.getHost().getEventLoop(), request, new RemoteQueryCompletionCallback(){

            public void queryComplete(Query query, long resultCount) {
                LOG.info((Object)("Recevied QueryComplete for Query:" + request.getSourceQuery().getQueryId()));
                if (resultCount > 0L) {
                    LOG.info((Object)("Local Query:" + request.getSourceQuery().getQueryId() + " returned:" + resultCount + " results"));
                    QueryController.this.requeueRequest((QueryRequest)query.getContextObject());
                } else {
                    LOG.info((Object)("Query:" + request.getSourceQuery().getQueryId() + " returned zero results"));
                    QueryController.this.deactivateRequest((QueryRequest)query.getContextObject(), QueryRequest.RunState.ERROR);
                    QueryResult result = new QueryResult();
                    result.setTotalRecordCount(0L);
                    request.getCompletionCallback().queryComplete(request, result);
                    LOG.info((Object)("Query:" + request.getSourceQuery().getQueryId() + " DONE DUDE"));
                }
            }

            public void queryFailed(Query query, String reason) {
                LOG.info((Object)("Recevied QueryFailed for Query:" + request.getSourceQuery().getQueryId() + " Reason:" + reason));
                QueryController.this.deactivateRequest((QueryRequest)query.getContextObject(), QueryRequest.RunState.ERROR);
                request.getCompletionCallback().queryFailed(request, reason);
            }
        });
    }

    private void runCacheQuery(QueryRequest request) {
        request.setRunState(QueryRequest.RunState.RUNNING_CACHE);
        request.getSourceQuery().startCacheQuery(this, this._remoteFS, this._conf, this.getHost().getEventLoop(), request, new QueryCompletionCallback(){

            public void queryComplete(QueryRequest request, QueryResult queryResult) {
                QueryController.this.deactivateRequest(request, QueryRequest.RunState.IDLE);
                request.getCompletionCallback().queryComplete(request, queryResult);
            }

            public void queryFailed(QueryRequest request, String reason) {
                QueryController.this.deactivateRequest(request, QueryRequest.RunState.ERROR);
                request.getCompletionCallback().queryFailed(request, reason);
            }
        });
    }

    private static String canonicalIdAndQueryIdToFilename(Tuples.Pair<Long, Long> canonicalId, long queryId) {
        return QueryController.canonicalIdToString(canonicalId) + "-" + Long.toString(queryId);
    }

    private static String canonicalIdToString(Tuples.Pair<Long, Long> canonicalId) {
        return Long.toHexString((Long)canonicalId.e0) + "-" + Long.toHexString((Long)canonicalId.e1);
    }

    private static long getTimestampFromQueryPathString(String encodedQueryFilename) {
        return Long.parseLong(encodedQueryFilename.substring(encodedQueryFilename.lastIndexOf("-") + 1));
    }

    private static String getCanonicalIdFromPathString(String encodedQueryFilename) {
        return encodedQueryFilename.substring(0, encodedQueryFilename.lastIndexOf("-"));
    }

    private Path persistentQueryInfoToPath(PersistentQueryInfo queryInfo) {
        return new Path(this._hdfsQueryHistoryDir, queryInfo.getCannonicalQueryId() + "-" + queryInfo.getQueryId());
    }

    private PersistentQueryInfo getPersistentQueryInfo(Tuples.Pair<Long, Long> queryCanonicalId, long maxAge) throws IOException {
        Path searchPattern = new Path(this._hdfsQueryHistoryDir, QueryController.canonicalIdToString(queryCanonicalId) + "-*");
        FileStatus[] matches = this._remoteFS.globStatus(searchPattern);
        FileStatus bestMatch = null;
        for (FileStatus match : matches) {
            if (bestMatch == null) {
                bestMatch = match;
                continue;
            }
            long bestMatchTS = QueryController.getTimestampFromQueryPathString(bestMatch.getPath().getName());
            long matchTS = QueryController.getTimestampFromQueryPathString(match.getPath().getName());
            if (matchTS <= bestMatchTS) continue;
            bestMatch = match;
        }
        if (bestMatch != null) {
            PersistentQueryInfo queryInfo = new PersistentQueryInfo();
            queryInfo.setCannonicalQueryId(QueryController.getCanonicalIdFromPathString(bestMatch.getPath().getName()));
            queryInfo.setQueryId(QueryController.getTimestampFromQueryPathString(bestMatch.getPath().getName()));
            if (System.currentTimeMillis() - queryInfo.getQueryId() < maxAge) {
                return queryInfo;
            }
        }
        return null;
    }

    private File getTempDirForQuery(long queryId) {
        return new File(this._localTempDir, Long.toString(queryId));
    }

    public void renderQueueStats(final JsonWriter jsonWriter) throws IOException {
        EventLoop eventLoop = this.getHost().getEventLoop();
        final AtomicReference exceptionRef = new AtomicReference();
        if (Thread.currentThread() != eventLoop.getEventThread()) {
            final Semaphore semaphore = new Semaphore(0);
            eventLoop.queueAsyncCallback(new Callbacks.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() {
                    try {
                        try {
                            QueryController.this.renderQueueStatsInternal(jsonWriter);
                        }
                        catch (IOException e) {
                            exceptionRef.set(e);
                            Object var3_2 = null;
                            semaphore.release();
                        }
                        Object var3_1 = null;
                        semaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        semaphore.release();
                        throw throwable;
                    }
                }
            });
            semaphore.acquireUninterruptibly();
            if (exceptionRef.get() != null) {
                throw (IOException)exceptionRef.get();
            }
        } else {
            this.renderQueueStatsInternal(jsonWriter);
        }
    }

    private void renderQueueStatsInternal(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.name("pending").beginArray();
        for (QueryRequest request : this._queuedClientQueries) {
            writer.beginObject();
            writer.name("id:").value(request.getSourceQuery().getQueryId());
            writer.name("state").value(request.getRunState().toString());
            writer.name("pctComplete").value((double)request.getQueryStatus().getProgress());
            writer.name("type").value(request.getSourceQuery().getQueryDomainId());
            writer.name("params").value(request.getSourceQuery().getUniqueQueryParameters());
            writer.endObject();
        }
        writer.endArray();
        writer.name("running").beginArray();
        for (QueryRequest request : this._activeRemoteOrLocalQueries.values()) {
            writer.beginObject();
            writer.name("id:").value(request.getSourceQuery().getQueryId());
            writer.name("state").value(request.getRunState().toString());
            writer.name("pctComplete").value((double)request.getQueryStatus().getProgress());
            writer.name("type").value(request.getSourceQuery().getQueryDomainId());
            writer.name("params").value(request.getSourceQuery().getUniqueQueryParameters());
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlockingQueryResult<KeyType, ValueType> {
        public boolean querySucceeded = false;
        public QueryResult<KeyType, ValueType> resultObject;
        public String errorString;

        public BlockingQueryResult(QueryResult<KeyType, ValueType> resultObject) {
            this.querySucceeded = true;
            this.resultObject = resultObject;
        }

        public BlockingQueryResult(String failureReason) {
            this.querySucceeded = false;
            this.errorString = failureReason;
        }
    }
}

