/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.query.QueryInputSplit;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCommon
extends RPCStruct<QueryCommon>
implements Writable {
    public static final int Field_QUERYID = 1;
    public static final int Field_QUERYRESULTPATH = 2;
    public static final int Field_QUERYTEMPPATH = 3;
    public static final int Field_RELEVANTSPLITS = 5;
    static final int FieldID_MAX = 5;
    private BitSet __validFields = new BitSet(6);
    private long queryId;
    private TextBytes queryResultPath = new TextBytes();
    private TextBytes queryTempPath = new TextBytes();
    private ArrayList<QueryInputSplit> relevantSplits = new ArrayList();

    public static QueryCommon newInstance(Configuration conf) {
        return (QueryCommon)ReflectionUtils.newInstance(QueryCommon.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final QueryCommon setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final QueryCommon setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public QueryCommon setQueryId(long queryId) {
        this.__validFields.set(1);
        this.queryId = queryId;
        return this;
    }

    public TextBytes getQueryResultPathAsTextBytes() {
        return this.queryResultPath;
    }

    public String getQueryResultPath() {
        return this.queryResultPath.toString();
    }

    public QueryCommon setQueryResultPath(String queryResultPath) {
        this.__validFields.set(2);
        this.queryResultPath.set(queryResultPath);
        return this;
    }

    public TextBytes getQueryTempPathAsTextBytes() {
        return this.queryTempPath;
    }

    public String getQueryTempPath() {
        return this.queryTempPath.toString();
    }

    public QueryCommon setQueryTempPath(String queryTempPath) {
        this.__validFields.set(3);
        this.queryTempPath.set(queryTempPath);
        return this;
    }

    public ArrayList<QueryInputSplit> getRelevantSplits() {
        return this.relevantSplits;
    }

    public QueryCommon setRelevantSplits(ArrayList<QueryInputSplit> relevantSplits) {
        this.__validFields.set(5);
        this.relevantSplits = relevantSplits;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.relevantSplits.size() != 0;
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "queryId", 1);
            encoder.writeLong(output, this.queryId);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "queryResultPath", 2);
            encoder.writeTextBytes(output, this.queryResultPath);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "queryTempPath", 3);
            encoder.writeTextBytes(output, this.queryTempPath);
        }
        if (this.relevantSplits.size() != 0) {
            this.__validFields.set(5);
            encoder.beginField(output, "relevantSplits", 5);
            int len1 = this.relevantSplits.size();
            encoder.writeInt(output, len1);
            for (int vidx1 = 0; vidx1 < len1; ++vidx1) {
                QueryInputSplit e1 = this.relevantSplits.get(vidx1);
                e1.serialize(output, encoder);
            }
        } else {
            this.__validFields.clear(5);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.queryId = decoder.readLong(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    decoder.readTextBytes(input, this.queryResultPath);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.queryTempPath);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    int itemCount1 = decoder.readInt(input);
                    this.relevantSplits = new ArrayList();
                    for (int i1 = 0; i1 < itemCount1; ++i1) {
                        QueryInputSplit e1 = new QueryInputSplit();
                        e1.deserialize(input, decoder);
                        this.relevantSplits.add(e1);
                    }
                    break;
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.queryId = 0L;
        this.queryResultPath.clear();
        this.queryTempPath.clear();
        this.relevantSplits.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof QueryCommon)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        QueryCommon peer = (QueryCommon)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.queryId == peer.queryId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(2) && !(ret = this.queryResultPath.equals(peer.queryResultPath))) {
            return ret;
        }
        if (this.__validFields.get(3) && !(ret = this.queryTempPath.equals(peer.queryTempPath))) {
            return ret;
        }
        if (this.relevantSplits.size() != 0 && !(ret = this.relevantSplits.equals(peer.relevantSplits))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        QueryCommon other = new QueryCommon();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.queryId = this.queryId;
        }
        if (this.__validFields.get(2)) {
            other.queryResultPath = (TextBytes)this.queryResultPath.clone();
        }
        if (this.__validFields.get(3)) {
            other.queryTempPath = (TextBytes)this.queryTempPath.clone();
        }
        other.relevantSplits = new ArrayList();
        int len0 = this.relevantSplits.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            QueryInputSplit src0 = this.relevantSplits.get(vidx0);
            QueryInputSplit tgt0 = (QueryInputSplit)src0.clone();
            other.relevantSplits.add(tgt0);
        }
        return other;
    }

    @Override
    public final void merge(QueryCommon peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.queryId = peer.queryId;
        }
        if (peer.__validFields.get(2)) {
            this.queryResultPath = (TextBytes)peer.queryResultPath.clone();
        }
        if (peer.__validFields.get(3)) {
            this.queryTempPath = (TextBytes)peer.queryTempPath.clone();
        }
        int len0 = peer.relevantSplits.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            QueryInputSplit src0 = peer.relevantSplits.get(vidx0);
            QueryInputSplit tgt0 = (QueryInputSplit)src0.clone();
            this.relevantSplits.add(tgt0);
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.queryId, result);
        result = MurmurHash.hash(this.queryResultPath.getBytes(), this.queryResultPath.getOffset(), this.queryResultPath.getLength(), result);
        result = MurmurHash.hash(this.queryTempPath.getBytes(), this.queryTempPath.getOffset(), this.queryTempPath.getLength(), result);
        result = MurmurHash.hashInt(this.relevantSplits.hashCode(), result);
        return result;
    }
}

