/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStructWithId;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentQueryInfo
extends RPCStructWithId<PersistentQueryInfo>
implements Writable {
    public static final int Field_QUERYID = 1;
    public static final int Field_CANNONICALQUERYID = 3;
    static final int FieldID_MAX = 3;
    private BitSet __validFields = new BitSet(4);
    private long queryId;
    private TextBytes cannonicalQueryId = new TextBytes();

    public static PersistentQueryInfo newInstance(Configuration conf) {
        return (PersistentQueryInfo)ReflectionUtils.newInstance(PersistentQueryInfo.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final PersistentQueryInfo setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final PersistentQueryInfo setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public PersistentQueryInfo setQueryId(long queryId) {
        this.__validFields.set(1);
        this.queryId = queryId;
        return this;
    }

    public TextBytes getCannonicalQueryIdAsTextBytes() {
        return this.cannonicalQueryId;
    }

    public String getCannonicalQueryId() {
        return this.cannonicalQueryId.toString();
    }

    public PersistentQueryInfo setCannonicalQueryId(String cannonicalQueryId) {
        this.__validFields.set(3);
        this.cannonicalQueryId.set(cannonicalQueryId);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "queryId", 1);
            encoder.writeLong(output, this.queryId);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "cannonicalQueryId", 3);
            encoder.writeTextBytes(output, this.cannonicalQueryId);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.queryId = decoder.readLong(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.cannonicalQueryId);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    @Override
    public final void clear() {
        super.clear();
        this.__validFields.clear();
        this.queryId = 0L;
        this.cannonicalQueryId.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof PersistentQueryInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        PersistentQueryInfo peer = (PersistentQueryInfo)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.queryId == peer.queryId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3) && !(ret = this.cannonicalQueryId.equals(peer.cannonicalQueryId))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        PersistentQueryInfo other = new PersistentQueryInfo();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.queryId = this.queryId;
        }
        if (this.__validFields.get(3)) {
            other.cannonicalQueryId = (TextBytes)this.cannonicalQueryId.clone();
        }
        return other;
    }

    @Override
    public final void merge(PersistentQueryInfo peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.queryId = peer.queryId;
        }
        if (peer.__validFields.get(3)) {
            this.cannonicalQueryId = (TextBytes)peer.cannonicalQueryId.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.queryId, result);
        result = MurmurHash.hash(this.cannonicalQueryId.getBytes(), this.cannonicalQueryId.getOffset(), this.cannonicalQueryId.getLength(), result);
        return result;
    }
}

