/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientQueryInfo
extends RPCStruct<ClientQueryInfo>
implements Writable {
    public static final int Field_CLIENTQUERYID = 1;
    public static final int Field_SORTBYFIELD = 3;
    public static final int Field_SORTORDER = 4;
    public static final int Field_PAGINATIONOFFSET = 5;
    public static final int Field_PAGESIZE = 6;
    public static final int Field_MAXAGE = 7;
    static final int FieldID_MAX = 7;
    private BitSet __validFields = new BitSet(8);
    private long clientQueryId;
    private TextBytes sortByField = new TextBytes();
    private int sortOrder;
    private int paginationOffset;
    private int pageSize;
    private long maxAge;

    public static ClientQueryInfo newInstance(Configuration conf) {
        return (ClientQueryInfo)ReflectionUtils.newInstance(ClientQueryInfo.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ClientQueryInfo setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ClientQueryInfo setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public long getClientQueryId() {
        return this.clientQueryId;
    }

    public ClientQueryInfo setClientQueryId(long clientQueryId) {
        this.__validFields.set(1);
        this.clientQueryId = clientQueryId;
        return this;
    }

    public TextBytes getSortByFieldAsTextBytes() {
        return this.sortByField;
    }

    public String getSortByField() {
        return this.sortByField.toString();
    }

    public ClientQueryInfo setSortByField(String sortByField) {
        this.__validFields.set(3);
        this.sortByField.set(sortByField);
        return this;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public ClientQueryInfo setSortOrder(int sortOrder) {
        this.__validFields.set(4);
        this.sortOrder = sortOrder;
        return this;
    }

    public int getPaginationOffset() {
        return this.paginationOffset;
    }

    public ClientQueryInfo setPaginationOffset(int paginationOffset) {
        this.__validFields.set(5);
        this.paginationOffset = paginationOffset;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ClientQueryInfo setPageSize(int pageSize) {
        this.__validFields.set(6);
        this.pageSize = pageSize;
        return this;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public ClientQueryInfo setMaxAge(long maxAge) {
        this.__validFields.set(7);
        this.maxAge = maxAge;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "clientQueryId", 1);
            encoder.writeLong(output, this.clientQueryId);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "sortByField", 3);
            encoder.writeTextBytes(output, this.sortByField);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "sortOrder", 4);
            encoder.writeInt(output, this.sortOrder);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "paginationOffset", 5);
            encoder.writeInt(output, this.paginationOffset);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "pageSize", 6);
            encoder.writeInt(output, this.pageSize);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "maxAge", 7);
            encoder.writeLong(output, this.maxAge);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.clientQueryId = decoder.readLong(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.sortByField);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.sortOrder = decoder.readInt(input);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.paginationOffset = decoder.readInt(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    this.pageSize = decoder.readInt(input);
                    break;
                }
                case 7: {
                    this.__validFields.set(7);
                    this.maxAge = decoder.readLong(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.clientQueryId = 0L;
        this.sortByField.clear();
        this.sortOrder = 0;
        this.paginationOffset = 0;
        this.pageSize = 0;
        this.maxAge = 0L;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ClientQueryInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ClientQueryInfo peer = (ClientQueryInfo)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.clientQueryId == peer.clientQueryId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3) && !(ret = this.sortByField.equals(peer.sortByField))) {
            return ret;
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.sortOrder == peer.sortOrder;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.paginationOffset == peer.paginationOffset;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(6)) {
            boolean bl = ret = this.pageSize == peer.pageSize;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(7)) {
            boolean bl = ret = this.maxAge == peer.maxAge;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ClientQueryInfo other = new ClientQueryInfo();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.clientQueryId = this.clientQueryId;
        }
        if (this.__validFields.get(3)) {
            other.sortByField = (TextBytes)this.sortByField.clone();
        }
        if (this.__validFields.get(4)) {
            other.sortOrder = this.sortOrder;
        }
        if (this.__validFields.get(5)) {
            other.paginationOffset = this.paginationOffset;
        }
        if (this.__validFields.get(6)) {
            other.pageSize = this.pageSize;
        }
        if (this.__validFields.get(7)) {
            other.maxAge = this.maxAge;
        }
        return other;
    }

    @Override
    public final void merge(ClientQueryInfo peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.clientQueryId = peer.clientQueryId;
        }
        if (peer.__validFields.get(3)) {
            this.sortByField = (TextBytes)peer.sortByField.clone();
        }
        if (peer.__validFields.get(4)) {
            this.sortOrder = peer.sortOrder;
        }
        if (peer.__validFields.get(5)) {
            this.paginationOffset = peer.paginationOffset;
        }
        if (peer.__validFields.get(6)) {
            this.pageSize = peer.pageSize;
        }
        if (peer.__validFields.get(7)) {
            this.maxAge = peer.maxAge;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.clientQueryId, result);
        result = MurmurHash.hash(this.sortByField.getBytes(), this.sortByField.getOffset(), this.sortByField.getLength(), result);
        result = MurmurHash.hashInt(this.sortOrder, result);
        result = MurmurHash.hashInt(this.paginationOffset, result);
        result = MurmurHash.hashInt(this.pageSize, result);
        result = MurmurHash.hashLong(this.maxAge, result);
        return result;
    }

    public static final class SortOrder {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 0: {
                    return "ASCENDING";
                }
                case 1: {
                    return "DESCENDING";
                }
            }
            return "";
        }
    }
}

