/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFPV2
extends RPCStruct<URLFPV2>
implements WritableComparable {
    public static final int Field_DOMAINHASH = 1;
    public static final int Field_URLHASH = 2;
    public static final int Field_ROOTDOMAINHASH = 3;
    static final int FieldID_MAX = 3;
    private long domainHash;
    private long urlHash;
    private long rootDomainHash;

    public static URLFPV2 newInstance(Configuration conf) {
        return (URLFPV2)ReflectionUtils.newInstance(URLFPV2.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public int compareTo(Object other) {
        int result = Long.valueOf(this.domainHash).compareTo(((URLFPV2)other).domainHash);
        if (result == 0) {
            result = Long.valueOf(this.urlHash).compareTo(((URLFPV2)other).urlHash);
        }
        return result;
    }

    @Override
    public String getKey() {
        return "domainHash_" + Long.valueOf(this.domainHash).toString() + "_" + "urlHash_" + Long.valueOf(this.urlHash).toString();
    }

    public final boolean isFieldDirty(int fieldId) {
        return true;
    }

    public final URLFPV2 setFieldDirty(int fieldId) {
        return this;
    }

    public final URLFPV2 setFieldClean(int fieldId) {
        return this;
    }

    public long getDomainHash() {
        return this.domainHash;
    }

    public URLFPV2 setDomainHash(long domainHash) {
        this.domainHash = domainHash;
        return this;
    }

    public long getUrlHash() {
        return this.urlHash;
    }

    public URLFPV2 setUrlHash(long urlHash) {
        this.urlHash = urlHash;
        return this;
    }

    public long getRootDomainHash() {
        return this.rootDomainHash;
    }

    public URLFPV2 setRootDomainHash(long rootDomainHash) {
        this.rootDomainHash = rootDomainHash;
        return this;
    }

    public final boolean isObjectDirty() {
        return true;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        encoder.beginField(output, "domainHash", 1);
        encoder.writeVLong(output, this.domainHash);
        encoder.beginField(output, "urlHash", 2);
        encoder.writeVLong(output, this.urlHash);
        encoder.beginField(output, "rootDomainHash", 3);
        encoder.writeVLong(output, this.rootDomainHash);
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.domainHash = decoder.readVLong(input);
                    break;
                }
                case 2: {
                    this.urlHash = decoder.readVLong(input);
                    break;
                }
                case 3: {
                    this.rootDomainHash = decoder.readVLong(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.domainHash = 0L;
        this.urlHash = 0L;
        this.rootDomainHash = 0L;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof URLFPV2)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        URLFPV2 peer = (URLFPV2)peer_;
        boolean ret = true;
        boolean bl = ret = this.domainHash == peer.domainHash;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.urlHash == peer.urlHash;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.rootDomainHash == peer.rootDomainHash;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        URLFPV2 other = new URLFPV2();
        other.domainHash = this.domainHash;
        other.urlHash = this.urlHash;
        other.rootDomainHash = this.rootDomainHash;
        return other;
    }

    @Override
    public final void merge(URLFPV2 peer) throws CloneNotSupportedException {
        this.domainHash = peer.domainHash;
        this.urlHash = peer.urlHash;
        this.rootDomainHash = peer.rootDomainHash;
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.domainHash, result);
        result = MurmurHash.hashLong(this.urlHash, result);
        return result;
    }
}

