/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.protocol.shared.HTMLMetaTags;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcFileMetadata
extends RPCStruct<ArcFileMetadata>
implements Writable {
    public static final int Field_ARCFILENAME = 1;
    public static final int Field_DOCURL = 2;
    public static final int Field_ARCFILEOFFSET = 3;
    public static final int Field_ARCFILELENGTH = 4;
    public static final int Field_SOURCEIPADDRESS = 5;
    public static final int Field_CONTENTTYPE = 6;
    public static final int Field_CONTENTLENGTH = 7;
    public static final int Field_CHARSET = 8;
    public static final int Field_SIGNATURE = 9;
    public static final int Field_TEXTSIMHASHVALUE = 10;
    public static final int Field_FLAGS = 12;
    public static final int Field_HTTPRESPONSEFLAGS = 13;
    public static final int Field_HTTPRESULTCODE = 14;
    public static final int Field_DETECTEDCHARSET = 15;
    public static final int Field_JAVACHARSET = 16;
    public static final int Field_METATAGS = 17;
    public static final int Field_TITLETEXT = 18;
    public static final int Field_BASEURL = 20;
    public static final int Field_ANCHORTAGS = 21;
    public static final int Field_HTTPDATE = 22;
    public static final int Field_LASTMODIFIEDTIME = 23;
    public static final int Field_ETAG = 24;
    public static final int Field_MAXAGE = 25;
    public static final int Field_EXPIRES = 26;
    public static final int Field_AGE = 27;
    public static final int Field_CACHECONTROLFLAGS = 28;
    static final int FieldID_MAX = 28;
    private BitSet __validFields = new BitSet(29);
    private TextBytes arcFileName = new TextBytes();
    private TextBytes docURL = new TextBytes();
    private int arcFileOffset;
    private int arcFileLength;
    private int sourceIPAddress;
    private TextBytes contentType = new TextBytes();
    private int contentLength;
    private TextBytes charset = new TextBytes();
    private FlexBuffer signature = new FlexBuffer();
    private long textSimHashValue;
    private byte flags;
    private byte httpResponseFlags;
    private int httpResultCode;
    private TextBytes detectedCharset = new TextBytes();
    private TextBytes javaCharset = new TextBytes();
    private HTMLMetaTags metaTags = new HTMLMetaTags();
    private TextBytes titleText = new TextBytes();
    private TextBytes baseURL = new TextBytes();
    private TextBytes anchorTags = new TextBytes();
    private long httpDate;
    private long lastModifiedTime;
    private TextBytes eTag = new TextBytes();
    private long maxAge;
    private long expires;
    private long age;
    private byte cacheControlFlags;

    public static ArcFileMetadata newInstance(Configuration conf) {
        return (ArcFileMetadata)ReflectionUtils.newInstance(ArcFileMetadata.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ArcFileMetadata setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ArcFileMetadata setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getArcFileNameAsTextBytes() {
        return this.arcFileName;
    }

    public String getArcFileName() {
        return this.arcFileName.toString();
    }

    public ArcFileMetadata setArcFileName(String arcFileName) {
        this.__validFields.set(1);
        this.arcFileName.set(arcFileName);
        return this;
    }

    public TextBytes getDocURLAsTextBytes() {
        return this.docURL;
    }

    public String getDocURL() {
        return this.docURL.toString();
    }

    public ArcFileMetadata setDocURL(String docURL) {
        this.__validFields.set(2);
        this.docURL.set(docURL);
        return this;
    }

    public int getArcFileOffset() {
        return this.arcFileOffset;
    }

    public ArcFileMetadata setArcFileOffset(int arcFileOffset) {
        this.__validFields.set(3);
        this.arcFileOffset = arcFileOffset;
        return this;
    }

    public int getArcFileLength() {
        return this.arcFileLength;
    }

    public ArcFileMetadata setArcFileLength(int arcFileLength) {
        this.__validFields.set(4);
        this.arcFileLength = arcFileLength;
        return this;
    }

    public int getSourceIPAddress() {
        return this.sourceIPAddress;
    }

    public ArcFileMetadata setSourceIPAddress(int sourceIPAddress) {
        this.__validFields.set(5);
        this.sourceIPAddress = sourceIPAddress;
        return this;
    }

    public TextBytes getContentTypeAsTextBytes() {
        return this.contentType;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public ArcFileMetadata setContentType(String contentType) {
        this.__validFields.set(6);
        this.contentType.set(contentType);
        return this;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public ArcFileMetadata setContentLength(int contentLength) {
        this.__validFields.set(7);
        this.contentLength = contentLength;
        return this;
    }

    public TextBytes getCharsetAsTextBytes() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.toString();
    }

    public ArcFileMetadata setCharset(String charset) {
        this.__validFields.set(8);
        this.charset.set(charset);
        return this;
    }

    public ImmutableBuffer getSignature() {
        return new ImmutableBuffer(this.signature);
    }

    public ArcFileMetadata setSignature(FlexBuffer signature) {
        this.__validFields.set(9);
        this.signature = signature;
        return this;
    }

    public ArcFileMetadata setSignature(Buffer signature, boolean shared) {
        this.__validFields.set(9);
        this.signature = new FlexBuffer(signature.get(), 0, signature.getCount(), shared);
        return this;
    }

    public long getTextSimHashValue() {
        return this.textSimHashValue;
    }

    public ArcFileMetadata setTextSimHashValue(long textSimHashValue) {
        this.__validFields.set(10);
        this.textSimHashValue = textSimHashValue;
        return this;
    }

    public byte getFlags() {
        return this.flags;
    }

    public ArcFileMetadata setFlags(byte flags) {
        this.__validFields.set(12);
        this.flags = flags;
        return this;
    }

    public byte getHttpResponseFlags() {
        return this.httpResponseFlags;
    }

    public ArcFileMetadata setHttpResponseFlags(byte httpResponseFlags) {
        this.__validFields.set(13);
        this.httpResponseFlags = httpResponseFlags;
        return this;
    }

    public int getHttpResultCode() {
        return this.httpResultCode;
    }

    public ArcFileMetadata setHttpResultCode(int httpResultCode) {
        this.__validFields.set(14);
        this.httpResultCode = httpResultCode;
        return this;
    }

    public TextBytes getDetectedCharsetAsTextBytes() {
        return this.detectedCharset;
    }

    public String getDetectedCharset() {
        return this.detectedCharset.toString();
    }

    public ArcFileMetadata setDetectedCharset(String detectedCharset) {
        this.__validFields.set(15);
        this.detectedCharset.set(detectedCharset);
        return this;
    }

    public TextBytes getJavaCharsetAsTextBytes() {
        return this.javaCharset;
    }

    public String getJavaCharset() {
        return this.javaCharset.toString();
    }

    public ArcFileMetadata setJavaCharset(String javaCharset) {
        this.__validFields.set(16);
        this.javaCharset.set(javaCharset);
        return this;
    }

    public HTMLMetaTags getMetaTags() {
        return this.metaTags;
    }

    public ArcFileMetadata setMetaTags(HTMLMetaTags metaTags) {
        this.__validFields.set(17);
        this.metaTags = metaTags;
        return this;
    }

    public TextBytes getTitleTextAsTextBytes() {
        return this.titleText;
    }

    public String getTitleText() {
        return this.titleText.toString();
    }

    public ArcFileMetadata setTitleText(String titleText) {
        this.__validFields.set(18);
        this.titleText.set(titleText);
        return this;
    }

    public TextBytes getBaseURLAsTextBytes() {
        return this.baseURL;
    }

    public String getBaseURL() {
        return this.baseURL.toString();
    }

    public ArcFileMetadata setBaseURL(String baseURL) {
        this.__validFields.set(20);
        this.baseURL.set(baseURL);
        return this;
    }

    public TextBytes getAnchorTagsAsTextBytes() {
        return this.anchorTags;
    }

    public String getAnchorTags() {
        return this.anchorTags.toString();
    }

    public ArcFileMetadata setAnchorTags(String anchorTags) {
        this.__validFields.set(21);
        this.anchorTags.set(anchorTags);
        return this;
    }

    public long getHttpDate() {
        return this.httpDate;
    }

    public ArcFileMetadata setHttpDate(long httpDate) {
        this.__validFields.set(22);
        this.httpDate = httpDate;
        return this;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ArcFileMetadata setLastModifiedTime(long lastModifiedTime) {
        this.__validFields.set(23);
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public TextBytes getETagAsTextBytes() {
        return this.eTag;
    }

    public String getETag() {
        return this.eTag.toString();
    }

    public ArcFileMetadata setETag(String eTag) {
        this.__validFields.set(24);
        this.eTag.set(eTag);
        return this;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public ArcFileMetadata setMaxAge(long maxAge) {
        this.__validFields.set(25);
        this.maxAge = maxAge;
        return this;
    }

    public long getExpires() {
        return this.expires;
    }

    public ArcFileMetadata setExpires(long expires) {
        this.__validFields.set(26);
        this.expires = expires;
        return this;
    }

    public long getAge() {
        return this.age;
    }

    public ArcFileMetadata setAge(long age) {
        this.__validFields.set(27);
        this.age = age;
        return this;
    }

    public byte getCacheControlFlags() {
        return this.cacheControlFlags;
    }

    public ArcFileMetadata setCacheControlFlags(byte cacheControlFlags) {
        this.__validFields.set(28);
        this.cacheControlFlags = cacheControlFlags;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.metaTags.isObjectDirty();
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "arcFileName", 1);
            encoder.writeTextBytes(output, this.arcFileName);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "docURL", 2);
            encoder.writeTextBytes(output, this.docURL);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "arcFileOffset", 3);
            encoder.writeVInt(output, this.arcFileOffset);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "arcFileLength", 4);
            encoder.writeVInt(output, this.arcFileLength);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "sourceIPAddress", 5);
            encoder.writeInt(output, this.sourceIPAddress);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "contentType", 6);
            encoder.writeTextBytes(output, this.contentType);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "contentLength", 7);
            encoder.writeVInt(output, this.contentLength);
        }
        if (this.__validFields.get(8)) {
            encoder.beginField(output, "charset", 8);
            encoder.writeTextBytes(output, this.charset);
        }
        if (this.__validFields.get(9)) {
            encoder.beginField(output, "signature", 9);
            encoder.writeFlexBuffer(output, this.signature);
        }
        if (this.__validFields.get(10)) {
            encoder.beginField(output, "textSimHashValue", 10);
            encoder.writeLong(output, this.textSimHashValue);
        }
        if (this.__validFields.get(12)) {
            encoder.beginField(output, "flags", 12);
            encoder.writeByte(output, this.flags);
        }
        if (this.__validFields.get(13)) {
            encoder.beginField(output, "httpResponseFlags", 13);
            encoder.writeByte(output, this.httpResponseFlags);
        }
        if (this.__validFields.get(14)) {
            encoder.beginField(output, "httpResultCode", 14);
            encoder.writeVInt(output, this.httpResultCode);
        }
        if (this.__validFields.get(15)) {
            encoder.beginField(output, "detectedCharset", 15);
            encoder.writeTextBytes(output, this.detectedCharset);
        }
        if (this.__validFields.get(16)) {
            encoder.beginField(output, "javaCharset", 16);
            encoder.writeTextBytes(output, this.javaCharset);
        }
        if (this.metaTags.isObjectDirty()) {
            this.__validFields.set(17);
            encoder.beginField(output, "metaTags", 17);
            this.metaTags.serialize(output, encoder);
        } else {
            this.__validFields.clear(17);
        }
        if (this.__validFields.get(18)) {
            encoder.beginField(output, "titleText", 18);
            encoder.writeTextBytes(output, this.titleText);
        }
        if (this.__validFields.get(20)) {
            encoder.beginField(output, "baseURL", 20);
            encoder.writeTextBytes(output, this.baseURL);
        }
        if (this.__validFields.get(21)) {
            encoder.beginField(output, "anchorTags", 21);
            encoder.writeTextBytes(output, this.anchorTags);
        }
        if (this.__validFields.get(22)) {
            encoder.beginField(output, "httpDate", 22);
            encoder.writeVLong(output, this.httpDate);
        }
        if (this.__validFields.get(23)) {
            encoder.beginField(output, "lastModifiedTime", 23);
            encoder.writeVLong(output, this.lastModifiedTime);
        }
        if (this.__validFields.get(24)) {
            encoder.beginField(output, "eTag", 24);
            encoder.writeTextBytes(output, this.eTag);
        }
        if (this.__validFields.get(25)) {
            encoder.beginField(output, "maxAge", 25);
            encoder.writeVLong(output, this.maxAge);
        }
        if (this.__validFields.get(26)) {
            encoder.beginField(output, "expires", 26);
            encoder.writeVLong(output, this.expires);
        }
        if (this.__validFields.get(27)) {
            encoder.beginField(output, "age", 27);
            encoder.writeVLong(output, this.age);
        }
        if (this.__validFields.get(28)) {
            encoder.beginField(output, "cacheControlFlags", 28);
            encoder.writeByte(output, this.cacheControlFlags);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.arcFileName);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    decoder.readTextBytes(input, this.docURL);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    this.arcFileOffset = decoder.readVInt(input);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.arcFileLength = decoder.readVInt(input);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.sourceIPAddress = decoder.readInt(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    decoder.readTextBytes(input, this.contentType);
                    break;
                }
                case 7: {
                    this.__validFields.set(7);
                    this.contentLength = decoder.readVInt(input);
                    break;
                }
                case 8: {
                    this.__validFields.set(8);
                    decoder.readTextBytes(input, this.charset);
                    break;
                }
                case 9: {
                    this.__validFields.set(9);
                    decoder.readFlexBuffer(input, this.signature);
                    break;
                }
                case 10: {
                    this.__validFields.set(10);
                    this.textSimHashValue = decoder.readLong(input);
                    break;
                }
                case 12: {
                    this.__validFields.set(12);
                    this.flags = decoder.readByte(input);
                    break;
                }
                case 13: {
                    this.__validFields.set(13);
                    this.httpResponseFlags = decoder.readByte(input);
                    break;
                }
                case 14: {
                    this.__validFields.set(14);
                    this.httpResultCode = decoder.readVInt(input);
                    break;
                }
                case 15: {
                    this.__validFields.set(15);
                    decoder.readTextBytes(input, this.detectedCharset);
                    break;
                }
                case 16: {
                    this.__validFields.set(16);
                    decoder.readTextBytes(input, this.javaCharset);
                    break;
                }
                case 17: {
                    this.__validFields.set(17);
                    this.metaTags = new HTMLMetaTags();
                    this.metaTags.deserialize(input, decoder);
                    break;
                }
                case 18: {
                    this.__validFields.set(18);
                    decoder.readTextBytes(input, this.titleText);
                    break;
                }
                case 20: {
                    this.__validFields.set(20);
                    decoder.readTextBytes(input, this.baseURL);
                    break;
                }
                case 21: {
                    this.__validFields.set(21);
                    decoder.readTextBytes(input, this.anchorTags);
                    break;
                }
                case 22: {
                    this.__validFields.set(22);
                    this.httpDate = decoder.readVLong(input);
                    break;
                }
                case 23: {
                    this.__validFields.set(23);
                    this.lastModifiedTime = decoder.readVLong(input);
                    break;
                }
                case 24: {
                    this.__validFields.set(24);
                    decoder.readTextBytes(input, this.eTag);
                    break;
                }
                case 25: {
                    this.__validFields.set(25);
                    this.maxAge = decoder.readVLong(input);
                    break;
                }
                case 26: {
                    this.__validFields.set(26);
                    this.expires = decoder.readVLong(input);
                    break;
                }
                case 27: {
                    this.__validFields.set(27);
                    this.age = decoder.readVLong(input);
                    break;
                }
                case 28: {
                    this.__validFields.set(28);
                    this.cacheControlFlags = decoder.readByte(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.arcFileName.clear();
        this.docURL.clear();
        this.arcFileOffset = 0;
        this.arcFileLength = 0;
        this.sourceIPAddress = 0;
        this.contentType.clear();
        this.contentLength = 0;
        this.charset.clear();
        this.signature.reset();
        this.textSimHashValue = 0L;
        this.flags = 0;
        this.httpResponseFlags = 0;
        this.httpResultCode = 0;
        this.detectedCharset.clear();
        this.javaCharset.clear();
        this.metaTags.clear();
        this.titleText.clear();
        this.baseURL.clear();
        this.anchorTags.clear();
        this.httpDate = 0L;
        this.lastModifiedTime = 0L;
        this.eTag.clear();
        this.maxAge = 0L;
        this.expires = 0L;
        this.age = 0L;
        this.cacheControlFlags = 0;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ArcFileMetadata)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ArcFileMetadata peer = (ArcFileMetadata)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.arcFileName.equals(peer.arcFileName))) {
            return ret;
        }
        if (this.__validFields.get(2) && !(ret = this.docURL.equals(peer.docURL))) {
            return ret;
        }
        if (this.__validFields.get(3)) {
            boolean bl = ret = this.arcFileOffset == peer.arcFileOffset;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.arcFileLength == peer.arcFileLength;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.sourceIPAddress == peer.sourceIPAddress;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(6) && !(ret = this.contentType.equals(peer.contentType))) {
            return ret;
        }
        if (this.__validFields.get(7)) {
            boolean bl = ret = this.contentLength == peer.contentLength;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(8) && !(ret = this.charset.equals(peer.charset))) {
            return ret;
        }
        if (this.__validFields.get(9) && !(ret = this.signature.equals(peer.signature))) {
            return ret;
        }
        if (this.__validFields.get(10)) {
            boolean bl = ret = this.textSimHashValue == peer.textSimHashValue;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(12)) {
            boolean bl = ret = this.flags == peer.flags;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(13)) {
            boolean bl = ret = this.httpResponseFlags == peer.httpResponseFlags;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(14)) {
            boolean bl = ret = this.httpResultCode == peer.httpResultCode;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(15) && !(ret = this.detectedCharset.equals(peer.detectedCharset))) {
            return ret;
        }
        if (this.__validFields.get(16) && !(ret = this.javaCharset.equals(peer.javaCharset))) {
            return ret;
        }
        if (this.metaTags.isObjectDirty() && !(ret = this.metaTags.equals(peer.metaTags))) {
            return ret;
        }
        if (this.__validFields.get(18) && !(ret = this.titleText.equals(peer.titleText))) {
            return ret;
        }
        if (this.__validFields.get(20) && !(ret = this.baseURL.equals(peer.baseURL))) {
            return ret;
        }
        if (this.__validFields.get(21) && !(ret = this.anchorTags.equals(peer.anchorTags))) {
            return ret;
        }
        if (this.__validFields.get(22)) {
            boolean bl = ret = this.httpDate == peer.httpDate;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(23)) {
            boolean bl = ret = this.lastModifiedTime == peer.lastModifiedTime;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(24) && !(ret = this.eTag.equals(peer.eTag))) {
            return ret;
        }
        if (this.__validFields.get(25)) {
            boolean bl = ret = this.maxAge == peer.maxAge;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(26)) {
            boolean bl = ret = this.expires == peer.expires;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(27)) {
            boolean bl = ret = this.age == peer.age;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(28)) {
            boolean bl = ret = this.cacheControlFlags == peer.cacheControlFlags;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ArcFileMetadata other = new ArcFileMetadata();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.arcFileName = (TextBytes)this.arcFileName.clone();
        }
        if (this.__validFields.get(2)) {
            other.docURL = (TextBytes)this.docURL.clone();
        }
        if (this.__validFields.get(3)) {
            other.arcFileOffset = this.arcFileOffset;
        }
        if (this.__validFields.get(4)) {
            other.arcFileLength = this.arcFileLength;
        }
        if (this.__validFields.get(5)) {
            other.sourceIPAddress = this.sourceIPAddress;
        }
        if (this.__validFields.get(6)) {
            other.contentType = (TextBytes)this.contentType.clone();
        }
        if (this.__validFields.get(7)) {
            other.contentLength = this.contentLength;
        }
        if (this.__validFields.get(8)) {
            other.charset = (TextBytes)this.charset.clone();
        }
        if (this.__validFields.get(9)) {
            other.signature = (FlexBuffer)this.signature.clone();
        }
        if (this.__validFields.get(10)) {
            other.textSimHashValue = this.textSimHashValue;
        }
        if (this.__validFields.get(12)) {
            other.flags = this.flags;
        }
        if (this.__validFields.get(13)) {
            other.httpResponseFlags = this.httpResponseFlags;
        }
        if (this.__validFields.get(14)) {
            other.httpResultCode = this.httpResultCode;
        }
        if (this.__validFields.get(15)) {
            other.detectedCharset = (TextBytes)this.detectedCharset.clone();
        }
        if (this.__validFields.get(16)) {
            other.javaCharset = (TextBytes)this.javaCharset.clone();
        }
        other.metaTags = (HTMLMetaTags)this.metaTags.clone();
        if (this.__validFields.get(18)) {
            other.titleText = (TextBytes)this.titleText.clone();
        }
        if (this.__validFields.get(20)) {
            other.baseURL = (TextBytes)this.baseURL.clone();
        }
        if (this.__validFields.get(21)) {
            other.anchorTags = (TextBytes)this.anchorTags.clone();
        }
        if (this.__validFields.get(22)) {
            other.httpDate = this.httpDate;
        }
        if (this.__validFields.get(23)) {
            other.lastModifiedTime = this.lastModifiedTime;
        }
        if (this.__validFields.get(24)) {
            other.eTag = (TextBytes)this.eTag.clone();
        }
        if (this.__validFields.get(25)) {
            other.maxAge = this.maxAge;
        }
        if (this.__validFields.get(26)) {
            other.expires = this.expires;
        }
        if (this.__validFields.get(27)) {
            other.age = this.age;
        }
        if (this.__validFields.get(28)) {
            other.cacheControlFlags = this.cacheControlFlags;
        }
        return other;
    }

    @Override
    public final void merge(ArcFileMetadata peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.arcFileName = (TextBytes)peer.arcFileName.clone();
        }
        if (peer.__validFields.get(2)) {
            this.docURL = (TextBytes)peer.docURL.clone();
        }
        if (peer.__validFields.get(3)) {
            this.arcFileOffset = peer.arcFileOffset;
        }
        if (peer.__validFields.get(4)) {
            this.arcFileLength = peer.arcFileLength;
        }
        if (peer.__validFields.get(5)) {
            this.sourceIPAddress = peer.sourceIPAddress;
        }
        if (peer.__validFields.get(6)) {
            this.contentType = (TextBytes)peer.contentType.clone();
        }
        if (peer.__validFields.get(7)) {
            this.contentLength = peer.contentLength;
        }
        if (peer.__validFields.get(8)) {
            this.charset = (TextBytes)peer.charset.clone();
        }
        if (peer.__validFields.get(9)) {
            this.signature = (FlexBuffer)peer.signature.clone();
        }
        if (peer.__validFields.get(10)) {
            this.textSimHashValue = peer.textSimHashValue;
        }
        if (peer.__validFields.get(12)) {
            this.flags = peer.flags;
        }
        if (peer.__validFields.get(13)) {
            this.httpResponseFlags = peer.httpResponseFlags;
        }
        if (peer.__validFields.get(14)) {
            this.httpResultCode = peer.httpResultCode;
        }
        if (peer.__validFields.get(15)) {
            this.detectedCharset = (TextBytes)peer.detectedCharset.clone();
        }
        if (peer.__validFields.get(16)) {
            this.javaCharset = (TextBytes)peer.javaCharset.clone();
        }
        this.metaTags.merge(peer.metaTags);
        if (peer.__validFields.get(18)) {
            this.titleText = (TextBytes)peer.titleText.clone();
        }
        if (peer.__validFields.get(20)) {
            this.baseURL = (TextBytes)peer.baseURL.clone();
        }
        if (peer.__validFields.get(21)) {
            this.anchorTags = (TextBytes)peer.anchorTags.clone();
        }
        if (peer.__validFields.get(22)) {
            this.httpDate = peer.httpDate;
        }
        if (peer.__validFields.get(23)) {
            this.lastModifiedTime = peer.lastModifiedTime;
        }
        if (peer.__validFields.get(24)) {
            this.eTag = (TextBytes)peer.eTag.clone();
        }
        if (peer.__validFields.get(25)) {
            this.maxAge = peer.maxAge;
        }
        if (peer.__validFields.get(26)) {
            this.expires = peer.expires;
        }
        if (peer.__validFields.get(27)) {
            this.age = peer.age;
        }
        if (peer.__validFields.get(28)) {
            this.cacheControlFlags = peer.cacheControlFlags;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.arcFileName.getBytes(), this.arcFileName.getOffset(), this.arcFileName.getLength(), result);
        result = MurmurHash.hash(this.docURL.getBytes(), this.docURL.getOffset(), this.docURL.getLength(), result);
        result = MurmurHash.hashInt(this.arcFileOffset, result);
        result = MurmurHash.hashInt(this.arcFileLength, result);
        result = MurmurHash.hashInt(this.sourceIPAddress, result);
        result = MurmurHash.hash(this.contentType.getBytes(), this.contentType.getOffset(), this.contentType.getLength(), result);
        result = MurmurHash.hashInt(this.contentLength, result);
        result = MurmurHash.hash(this.charset.getBytes(), this.charset.getOffset(), this.charset.getLength(), result);
        result = MurmurHash.hash(this.signature.get(), this.signature.getOffset(), this.signature.getCount(), result);
        result = MurmurHash.hashLong(this.textSimHashValue, result);
        result = MurmurHash.hashInt(this.flags, result);
        result = MurmurHash.hashInt(this.httpResponseFlags, result);
        result = MurmurHash.hashInt(this.httpResultCode, result);
        result = MurmurHash.hash(this.detectedCharset.getBytes(), this.detectedCharset.getOffset(), this.detectedCharset.getLength(), result);
        result = MurmurHash.hash(this.javaCharset.getBytes(), this.javaCharset.getOffset(), this.javaCharset.getLength(), result);
        result = MurmurHash.hashInt(this.metaTags.hashCode(), result);
        result = MurmurHash.hash(this.titleText.getBytes(), this.titleText.getOffset(), this.titleText.getLength(), result);
        result = MurmurHash.hash(this.baseURL.getBytes(), this.baseURL.getOffset(), this.baseURL.getLength(), result);
        result = MurmurHash.hash(this.anchorTags.getBytes(), this.anchorTags.getOffset(), this.anchorTags.getLength(), result);
        result = MurmurHash.hashLong(this.httpDate, result);
        result = MurmurHash.hashLong(this.lastModifiedTime, result);
        result = MurmurHash.hash(this.eTag.getBytes(), this.eTag.getOffset(), this.eTag.getLength(), result);
        result = MurmurHash.hashLong(this.maxAge, result);
        result = MurmurHash.hashLong(this.expires, result);
        result = MurmurHash.hashLong(this.age, result);
        result = MurmurHash.hashInt(this.cacheControlFlags, result);
        return result;
    }

    public static final class CacheControlFlags {
        public static final int NO_CACHE = 1;
        public static final int NO_STORE = 2;
        public static final int VARY = 4;
        public static final int MUST_REVALIDATE = 8;
        public static final int PRIVATE = 16;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "NO_CACHE";
                }
                case 2: {
                    return "NO_STORE";
                }
                case 4: {
                    return "VARY";
                }
                case 8: {
                    return "MUST_REVALIDATE";
                }
                case 16: {
                    return "PRIVATE";
                }
            }
            return "";
        }
    }

    public static final class HTTPResponseFlags {
        public static final int HEADER_MISSING = 1;
        public static final int VERSION_MISSING = 2;
        public static final int VERSION_0_9 = 4;
        public static final int VERSION_1_0 = 8;
        public static final int VERSION_1_1 = 16;
        public static final int ENCODED_IS_GZIP = 32;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "HEADER_MISSING";
                }
                case 2: {
                    return "VERSION_MISSING";
                }
                case 4: {
                    return "VERSION_0_9";
                }
                case 8: {
                    return "VERSION_1_0";
                }
                case 16: {
                    return "VERSION_1_1";
                }
                case 32: {
                    return "ENCODED_IS_GZIP";
                }
            }
            return "";
        }
    }

    public static final class Flags {
        public static final int IS_ValidTextType = 1;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "IS_ValidTextType";
                }
            }
            return "";
        }
    }
}

