/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.protocol.shared.ArcFileHeaderItem;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcFileItem
extends RPCStruct<ArcFileItem>
implements Writable {
    public static final int Field_URI = 1;
    public static final int Field_HOSTIP = 2;
    public static final int Field_TIMESTAMP = 3;
    public static final int Field_MIMETYPE = 4;
    public static final int Field_RECORDLENGTH = 5;
    public static final int Field_HEADERITEMS = 6;
    public static final int Field_CONTENT = 7;
    public static final int Field_ARCFILENAME = 8;
    public static final int Field_ARCFILEPOS = 9;
    public static final int Field_FLAGS = 10;
    public static final int Field_ARCFILESIZE = 11;
    static final int FieldID_MAX = 11;
    private BitSet __validFields = new BitSet(12);
    private TextBytes uri = new TextBytes();
    private TextBytes hostIP = new TextBytes();
    private long timestamp;
    private TextBytes mimeType = new TextBytes();
    private int recordLength;
    private ArrayList<ArcFileHeaderItem> headerItems = new ArrayList();
    private FlexBuffer content = new FlexBuffer();
    private TextBytes arcFileName = new TextBytes();
    private int arcFilePos;
    private int flags;
    private int arcFileSize;

    public static ArcFileItem newInstance(Configuration conf) {
        return (ArcFileItem)ReflectionUtils.newInstance(ArcFileItem.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ArcFileItem setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ArcFileItem setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getUriAsTextBytes() {
        return this.uri;
    }

    public String getUri() {
        return this.uri.toString();
    }

    public ArcFileItem setUri(String uri) {
        this.__validFields.set(1);
        this.uri.set(uri);
        return this;
    }

    public TextBytes getHostIPAsTextBytes() {
        return this.hostIP;
    }

    public String getHostIP() {
        return this.hostIP.toString();
    }

    public ArcFileItem setHostIP(String hostIP) {
        this.__validFields.set(2);
        this.hostIP.set(hostIP);
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ArcFileItem setTimestamp(long timestamp) {
        this.__validFields.set(3);
        this.timestamp = timestamp;
        return this;
    }

    public TextBytes getMimeTypeAsTextBytes() {
        return this.mimeType;
    }

    public String getMimeType() {
        return this.mimeType.toString();
    }

    public ArcFileItem setMimeType(String mimeType) {
        this.__validFields.set(4);
        this.mimeType.set(mimeType);
        return this;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public ArcFileItem setRecordLength(int recordLength) {
        this.__validFields.set(5);
        this.recordLength = recordLength;
        return this;
    }

    public ArrayList<ArcFileHeaderItem> getHeaderItems() {
        return this.headerItems;
    }

    public ArcFileItem setHeaderItems(ArrayList<ArcFileHeaderItem> headerItems) {
        this.__validFields.set(6);
        this.headerItems = headerItems;
        return this;
    }

    public ImmutableBuffer getContent() {
        return new ImmutableBuffer(this.content);
    }

    public ArcFileItem setContent(FlexBuffer content) {
        this.__validFields.set(7);
        this.content = content;
        return this;
    }

    public ArcFileItem setContent(Buffer content, boolean shared) {
        this.__validFields.set(7);
        this.content = new FlexBuffer(content.get(), 0, content.getCount(), shared);
        return this;
    }

    public TextBytes getArcFileNameAsTextBytes() {
        return this.arcFileName;
    }

    public String getArcFileName() {
        return this.arcFileName.toString();
    }

    public ArcFileItem setArcFileName(String arcFileName) {
        this.__validFields.set(8);
        this.arcFileName.set(arcFileName);
        return this;
    }

    public int getArcFilePos() {
        return this.arcFilePos;
    }

    public ArcFileItem setArcFilePos(int arcFilePos) {
        this.__validFields.set(9);
        this.arcFilePos = arcFilePos;
        return this;
    }

    public int getFlags() {
        return this.flags;
    }

    public ArcFileItem setFlags(int flags) {
        this.__validFields.set(10);
        this.flags = flags;
        return this;
    }

    public int getArcFileSize() {
        return this.arcFileSize;
    }

    public ArcFileItem setArcFileSize(int arcFileSize) {
        this.__validFields.set(11);
        this.arcFileSize = arcFileSize;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.headerItems.size() != 0;
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "uri", 1);
            encoder.writeTextBytes(output, this.uri);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "hostIP", 2);
            encoder.writeTextBytes(output, this.hostIP);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "timestamp", 3);
            encoder.writeLong(output, this.timestamp);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "mimeType", 4);
            encoder.writeTextBytes(output, this.mimeType);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "recordLength", 5);
            encoder.writeInt(output, this.recordLength);
        }
        if (this.headerItems.size() != 0) {
            this.__validFields.set(6);
            encoder.beginField(output, "headerItems", 6);
            int len1 = this.headerItems.size();
            encoder.writeInt(output, len1);
            for (int vidx1 = 0; vidx1 < len1; ++vidx1) {
                ArcFileHeaderItem e1 = this.headerItems.get(vidx1);
                e1.serialize(output, encoder);
            }
        } else {
            this.__validFields.clear(6);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "content", 7);
            encoder.writeFlexBuffer(output, this.content);
        }
        if (this.__validFields.get(8)) {
            encoder.beginField(output, "arcFileName", 8);
            encoder.writeTextBytes(output, this.arcFileName);
        }
        if (this.__validFields.get(9)) {
            encoder.beginField(output, "arcFilePos", 9);
            encoder.writeInt(output, this.arcFilePos);
        }
        if (this.__validFields.get(10)) {
            encoder.beginField(output, "flags", 10);
            encoder.writeInt(output, this.flags);
        }
        if (this.__validFields.get(11)) {
            encoder.beginField(output, "arcFileSize", 11);
            encoder.writeInt(output, this.arcFileSize);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        block13: while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.uri);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    decoder.readTextBytes(input, this.hostIP);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    this.timestamp = decoder.readLong(input);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    decoder.readTextBytes(input, this.mimeType);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.recordLength = decoder.readInt(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    int itemCount1 = decoder.readInt(input);
                    this.headerItems = new ArrayList();
                    for (int i1 = 0; i1 < itemCount1; ++i1) {
                        ArcFileHeaderItem e1 = new ArcFileHeaderItem();
                        e1.deserialize(input, decoder);
                        this.headerItems.add(e1);
                    }
                    continue block13;
                }
                case 7: {
                    this.__validFields.set(7);
                    decoder.readFlexBuffer(input, this.content);
                    break;
                }
                case 8: {
                    this.__validFields.set(8);
                    decoder.readTextBytes(input, this.arcFileName);
                    break;
                }
                case 9: {
                    this.__validFields.set(9);
                    this.arcFilePos = decoder.readInt(input);
                    break;
                }
                case 10: {
                    this.__validFields.set(10);
                    this.flags = decoder.readInt(input);
                    break;
                }
                case 11: {
                    this.__validFields.set(11);
                    this.arcFileSize = decoder.readInt(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.uri.clear();
        this.hostIP.clear();
        this.timestamp = 0L;
        this.mimeType.clear();
        this.recordLength = 0;
        this.headerItems.clear();
        this.content.reset();
        this.arcFileName.clear();
        this.arcFilePos = 0;
        this.flags = 0;
        this.arcFileSize = 0;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ArcFileItem)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ArcFileItem peer = (ArcFileItem)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.uri.equals(peer.uri))) {
            return ret;
        }
        if (this.__validFields.get(2) && !(ret = this.hostIP.equals(peer.hostIP))) {
            return ret;
        }
        if (this.__validFields.get(3)) {
            boolean bl = ret = this.timestamp == peer.timestamp;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(4) && !(ret = this.mimeType.equals(peer.mimeType))) {
            return ret;
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.recordLength == peer.recordLength;
            if (!ret) {
                return ret;
            }
        }
        if (this.headerItems.size() != 0 && !(ret = this.headerItems.equals(peer.headerItems))) {
            return ret;
        }
        if (this.__validFields.get(7) && !(ret = this.content.equals(peer.content))) {
            return ret;
        }
        if (this.__validFields.get(8) && !(ret = this.arcFileName.equals(peer.arcFileName))) {
            return ret;
        }
        if (this.__validFields.get(9)) {
            boolean bl = ret = this.arcFilePos == peer.arcFilePos;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(10)) {
            boolean bl = ret = this.flags == peer.flags;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(11)) {
            boolean bl = ret = this.arcFileSize == peer.arcFileSize;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ArcFileItem other = new ArcFileItem();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.uri = (TextBytes)this.uri.clone();
        }
        if (this.__validFields.get(2)) {
            other.hostIP = (TextBytes)this.hostIP.clone();
        }
        if (this.__validFields.get(3)) {
            other.timestamp = this.timestamp;
        }
        if (this.__validFields.get(4)) {
            other.mimeType = (TextBytes)this.mimeType.clone();
        }
        if (this.__validFields.get(5)) {
            other.recordLength = this.recordLength;
        }
        other.headerItems = new ArrayList();
        int len0 = this.headerItems.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            ArcFileHeaderItem src0 = this.headerItems.get(vidx0);
            ArcFileHeaderItem tgt0 = (ArcFileHeaderItem)src0.clone();
            other.headerItems.add(tgt0);
        }
        if (this.__validFields.get(7)) {
            other.content = (FlexBuffer)this.content.clone();
        }
        if (this.__validFields.get(8)) {
            other.arcFileName = (TextBytes)this.arcFileName.clone();
        }
        if (this.__validFields.get(9)) {
            other.arcFilePos = this.arcFilePos;
        }
        if (this.__validFields.get(10)) {
            other.flags = this.flags;
        }
        if (this.__validFields.get(11)) {
            other.arcFileSize = this.arcFileSize;
        }
        return other;
    }

    @Override
    public final void merge(ArcFileItem peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.uri = (TextBytes)peer.uri.clone();
        }
        if (peer.__validFields.get(2)) {
            this.hostIP = (TextBytes)peer.hostIP.clone();
        }
        if (peer.__validFields.get(3)) {
            this.timestamp = peer.timestamp;
        }
        if (peer.__validFields.get(4)) {
            this.mimeType = (TextBytes)peer.mimeType.clone();
        }
        if (peer.__validFields.get(5)) {
            this.recordLength = peer.recordLength;
        }
        int len0 = peer.headerItems.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            ArcFileHeaderItem src0 = peer.headerItems.get(vidx0);
            ArcFileHeaderItem tgt0 = (ArcFileHeaderItem)src0.clone();
            this.headerItems.add(tgt0);
        }
        if (peer.__validFields.get(7)) {
            this.content = (FlexBuffer)peer.content.clone();
        }
        if (peer.__validFields.get(8)) {
            this.arcFileName = (TextBytes)peer.arcFileName.clone();
        }
        if (peer.__validFields.get(9)) {
            this.arcFilePos = peer.arcFilePos;
        }
        if (peer.__validFields.get(10)) {
            this.flags = peer.flags;
        }
        if (peer.__validFields.get(11)) {
            this.arcFileSize = peer.arcFileSize;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.uri.getBytes(), this.uri.getOffset(), this.uri.getLength(), result);
        result = MurmurHash.hash(this.hostIP.getBytes(), this.hostIP.getOffset(), this.hostIP.getLength(), result);
        result = MurmurHash.hashLong(this.timestamp, result);
        result = MurmurHash.hash(this.mimeType.getBytes(), this.mimeType.getOffset(), this.mimeType.getLength(), result);
        result = MurmurHash.hashInt(this.recordLength, result);
        result = MurmurHash.hashInt(this.headerItems.hashCode(), result);
        result = MurmurHash.hash(this.content.get(), this.content.getOffset(), this.content.getCount(), result);
        result = MurmurHash.hash(this.arcFileName.getBytes(), this.arcFileName.getOffset(), this.arcFileName.getLength(), result);
        result = MurmurHash.hashInt(this.arcFilePos, result);
        result = MurmurHash.hashInt(this.flags, result);
        result = MurmurHash.hashInt(this.arcFileSize, result);
        return result;
    }

    public static final class Flags {
        public static final int TruncatedInDownload = 1;
        public static final int TruncatedInInflate = 2;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "TruncatedInDownload";
                }
                case 2: {
                    return "TruncatedInInflate";
                }
            }
            return "";
        }
    }
}

