/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIOServerSocket;
import org.commoncrawl.io.internal.NIOSocket;

public class NIOSocketSelector {
    Selector _selector = null;
    EventLoop _eventLoop = null;
    public static final Log LOG = LogFactory.getLog((String)"org.commoncrawl.io.NIOSocketSelector");
    Map<Integer, PendingRegistration> _pendingRegistrations = new TreeMap<Integer, PendingRegistration>();
    private long _lastPollTime = -1L;

    public Selector getSelector() {
        return this._selector;
    }

    public NIOSocketSelector(EventLoop eventLoop) throws IOException {
        this._eventLoop = eventLoop;
        this._selector = Selector.open();
    }

    public void registerForConnect(NIOClientSocket theSocket) throws IOException {
        this.registerSocket(theSocket, 8);
    }

    public void registerForRead(NIOClientSocket theSocket) throws IOException {
        this.registerSocket(theSocket, 1);
    }

    public void registerForWrite(NIOClientSocket theSocket) throws IOException {
        this.registerSocket(theSocket, 4);
    }

    public void registerForReadAndWrite(NIOClientSocket theSocket) throws IOException {
        this.registerSocket(theSocket, 5);
    }

    public void registerForAccept(NIOServerSocket theSocket) throws IOException {
        this.registerSocket(theSocket, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRegistration(NIOSocket theSocket) {
        if (this._eventLoop == null || this._eventLoop.getEventThread() == Thread.currentThread()) {
            SelectionKey key;
            if (theSocket.getChannel() != null && (key = theSocket.getChannel().keyFor(this._selector)) != null) {
                key.cancel();
            }
        } else {
            Map<Integer, PendingRegistration> map = this._pendingRegistrations;
            synchronized (map) {
                this._pendingRegistrations.put(theSocket.getSocketId(), new PendingRegistration(theSocket, 0));
            }
            this._eventLoop.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSocket(NIOSocket theSocket, int interestOps) throws IOException {
        if (this._eventLoop == null || this._eventLoop.getEventThread() == Thread.currentThread()) {
            SelectionKey key = theSocket.getChannel().keyFor(this._selector);
            if (key == null) {
                key = theSocket.getChannel().register(this._selector, interestOps, theSocket);
            } else {
                key.interestOps(key.interestOps() | interestOps);
            }
        } else {
            Map<Integer, PendingRegistration> map = this._pendingRegistrations;
            synchronized (map) {
                PendingRegistration pendingRegistration = this._pendingRegistrations.get(theSocket.getSocketId());
                if (pendingRegistration == null) {
                    this._pendingRegistrations.put(theSocket.getSocketId(), new PendingRegistration(theSocket, interestOps));
                } else {
                    pendingRegistration.setInterestOps(pendingRegistration.getInterestOps() | interestOps);
                }
            }
            this._eventLoop.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processPendingRegistrations() {
        Map<Integer, PendingRegistration> map = this._pendingRegistrations;
        synchronized (map) {
            if (this._pendingRegistrations.size() != 0) {
                for (PendingRegistration registration : this._pendingRegistrations.values()) {
                    if (registration.getInterestOps() == 0) {
                        this.cancelRegistration(registration.getSocket());
                        continue;
                    }
                    try {
                        this.registerSocket(registration.getSocket(), registration.getInterestOps());
                    }
                    catch (IOException e) {
                        LOG.error((Object)("registerSocket threw Exception:" + e.getMessage()));
                    }
                }
                this._pendingRegistrations.clear();
            }
        }
    }

    public int poll(long timeoutValue, TimeUsageDetail timeUsageDetailOut) throws IOException {
        long timeStart = System.currentTimeMillis();
        if (this._lastPollTime != -1L && timeStart - this._lastPollTime >= 30000L) {
            LOG.error((Object)("POLL Delta Too Long:" + (timeStart - this._lastPollTime)));
        }
        this._lastPollTime = timeStart;
        if (timeUsageDetailOut != null) {
            timeUsageDetailOut.blockedTime = 0L;
            timeUsageDetailOut.unblockedTime = 0L;
        }
        if (this._selector == null || !this._selector.isOpen()) {
            IOException e = new IOException("Selector NULL or Selector is Not Open!");
            LOG.error((Object)e);
            throw e;
        }
        this.processPendingRegistrations();
        long timeEnd = System.currentTimeMillis();
        if (timeUsageDetailOut != null) {
            timeUsageDetailOut.unblockedTime += timeEnd - timeStart;
        }
        timeStart = System.currentTimeMillis();
        int count = 0;
        if (timeoutValue <= 0L) {
            count = this._selector.selectNow();
        } else {
            if (timeoutValue == Long.MAX_VALUE) {
                timeoutValue = 0L;
            }
            count = this._selector.select(timeoutValue);
        }
        timeEnd = System.currentTimeMillis();
        if (timeUsageDetailOut != null) {
            timeUsageDetailOut.blockedTime += timeEnd - timeStart;
        }
        long unblockedTimeStart = System.currentTimeMillis();
        Set<SelectionKey> selectionSet = this._selector.selectedKeys();
        Iterator<SelectionKey> i = selectionSet.iterator();
        while (i.hasNext()) {
            SelectionKey selectionKey = i.next();
            i.remove();
            if (selectionKey.isValid()) {
                Object attachment = selectionKey.attachment();
                if (attachment instanceof NIOSocket) {
                    NIOSocket theSocket = (NIOSocket)selectionKey.attachment();
                    if (theSocket == null || theSocket.getListener() == null) continue;
                    selectionKey.interestOps(0);
                    if (selectionKey.isConnectable()) {
                        boolean connected = false;
                        Exception disconnectException = null;
                        try {
                            if (((NIOClientSocket)theSocket).finishConnect()) {
                                connected = true;
                                System.out.println("Connected to:" + ((NIOClientSocket)theSocket).getSocketAddress());
                                timeStart = System.currentTimeMillis();
                                ((NIOClientSocketListener)theSocket.getListener()).Connected((NIOClientSocket)theSocket);
                                if (timeUsageDetailOut != null) {
                                    timeUsageDetailOut.timeInConnectedEvt += System.currentTimeMillis() - timeStart;
                                }
                            } else {
                                theSocket.close();
                            }
                        }
                        catch (IOException e) {
                            theSocket.close();
                            disconnectException = e;
                        }
                        catch (RuntimeException e) {
                            LOG.error((Object)("Caught Runtime Exception in Connected Event:" + StringUtils.stringifyException((Throwable)e)));
                            ((NIOClientSocketListener)theSocket.getListener()).Excepted((NIOClientSocket)theSocket, e);
                            theSocket.close();
                            disconnectException = e;
                        }
                        if (!connected) {
                            ((NIOClientSocketListener)theSocket.getListener()).Disconnected((NIOClientSocket)theSocket, disconnectException);
                            continue;
                        }
                    }
                    if (theSocket instanceof NIOClientSocket && selectionKey.isValid()) {
                        selectionKey.interestOps(selectionKey.interestOps() | 1);
                    }
                    if (selectionKey.isValid() && selectionKey.isReadable()) {
                        int bytesRead = -1;
                        try {
                            timeStart = System.currentTimeMillis();
                            bytesRead = ((NIOClientSocketListener)theSocket.getListener()).Readable((NIOClientSocket)theSocket);
                            if (timeUsageDetailOut != null) {
                                timeUsageDetailOut.timeInReadableEvt += System.currentTimeMillis() - timeStart;
                            }
                            if (bytesRead == -1) {
                                ((NIOClientSocketListener)theSocket.getListener()).Disconnected((NIOClientSocket)theSocket, null);
                                theSocket.close();
                            }
                        }
                        catch (RuntimeException e) {
                            LOG.error((Object)("Caught Runtime Exception in Readable Event:" + StringUtils.stringifyException((Throwable)e)));
                            ((NIOClientSocketListener)theSocket.getListener()).Excepted((NIOClientSocket)theSocket, e);
                            theSocket.close();
                        }
                    }
                    if (selectionKey.isValid() && selectionKey.isWritable()) {
                        try {
                            timeStart = System.currentTimeMillis();
                            ((NIOClientSocketListener)theSocket.getListener()).Writeable((NIOClientSocket)theSocket);
                            if (timeUsageDetailOut != null) {
                                timeUsageDetailOut.timeInWritableEvt += System.currentTimeMillis() - timeStart;
                            }
                        }
                        catch (RuntimeException e) {
                            LOG.error((Object)("Caught Runtime Exception in Readable Event:" + StringUtils.stringifyException((Throwable)e)));
                            ((NIOClientSocketListener)theSocket.getListener()).Excepted((NIOClientSocket)theSocket, e);
                            theSocket.close();
                        }
                    }
                    if (!selectionKey.isValid() || !selectionKey.isAcceptable()) continue;
                    ((NIOServerSocket)theSocket).acceptable();
                    selectionKey.interestOps(selectionKey.interestOps() | 0x10);
                    continue;
                }
                if (!(attachment instanceof NIOClientSocketListener)) continue;
                NIOClientSocketListener listener = (NIOClientSocketListener)attachment;
                selectionKey.interestOps(0);
                selectionKey.interestOps(selectionKey.interestOps() | 1);
                if (selectionKey.isValid() && selectionKey.isReadable()) {
                    int bytesRead = -1;
                    try {
                        timeStart = System.currentTimeMillis();
                        bytesRead = listener.Readable(null);
                        if (timeUsageDetailOut != null) {
                            timeUsageDetailOut.timeInReadableEvt += System.currentTimeMillis() - timeStart;
                        }
                        if (bytesRead == -1) {
                            listener.Disconnected(null, null);
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)("Caught Runtime Exception in Readable Event:" + StringUtils.stringifyException((Throwable)e)));
                        listener.Excepted(null, e);
                    }
                }
                if (!selectionKey.isValid() || !selectionKey.isWritable()) continue;
                try {
                    timeStart = System.currentTimeMillis();
                    listener.Writeable(null);
                    if (timeUsageDetailOut == null) continue;
                    timeUsageDetailOut.timeInWritableEvt += System.currentTimeMillis() - timeStart;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Caught Runtime Exception in Readable Event:" + StringUtils.stringifyException((Throwable)e)));
                    listener.Excepted(null, e);
                }
                continue;
            }
            LOG.error((Object)"Invalid Socket Detected. Calling Disconnect");
            NIOSocket theSocket = (NIOSocket)selectionKey.attachment();
            if (theSocket == null || theSocket.getListener() == null) continue;
            theSocket.getListener().Disconnected(theSocket, null);
        }
        long unblockedTimeEnd = System.currentTimeMillis();
        if (timeUsageDetailOut != null) {
            timeUsageDetailOut.unblockedTime += unblockedTimeEnd - unblockedTimeStart;
        }
        return count;
    }

    public void wakeup() throws IOException {
        if (this._selector == null || !this._selector.isOpen()) {
            IOException e = new IOException("Selector NULL or Selector is Not Open!");
            LOG.error((Object)e);
            throw e;
        }
        this._selector.wakeup();
    }

    public static class TimeUsageDetail {
        public long blockedTime;
        public long unblockedTime;
        public long timeInConnectedEvt;
        public long timeInReadableEvt;
        public long timeInWritableEvt;

        void reset() {
            this.blockedTime = 0L;
            this.unblockedTime = 0L;
            this.timeInConnectedEvt = 0L;
            this.timeInReadableEvt = 0L;
            this.timeInWritableEvt = 0L;
        }
    }

    private static class PendingRegistration {
        NIOSocket _socket;
        int _interestOps;

        PendingRegistration(NIOSocket socket, int socketOp) {
            this._socket = socket;
            this._interestOps = socketOp;
        }

        public int getInterestOps() {
            return this._interestOps;
        }

        public void setInterestOps(int ops) {
            this._interestOps = ops;
        }

        public NIOSocket getSocket() {
            return this._socket;
        }
    }
}

