/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.FutureTask;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListInputStream;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIODNSQueryClient;
import org.commoncrawl.io.internal.NIODNSQueryResult;
import org.commoncrawl.io.internal.NIODNSResolver;
import org.commoncrawl.io.internal.NIOHttpCookieStore;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.io.internal.NIOSocketFactory;
import org.commoncrawl.io.internal.NIOSocketSelector;
import org.commoncrawl.io.internal.NIOStreamEncoder;
import org.commoncrawl.io.shared.NIOHttpHeaders;
import org.commoncrawl.util.shared.BandwidthUtils;
import org.commoncrawl.util.shared.CustomLogger;
import org.commoncrawl.util.shared.IPAddressUtils;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NIOHttpConnection
implements NIOClientSocketListener,
NIODNSQueryClient {
    private static final Log LOG = LogFactory.getLog(NIOHttpConnection.class);
    private static final int HTTP_HEADER_SIZE_MAX = 16384;
    private static final int CHUNK_LINE_MAX = 1024;
    private static final int DNS_TIMEOUT_DEFAULT = 40000;
    private static final int TIMEOUT_DEFAULT = 30000;
    private static final int UPLOAD_DOWNLOAD_TIMEOUT_DEFAULT = 30000;
    private static final int MIN_DNS_CACHE_TIME = 3600000;
    private static final Charset _utf8Charset = Charset.forName("UTF8");
    private final NIOHttpHeaders _requestHeaders = new NIOHttpHeaders();
    private boolean _populateDefaultHeaderItems = true;
    private final NIOHttpHeaders _responseHeaders = new NIOHttpHeaders();
    private boolean _foundStatusLine = false;
    private boolean _lastCharWasLF = false;
    private byte _lastChar = 0;
    private final NIOBufferList _outBuf = new NIOBufferList();
    private NIOBufferList _inBuf = new NIOBufferList();
    private ByteArrayOutputStream _incomingAccumulationBuffer = null;
    private NIOClientSocket _socket = null;
    private NIOSocketSelector _selector = null;
    private NIODNSResolver _resolver = null;
    private static long _cumilativeRead = 0L;
    private static long _cumilativeWritten = 0L;
    private int _totalWritten = 0;
    private int _totalRead = 0;
    private boolean _closed = false;
    private URL _url = null;
    private InetAddress _resolvedAddress = null;
    private InetSocketAddress _sourceIP = null;
    private long _resolvedAddressTTL = -1L;
    private String _resolvedCName;
    private Listener _listener = null;
    private DataSource _dataSource = null;
    private Object _context = null;
    private int _contentLength = -1;
    private int _downloadedContentLength = 0;
    private int _downloadMax = -1;
    private boolean _contentTruncated = false;
    private boolean _chunked = false;
    private InetSocketAddress _proxyServer;
    private static CustomLogger _cookieLogger;
    ChunkState _chunkState = ChunkState.STATE_AWAITING_CHUNK_HEADER;
    int _chunkSize = 0;
    int _chunkPos = 0;
    NIOBufferList.CRLFReadState _chunkCRLFReadState = NIOBufferList.CRLFReadState.NONE;
    StringBuffer _chunkLineBuffer = null;
    NIOBufferList _chunkContentBuffer = null;
    private int _downloadLength = 0;
    private long _openTime = -1L;
    private int _resolveTime = 0;
    private int _connectTime = 0;
    private int _uploadTime = 0;
    private int _downloadTime = 0;
    private int _id = 0;
    private long _phaseStartTime;
    private long _lastReadOrWriteTime = -1L;
    private int _dnsTimeout = 40000;
    private int _connectTimeout = 30000;
    private int _uploadDownloadTimeout = 30000;
    private String _method = "GET";
    private String _httpVersionString = "HTTP/1.1";
    private static String _defaultUserAgentString;
    private State _state = State.IDLE;
    private State _timeoutState = State.IDLE;
    private ErrorType _errorType = ErrorType.UNKNOWN;
    private String _errorDesc;
    private Exception _lastException = null;
    private BandwidthUtils.RateLimiter _uploadRateLimiter;
    private NIOHttpCookieStore _cookieStore;
    private static final int MIN_BYTES_FOR_STATUS_LINE = 8;
    private static final int HTTP_STATUS_LINE_SLOP = 4;
    private static byte[] httpStr;

    private NIOHttpConnection() {
    }

    public NIOHttpConnection(URL theURL, NIOSocketSelector selector, NIODNSResolver resolver, NIOHttpCookieStore cookieStore) throws IOException {
        this._url = theURL;
        this._socket = NIOSocketFactory.createClientSocket(theURL, null, (NIOClientSocketListener)this);
        this._sourceIP = this._socket.getLocalSocketAddress();
        this._selector = selector;
        this._resolver = resolver;
        this._cookieStore = cookieStore;
    }

    public NIOHttpConnection(URL theURL, InetSocketAddress localBindAddress, NIOSocketSelector selector, NIODNSResolver resolver, NIOHttpCookieStore cookieStore) throws IOException {
        this._url = theURL;
        this._sourceIP = localBindAddress;
        this._socket = NIOSocketFactory.createClientSocket(theURL, localBindAddress, (NIOClientSocketListener)this);
        this._selector = selector;
        this._resolver = resolver;
        this._cookieStore = cookieStore;
    }

    public static void setCookieLogger(CustomLogger logger) {
        _cookieLogger = logger;
    }

    public void setProxyServer(InetSocketAddress proxyServerAddress) {
        this._proxyServer = proxyServerAddress;
    }

    public InetSocketAddress getProxyServer() {
        return this._proxyServer;
    }

    public static long getCumilativeBytesRead() {
        return _cumilativeRead;
    }

    public static long getCumilativeBytesWritten() {
        return _cumilativeWritten;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setHttpVersionString(String httpVersion) {
        this._httpVersionString = httpVersion;
    }

    public static void setDefaultUserAgentString(String userAgentString) {
        _defaultUserAgentString = userAgentString;
    }

    public final Listener getListener() {
        return this._listener;
    }

    public final void setListener(Listener listener) {
        this._listener = listener;
    }

    public final void setDataSource(DataSource source) {
        this._dataSource = source;
    }

    public final DataSource getDataSource() {
        return this._dataSource;
    }

    public final void setContext(Object contextObj) {
        this._context = contextObj;
    }

    public final Object getContext() {
        return this._context;
    }

    public InetSocketAddress getLocalAddress() {
        return this._sourceIP;
    }

    public final void setPopulateDefaultHeaderItems(boolean value) {
        this._populateDefaultHeaderItems = value;
    }

    public final State getState() {
        return this._state;
    }

    public final State getTimeoutState() {
        return this._timeoutState;
    }

    private final void setState(State newState, Exception e) {
        long currentTime = System.currentTimeMillis();
        State oldState = this._state;
        this._state = newState;
        if (e != null) {
            this._lastException = e;
        }
        if (this._listener != null) {
            this._listener.HttpConnectionStateChanged(this, oldState, newState);
        }
        if (newState != State.ERROR) {
            switch (oldState) {
                case AWAITING_RESOLUTION: {
                    this._resolveTime = (int)(currentTime - this._phaseStartTime);
                    break;
                }
                case AWAITING_CONNECT: {
                    this._connectTime = (int)(currentTime - this._phaseStartTime);
                    break;
                }
                case SENDING_REQUEST: {
                    this._uploadTime = (int)(currentTime - this._phaseStartTime);
                    break;
                }
                case RECEIVING_CONTENT: {
                    this._downloadTime = (int)(currentTime - this._phaseStartTime);
                }
            }
            switch (newState) {
                case AWAITING_RESOLUTION: 
                case AWAITING_CONNECT: 
                case SENDING_REQUEST: 
                case RECEIVING_HEADERS: {
                    if (oldState == newState) break;
                    this._phaseStartTime = currentTime;
                }
            }
            if (newState.ordinal() >= State.SENDING_REQUEST.ordinal()) {
                this._lastReadOrWriteTime = currentTime;
            }
        }
        if (newState == State.ERROR) {
            // empty if block
        }
        if (newState == State.DONE || newState == State.ERROR) {
            this.close();
        }
    }

    void setErrorType(ErrorType errorType) {
        this._errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this._errorType;
    }

    public String getErrorDesc() {
        return this._errorDesc;
    }

    void setErrorDesc(String errorDesc) {
        this._errorDesc = errorDesc;
    }

    public final int getHttpResponseCode() {
        return this._responseHeaders.getHttpResponseCode();
    }

    public boolean isRedirectResponse() {
        switch (this.getHttpResponseCode()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public String getRedirectLocation() {
        int key = this._responseHeaders.getKey("Location");
        if (key == -1) {
            key = this._responseHeaders.getKey("location");
        }
        if (key != -1) {
            return this._responseHeaders.getValue(key);
        }
        return null;
    }

    public static int getHttpResponseCode(NIOHttpHeaders responseHeaders) {
        return responseHeaders.getHttpResponseCode();
    }

    public void setDNSTimeout(int timeoutValue) {
        this._dnsTimeout = timeoutValue;
    }

    public void setConnectTimeout(int timeoutValue) {
        this._connectTimeout = timeoutValue;
    }

    public void setDownloadTimeout(int timeoutValue) {
        this._uploadDownloadTimeout = timeoutValue;
    }

    public final int getContentLength() {
        return this._contentLength;
    }

    public final int getDownloadLength() {
        return this._downloadLength;
    }

    public final boolean isContentTruncated() {
        return this._contentTruncated;
    }

    public final void setDownloadMax(int downloadMax) {
        this._downloadMax = downloadMax;
    }

    public final NIOBufferList getContentBuffer() {
        return this._inBuf;
    }

    public final NIOHttpHeaders getRequestHeaders() {
        return this._requestHeaders;
    }

    public final NIOHttpHeaders getResponseHeaders() {
        return this._responseHeaders;
    }

    public final long getOpenTime() {
        return this._openTime;
    }

    public final int getResolveTime() {
        return this._resolveTime;
    }

    public final int getConnectTime() {
        return this._connectTime;
    }

    public final int getUploadTime() {
        return this._uploadTime;
    }

    public final int getDownloadTime() {
        return this._downloadTime;
    }

    public final int getId() {
        return this._id;
    }

    public final void setId(int id) {
        this._id = id;
    }

    public final void setUploadRateLimiter(BandwidthUtils.RateLimiter rateLimiter) {
        this._uploadRateLimiter = rateLimiter;
    }

    public final URL getURL() {
        return this._url;
    }

    public void setResolvedAddress(InetAddress address, long ttl, String optionalCName) {
        this._resolvedAddress = address;
        this._resolvedAddressTTL = ttl;
        this._resolvedCName = optionalCName;
    }

    public InetAddress getResolvedAddress() {
        return this._resolvedAddress;
    }

    public long getResolvedAddressTTL() {
        return this._resolvedAddressTTL;
    }

    public String getResolvedServerCName() {
        return this._resolvedCName;
    }

    public final Exception getLastException() {
        return this._lastException;
    }

    public final NIOSocket getSocket() {
        return this._socket;
    }

    public void open() throws IOException {
        if (this._state != State.IDLE) {
            throw new IOException("Invalid State");
        }
        this._openTime = System.currentTimeMillis();
        if (this._url.getHost().length() == 0 || this._method.length() == 0 || this._httpVersionString.length() == 0) {
            throw new IOException("Invalid Base HTTP Parameters Specified");
        }
        this.setState(State.AWAITING_RESOLUTION, null);
        InetSocketAddress socketAddress = this.getProxyServer();
        if (socketAddress == null) {
            InetAddress addressToConnectTo = null;
            String hostName = this._url.getHost();
            byte[] ipAddress = IPAddressUtils.textToNumericFormatV4(hostName);
            if (ipAddress != null) {
                addressToConnectTo = InetAddress.getByAddress(ipAddress);
            }
            if (addressToConnectTo == null) {
                addressToConnectTo = this.getResolvedAddress();
            }
            if (addressToConnectTo != null) {
                socketAddress = new InetSocketAddress(addressToConnectTo, this._url.getPort() == -1 ? 80 : this._url.getPort());
            }
        }
        if (socketAddress != null) {
            this.startConnect(socketAddress);
        } else {
            LOG.info((Object)("Sending Host:" + this._url.getHost() + " to resolver"));
            this._resolver.resolve(this, this._url.getHost(), false, true, this._dnsTimeout);
        }
    }

    public void close() {
        if (!this._closed) {
            if (this._socket != null) {
                this._selector.cancelRegistration(this._socket);
                this._socket.close();
            }
            if (this.getState() == State.DONE) {
                this._downloadLength = this._inBuf.available();
            } else {
                this._inBuf.reset();
            }
            this._outBuf.reset();
            this._closed = true;
        }
    }

    private final void _buildAndWriteRequestHeader() throws IOException {
        if (this._populateDefaultHeaderItems) {
            String cookies;
            String file = null;
            if (this.getProxyServer() == null) {
                file = this._url.getPath();
                if (this._url.getQuery() != null) {
                    file = file + "?";
                    file = file + this._url.getQuery();
                }
            } else {
                file = this._url.toString();
            }
            if (file.length() == 0) {
                file = "/";
            }
            this._requestHeaders.prepend(this._method + " " + file + " " + this._httpVersionString, null);
            if (this._url.getPort() != -1 && this._url.getPort() != 80) {
                this._requestHeaders.setIfNotSet("Host", this._url.getHost() + ":" + String.valueOf(this._url.getPort()));
            } else {
                this._requestHeaders.setIfNotSet("Host", this._url.getHost());
            }
            this._requestHeaders.setIfNotSet("User-Agent", _defaultUserAgentString);
            this._requestHeaders.setIfNotSet("Accept", "text/html,application/xhtml+xml,text/xml;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            this._requestHeaders.setIfNotSet("Accept-Language", "en-us,en;q=0.5");
            this._requestHeaders.setIfNotSet("Accept-Encoding", "gzip");
            this._requestHeaders.setIfNotSet("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            this._requestHeaders.setIfNotSet("Connection", "close");
            this._requestHeaders.setIfNotSet("Cache-Control", "no-cache");
            this._requestHeaders.setIfNotSet("Pragma", "no-cache");
            if (this._cookieStore != null && (cookies = this._cookieStore.GetCookies(this._url)).length() != 0) {
                if (_cookieLogger != null) {
                    _cookieLogger.info("Got Cookies:" + cookies + " from URL:" + this._url);
                }
                this._requestHeaders.setIfNotSet("Cookie", cookies);
            }
        }
        NIOStreamEncoder encoder = new NIOStreamEncoder(this._outBuf, _utf8Charset.newEncoder());
        PrintWriter writer = new PrintWriter(encoder);
        this._requestHeaders.print(writer);
        writer.flush();
        this._outBuf.flush();
    }

    @Override
    public void AddressResolutionFailure(NIODNSResolver eventSource, String hostName, NIODNSQueryClient.Status status, String errorDesc) {
        if (status == NIODNSQueryClient.Status.RESOLVER_FAILURE) {
            this.setErrorType(ErrorType.RESOLVER_FAILURE);
        } else if (status == NIODNSQueryClient.Status.SERVER_FAILURE) {
            this.setErrorType(ErrorType.DNS_FAILURE);
        }
        this.setErrorDesc(errorDesc);
        this.setState(State.ERROR, new UnknownHostException(hostName));
    }

    @Override
    public void AddressResolutionSuccess(NIODNSResolver eventSource, String hostName, String cName, InetAddress address, long addressTTL) {
        this._resolvedAddress = address;
        this._resolvedAddressTTL = Math.max(addressTTL, System.currentTimeMillis() + 3600000L);
        this._resolvedCName = cName;
        this.startConnect(new InetSocketAddress(this._resolvedAddress, this._url.getPort() == -1 ? 80 : this._url.getPort()));
    }

    private void startConnect(InetSocketAddress addressToConnectTo) {
        if (this._socket != null && this._socket.isOpen()) {
            this.setState(State.AWAITING_CONNECT, null);
            try {
                this._buildAndWriteRequestHeader();
                this._socket.connect(addressToConnectTo);
                this._selector.registerForConnect(this._socket);
            }
            catch (IOException e) {
                LOG.error((Object)("Socket Connect via Address Resolution Success for host:" + this._url.getHost() + " threw Exception:" + e.getMessage()));
                this.setErrorType(ErrorType.IOEXCEPTION);
                this.setErrorDesc(e.toString());
                this.setState(State.ERROR, e);
            }
        } else {
            LOG.error((Object)("AddressResolutionSuccess called on closed connection. URL:" + this._url));
            this.setErrorType(ErrorType.UNKNOWN);
            this.setErrorDesc("AddressResolutionSuccess called on closed connection. URL:" + this._url);
            this.setState(State.ERROR, new ConnectException(this._url.getHost()));
        }
    }

    @Override
    public void DNSResultsAvailable() {
        if (this._selector != null) {
            try {
                this._selector.wakeup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void Connected(NIOClientSocket theSocket) throws IOException {
        this.setState(State.SENDING_REQUEST, null);
        try {
            this._selector.registerForWrite(this._socket);
        }
        catch (IOException e) {
            LOG.error((Object)("registerForWrite for url:" + this.getURL() + " threw Exception:" + e.getMessage()));
            this.setErrorType(ErrorType.IOEXCEPTION);
            this.setErrorDesc(e.toString());
            this.setState(State.ERROR, e);
        }
    }

    @Override
    public void Disconnected(NIOSocket theSocket, Exception disconnectReason) throws IOException {
        if (this._state == State.RECEIVING_CONTENT) {
            this.setState(State.DONE, null);
        } else if (this._state != State.DONE && this._state != State.ERROR) {
            this.setErrorType(ErrorType.IOEXCEPTION);
            if (disconnectReason != null) {
                this.setErrorDesc("Disconnected with State:" + (Object)((Object)this.getState()) + " And Exception:" + disconnectReason.toString());
            } else {
                this.setErrorDesc("Disconnected with State:" + (Object)((Object)this.getState()) + " ContentLength:" + this._contentLength + " BufferSize:" + this._inBuf.available());
            }
            this.setState(State.ERROR, disconnectReason != null ? disconnectReason : new SocketException());
        }
    }

    @Override
    public void Excepted(NIOSocket s, Exception e) {
        LOG.error((Object)("Caught Unhandled Exception:" + StringUtils.stringifyException((Throwable)e) + " for URL:" + this.getURL()));
        this.setErrorType(ErrorType.IOEXCEPTION);
        this.setErrorDesc("Unhanled Exception:" + StringUtils.stringifyException((Throwable)e));
        this.setState(State.ERROR, e);
    }

    @Override
    public void Writeable(NIOClientSocket theSocket) throws IOException {
        if (!theSocket.isOpen()) {
            return;
        }
        int amountWritten = 0;
        try {
            ByteBuffer bufferToWrite;
            boolean contentEOF = false;
            amountWritten = 0;
            if (this._outBuf.available() == 0 && this._dataSource != null) {
                contentEOF = this._dataSource.read(this._outBuf);
            }
            if ((bufferToWrite = this._outBuf.read()) != null) {
                int amountToWrite = bufferToWrite.remaining();
                if (this._uploadRateLimiter != null) {
                    amountToWrite = this._uploadRateLimiter.checkRateLimit(amountToWrite);
                }
                if (amountToWrite != 0) {
                    if (amountToWrite < bufferToWrite.remaining()) {
                        ByteBuffer slicedBuffer = bufferToWrite.slice();
                        slicedBuffer.limit(amountToWrite);
                        amountWritten = this._socket.write(slicedBuffer);
                        if (amountWritten >= 0) {
                            bufferToWrite.position(bufferToWrite.position() + amountWritten);
                        }
                    } else {
                        amountWritten = this._socket.write(bufferToWrite);
                    }
                    if (this._uploadRateLimiter != null) {
                        this._uploadRateLimiter.updateStats(amountWritten);
                        BandwidthUtils.BandwidthStats stats = new BandwidthUtils.BandwidthStats();
                        this._uploadRateLimiter.getStats(stats);
                    }
                }
                this._totalWritten += amountWritten;
                _cumilativeWritten += (long)amountWritten;
                if (bufferToWrite.remaining() > 0) {
                    this._outBuf.putBack(bufferToWrite);
                }
            }
            if (this._totalWritten > 0 && !this._outBuf.isDataAvailable() && (this._dataSource == null || contentEOF)) {
                this._lastReadOrWriteTime = System.currentTimeMillis();
                if (this._state == State.SENDING_REQUEST) {
                    this.setState(State.RECEIVING_HEADERS, null);
                    this._selector.registerForRead(theSocket);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Writeable for url:" + this.getURL() + " threw Exception:" + e.getMessage()));
            this.setErrorType(ErrorType.IOEXCEPTION);
            this.setErrorDesc(StringUtils.stringifyException((Throwable)e));
            this.setState(State.ERROR, e);
            throw e;
        }
        if (this._state == State.SENDING_REQUEST) {
            this._selector.registerForReadAndWrite(theSocket);
        } else if (this._state.ordinal() >= State.RECEIVING_HEADERS.ordinal() && this._state.ordinal() < State.DONE.ordinal()) {
            this._selector.registerForRead(theSocket);
        }
    }

    final void processIncomingData(int newBytes) throws IOException {
        while (this._inBuf.isDataAvailable()) {
            if (this._state == State.RECEIVING_HEADERS) {
                if (this.processHeaders()) continue;
                break;
            }
            if (this._state != State.RECEIVING_CONTENT) break;
            if (this._chunked) {
                this.processChunkedContent();
                break;
            }
            this.processUnChunkedContent(Math.min(newBytes, this._inBuf.available()));
            break;
        }
    }

    @Override
    public int Readable(NIOClientSocket theSocket) throws IOException {
        if (!theSocket.isOpen()) {
            LOG.error((Object)"Readable Called on Closed Socket");
            return -1;
        }
        int totalBytesRead = 0;
        int singleReadAmount = 0;
        boolean overflow = false;
        boolean disconnected = false;
        try {
            if (this._downloadMax == -1 || this._totalRead < this._downloadMax) {
                do {
                    ByteBuffer buffer = this._inBuf.getWriteBuf();
                    if (this._downloadMax != -1 && this._totalRead + buffer.remaining() > this._downloadMax) {
                        int overflowAmt = this._totalRead + buffer.remaining() - this._downloadMax;
                        buffer.limit(buffer.limit() - overflowAmt);
                    }
                    if ((singleReadAmount = this._socket.read(buffer)) <= 0) continue;
                    this._inBuf.write(buffer);
                    this._totalRead += singleReadAmount;
                    _cumilativeRead += (long)singleReadAmount;
                    totalBytesRead += singleReadAmount;
                } while (singleReadAmount > 0 && (this._downloadMax == -1 || this._totalRead < this._downloadMax));
                if (this._downloadMax != -1 && this._totalRead == this._downloadMax) {
                    overflow = true;
                    this._contentTruncated = true;
                }
            }
            if (totalBytesRead > 0) {
                this._inBuf.flush();
                this.processIncomingData(totalBytesRead);
            }
            if (singleReadAmount == -1 || overflow) {
                disconnected = true;
                if (this.getState() == State.RECEIVING_CONTENT && (overflow || this._contentLength == -1 || this._contentLength == this._downloadedContentLength)) {
                    if (this._chunked) {
                        this._inBuf.reset();
                        if (this._chunkContentBuffer != null) {
                            this._chunkContentBuffer.flush();
                            this._inBuf = this._chunkContentBuffer;
                            this._chunkContentBuffer = null;
                        }
                        this._chunked = false;
                        if (!overflow) {
                            this.setErrorType(ErrorType.IOEXCEPTION);
                            this.setErrorDesc("Connection Closed Before Receiving Chunk Trailer");
                            this.setState(State.ERROR, new SocketException());
                        }
                    }
                    if (this.getState() == State.RECEIVING_CONTENT) {
                        this.setState(State.DONE, null);
                    }
                } else if (this.getState() != State.DONE) {
                    if (this.getState() == State.RECEIVING_CONTENT && this._downloadedContentLength != 0) {
                        LOG.warn((Object)("URL:" + this._url + " POSSIBLE TRUNCATION: Read returned -1 with ContentLength:" + this._contentLength + " BufferSize:" + this._inBuf.available() + " DownloadSize:" + this._downloadedContentLength + " State:" + (Object)((Object)this.getState()) + "Context:" + this._context));
                        this.setState(State.DONE, null);
                    } else {
                        LOG.error((Object)("URL:" + this._url + " Read returned -1 with ContentLength:" + this._contentLength + " BufferSize:" + this._inBuf.available() + " DownloadSize:" + this._downloadedContentLength + " State:" + (Object)((Object)this.getState()) + "Context:" + this._context));
                        this.setErrorType(ErrorType.IOEXCEPTION);
                        this.setErrorDesc("Read returned -1 with ContentLength:" + this._contentLength + " BufferSize:" + this._inBuf.available() + " DownloadSize:" + this._downloadedContentLength + " State:" + (Object)((Object)this.getState()));
                        this.setState(State.ERROR, new SocketException());
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Readable for url:" + this.getURL() + " threw Exception:" + e.getMessage()));
            this.setErrorType(ErrorType.IOEXCEPTION);
            this.setErrorDesc(StringUtils.stringifyException((Throwable)e));
            this.setState(State.ERROR, e);
        }
        if (this._socket.isOpen()) {
            if (this._outBuf.isDataAvailable()) {
                this._selector.registerForReadAndWrite(theSocket);
            } else {
                this._selector.registerForRead(theSocket);
            }
        }
        if (totalBytesRead > 0) {
            this._lastReadOrWriteTime = System.currentTimeMillis();
        }
        return disconnected ? -1 : totalBytesRead;
    }

    private boolean accumulateHeaders(int headersMax) throws IOException {
        if (this._incomingAccumulationBuffer == null) {
            this._incomingAccumulationBuffer = new ByteArrayOutputStream(16384);
        }
        ByteBuffer currentBuffer = null;
        boolean eolFound = false;
        while (!eolFound && (currentBuffer = this._inBuf.read()) != null) {
            while (!eolFound && currentBuffer.hasRemaining()) {
                byte c = currentBuffer.get();
                this._incomingAccumulationBuffer.write(c);
                if (c == 10) {
                    if (this._lastCharWasLF) {
                        eolFound = true;
                    } else {
                        this._lastCharWasLF = true;
                    }
                } else if (c != 13 || this._lastChar != 10) {
                    this._lastCharWasLF = false;
                }
                this._lastChar = c;
                if (eolFound) {
                    if (currentBuffer.hasRemaining()) {
                        this._inBuf.putBack(currentBuffer);
                    }
                    return true;
                }
                if (headersMax == -1 || this._incomingAccumulationBuffer.size() <= headersMax) continue;
                throw new IOException("Header Size Limit Reached With No Terminator!");
            }
        }
        return false;
    }

    private static boolean isHTTPToken(byte[] data, int offset, int length) {
        if (length >= httpStr.length) {
            for (int i = 0; i < httpStr.length; ++i) {
                if (data[offset + i] == httpStr[i] || data[offset + i] + 32 == httpStr[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean detectStatusLine() throws IOException {
        boolean detectedStatusLine = false;
        if (this._inBuf.available() >= httpStr.length) {
            byte[] statusLineBytes = new byte[8];
            NIOBufferListInputStream temp = new NIOBufferListInputStream(this._inBuf);
            temp.read(statusLineBytes);
            temp.close();
            for (int i = 0; i <= 3; ++i) {
                if (!NIOHttpConnection.isHTTPToken(statusLineBytes, i, 4)) continue;
                detectedStatusLine = true;
                break;
            }
            boolean addBytesAsNewByteBuffer = true;
            ByteBuffer nextReadBuffer = this._inBuf.read();
            if (nextReadBuffer != null) {
                if (nextReadBuffer.position() == 8) {
                    nextReadBuffer.position(0);
                    addBytesAsNewByteBuffer = false;
                }
                this._inBuf.putBack(nextReadBuffer);
            }
            if (addBytesAsNewByteBuffer) {
                this._inBuf.putBack(ByteBuffer.wrap(statusLineBytes));
            }
        }
        return detectedStatusLine;
    }

    private boolean processHeaders() throws IOException {
        if (!this._foundStatusLine) {
            if (this._inBuf.available() < 8) {
                return false;
            }
            this._foundStatusLine = this.detectStatusLine();
            if (!this._foundStatusLine) {
                LOG.info((Object)"No stats line found while process headers. Assuming http 0.9 response");
                this._responseHeaders.add(null, "HTTP-0.9 200 OK");
                this.setState(State.RECEIVING_CONTENT, null);
            }
        }
        if (this._foundStatusLine && this.accumulateHeaders(16384)) {
            String strContentLength;
            this.setState(State.PARSING_HEADERS, null);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this._incomingAccumulationBuffer.toByteArray()), Charset.forName("UTF-8"));
            this._responseHeaders.mergeHeader(reader);
            if (this._cookieStore != null) {
                Iterator<String> values = this._responseHeaders.multiValueIterator("Set-Cookie");
                while (values.hasNext()) {
                    String value = values.next();
                    if (value == null || value.length() == 0) continue;
                    if (_cookieLogger != null) {
                        _cookieLogger.info("Setting Cookie:" + value + " to url:" + this._url);
                    }
                    this._cookieStore.setCookie(this._url, value);
                }
            }
            if ((strContentLength = this._responseHeaders.findValue("Content-Length")) != null) {
                try {
                    this._contentLength = Integer.parseInt(strContentLength);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Number Format Exception parsing Content-Length:" + strContentLength));
                }
            }
            this.setState(State.RECEIVING_CONTENT, null);
            String strTransferEncoding = this._responseHeaders.findValue("Transfer-Encoding");
            if (strTransferEncoding != null) {
                if (strTransferEncoding.equalsIgnoreCase("CHUNKED")) {
                    this._contentLength = -1;
                    this._chunked = true;
                    this._chunkState = ChunkState.STATE_AWAITING_CHUNK_HEADER;
                    this._chunkLineBuffer = new StringBuffer(1024);
                    this._chunkContentBuffer = new NIOBufferList();
                } else {
                    LOG.error((Object)("Unknown Transfer Encoding in Response Headers:" + strTransferEncoding));
                    throw new IOException("Uknown Transfer Encoding");
                }
            }
            if (this._contentLength == 0) {
                this.setState(State.DONE, null);
            }
            return true;
        }
        return false;
    }

    private void processChunkedContent() throws IOException {
        block9: while (this._inBuf.available() != 0 && this._chunkState != ChunkState.STATE_DONE) {
            switch (this._chunkState) {
                case STATE_AWAITING_CHUNK_HEADER: {
                    this._chunkCRLFReadState = this._inBuf.readCRLFLine(this._chunkLineBuffer, 1024, this._chunkCRLFReadState);
                    if (this._chunkCRLFReadState != NIOBufferList.CRLFReadState.DONE) break;
                    String line = this._chunkLineBuffer.toString();
                    int whiteSpaceIdx = line.indexOf(32);
                    if (whiteSpaceIdx != -1) {
                        line = line.substring(0, whiteSpaceIdx);
                    }
                    try {
                        this._chunkSize = Integer.parseInt(line, 16);
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Object)("Invalid Chunk Size Encountered reading CHUNK HEADER:" + line));
                        throw new IOException("Invalid chunk size");
                    }
                    this._chunkPos = 0;
                    this._chunkCRLFReadState = NIOBufferList.CRLFReadState.NONE;
                    this._chunkLineBuffer.setLength(0);
                    if (this._chunkSize > 0) {
                        this._chunkState = ChunkState.STATE_READING_CHUNK;
                        break;
                    }
                    this._chunkState = ChunkState.STATE_AWAITING_TRAILERS;
                    break;
                }
                case STATE_READING_CHUNK: {
                    int amountToRead = Math.min(this._chunkSize - this._chunkPos, this._inBuf.available());
                    int amountWritten = 0;
                    while (amountToRead != 0) {
                        ByteBuffer writeBuffer = this._chunkContentBuffer.getWriteBuf();
                        ByteBuffer readBuffer = this._inBuf.read();
                        if (readBuffer == writeBuffer) {
                            throw new RuntimeException("BAD NEWS!!!");
                        }
                        if (readBuffer.remaining() > writeBuffer.remaining() || readBuffer.remaining() > amountToRead) {
                            ByteBuffer sliced = readBuffer.slice();
                            int sliceAmount = Math.min(writeBuffer.remaining(), amountToRead);
                            readBuffer.position(readBuffer.position() + sliceAmount);
                            sliced.limit(sliced.position() + sliceAmount);
                            amountToRead -= sliceAmount;
                            this._chunkPos += sliceAmount;
                            amountWritten += sliced.remaining();
                            writeBuffer.put(sliced);
                            this._inBuf.putBack(readBuffer);
                            continue;
                        }
                        amountToRead -= readBuffer.remaining();
                        this._chunkPos += readBuffer.remaining();
                        amountWritten += readBuffer.remaining();
                        writeBuffer.put(readBuffer);
                    }
                    if (amountWritten != 0) {
                        this._downloadedContentLength += amountWritten;
                        if (this.getListener() != null) {
                            this.getListener().HttpContentAvailable(this, this._chunkContentBuffer);
                        }
                    }
                    if (this._chunkPos != this._chunkSize) continue block9;
                    this._chunkState = ChunkState.STATE_AWAITING_CHUNK_EOL;
                    break;
                }
                case STATE_AWAITING_CHUNK_EOL: {
                    if (this._inBuf.available() >= 2) {
                        ByteBuffer readBuffer = this._inBuf.read();
                        if (readBuffer.get() != 13) {
                            LOG.error((Object)"Missing CR from Chunk Data Terminator");
                            throw new IOException("missing CR");
                        }
                        if (readBuffer.remaining() == 0) {
                            readBuffer = this._inBuf.read();
                        }
                        if (readBuffer.get() != 10) {
                            LOG.error((Object)"Missing LFfrom Chunk Data Terminator");
                            throw new IOException("missing LF");
                        }
                        this._inBuf.putBack(readBuffer);
                        this._chunkState = ChunkState.STATE_AWAITING_CHUNK_HEADER;
                        break;
                    }
                    return;
                }
                case STATE_AWAITING_TRAILERS: {
                    this._chunkCRLFReadState = this._inBuf.readCRLFLine(this._chunkLineBuffer, 1024, this._chunkCRLFReadState);
                    if (this._chunkCRLFReadState != NIOBufferList.CRLFReadState.DONE) break;
                    this._chunkState = ChunkState.STATE_DONE;
                    this._chunkCRLFReadState = NIOBufferList.CRLFReadState.NONE;
                    this._chunkLineBuffer.setLength(0);
                }
                case STATE_DONE: {
                    this._inBuf.reset();
                    this._chunkContentBuffer.flush();
                    this._inBuf = this._chunkContentBuffer;
                    this._chunkContentBuffer = null;
                    this._chunked = false;
                    this.setState(State.DONE, null);
                }
            }
        }
    }

    private boolean processUnChunkedContent(int newBytesIn) throws IOException {
        this._downloadedContentLength += newBytesIn;
        if (this._downloadedContentLength != 0 && this.getListener() != null) {
            this.getListener().HttpContentAvailable(this, this._inBuf);
        }
        if (this._contentLength != -1 && this._downloadedContentLength >= this._contentLength) {
            this.setState(State.DONE, null);
        }
        return true;
    }

    public boolean hasTimedOut() {
        boolean timedOut = false;
        if (this.getState().ordinal() > State.AWAITING_RESOLUTION.ordinal()) {
            boolean bl = timedOut = this.getState() == State.ERROR && this.getErrorType() == ErrorType.TIMEOUT;
            if (!timedOut && this.getState().ordinal() < State.DONE.ordinal()) {
                long currentTime = System.currentTimeMillis();
                long timeDelta = 0L;
                if (this.getState().ordinal() <= State.AWAITING_CONNECT.ordinal()) {
                    timeDelta = currentTime - this._phaseStartTime;
                    timedOut = timeDelta >= (long)this._connectTimeout;
                } else {
                    timeDelta = currentTime - this._lastReadOrWriteTime;
                    boolean bl2 = timedOut = timeDelta >= (long)this._uploadDownloadTimeout;
                }
                if (timedOut) {
                    this._timeoutState = this.getState();
                    State oldState = this.getState();
                    Listener listenerTemp = this._listener;
                    this._listener = null;
                    this.setErrorType(ErrorType.TIMEOUT);
                    this.setErrorDesc("TIMEOUT-IN STATE:" + oldState.toString());
                    this.setState(State.ERROR, new SocketTimeoutException());
                    this._listener = listenerTemp;
                    timedOut = true;
                }
            }
        }
        return timedOut;
    }

    public String toString() {
        String strOut = "State:" + (Object)((Object)this._state) + "\n";
        if (this._url != null) {
            strOut = strOut + "URL:" + this._url.toString() + "\n";
        }
        if (this._context != null) {
            strOut = strOut + "ContextObj:" + this._context + "\n";
        }
        return strOut;
    }

    @Override
    public void done(NIODNSResolver eventSource, FutureTask<NIODNSQueryResult> task) {
    }

    void mockRead(String line) throws IOException {
        byte[] bytes = line.getBytes();
        ByteBuffer incomingBuffer = ByteBuffer.wrap(bytes);
        incomingBuffer.position(bytes.length);
        this._inBuf.write(incomingBuffer);
        this._inBuf.flush();
        this.processIncomingData(bytes.length);
    }

    void mockConnectionClose() throws IOException {
        if (this.getState() == State.RECEIVING_CONTENT) {
            this.setState(State.DONE, null);
        }
    }

    static void testHTTPConnection() {
        Assert.assertTrue((boolean)NIOHttpConnection.MockHTTPConnection(new String[]{"HTTP/1.0 200 OK\r\n\r\n", "hello world"}, false, "HTTP/1.0 200 OK", 200, "hello world"));
        Assert.assertTrue((boolean)NIOHttpConnection.MockHTTPConnection(new String[]{"HTTP/1.0 404 Not Found\nServer: blah\n\nDATA"}, false, "HTTP/1.0 404 Not Found", 404, "DATA"));
        Assert.assertTrue((boolean)NIOHttpConnection.MockHTTPConnection(new String[]{"HTTP/1.0 ", "200 OK", "\n", "Server: blah\r", "\n", "\n", "DA", "TA"}, false, "HTTP/1.0 200 OK", 200, "DATA"));
    }

    static boolean MockHTTPConnection(String[] dataSet, boolean failureExcepted, String statusLineExpected, int statusCodeExpected, String dataExpected) {
        block10: {
            int bytesAvailable;
            NIOHttpConnection connection = new NIOHttpConnection();
            connection._state = State.RECEIVING_HEADERS;
            try {
                for (String dataLine : dataSet) {
                    connection.mockRead(dataLine);
                }
                connection.mockConnectionClose();
            }
            catch (IOException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                return failureExcepted;
            }
            if (failureExcepted) {
                return false;
            }
            NIOHttpHeaders headers = connection.getResponseHeaders();
            if (headers.getValue(0).compareTo(statusLineExpected) != 0) {
                LOG.error((Object)("Status Line Comparison Failed. Connection:" + headers.getValue(0) + " Expected:" + statusLineExpected));
                return false;
            }
            if (NIOHttpConnection.getHttpResponseCode(headers) != statusCodeExpected) {
                LOG.error((Object)("Status Code Different. Found:" + NIOHttpConnection.getHttpResponseCode(headers) + " Expected:" + statusCodeExpected));
                return false;
            }
            byte[] bytesExpected = dataExpected.getBytes();
            if (bytesExpected.length == (bytesAvailable = connection.getContentBuffer().available())) {
                byte[] bytesFetched = new byte[bytesExpected.length];
                try {
                    connection.getContentBuffer().read(bytesFetched);
                    if (!Arrays.equals(bytesExpected, bytesFetched)) {
                        LOG.error((Object)"Content Mismatch!");
                        return false;
                    }
                    break block10;
                }
                catch (IOException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    return false;
                }
            }
            LOG.error((Object)"Content Length Mismatch!");
            return false;
        }
        return true;
    }

    static {
        _defaultUserAgentString = "Mozilla/5.0 (compatible; NIOHttpConnection/1.0;)";
        httpStr = new byte[]{104, 116, 116, 112};
    }

    public static class NIOHttpConnectionUnitTest {
        @Test
        public void runTest() throws Exception {
            NIOHttpConnection.testHTTPConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        UNKNOWN,
        RESOLVER_FAILURE,
        DNS_FAILURE,
        IOEXCEPTION,
        TIMEOUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        AWAITING_RESOLUTION,
        AWAITING_CONNECT,
        SENDING_REQUEST,
        RECEIVING_HEADERS,
        PARSING_HEADERS,
        RECEIVING_CONTENT,
        DONE,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ChunkState {
        STATE_AWAITING_CHUNK_HEADER,
        STATE_READING_CHUNK,
        STATE_AWAITING_CHUNK_EOL,
        STATE_AWAITING_TRAILERS,
        STATE_DONE;

    }

    public static interface DataSource {
        public boolean read(NIOBufferList var1) throws IOException;
    }

    public static interface Listener {
        public void HttpConnectionStateChanged(NIOHttpConnection var1, State var2, State var3);

        public void HttpContentAvailable(NIOHttpConnection var1, NIOBufferList var2);
    }
}

