/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.io.internal.NIODNSQueryClient;
import org.commoncrawl.io.internal.NIODNSResolver;

public class NIODNSQueryResult {
    static final Log LOG = LogFactory.getLog(NIODNSQueryResult.class);
    private NIODNSQueryClient.Status _status = NIODNSQueryClient.Status.RESOLVER_FAILURE;
    private String _errorDesc = "";
    private String _hostName;
    private String _cname;
    private InetAddress _address;
    private long _ttl;
    private NIODNSQueryClient _client;
    NIODNSResolver _source = null;

    public NIODNSQueryResult(NIODNSResolver source, NIODNSQueryClient client, String hostName) {
        this._source = source;
        this._client = client;
        this._hostName = hostName;
    }

    public void fireCallback() {
        NIODNSQueryClient client = this.getConnection();
        if (client != null) {
            if (this.success()) {
                client.AddressResolutionSuccess(this._source, this.getHostName(), this.getCName(), this.getAddress(), this.getTTL());
            } else {
                client.AddressResolutionFailure(this._source, this.getHostName(), this.getStatus(), this.getErrorDescription());
            }
        } else if (this.getHostName() != null) {
            LOG.error((Object)("Client no Longer Exists for DNS Resolution Request:" + this.getHostName()));
        } else {
            LOG.error((Object)"Client no Longer Exists for DNS Resolution Request");
        }
    }

    public final void setStatus(NIODNSQueryClient.Status theStatus) {
        this._status = theStatus;
    }

    public final NIODNSQueryClient.Status getStatus() {
        return this._status;
    }

    public final boolean success() {
        return this._status == NIODNSQueryClient.Status.SUCCESS;
    }

    public String getErrorDescription() {
        if (this._errorDesc != null) {
            return this._errorDesc;
        }
        return "";
    }

    public void setErrorDesc(String errorDesc) {
        this._errorDesc = errorDesc;
    }

    public final void setAddress(InetAddress address) {
        this._address = address;
    }

    public final InetAddress getAddress() {
        return this._address;
    }

    public final long getTTL() {
        return this._ttl;
    }

    public final void setTTL(long ttlValue) {
        this._ttl = ttlValue;
    }

    public final String getHostName() {
        return this._hostName;
    }

    public final String getCName() {
        return this._cname;
    }

    public final void setCName(String cname) {
        this._cname = cname;
    }

    public final NIODNSQueryClient getConnection() {
        return this._client;
    }
}

