/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIODNSCache;
import org.commoncrawl.io.internal.NIODNSQueryClient;
import org.commoncrawl.io.internal.NIODNSQueryResult;
import org.commoncrawl.io.internal.NIODNSResolver;
import org.commoncrawl.io.internal.NIODNSSimpleResolverImpl;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.IPAddressUtils;
import org.commoncrawl.util.shared.IntrusiveList;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NIODNSLocalResolver
extends IntrusiveList.IntrusiveListElement<NIODNSLocalResolver>
implements NIODNSResolver {
    public static final int MIN_TTL_VALUE = 1200000;
    private static NIODNSCache _dnsCache = new NIODNSCache();
    private static NIODNSCache _badHostCache = new NIODNSCache();
    private long _cacheHits = 0L;
    private long _cacheMisses = 0L;
    private long _queryCount = 0L;
    private static Logger _logger = null;
    public static final int SERVER_FAIL_BAD_HOST_LIFETIME = 3600000;
    public static final int NXDOMAIN_FAIL_BAD_HOST_LIFETIME = 300000;
    static final Log LOG = LogFactory.getLog(NIODNSLocalResolver.class);
    private EventLoop _eventLoop;
    private ExecutorService _threadPool = null;
    private ExecutorService _highPriorityThreadPool = null;
    private DNSExecutorCompletionService _completionService;
    private DNSExecutorCompletionService _highPriorityCompletionService = null;
    private boolean _useTCP = true;
    private String _dnsServerAddress = "127.0.0.1";
    private Object _context;
    LinkedList<TCPClient> _recycledClients = new LinkedList();
    private static long TTL_DELTA_MIN = 600000L;
    private static final int MAX_DNS_RETRIES = 1;

    public NIODNSLocalResolver(EventLoop eventLoop, ExecutorService dnsThreadPool, boolean useTCP) {
        this.lookupNameServer();
        this._eventLoop = eventLoop;
        this._threadPool = dnsThreadPool;
        this._completionService = new DNSExecutorCompletionService(this._eventLoop, this._threadPool);
        this._useTCP = useTCP;
        _dnsCache.enableIPAddressTracking();
    }

    public NIODNSLocalResolver(String serverAddress, EventLoop eventLoop, ExecutorService dnsThreadPool, ExecutorService highPriorityThreadPool, boolean useTCP) {
        this._dnsServerAddress = serverAddress;
        this._eventLoop = eventLoop;
        this._threadPool = dnsThreadPool;
        this._highPriorityThreadPool = highPriorityThreadPool;
        this._completionService = new DNSExecutorCompletionService(this._eventLoop, this._threadPool);
        this._highPriorityCompletionService = new DNSExecutorCompletionService(this._eventLoop, this._highPriorityThreadPool);
        this._useTCP = useTCP;
        _dnsCache.enableIPAddressTracking();
    }

    public int getQueuedItemCount() {
        if (this._threadPool != null) {
            return ((ThreadPoolExecutor)this._threadPool).getQueue().size();
        }
        return 0;
    }

    public String getName() {
        return this._dnsServerAddress;
    }

    public Object getContextObject() {
        return this._context;
    }

    public void setContextObject(Object obj) {
        this._context = obj;
    }

    private final void lookupNameServer() {
        String server = ResolverConfig.getCurrentConfig().server();
        if (server != null) {
            LOG.info((Object)("Using NameServer:" + server));
            this._dnsServerAddress = server;
        } else {
            LOG.info((Object)("No NameServer Found.Using:" + this._dnsServerAddress));
        }
    }

    public void setDNSServerAddress(String serverAddressInDottedDecimal) {
        this._dnsServerAddress = serverAddressInDottedDecimal;
    }

    public static void setLogger(Logger logger) {
        _logger = logger;
    }

    public static Logger getLogger() {
        return _logger;
    }

    public static NIODNSCache getDNSCache() {
        return _dnsCache;
    }

    public static NIODNSCache getBadHostCache() {
        return _badHostCache;
    }

    public long getQueryCount() {
        return this._queryCount;
    }

    public long getCacheHitCount() {
        return this._cacheHits;
    }

    public long getCacheMissCount() {
        return this._cacheMisses;
    }

    public static NIODNSQueryResult checkCache(NIODNSQueryClient client, String hostName) throws UnknownHostException {
        NIODNSCache.DNSResult result = _dnsCache.getIPAddressForHost(hostName);
        if (result != null) {
            long ttlDelta = result.getTTL() - System.currentTimeMillis();
            if (ttlDelta < 0L && Math.abs(ttlDelta) > TTL_DELTA_MIN) {
                return null;
            }
            NIODNSQueryResult queryResult = new NIODNSQueryResult(null, client, hostName);
            queryResult.setAddress(IPAddressUtils.IntegerToInetAddress(result.getIPAddress()));
            queryResult.setCName(result.getCannonicalName());
            queryResult.setTTL(result.getTTL());
            queryResult.setStatus(NIODNSQueryClient.Status.SUCCESS);
            return queryResult;
        }
        NIODNSCache.Node resolvedNode = _badHostCache.findNode(hostName);
        if (resolvedNode != null) {
            // empty if block
        }
        if (resolvedNode != null && resolvedNode.getTimeToLive() >= System.currentTimeMillis()) {
            NIODNSQueryResult queryResult = new NIODNSQueryResult(null, client, hostName);
            queryResult.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
            queryResult.setErrorDesc("Failed via Bad Host Cache");
            return queryResult;
        }
        return null;
    }

    public ReverseDNSQueryResult doReverseDNSQuery(InetAddress address, boolean useTCP, int timeoutValue) {
        Message response = null;
        Exception resolverException = null;
        ReverseDNSQueryResult result = new ReverseDNSQueryResult(address);
        try {
            Record[] records;
            NIODNSSimpleResolverImpl resolver = new NIODNSSimpleResolverImpl(this, this._dnsServerAddress);
            if (useTCP) {
                resolver.setTCP(true);
            }
            resolver.setTimeout(timeoutValue);
            Name name = ReverseMap.fromAddress((InetAddress)address);
            Record rec = Record.newRecord((Name)name, (int)12, (int)1);
            Message query = Message.newQuery((Record)rec);
            try {
                response = resolver.send(query);
            }
            catch (Exception e) {
                LOG.error((Object)("Reverse DNS Resolution for:" + address + " threw IOException:" + StringUtils.stringifyException((Throwable)e)));
                resolverException = e;
            }
            if (response != null && response.getRcode() == 0 && (records = response.getSectionArray(1)) != null) {
                for (Record record : records) {
                    if (record.getType() != 12) continue;
                    result.getHostNames().add(((PTRRecord)record).getTarget().toString());
                }
            }
        }
        catch (UnknownHostException e) {
            resolverException = e;
        }
        if (response == null) {
            result.setStatus(NIODNSQueryClient.Status.RESOLVER_FAILURE);
            LOG.error((Object)("Critical Reverse DNS Failure for host:" + address.toString()));
            if (resolverException != null) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)resolverException));
                result.setErrorDesc(resolverException.toString());
            }
        } else if (response.getRcode() != 0) {
            result.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
            result.setErrorDesc(Rcode.string((int)response.getRcode()));
        } else if (response.getRcode() == 0) {
            if (result.getHostNames().size() != 0) {
                result.setStatus(NIODNSQueryClient.Status.SUCCESS);
            } else {
                result.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
                result.setErrorDesc("NO PTR RECORDS FOUND");
            }
        }
        return result;
    }

    public NIODNSQueryResult doDNSQuery(NIODNSQueryClient client, String hostName, boolean useTCP, boolean noCache, int timeoutValue) {
        NIODNSQueryResult result = null;
        int retryCount = 0;
        boolean retry = false;
        boolean resultViaCache = false;
        do {
            Throwable resolverException;
            long expireTime;
            String cname;
            InetAddress address;
            Message response;
            block26: {
                response = null;
                address = null;
                cname = null;
                expireTime = -1L;
                resolverException = null;
                ++this._queryCount;
                try {
                    if (!noCache) {
                        result = NIODNSLocalResolver.checkCache(client, hostName);
                    }
                    if (result != null) {
                        ++this._cacheHits;
                        resultViaCache = true;
                    }
                }
                catch (UnknownHostException e) {
                    if (_logger == null) break block26;
                    _logger.logDNSException(hostName, StringUtils.stringifyException((Throwable)e));
                }
            }
            if (result != null) continue;
            ++this._cacheMisses;
            try {
                block27: {
                    NIODNSSimpleResolverImpl resolver = new NIODNSSimpleResolverImpl(this, this._dnsServerAddress);
                    if (useTCP) {
                        resolver.setTCP(true);
                    }
                    resolver.setTimeout(timeoutValue);
                    Name name = Name.fromString((String)hostName, (Name)Name.root);
                    Record rec = Record.newRecord((Name)name, (int)1, (int)1);
                    Message query = Message.newQuery((Record)rec);
                    try {
                        response = resolver.send(query);
                    }
                    catch (IOException e) {
                        if (_logger != null) {
                            _logger.logDNSException(hostName, StringUtils.stringifyException((Throwable)e));
                        }
                        resolverException = e;
                        if (retryCount++ == 1) break block27;
                        LOG.info((Object)("Waiting to Retry Failed DNS Query for:" + hostName));
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e1) {
                            // empty catch block
                        }
                        LOG.info((Object)("Retrying Failed DNS Query for:" + hostName));
                        retry = true;
                    }
                }
                if (response != null && response.getRcode() == 0) {
                    Record[] records = response.getSectionArray(1);
                    if (records != null) {
                        for (Record record : records) {
                            if (record.getType() == 5) {
                                cname = ((CNAMERecord)record).getAlias().toString();
                                if (cname == null || !cname.endsWith(".")) continue;
                                cname = cname.substring(0, cname.length() - 1);
                                continue;
                            }
                            if (record.getType() != 1 || address != null) continue;
                            address = ((ARecord)record).getAddress();
                            expireTime = Math.max(System.currentTimeMillis() + ((ARecord)record).getTTL() * 1000L, System.currentTimeMillis() + 1200000L);
                        }
                    }
                    if (address != null && !noCache) {
                        _dnsCache.cacheIPAddressForHost(hostName, IPAddressUtils.IPV4AddressToInteger(address.getAddress()), expireTime, cname);
                    }
                }
            }
            catch (TextParseException e) {
                resolverException = e;
            }
            catch (UnknownHostException e) {
                resolverException = e;
            }
            if (retry) continue;
            result = new NIODNSQueryResult(this, client, hostName);
            if (response == null) {
                if (resolverException != null && (resolverException instanceof TextParseException || resolverException instanceof WireParseException)) {
                    result.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
                    result.setErrorDesc(StringUtils.stringifyException((Throwable)resolverException));
                    continue;
                }
                result.setStatus(NIODNSQueryClient.Status.RESOLVER_FAILURE);
                if (resolverException != null) {
                    if (_logger != null) {
                        _logger.logDNSException(hostName, StringUtils.stringifyException((Throwable)resolverException));
                    }
                    result.setErrorDesc(StringUtils.stringifyException((Throwable)resolverException));
                    continue;
                }
                if (_logger == null) continue;
                _logger.logDNSException(hostName, "Response was NULL");
                continue;
            }
            if (response.getRcode() != 0) {
                result.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
                result.setErrorDesc(Rcode.string((int)response.getRcode()));
                if (_logger == null) continue;
                _logger.logDNSFailure(hostName, Rcode.string((int)response.getRcode()));
                continue;
            }
            if (response.getRcode() != 0) continue;
            if (address != null) {
                result.setStatus(NIODNSQueryClient.Status.SUCCESS);
                result.setAddress(address);
                result.setCName(cname);
                result.setTTL(expireTime);
                if (_logger == null) continue;
                _logger.logDNSQuery(hostName, address, expireTime, cname);
                continue;
            }
            result.setStatus(NIODNSQueryClient.Status.SERVER_FAILURE);
            result.setErrorDesc("UNKNOWN-NO A RECORD");
            if (_logger == null) continue;
            _logger.logDNSFailure(hostName, "NOERROR");
        } while (result == null);
        if (!resultViaCache && result.getStatus() == NIODNSQueryClient.Status.SERVER_FAILURE && result.getErrorDescription().equals("NXDOMAIN")) {
            _badHostCache.cacheIPAddressForHost(hostName, 0, System.currentTimeMillis() + 300000L, null);
        }
        return result;
    }

    @Override
    public Future<NIODNSQueryResult> resolve(NIODNSQueryClient client, String theHost, boolean noCache, boolean highPriorityRequest, int timeoutValue) throws IOException {
        int flags;
        int n = flags = noCache ? 1 : 0;
        if (this._useTCP) {
            flags |= 2;
        }
        if (!highPriorityRequest || this._highPriorityCompletionService == null) {
            return this._completionService.submit(new DNSQuery(client, this, theHost, flags, timeoutValue));
        }
        return this._highPriorityCompletionService.submit(new DNSQuery(client, this, theHost, flags, timeoutValue));
    }

    public final void poll() {
        Future<NIODNSQueryResult> result;
        while ((result = this._completionService.poll()) != null) {
            NIODNSQueryResult qResult;
            block4: {
                qResult = null;
                try {
                    qResult = result.get();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    }
                    if (!(e instanceof RuntimeException)) break block4;
                    LOG.fatal((Object)StringUtils.stringifyException((Throwable)e));
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (qResult == null) continue;
            qResult.fireCallback();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DNSQuery
    implements Callable<NIODNSQueryResult> {
        private String _hostName = null;
        private NIODNSQueryClient _client;
        private int _timeoutValue;
        private NIODNSLocalResolver _resolver;
        private int _flags;
        static final int Flag_SkipCache = 1;
        static final int Flag_UseTCP = 2;
        static final int Flag_HighPriority = 4;

        public DNSQuery(NIODNSQueryClient client, NIODNSLocalResolver resolver, String hostName, int flags, int timeoutValue) {
            this._hostName = hostName;
            this._client = client;
            this._flags = flags;
            this._timeoutValue = timeoutValue;
            this._resolver = resolver;
        }

        @Override
        public NIODNSQueryResult call() throws Exception {
            NIODNSQueryResult result = null;
            try {
                result = this._resolver.doDNSQuery(this._client, this._hostName, (this._flags & 2) != 0, (this._flags & 1) != 0, this._timeoutValue);
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw e;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseDNSQueryResult {
        private NIODNSQueryClient.Status _status = NIODNSQueryClient.Status.RESOLVER_FAILURE;
        private String _errorDesc = "";
        private InetAddress _targetAddress;
        private Vector<String> _hostNames = new Vector();

        ReverseDNSQueryResult(InetAddress address) {
            this._targetAddress = address;
        }

        public final void setStatus(NIODNSQueryClient.Status theStatus) {
            this._status = theStatus;
        }

        public final NIODNSQueryClient.Status getStatus() {
            return this._status;
        }

        public final boolean success() {
            return this._status == NIODNSQueryClient.Status.SUCCESS;
        }

        public String getErrorDescription() {
            return this._errorDesc;
        }

        void setErrorDesc(String errorDesc) {
            this._errorDesc = errorDesc;
        }

        public final InetAddress getTargetAddress() {
            return this._targetAddress;
        }

        public final Vector<String> getHostNames() {
            return this._hostNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DNSExecutorCompletionService
    implements CompletionService<NIODNSQueryResult> {
        private final Executor executor;
        private final BlockingQueue<Future<NIODNSQueryResult>> completionQueue;
        private final EventLoop eventLoop;

        public DNSExecutorCompletionService(EventLoop eventLoop, Executor executor) {
            if (executor == null) {
                throw new NullPointerException();
            }
            this.executor = executor;
            this.completionQueue = new LinkedBlockingQueue<Future<NIODNSQueryResult>>();
            this.eventLoop = eventLoop;
        }

        @Override
        public Future<NIODNSQueryResult> submit(Callable<NIODNSQueryResult> task) {
            if (task == null) {
                throw new NullPointerException();
            }
            QueueingFuture f = new QueueingFuture(task);
            this.executor.execute(f);
            return f;
        }

        @Override
        public Future<NIODNSQueryResult> submit(Runnable task, NIODNSQueryResult result) {
            if (task == null) {
                throw new NullPointerException();
            }
            QueueingFuture f = new QueueingFuture(task, result);
            this.executor.execute(f);
            return f;
        }

        @Override
        public Future<NIODNSQueryResult> take() throws InterruptedException {
            return this.completionQueue.take();
        }

        @Override
        public Future<NIODNSQueryResult> poll() {
            return (Future)this.completionQueue.poll();
        }

        @Override
        public Future<NIODNSQueryResult> poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completionQueue.poll(timeout, unit);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class QueueingFuture
        extends FutureTask<NIODNSQueryResult> {
            QueueingFuture(Callable<NIODNSQueryResult> c) {
                super(c);
            }

            QueueingFuture(Runnable t, NIODNSQueryResult r) {
                super(t, r);
            }

            @Override
            protected void done() {
                DNSExecutorCompletionService.this.eventLoop.setTimer(new Timer(0L, false, new Timer.Callback(){

                    public void timerFired(Timer timer) {
                        if (!QueueingFuture.this.isCancelled()) {
                            NIODNSQueryResult qResult;
                            block12: {
                                qResult = null;
                                try {
                                    qResult = (NIODNSQueryResult)QueueingFuture.this.get();
                                }
                                catch (Exception e) {
                                    if (e instanceof IOException) {
                                        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                                    }
                                    if (!(e instanceof RuntimeException)) break block12;
                                    LOG.fatal((Object)StringUtils.stringifyException((Throwable)e));
                                }
                            }
                            if (qResult != null) {
                                NIODNSQueryClient client = qResult.getConnection();
                                if (client != null) {
                                    if (qResult.success()) {
                                        client.AddressResolutionSuccess(qResult._source, qResult.getHostName(), qResult.getCName(), qResult.getAddress(), qResult.getTTL());
                                    } else {
                                        client.AddressResolutionFailure(qResult._source, qResult.getHostName(), qResult.getStatus(), qResult.getErrorDescription());
                                    }
                                    client.done(qResult._source, QueueingFuture.this);
                                } else if (qResult.getHostName() != null) {
                                    LOG.error((Object)("Client no Longer Exists for DNS Resolution Request:" + qResult.getHostName()));
                                } else {
                                    LOG.error((Object)"Client no Longer Exists for DNS Resolution Request");
                                }
                            }
                        } else {
                            LOG.error((Object)"Future Cancelled!!!!!");
                        }
                    }
                }));
            }
        }
    }

    public static interface Logger {
        public void logDNSQuery(String var1, InetAddress var2, long var3, String var5);

        public void logDNSFailure(String var1, String var2);

        public void logDNSException(String var1, String var2);
    }
}

